### Формы {#forms}

-   [Маркетинговое мероприятие](#formEvent)

-   [Лид](#formLead)

-   [Сделка](#formDeal)

-   [Аккаунт](#formAccount)

-   [Контакт](#formContact)

-   [Активность лида](#formLeadActivity)

-   [Активность сделки](#formDealActivity)

-   [% комиссии](#formComission)

-   [Товар (услуга)](#formItem)

-   [Цена](#formPrice)

-   [Тема сотрудничества](#formTheme)

[Шаблоны документов](#formsTemplates):

-   [Договор поставки (единовременная оплата)](#formContractDeliveryAll)

-   [Договор поставки (оплата частями)](#formContractDeliveryPart)

-   [Акт приема-передачи товара](#formCertificate)

-   [Коммерческое предложение](#formOffer)

#### Маркетинговое мероприятие {#formEvent}

Код формы: crm_form_event.

Форма содержит следующие компоненты:

+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                                | Имя компонента                                         |
+========================================================+===============================================================+========================================================+
| **Тип мероприятия**                                    | выпадающий список (справочник *crm_dict_eventType*)           | crm_form_event_main_type                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Наименование мероприятия**                           | однострочное поле                                             | crm_form_event_main_name                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Стоимость**                                          | числовое поле                                                 | crm_form_event_main_cost                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Мероприятие**                                        | ссылка                                                        | crm_form_event_main_event                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Комментарий**                                        | многострочное поле                                            | crm_form_event_main_comment                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Ответственный менеджер**                             | выбор пользователя                                            | crm_form_event_responsibleManager_responsible          |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+

#### Лид {#formLead}

Код формы: crm_form_lead.

Форма содержит следующие компоненты:

+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                                | Имя компонента                                         |
+========================================================+===============================================================+========================================================+
| **Мероприятие**                                        | ссылка на реестр "Маркетингоое мероприятие"                   | crm_form_lead_main_action                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Источник лида**                                      | ссылка на реестр "Контакт"                                    | crm_form_lead_main_leadSource                          |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Контакт**                                            | пользовательский компонент на реестр "Контакт"                | crm_form_lead_main_contact                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Аккаунт**                                            | пользовательский компонент на реестр "Аккаунт"                | crm_form_lead_main_account                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Сотрудничество**                                     | динамическая таблица                                          | crm_form_lead_deals                                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества                                    | ссылка на реестр "Темы сотрудничества"                        | crm_form_lead_deals_theme                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Потенциальный бюджет                                   | числовое поле                                                 | crm_form_lead_deals_budget                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Статус                                                 | выпадающий список (справочник "crm_dict_dealStatus")          | crm_form_lead_deals_status                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| %кнопка_создания_сделки%                               | пользовательский компонент                                    | crm_form_lead_deals_newDeal                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Ответственный менеджер**                             | выбор пользователя                                            | crm_form_lead_responsibleManager_responsible           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Активность**                                         | пользовательский компонент на реестр "Активность лидов"       | crm_form_lead_activity_activity                        |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+

*%кнопка_создания_сделки%*:

*   Кнопка не отображается, если в выпадающем списке "Статус" выбрана запись
    справочника [crm_dict_leadStatus](#dictionaryLeadStatus), у которой
    crm_dict_leadStatus_end=1.

#### Сделка {#formDeal}

Код формы: crm_form_deal.

Форма содержит следующие компоненты:

+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                                | Имя компонента                                         |
+========================================================+===============================================================+========================================================+
| **Лид**                                                | ссылка на реестр "Лид"                                        | crm_form_deal_main1_lead                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Тема**                                               | выпадающий список                                             | crm_form_deal_main2_theme                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Описание**                                           | многострочное поле                                            | crm_form_deal_main2_info                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Заказ**                                              | динамическая таблица                                          | crm_form_deal_order                                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Товар                                                  | выпадающий список                                             | crm_form_deal_order_orderList                          |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Количество                                             | числовое поле                                                 | crm_form_deal_order_orderAmount                        |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Сумма                                                  | числовое поле                                                 | crm_form_deal_order_total                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Бюджет**                                             | числовое поле                                                 | crm_form_deal_main3_budget                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Статус**                                             | выпадающий список (справочник "crm_dict_dealStatus")          | crm_form_deal_main3_status                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Причина отказа                                         | многострочное поле                                            | crm_form_deal_main3_rejection                          |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Задачи**                                             | динамическая таблица                                          | crm_form_deal_tasks                                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Проект                                                 | ссылка на проект                                              | crm_form_deal_tasks_project                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Документы**                                          | динамическая таблица                                          | crm_form_deal_files                                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Файл                                                   | файл                                                          | crm_form_deal_files_file                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Ответственный менеджер**                             | выбор пользователя                                            | crm_form_deal_responsibleManager_responsible           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Активность**                                         | пользовательский компонент на реестр "Активность сделки"      | crm_form_deal_activity                                 |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+

*Поле "Сумма"*:

*   Значение поля рассчитывается как:

    `%стоимость_в_прайс-листе% * crm_form_deal_order_orderAmount`

*   Флаг "Заблокировать от изменений пользователем" включен.

*Поле "Бюджет"*:

*   Флаг "Заблокировать от изменений пользователем" включен.

*   Значение поля - сумма значений всех полей "Сумма".

*Поле "Причина отказа"*:

*   Поле отображается только в случае, если поле "Статус" имеет значение
    "Отказ".

#### Аккаунт {#formAccount}

Код формы: crm_form_account.

Форма содержит следующие компоненты:

+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                           | Имя компонента                                         |
+========================================================+==========================================================+========================================================+
| **Лид**                                                | ссылка на реестр "Лид"                                   | crm_form_account_lead_lead                             |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Логотип**                                            | файл                                                     | crm_form_account_logo                                  |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Наименование**                                       | однострочное поле                                        | crm_form_account_main_name                             |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Описание**                                           | многострочное поле                                       | crm_form_account_main_info                             |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Вид деятельности**                                   | дата                                                     | crm_form_account_main_activityCategory                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Выручка**                                            | числовое поле                                            | crm_form_account_main_revenue                          |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Численность штата**                                  | многострочное поле                                       | crm_form_account_main_staffAmount                      |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Статус**                                             | выпадающий список (справочник *crm_dict_accountStatus*)  | crm_form_account_main_status                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Телефон**                                            | динамическая таблица                                     | crm_form_account_phone                                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип номера телефона                                    | выпадающий список (справочник *crm_dict_phone*)          | crm_form_account_phone_phoneCombo                      |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Номер телефона                                         | однострочное поле                                        | crm_form_account_phone_phone                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **E-mail**                                             | динамическая таблица                                     | crm_form_account_email                                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип почтового адреса                                   | выпадающий список (справочник *crm_dict_email*)          | crm_form_account_email_emailCombo                      |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Почтовый адрес                                         | однострочное поле                                        | crm_form_account_email_email                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Адрес**                                              | динамическая таблица                                     | crm_form_account_address                               |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип адреса                                             | выпадающий список (справочник *crm_dict_address*)        | crm_form_account_address_addressCombo                  |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Адрес                                                  | многострочное поле                                       | crm_form_account_address_address                       |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Социальные сети**                                    | динамическая таблица                                     | crm_form_account_socialNetworks                        |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип социальной сети                                    | выпадающий список (справочник *crm_dict_socialNetworks*) | crm_form_account_socialNetworks_socialNetworksCombo    |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Социальная сеть                                        | ссылка                                                   | crm_form_account_socialNetworks_socialNetworks         |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Материнский аккаунт**                                | ссылка на реестр *Аккаунт*                               | crm_form_account_parentAccount_parentAccount           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Дочерние аккаунты**                                  | динамическая таблица                                     | crm_form_account_childAccount                          |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Аккаунты                                               | ссылка на реестр *Аккаунт*                               | crm_form_account_childAccount_account                  |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Ответственный менеджер**                             | выбор пользователя                                       | crm_form_account_responsibleManager_responsible        |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+

#### Контакт {#formContact}

Код формы: crm_form_contact.

Форма содержит следующие компоненты:

+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                           | Имя компонента                                         |
+========================================================+==========================================================+========================================================+
| **Лид**                                                | ссылка на реестр "Лид"                                   | crm_form_contact_lead_lead                             |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Фото**                                               | файл                                                     | crm_form_contact_photo                                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Полное имя**                                         | однострочное поле                                        | crm_form_contact_main_fullName                         |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Должность**                                          | многострочное поле                                       | crm_form_contact_main_position                         |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Дата рождения**                                      | дата                                                     | crm_form_contact_main_birthDate                        |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Статус**                                             | выпадающий список (справочник *crm_dict_contactStatus*)  | crm_form_contact_main_status                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Информация**                                         | многострочное поле                                       | crm_form_contact_main_info                             |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Телефон**                                            | динамическая таблица                                     | crm_form_contact_phone                                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип номера телефона                                    | выпадающий список (справочник *crm_dict_phone*)          | crm_form_contact_phone_phoneCombo                      |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Номер телефона                                         | однострочное поле                                        | crm_form_contact_phone_phone                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **E-mail**                                             | динамическая таблица                                     | crm_form_contact_email                                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип почтового адреса                                   | выпадающий список (справочник *crm_dict_email*)          | crm_form_contact_email_emailCombo                      |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Почтовый адрес                                         | однострочное поле                                        | crm_form_contact_email_email                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Адрес**                                              | динамическая таблица                                     | crm_form_contact_address                               |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип адреса                                             | выпадающий список (справочник *crm_dict_address*)        | crm_form_contact_address_addressCombo                  |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Адрес                                                  | многострочное поле                                       | crm_form_contact_address_address                       |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Социальные сети**                                    | динамическая таблица                                     | crm_form_contact_socialNetworks                        |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип социальной сети                                    | выпадающий список (справочник *crm_dict_socialNetworks*) | crm_form_contact_socialNetworks_socialNetworksCombo    |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Социальная сеть                                        | ссылка                                                   | crm_form_contact_socialNetworks_socialNetworks         |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Ответственный менеджер**                             | выбор пользователя                                       | crm_form_contact_responsibleManager_responsible        |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+

#### Активность лида {#formLeadActivity}

Код формы: crm_form_leadActivity.

Форма содержит следующие компоненты:

+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                         | Имя компонента                                         |
+========================================================+========================================================+========================================================+
| **Лид**                                                | ссылка на реестр "Лид"                                 | crm_form_leadActivity_main_lead                        |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| **Активности**                                         | динамическая таблица                                   | crm_form_leadActivity_activities                       |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Тип активности                                         | выпадающий список (справочник "crm_dict_activityType") | crm_form_leadActivity_activities_type                  |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Активность                                             | многострочное поле                                     | crm_form_leadActivity_activities_info                  |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Дата                                                   | дата                                                   | crm_form_leadActivity_activities_date                  |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Стоимость                                              | числовое поле                                          | crm_form_leadActivity_activities_cost                  |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| **Ответственный менеджер**                             | выбор пользователя                                     | crm_form_leadActivity_responsibleManager_responsible   |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+

#### Активность сделки {#formDealActivity}

Код формы: crm_form_dealActivity.

Форма содержит следующие компоненты:

+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                         | Имя компонента                                         |
+========================================================+========================================================+========================================================+
| **Сделка**                                             | ссылка на реестр "Сделка"                              | crm_form_dealActivity_main_deal                        |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| **Активности**                                         | динамическая таблица                                   | crm_form_dealActivity_activities                       |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Тип активности                                         | выпадающий список (справочник "crm_dict_activityType") | crm_form_dealActivity_activities_type                  |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Активность                                             | многострочное поле                                     | crm_form_dealActivity_activities_info                  |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Дата                                                   | дата                                                   | crm_form_dealActivity_activities_date                  |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Стоимость                                              | числовое поле                                          | crm_form_dealActivity_activities_cost                  |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| **Ответственный менеджер**                             | выбор пользователя                                     | crm_form_dealActivity_responsibleManager_responsible   |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+

#### % комиссии {#formComission}

Код формы: crm_form_comission.

Форма содержит следующие компоненты:

+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                         | Имя компонента                                         |
+========================================================+========================================================+========================================================+
| **% комссии**                                          | динамическая таблица                                   | crm_form_comission_main                                |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Дата начала                                            | дата                                                   | crm_form_comission_main_startDate                      |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Дата окончания                                         | дата                                                   | crm_form_comission_main_finishDate                     |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| % комиссии                                             | числовое поле                                          | crm_form_comission_main_comission                      |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+

*Поле "Дата начала"*:

*   Флаги "Заблокировать от изменений пользователем" и "Заполнять текущей
    датой/временем" включены.

*Поле "Дата окончания"*:

*   Флаг "Заблокировать от изменений пользователем" включен.

*   Компонент в последней строке заполняется текущей датой при добавлении
    новой строки динамической таблицы.

*Поле "% комиссии"*:

*   Значение поля по умолчанию при создании записи реестра - *5*.

#### Товар (услуга) {#formItem}

Код формы: crm_form_item.

Форма содержит следующие компоненты:

+--------------------------------------------------------+---------------------------------------------------------------+-------------------------------------------------+
| Поле                                                   | Тип компонента                                                | Имя компонента                                  |
+========================================================+===============================================================+=================================================+
| ID товара                                              | номер (шаблон номера "Номер товара в каталоге")               | crm_form_item_id                                |
+--------------------------------------------------------+---------------------------------------------------------------+-------------------------------------------------+
| Наименование                                           | однострочное поле                                             | crm_form_item_name                              |
+--------------------------------------------------------+---------------------------------------------------------------+-------------------------------------------------+
| Описание                                               | многострочное поле                                            | crm_form_item_description                       |
+--------------------------------------------------------+---------------------------------------------------------------+-------------------------------------------------+

#### Цена {#formPrice}

Код формы: crm_form_price

Форма содержит следующие компоненты:

+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                         | Имя компонента                                         |
+========================================================+========================================================+========================================================+
| Товар                                                  | ссылка на реестр "Каталог товаров и услуг"             | crm_form_price_item_name                               | 
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Единица измерения                                      | однострочное поле                                      | crm_form_price_unit                                    |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Цена                                                   | числовое поле                                          | crm_form_price_price                                   |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+

#### Тема сотрудничества {#formTheme}

Код формы: crm_form_theme.

Форма содержит следующие компоненты:

+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                         | Имя компонента                                         |
+========================================================+========================================================+========================================================+
| Тема сотрудничества                                    | однострочное поле                                      | crm_form_theme_theme                                   |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+

#### Шаблоны документов {#formsTemplates}

Формы для формирования шаблонов документов. Для всех форм ниже одинаково настроена таблица 
"Отправить заказчику":

*Для выпадающего списка "Источник адреса" настроены следующие значения:*

*   Аккаунт - 0

*   Контакт - 1

*   Ручной ввод - 2

При выборе в поле  значения "Аккаунт" компонент "Выбрать контакт" не отображается, 
при выборе "Контакт" компонент "Выбрать аккаунт" не отображается. При выборе значения
"Ручной ввод" компоненты "Выбрать контакт", "Выбрать аккаунт" не отображаются.

*Для компонента "Выбрать аккаунт" настроено сопоставление:*

*   `crm_form_account_email` - `crm_form_account_email` - `EQUAL`

*Для компонента "Выбрать контакт" настроено сопоставление:*

*   `crm_form_contact_email` - `crm_form_contact_email` - `EQUAL`

Таблицы "Адреса аккаунта" и "Адреса контакта" являются служебными и не отображаются 
пользователю.

##### Договор поставки (единовременная оплата) {#formContractDeliveryAll}

Код формы: crm_form_contract_delivery_100.

Форма содержит следующие компоненты:

+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Поле                             | Тип компонента                                    | Имя компонента                                         |
+==================================+===================================================+========================================================+
| **Номер договора**               | однострочное поле                                 | crm_form_contract_delivery_100_contract_number         |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Город**                        | выпадающий список (справочник crm_dict_cities)    | crm_form_contract_delivery_100_city_from               |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата договора**                | выбор даты                                        | crm_form_contract_delivery_100_contract_date           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Основание (сделка)**           | ссылка на реестр "Сделки"                         | crm_form_contract_delivery_100_deal                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Заказчик (аккаунт)**           | ссылка на реестр "Аккаунты"                       | crm_form_contract_delivery_100_client_account          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Заказчик (контакт)**           | ссылка на реестр "Контакты"                       | crm_form_contract_delivery_100_client_client           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Основание заказчика**          | однострочное поле                                 | crm_form_contract_delivery_100_client_reason           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Поставщик (организация)**      | выбор подразделений (всегда выбрана корневая нода)| crm_form_contract_delivery_100_provider                |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Представитель поставщика**     | выбор пользователя                                | crm_form_contract_delivery_100_provider_name           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Основание поставщика**         | однострочное поле                                 | crm_form_contract_delivery_100_provider_base           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Товар**                        | однострочное поле (тема сотрудничества из         | crm_form_contract_delivery_100_theme                   |
|                                  | выбранной записи в поле "Основание (сделка))"     |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Срок поставки товара**         | числовое поле                                     | crm_form_contract_delivery_100_time                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Срок поставки (прописью)**     | однострочное поле                                 | crm_form_contract_delivery_100_time_by_text            |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Город поставки**               | выпадающий список (справочник crm_dict_cities)    | crm_form_contract_delivery_100_city_to                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адрес**                        | однострочное поле                                 | crm_form_contract_delivery_100_address                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Общая сумма договора**         | числовое поле                                     | crm_form_contract_delivery_100_sum_total               |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Сумма договора (прописью)**    | однострочное поле                                 | crm_form_contract_delivery_100_sum_total_by_text       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Срок предоставления Акта**     | числовое поле                                     | crm_form_contract_delivery_100_act_time                |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Срок действия договора**       | выбор даты                                        | crm_form_contract_delivery_100_contract_time_to        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Юридический адрес Заказчика**  | многострочное поле                                | crm_form_contract_delivery_100_client_requisites1      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Юридический адрес Поставщика** | многострочное поле                                | crm_form_contract_delivery_100_provider_requisites1    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Реквизиты Заказчика**          | ссылка                                            | crm_form_contract_delivery_100_client_requisites2      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Реквизиты Поставщика**         | многострочное поле                                | crm_form_contract_delivery_100_provider_requisites2    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора (приложение)**  | однострочное поле                                 | crm_form_contract_delivery_100_contract_number_appendix|
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата договора (приложение)**   | выбор даты                                        | crm_form_contract_delivery_100_contract_date_appendix  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Перечень закупаемых товаров**  | динамическая таблица (из группы полей "Заказ"     | crm_form_contract_delivery_100_items                   |
|                                  | сделки, указанной в поле "Основание (сделка)")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   №                              | однострочное поле                                 | crm_form_deal_order_number                             |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Наименование Товара            | ссылка на реестр "Прайс-лист"                     | crm_form_deal_order_orderList                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Ед.изм.                        | однострочное поле                                 | crm_form_deal_order_unit                               |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Кол-во                         | числовое поле                                     | crm_form_deal_order_amount                             |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Цена за ед., тенге             | числовое поле                                     | crm_form_deal_order_price                              |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Сумма, тенге                   | числовое поле                                     | crm_form_deal_order_total                              |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Итого**                        | числовое поле                                     | crm_form_contract_delivery_100_items_total             |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Подпись заказчика**            | ссылка на реестр "Контакты"                       | crm_form_contract_delivery_100_client_account_appendix |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Подпись поставщика**           | выбор пользователя                                | crm_form_contract_delivery_100_provider_name_appendix  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Источник адреса**              | выпадающий список                                 | choice                                                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выбрать аккаунт**              | ссылка на реестр "Аккаунты"                       | account_link                                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выбрать контакт**              | ссылка на реестр "Контакты"                       | contact_link                                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **E-mail**                       | однострочное поле                                 | email                                                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адреса аккаунта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_account_email                                 |
|                                  | аккаунта, указанного в поле "Выбрать аккаунт")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Актуальный адрес аккаунта**    | однострочное поле                                 | crm_form_account_email_email                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адреса контакта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_contact_email                                 |
|                                  | контакта, указанного в поле "Выбрать контакт")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Актуальный адрес контакта**    | однострочное поле                                 | crm_form_contact_email_email                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+


##### Договор поставки (оплата частями) {#formContractDeliveryPart}

Код формы: crm_form_contract_delivery_part.

Форма содержит следующие компоненты:

+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| Поле                             | Тип компонента                                    | Имя компонента                                           |
+==================================+===================================================+==========================================================+
| **Номер договора**               | однострочное поле                                 | crm_form_contract_delivery_part_contract_number          |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Город**                        | выпадающий список (справочник crm_dict_cities)    | crm_form_contract_delivery_part_city_from                |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Дата договора**                | выбор даты                                        | crm_form_contract_delivery_part_contract_date            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Основание (сделка)**           | ссылка на реестр "Сделки"                         | crm_form_contract_delivery_part_deal                     |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Заказчик (аккаунт)**           | ссылка на реестр "Аккаунты"                       | crm_form_contract_delivery_part_client_account           |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Заказчик (контакт)**           | ссылка на реестр "Контакты"                       | crm_form_contract_delivery_part_client_client            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Основание заказчика**          | однострочное поле                                 | crm_form_contract_delivery_part_client_reason            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Поставщик (организация)**      | выбор подразделений (всегда выбрана корневая нода)| crm_form_contract_delivery_part_provider                 |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Представитель поставщика**     | выбор пользователя                                | crm_form_contract_delivery_part_provider_name            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Основание поставщика**         | однострочное поле                                 | crm_form_contract_delivery_part_provider_base            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Товар**                        | однострочное поле (тема сотрудничества из         | crm_form_contract_delivery_part_theme                    |
|                                  | выбранной записи в поле "Основание (сделка))"     |                                                          |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Срок поставки товара**         | числовое поле                                     | crm_form_contract_delivery_part_time                     |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Срок поставки (прописью)**     | однострочное поле                                 | crm_form_contract_delivery_part_time_by_text             |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Город поставки**               | выпадающий список (справочник crm_dict_cities)    | crm_form_contract_delivery_part_city_to                  |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Адрес**                        | однострочное поле                                 | crm_form_contract_delivery_part_address                  |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Общая сумма договора**         | числовое поле                                     | crm_form_contract_delivery_part_sum_total                |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Сумма договора (прописью)**    | однострочное поле                                 | crm_form_contract_delivery_part_sum_total_by_text        |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Размер аванса**                | однострочное поле                                 | crm_form_contract_delivery_part_avans                    |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Срок выплаты аванса**          | однострочное поле                                 | crm_form_contract_delivery_part_avans_time               |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Размер доплаты**               | однострочное поле                                 | crm_form_contract_delivery_part_balance                  |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Срок предоставления Акта**     | числовое поле                                     | crm_form_contract_delivery_part_act_time                 |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Срок действия договора**       | выбор даты                                        | crm_form_contract_delivery_part_contract_time_to         |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Юридический адрес Заказчика**  | многострочное поле                                | crm_form_contract_delivery_part_client_requisites1       |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Юридический адрес Поставщика** | многострочное поле                                | crm_form_contract_delivery_part_provider_requisites1     |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Реквизиты Заказчика**          | ссылка                                            | crm_form_contract_delivery_part_client_requisites2       |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Реквизиты Поставщика**         | многострочное поле                                | crm_form_contract_delivery_part_provider_requisites2     |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Номер договора (приложение)**  | однострочное поле                                 | crm_form_contract_delivery_part_contract_number_appendix |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Дата договора (приложение)**   | выбор даты                                        | crm_form_contract_delivery_part_contract_date_appendix   |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Перечень закупаемых товаров**  | динамическая таблица (из группы полей "Заказ"     | crm_form_contract_delivery_part_items                    |
|                                  | сделки, указанной в поле "Основание (сделка)")    |                                                          |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   №                              | однострочное поле                                 | crm_form_deal_order_number                               |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   Наименование Товара            | ссылка на реестр "Прайс-лист"                     | crm_form_deal_order_orderList                            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   Ед.изм.                        | однострочное поле                                 | crm_form_deal_order_unit                                 |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   Кол-во                         | числовое поле                                     | crm_form_deal_order_amount                               |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   Цена за ед., тенге             | числовое поле                                     | crm_form_deal_order_price                                |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   Сумма, тенге                   | числовое поле                                     | crm_form_deal_order_total                                |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Итого**                        | числовое поле                                     | crm_form_contract_delivery_part_items_total              |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Подпись заказчика**            | ссылка на реестр "Контакты"                       | crm_form_contract_delivery_part_client_account_appendix  |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Подпись поставщика**           | выбор пользователя                                | crm_form_contract_delivery_part_provider_name_appendix   |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Источник адреса**              | выпадающий список                                 | choice                                                   |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Выбрать аккаунт**              | ссылка на реестр "Аккаунты"                       | account_link                                             |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Выбрать контакт**              | ссылка на реестр "Контакты"                       | contact_link                                             |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **E-mail**                       | однострочное поле                                 | email                                                    |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Адреса аккаунта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_account_email                                   |
|                                  | аккаунта, указанного в поле "Выбрать аккаунт")    |                                                          |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Актуальный адрес аккаунта**    | однострочное поле                                 | crm_form_account_email_email                             |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Адреса контакта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_contact_email                                   |
|                                  | контакта, указанного в поле "Выбрать контакт")    |                                                          |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Актуальный адрес контакта**    | однострочное поле                                 | crm_form_contact_email_email                             |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+

##### Акт приема-передачи товара {#formCertificate}

Код формы: crm_form_certificate.

Форма содержит следующие компоненты:

+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Поле                             | Тип компонента                                    | Имя компонента                                         |
+==================================+===================================================+========================================================+
| **Заказчик**                     | ссылка на реестр "Контакт"                        | crm_form_certificate_table1_customer                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Поставщик**                    | компонент выбора подразделений                    | crm_form_certificate_table1_supplier                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Город**                        | выпадающий список (справочник crm_dict_cities)    | crm_form_certificate_table2_city                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата**                         | дата                                              | crm_form_certificate_table2_date                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Договор**                      | ссылка на реестр "Договоры поставки"              | crm_form_certificate_table3_contract                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table4_number                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table4_date                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Товар**                        | динамическая таблица                              | crm_form_certificate_table5                            |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| П/п                              | числовое поле                                     | crm_form_certificate_table5_n                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Наименование                     | ссылка на реестр "Каталог товаров и услуг"        | crm_form_certificate_table5_goods                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Количество                       | числовое поле                                     | crm_form_certificate_table5_amount                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Сумма                            | числовое поле                                     | crm_form_certificate_table5_summ                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Общая стоимость товара**       | числовое поле                                     | crm_form_certificate_table6_cost                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table7_number                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table7_date                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table8_number                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table9_date                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Аккаунт заказчика**            | ссылка на реестр "Аккаунт"                        | crm_form_certificate_table10_account                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Контакт заказчика**            | ссылка на реестр "Контакт"                        | crm_form_certificate_table10_contact                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Договор заказчика**            | ссылка на реестр "Договоры поставки"              | crm_form_certificate_table11_contract                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Подразделение исполнителя**    | компонент выбора подразделений                    | crm_form_certificate_table12_account                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Исполнитель**                  | компонент выбора пользователей                    | crm_form_certificate_table12_contact                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Договор исполнителя**          | ссылка на реестр "Договоры поставки"              | crm_form_certificate_table13_contract                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table14_number                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table15_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Список работ**                 | динамическая таблица                              | crm_form_certificate_table16                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Виды работ                       | ссылка на реестр "Каталог товаров и услуг"        | crm_form_certificate_table16_goods                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Сумма**                        | числовое поле                                     | crm_form_certificate_table17_summ1                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Сумма (прописью)**             | однострочное поле                                 | crm_form_certificate_table17_summ2                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата**                         | дата                                              | crm_form_certificate_table18_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Передал**                      | ссылка на реестр "Контакт"                        | crm_form_certificate_table19_supplier                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Принял**                       | компонент выбора пользователей                    | crm_form_certificate_table19_customer                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table20_number                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table21_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Заказчик**                     | ссылка на реестр "Контакт"                        | crm_form_certificate_table22_customer                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **ИИН/БИН заказчика**            | числовое поле                                     | crm_form_certificate_table22_customerID                |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Исполнитель**                  | компонент выбора пользователей                    | crm_form_certificate_table22_responder                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **ИИН/БИН исполнителя**          | числовое поле                                     | crm_form_certificate_table22_responderID               |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Договор**                      | ссылка на реестр "Договоры поставки"              | crm_form_certificate_table23_contract                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table23_number                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table23_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выполненные работы**           | динамическая таблица                              | crm_form_certificate_table24                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Номер                            | числовое поле                                     | crm_form_certificate_table16_goods                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Наименование                     | ссылка на реестр "Каталог товаров и услуг"        | crm_form_certificate_table24_goods                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Дата                             | дата                                              | crm_form_certificate_table24_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Сведения об отчете               | однострочное поле                                 | crm_form_certificate_table24_comment                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Единица измерения                | однострочное поле                                 | crm_form_certificate_table24_unit                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Количество                       | числовое поле                                     | crm_form_certificate_table24_amount                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Цена                             | числовое поле                                     | crm_form_certificate_table24_price                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость                        | числовое поле                                     | crm_form_certificate_table24_summ                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Итоговое количество**          | числовое поле                                     | crm_form_certificate_table25_finalAmount               |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Итоговая стоимость**           | числовое поле                                     | crm_form_certificate_table25_finalSumm                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Наименование запасов**         | однострочное поле                                 | crm_form_certificate_table26_name                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Количество запасов**           | числовое поле                                     | crm_form_certificate_table26_amount                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Стоимость запасов**            | числовое поле                                     | crm_form_certificate_table26_cost                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Количество страниц**           | числовое поле                                     | crm_form_certificate_table27_amount                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Список приложений**            | однострочное поле                                 | crm_form_certificate_list                              |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата подписания**              | дата                                              | crm_form_certificate_table28_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Заказчик**                     | ссылка на реестр "Контакт"                        | crm_form_certificate_table29_customer                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Исполнитель**                  | компонент выбора пользователей                    | crm_form_certificate_table29_responder                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Источник адреса**              | выпадающий список                                 | choice                                                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выбрать аккаунт**              | ссылка на реестр "Аккаунты"                       | account_link                                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выбрать контакт**              | ссылка на реестр "Контакты"                       | contact_link                                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **E-mail**                       | однострочное поле                                 | email                                                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адреса аккаунта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_account_email                                 |
|                                  | аккаунта, указанного в поле "Выбрать аккаунт")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Актуальный адрес аккаунта**    | однострочное поле                                 | crm_form_account_email_email                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адреса контакта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_contact_email                                 |
|                                  | контакта, указанного в поле "Выбрать контакт")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Актуальный адрес контакта**    | однострочное поле                                 | crm_form_contact_email_email                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+

*Компоненты выбора даты*:

*   Формат даты всех компонентов выбора дат - `"${dd}" ${monthed} ${yyyy}г.`

##### Коммерческое предложение {#formOffer}

Код формы: crm_form_offer.

Форма содержит следующие компоненты:

+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                                | Имя компонента                                         |
+========================================================+===============================================================+========================================================+
| **Аккаунт**                                            | ссылка на реестр "Аккаунты"                                   | crm_form_offer_account                                 |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Контакты для шапки справа**                          | ссылка на реестр "Контакты"                                   | crm_form_offer_contact1                                |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Контакты для ИО в центре после Уважаемый**           | ссылка на реестр "Контакты"                                   | crm_form_offer_contact2                                |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Должность**                                          | однострочное поле                                             | crm_form_offer_whom_position                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Аккаунт3**                                           | однострочное поле                                             | crm_form_offer_whom_account                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **ФИО**                                                | однострочное поле                                             | crm_form_offer_whom_fullname                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Уважаемый**                                          | однострочное поле                                             | crm_form_offer_address_dear                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **ИО в обращении**                                     | однострочное поле                                             | crm_form_offer_address_fullname                        |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Количество листов**                                  | однострочное поле                                             | crm_form_offer_attachment_number                       |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Должность отправителя**                              | выбор должности                                               | crm_form_offer_from_position                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **ФИО отправителя**                                    | выбор пользователя                                            | crm_form_offer_from_user                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Организация отправителя**                            | однострочное поле                                             | crm_form_offer_from_organization                       |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Прайс-листы**                                        | динамическая таблица                                          | crm_form_offer_price                                   |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Прайс-лист                                             | ссылка на реестр "Прайс-лист"                                 | crm_form_offer_price_price                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Стоимость реализации проекта**                       | динамическая таблица                                          | crm_form_offer_project_price                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Номер                                                  | однострочное поле                                             | crm_form_offer_project_price_number                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Название товара или услуги                             | однострочное поле                                             | crm_form_offer_project_price_item_name                 |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Цена                                                   | числовое поле                                                 | crm_form_offer_project_price_price                     |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Описание                                               | многострочное поле                                            | crm_form_offer_project_price_description               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Сумма                                                  | числовое поле                                                 | crm_form_offer_project_summa_summa                     |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Источник адреса**                                    | выпадающий список                                             | choice                                                 |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Выбрать аккаунт**                                    | ссылка на реестр "Аккаунты"                                   | account_link                                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Выбрать контакт**                                    | ссылка на реестр "Контакты"                                   | contact_link                                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **E-mail**                                             | однострочное поле                                             | email                                                  |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Адреса аккаунта**                                    | динамическая таблица (из группы полей "E-mail"                | crm_form_account_email                                 |
|                                                        | аккаунта, указанного в поле "Выбрать аккаунт")                |                                                        |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Актуальный адрес аккаунта                              | однострочное поле                                             | crm_form_account_email_email                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Адреса контакта**                                    | динамическая таблица (из группы полей "E-mail"                | crm_form_contact_email                                 |
|                                                        | контакта, указанного в поле "Выбрать контакт")                |                                                        |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Актуальный адрес контакта                              | однострочное поле                                             | crm_form_contact_email_email                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+

*Для компонента "Аккаунт" настроено сопоставление*:

*   `crm_form_account_main_name` - `crm_form_offer_whom_account` - `EQUAL`

*Для компонента "Контакты для шапки справа" настроено сопоставление:*

*   `crm_form_contact_main_fullName` - `crm_form_offer_whom_fullname` - `EQUAL`

*   `crm_form_contact_main_position` - `crm_form_offer_whom_position` - `EQUAL`

*Для компонента "Контакты для ИО в центре после Уважаемый" настроено сопоставление:*

*   `crm_form_contact_main_fullName` - `crm_form_offer_address_fullname` - `POSTFIX` - ! 

*Для компонента "ФИО отправителя" настроены:*

*   связь с компонентом `crm_form_offer_from_position`

*   включена опция "Изменить формат отображения ФИО в зависимости от языка системы"
    с форматом `${l} ${f.short}.${p.short.dot}`

    `%стоимость_в_прайс-листе% * crm_form_deal_order_orderAmount`

*Для компонента "Прайс-лист" настроено сопоставление:*

*   `crm_form_price_item_name` - `crm_form_offer_project_price_item_name` - `EQUAL`   

*   `crm_form_price_price` - `crm_form_offer_project_price_price` - `EQUAL`

*   `crm_form_price_description` - `crm_form_offer_project_price_description` - `EQUAL`

*Для поля "Описание":*

*   включена опция "Не удалять пробелы в начале строки"


