### Создание шаблонных документов {#create_temp_docs}

**Коммерческое предложение**

С помощью реестра "Коммерческое предложение" можно создавать коммерческие 
предложения, отправлять адресатам и распечатывать в формате `pdf`.

Для создания записи данного реестра необходимо:

1. Выделить реестр в навигаторе и кликнуть по кнопке "Создать", либо выбрать 
в контекстном меню кнопки "Создать" пункт "Новая запись". Также нажать кнопку
"Создать", далее выбрать "Шаблоны документов" и "Коммерческое предложение".

2. В открывшемся окне необходимо заполнить следующие данные:

-   *Аккаунт*. Необходимо выбрать аккаунт из реестра ["Аккаунты"](#account)
    в [компоненте выбора записи реестра](#registrychooser). При заполнении
    данного компонента автоматически заполнится однострочное поле справа,
    в котором будут отображаться данные о получателе коммерческого предложения:
    аккаунт.
    
-   *Контакты для шапки справа*. Необходимо выбрать контакт из реестра 
    ["Контакты"](#contact) в [компоненте выбора записи реестра](#registrychooser). 
    При заполнении данного компонента автоматически заполнятся однострочные
    поля справа, в котором будут отображаться данные о получателе коммерческого
    предложения: должность, полное имя.
    
-   *Контакты для ИО в центре после Уважаемый*. Необходимо выбрать тот же
    контакт, что был указан выше, из реестра ["Контакты"](#contact) в [компоненте выбора записи реестра](#registrychooser). При заполнении данного компонента автоматически 
    заполнится однострочное поле в центральной части после однострочного
    поля с текстом "Уважаемый". 
    
-   *Количество листов*. Необходимо указать количество листов приложения,
    которое находится рядом с лейблом "Приложения на".
    
-   *Должность отправителя*. Необходимо выбрать должность отправителя в
    [компоненте выбора должности](#positionchooser). При этом автоматически 
    заполнится ФИО в компоненте выбора пользователя.
    
-   *ФИО отправителя.* Компонент выбора пользователя автоматически заполняется 
    пользователем, который назначен на должность, указанную в компоненте 
    "Должность отправителя". Если присутствует несколько пользователей на данной
    должности, то выбрать другого пользователя можно, открыв [диалог выбора пользователей](#userchooser).

-   *Организация*. Необходимо ввести значение организации отправителя в 
    однострочное поле. Предварительно введен текст "ТОО «ARTA Software»".

-   *Каталог товаров и услуг*. Необходимо выбрать товар(услугу) из реестра 
    "Каталог товаров и услуг" в [компоненте выбора записи реестра](#registrychooser). 
    Возможно указание нескольких товаров(услуг), для этого необходимо кликнуть по лейблу 
    "+Добавить блок", после чего добавится еще один пустой компонент выбора
    записи реестра. При необходимости удалить строку с компонентом можно, 
    кликнув на крестик в конце строки.
    
-   *Стоимость реализации проекта:*

    -   *Номер*. Представляет собой поле для ввода текстовой информации - 
        порядкового номера пункта таблицы.
        
    -   *Название товара или услуги*. Представляет собой поле для ввода
        текстовой информации. Автоматически заполняется при выборе 
        товара(услуги) в компоненте "Каталог товаров и услуг".  

    -   *Цена*. Компонент [числовое поле](#numeric_field) автоматически 
        заполняется при выборе товара(услуги) в компоненте "Каталог товаров и услуг".

    -   *Описание*. Представляет собой многострочное поле для ввода 
        текстовой информации. Автоматически заполняется при выборе 
        товара(услуги) в компоненте "Каталог товаров и услуг".  

    При выборе одного товара(услуги) данные поля заполняются соответствующими
    значениями. При добавлении еще одного товара в следующем компоненте 
    "Каталог товаров и услуг", добавляется новый блок с указанными выше полями.

-    *Сумма*. Представляет собой [числовое поле](#numeric_field), которое автоматически 
     заполняется суммой всех значений поля "Цена".

-   *Отправить заказчику:*

    -   *Источник адреса*. Необходимо выбрать из выпадающего списка одно
         из значений. По нажатию на кнопку со стрелкой вниз раскрывается
         список со всеми возможными значениями:

         -  "Аккаунт"  
         -  "Контакт"  
         -  "Ручной ввод"  
    
    -   *Выбрать аккаунт/Выбрать контакт*. Необходимо выбрать запись реестра
        "Аккаунты" или "Контакты" (в зависимости от выбранного значения 
        поля "Источник адреса") в [компоненте выбора записи реестра](#registrychooser). 
        Данное поле не отображается, если в поле "Источник адреса" выбрано
        значение "Ручной ввод".

    -   *E-mail*. Однострочное поле для ввода текстовой информации. Если 
        в поле "Источник адреса" выбрано значение "Аккаунт" или "Контакт", 
        то в данном поле отображается первый указанный E-mail выбранного 
        аккаунта/контакта, и поле недоступно для редактирования. Если в поле 
        "Источник адреса" выбрано значение "Ручной ввод", то в данном поле 
        требуется указать электронный адрес, на который требуется отправить
        печатную форму документа.

-   *Владелец*. Поле заполняется автоматически подразделением создающего пользователя. 
    Запись в данном реестре доступна владельцу и всем его родительским подразделениям.
    Поле обязательно для заполнения, мультивыбор недоступен.
        
![Коммерческое предложение. Часть первая](resources/img/storage/offer1.png)

![Коммерческое предложение. Часть вторая](resources/img/storage/offer2.png)

![Коммерческое предложение. Часть третья](resources/img/storage/offer3.png)     

3. Для сохранения записи реестра необходимо нажать на кнопку "Сохранить". 

4. Чтобы отправить документ на адрес, указанный в поле "E-mail", необходимо
нажать на кнопку "Отправить". Для корректной отправки документа требуется 
[настроить аккаунт электронной почты](#user_settings).

5. Для перехода в режим просмотра используется кнопка "Режим редактирования".
При повторном нажатии на нее запись реестра отображается в режиме 
редактирования.

6. Файлы могут быть прикреплены в папки «Приложения» и «Прочие». Для этого 
   нажимаем "+" слева.  Прикреплять файлы к работе можно следующими вариантами: 

-   С хранилища. В коробке CRM хранилище файлов недоступно.

-   С компьютера. Выбор файлов будет осуществлен из компьютера пользователя.

-   Создать новый текстовый документ. Буден создан новый документ, в котором
    необходимо заполнить текст.

-   Сканировать. Сканер и приложение Synergy Agent устанавливаются разработчиком
    Synergy отдельно.

   Файл с компьютера можно загрузить не только с помощью пункта меню, но и перетащив 
   необходимый файл (или несколько файлов) в область «Файлы». 

**Договор поставки (единовременная оплата)**

Реестр "Договоры поставки (единовременная оплата)" по умолчанию находится в группе 
реестров "Шаблоны документов". Реестр позволяет формировать шаблон договора на 
поставку товара с условием единовременной оплаты в размере 100% суммы. 

При выборе данного реестра в основной рабочей области отображается таблица со 
столбцами, настроенными разработчиком Synergy в конфигураторе. По умолчанию 
отображаются столбцы:

- Номер договора 
- Дата договора 
- Тема договора 
- Заказчик 
- Сумма договора

Для создания записи данного реестра необходимо:

1. Выделить реестр в навигаторе и кликнуть по кнопке "Создать", либо выбрать 
в контекстном меню кнопки "Создать" пункт "Новая запись". Также нажать кнопку
"Создать", далее выбрать "Шаблоны документов" и "Договор поставки 
(единовременная оплата)". 

2. В открывшемся окне необходимо заполнить следующие данные:

- *Номер договора*. Однострочное поле для ввода текстовой информации, в которое
необходимо ввести номер договора.

- *Город*. Необходимо выбрать из выпадающего списка одно из значений. По нажатию на 
кнопку со стрелкой вниз раскрывается список со всеми возможными значениями. Перечень 
значений зависит от элементов справочника ["Города Казахстана"](#dictionaryCities).

- *Дата договора*. Поле выбора даты, по умолчанию заполняется текущей датой. Дата, 
введенная в этом поле, будет отображена в формате:

>> "%число%" %название_месяца_в_родительном_падеже% %год%г.

- *Основание (сделка)*. Необходимо выбрать сделку из реестра "Сделки" с помощью 
[компонента выбора записи реестра](#registrychooser). 

- *Заказчик (аккаунт)*. Необходимо выбрать организацию из реестра "Аккаунты" с помощью 
[компонента выбора записи реестра](#registrychooser). 

- *Заказчик (контакт)*. Необходимо выбрать представителя организации Заказчика из 
реестра "Контакты" с помощью [компонента выбора записи реестра](#registrychooser). 

- *Основание заказчика*. Однострочное поле для ввода текстовой информации. 

- *Поставщик (организация)*. Поле для выбора подразделения. По умолчанию в поле выбрано 
головное подразделение организации, заблокировано для изменения. Название организации, 
отображаемое в этом поле, указывается администратором Synergy.

- *Представитель поставщика*. Необходимо нажать на кнопку справа от поля ввода 
[компонента выбора пользователя](#userchooser) и в открывшемся диалоге выбрать нужного 
пользователя.

- *Основание поставщика*. Однострочное поле для ввода текстовой информации. 

- *Товар*. Однострочное поле для ввода текстовой информации. Если заполнено поле 
"Основание (сделка)", то данное поле автоматически заполняется значением поля "Тема" 
выбранной [сделки](#deal).

- *Срок поставки товара*. Представляет собой [числовое поле](#numeric_field). 
В поле необходимо ввести количество рабочих дней со дня подписания Договора, в течение 
которых необходимо поставить Товар.

- *Срок поставки (прописью)*. Однострочное поле для ввода текстовой информации. 

- *Город поставки*. Необходимо выбрать из выпадающего списка одно из значений. По 
нажатию на кнопку со стрелкой вниз раскрывается список со всеми возможными значениями. 
Перечень значений зависит от элементов справочника ["Города Казахстана"](#dictionaryCities).

- *Адрес*. Однострочное поле для ввода текстовой информации. 

- *Общая сумма договора*. Представляет собой [числовое поле](#numeric_field). 
В поле необходимо указать итоговую сумму договора с учетом НДС.

- *Сумма договора (прописью)*. Однострочное поле для ввода текстовой информации. 

- *Срок предоставления Акта*. Представляет собой [числовое поле](#numeric_field). 
В поле необходимо количество рабочих дней со дня поставки Товара, в течение 
которых необходимо предоставить Акт.

- *Срок действия договора*. Поле выбора даты. Дата, введенная в этом поле, будет 
отображена в формате:

>> "%число%" %название_месяца_в_родительном_падеже% %год%г.

- *Юридический адрес Заказчика*. Представляет собой многострочное поле для ввода 
текстовой информации.

- *Юридический адрес Поставщика*. Представляет собой многострочное поле для ввода 
текстовой информации.

- *Реквизиты Заказчика*. Представляет собой многострочное поле для ввода текстовой 
информации.

- *Реквизиты Поставщика*. Представляет собой многострочное поле для ввода текстовой 
информации.

- *Номер договора (приложение)*. Однострочное поле для ввода текстовой информации.

- *Дата договора (приложение)*. Поле выбора даты, по умолчанию заполняется текущей 
датой. Дата, введенная в этом поле, будет отображена в формате:

>> "%число%" %название_месяца_в_родительном_падеже% %год%г.

- *Перечень закупаемых товаров:*

    -   *№*. Представляет собой поле для ввода текста. В поле вводится номер 
позиции заказа.

    -   *Наименование Товара*. Необходимо выбрать товар из реестра "Каталог товаров и услуг" 
с помощью [компонента выбора записи реестра](#registrychooser). 

    -   *Ед. изм.* Представляет собой поле для ввода текста. В поле необходимо 
указать единицу измерения выбранного товара. 

    -   *Кол-во*. Представляет собой [числовое поле](#numeric_field). В поле 
необходимо указать количество экземпляров выбранного товара.

    -   *Цена за ед., тенге* Представляет собой [числовое поле](#numeric_field). 
В поле необходимо указать цену за единицу выбранного товара.

    -   *Сумма, тенге*. Представляет собой [числовое поле](#numeric_field). 
В поле необходимо указать итоговую стоимость выбранного товара.
        
> Если указано основание (сделка), то таблица заполнится автоматически списком 
товаров, указанных в выбранной сделке. Также доступно ручное заполнение таблицы.

> Возможно указание нескольких товаров, для этого необходимо кликнуть по лейблу 
"+Добавить блок", после чего добавятся вышеупомянутые компоненты. При необходимости 
удалить блок с компонентами можно, кликнув на крестик в конце блока.

- *Итого*. Представляет собой [числовое поле](#numeric_field). В поле необходимо 
указать итоговую стоимость всех указанных товаров.

- *Подпись заказчика*. Необходимо выбрать представителя организации Заказчика из 
реестра "Контакты" с помощью [компонента выбора записи реестра](#registrychooser). 
Данное поле автоматически заполняется тем же контактом, который указан в поле 
"Заказчик (контакт)".

- *Подпись поставщика*. Поле для выбора пользователя с помощью 
[компонента выбора пользователя](#userchooser). Данное поле автоматически заполняется 
тем же пользователем, который указан в поле "Представитель поставщика".

- *Источник адреса*. Необходимо выбрать из выпадающего списка одно из значений. 
По нажатию на кнопку со стрелкой вниз раскрывается список со всеми возможными 
значениями:

    - "Аккаунт" 
    - "Контакт"
    - "Ручной ввод"

- *Выбрать аккаунт/контакт*. Поле выбора записи из реестра "Аккаунты" или "Контакты" 
(в зависимости от выбранного значения поля "Источник адреса") с помощью 
[компонента выбора записи реестра](#registrychooser). Данное поле не отображается, если
в поле "Источник адреса" выбрано значение "Ручной ввод".

- *E-mail*. Однострочное поле для ввода текстовой информации. Если в поле "Источник адреса" 
выбрано значение "Аккаунт" или "Контакт", то в данном поле отображается первый указанный 
E-mail выбранного аккаунта/контакта, и поле недоступно для редактирования. Если в поле 
"Источник адреса" выбрано значение "Ручной ввод", то в данном поле требуется указать 
электронный адрес, на который требуется отправить печатную форму договора.

-   *Владелец*. Поле заполняется автоматически подразделением создающего пользователя. 
    Запись в данном реестре доступна владельцу и всем его родительским подразделениям.
    Поле обязательно для заполнения, мультивыбор недоступен.

![Договор поставки (единовременная оплата). Первая часть](resources/img/storage/contract_all_1.png)

![Договор поставки (единовременная оплата). Вторая часть](resources/img/storage/contract_all_2.png)

![Договор поставки (единовременная оплата). Третья часть](resources/img/storage/contract_all_3.png)

![Договор поставки (единовременная оплата). Четвертая часть](resources/img/storage/contract_all_4.png)

![Договор поставки (единовременная оплата). Пятая часть](resources/img/storage/contract_all_5.png)

![Договор поставки (единовременная оплата). Шестая часть](resources/img/storage/contract_all_6.png)

3. Для сохранения записи реестра необходимо нажать на кнопку "Сохранить". 

4. Чтобы отправить документ на адрес, указанный в поле "E-mail", необходимо
нажать на кнопку "Отправить". Для корректной отправки документа требуется 
[настроить аккаунт электронной почты](#user_settings).

5. Для перехода в режим просмотра используется кнопка "Режим редактирования".
При повторном нажатии на нее запись реестра отображается в режиме 
редактирования.

**Договоры поставки (оплата частями)**

Реестр "Договоры поставки (оплата частями)" по умолчанию находится в группе 
реестров "Шаблоны документов". Реестр позволяет формировать шаблон договора на 
поставку товара с условием выплаты аванса и дальнейшего рассчета в течение 
оговоренного срока. 

При выборе данного реестра в основной рабочей области отображается таблица со 
столбцами, настроенными разработчиком Synergy в конфигураторе. По умолчанию 
отображаются столбцы:

- Номер договора 
- Дата договора 
- Тема договора 
- Заказчик 
- Сумма договора

Для создания записи данного реестра необходимо:

1. Выделить его в навигаторе и кликнуть по кнопке "Создать", либо выбрать 
в контекстном меню кнопки "Создать" пункт "Новая запись". Также нажать кнопку
"Создать", далее выбрать "Шаблоны документов" и "Договор поставки 
(оплата частями)".

2. Заполнение договора поставки с оплатой частями аналогично 
[договору поставки с единовременной оплатой](#contract_all): форма содержит те же поля, 
что и договор единовременной выплаты, и дополнительно поля:

- *Размер аванса*. Однострочное поле для ввода текстовой информации.

- *Срок выплаты аванса*. Однострочное поле для ввода текстовой информации.

- *Размер доплаты*. Однострочное поле для ввода текстовой информации.

-   *Владелец*. Поле заполняется автоматически подразделением создающего пользователя. 
    Запись в данном реестре доступна владельцу и всем его родительским подразделениям.
    Поле обязательно для заполнения, мультивыбор недоступен.

![Договор поставки (оплата частями). Первая часть](resources/img/storage/contract_part_1.png)

![Договор поставки (оплата частями). Вторая часть](resources/img/storage/contract_part_2.png)

![Договор поставки (оплата частями). Третья часть](resources/img/storage/contract_part_3.png)

![Договор поставки (оплата частями). Четвертая часть](resources/img/storage/contract_part_4.png)

![Договор поставки (оплата частями). Пятая часть](resources/img/storage/contract_part_5.png)

![Договор поставки (оплата частями). Шестая часть](resources/img/storage/contract_part_6.png)

3. Для сохранения записи реестра необходимо нажать на кнопку "Сохранить". 

4. Чтобы отправить документ на адрес, указанный в поле "E-mail", необходимо
нажать на кнопку "Отправить". Для корректной отправки документа требуется 
[настроить аккаунт электронной почты](#user_settings).

5. Для перехода в режим просмотра используется кнопка "Режим редактирования".
При повторном нажатии на нее запись реестра отображается в режиме 
редактирования.

**Акт приема-передачи товара**

Реестр "Акты приема-передачи товара" по умолчанию находится в группе реестров 
"Шаблоны документов". Реестр позволяет формировать шаблон акта приема-передачи 
товара с приложениями. 

При выборе данного реестра в основной рабочей области отображается таблица со 
столбцами, настроенными разработчиком Synergy в конфигураторе. По умолчанию 
отображаются столбцы:

- Дата
- Основание договора

Для создания записи данного реестра необходимо:

1. Выделить его в навигаторе и кликнуть по кнопке "Создать", либо выбрать 
в контекстном меню кнопки "Создать" пункт "Новая запись". Также нажать кнопку
"Создать", далее выбрать "Шаблоны документов" и "Акт приема-передачи товара".

**Основная форма акта (илл. "Акт приема-передачи товара. Первая часть"):**

![Акт приема-передачи товара. Первая часть](resources/img/storage/act1.png)

2. В открывшемся окне необходимо заполнить следующие данные:

- *Заказчик*. Необходимо выбрать организацию из реестра "Аккаунты" с помощью 
[компонента выбора записи реестра](#registrychooser). 

- *Поставщик*. Поле для выбора подразделения. 

- *Город*. Необходимо выбрать из выпадающего списка одно из значений. По нажатию на 
кнопку со стрелкой вниз раскрывается список со всеми возможными значениями. Перечень 
значений зависит от элементов справочника ["Города Казахстана"](#dictionaryCities).

- *Дата*. Поле выбора даты. Дата, введенная в этом поле, будет отображена в формате:

>> "%число%" %название_месяца_в_родительном_падеже% %год% г.

- *Договор*. Необходимо выборать договор из реестра "Договоры поставки 
(единовременная оплата)" с помощью [компонента выбора записи реестра](#registrychooser). 

- *Номер договора*. Однострочное поле для ввода текстовой информации. Автоматически 
заполняется номером договора, выбранного в поле "Договор".

- *Дата заключения договора*. Поле выбора даты, по умолчанию заполняется датой договора, 
выбранного в поле "Договор". Дата, введенная в этом поле, будет отображена в формате:

>> "%число%" %название_месяца_в_родительном_падеже% %год% г.

- *Товар*:

    - *П/п*. Представляет собой поле для ввода текста. В поле вводится номер позиции 
товара.

    - *Наименование*. Необходимо выбрать товар из реестра "Каталог товаров и услуг" с 
помощью [компонента выбора записи реестра](#registrychooser). 

    - *Количество*. Представляет собой [поле для ввода чисел](#numeric_field). В поле 
необходимо указать количество экземпляров выбранного товара.

    - *Сумма*. Представляет собой [поле для ввода чисел](#numeric_field). В поле 
необходимо указать итоговую стоимость выбранного товара.

> Возможно указание нескольких товаров, для этого необходимо кликнуть по лейблу 
"+Добавить блок", после чего добавятся вышеупомянутые компоненты. При необходимости 
удалить блок с компонентами можно, кликнув на крестик в конце блока.

- *Общая строимость товара*. Представляет собой [поле для ввода чисел](#numeric_field). 
В поле необходимо указать итоговую стоимость всех указанных товаров.

- *Номер договора*. Однострочное поле для ввода текстовой информации.

- *Дата заключения договора*. Поле выбора даты. Дата, введенная в этом поле, будет 
отображена в формате:

>> "%число%" %название_месяца_в_родительном_падеже% %год% г.

**Форма Приложения №2 (илл. "Акт приема-передачи товара. Вторая часть"):**

![Акт приема-передачи товара. Вторая часть](resources/img/storage/act2.png)

- *Номер договора*. Однострочное поле для ввода текстовой информации.

- *Дата заключения договора*. Поле выбора даты. Дата, введенная в этом поле, будет 
отображена в формате:

>> "%число%" %название_месяца_в_родительном_падеже% %год% г.

- *Аккаунт заказчика*. Необходимо выбрать организацию из реестра "Аккаунты" с помощью 
[компонента выбора записи реестра](#registrychooser). 

- *Контакт заказчика*. Необходимо выбрать представителя организации Заказчика из 
реестра "Контакты" с помощью [компонента выбора записи реестра](#registrychooser). 

- *Договор заказчика*. Необходимо выборать договор из реестра "Договоры поставки 
(единовременная оплата)" с помощью [компонента выбора записи реестра](#registrychooser). 

- *Подразделение исполнителя*. Поле для выбора подразделения. 

- *Исполнитель*. Поле для выбора пользователя с помощью 
[компонента выбора пользователя](#userchooser).

- *Договор исполнителя*. Необходимо выборать договор из реестра "Договоры поставки 
(единовременная оплата)" с помощью [компонента выбора записи реестра](#registrychooser). 

- *Номер договора*. Однострочное поле для ввода текстовой информации.

- *Дата заключения договора*. Поле выбора даты. Дата, введенная в этом поле, будет 
отображена в формате:

>> "%число%" %название_месяца_в_родительном_падеже% %год% г.

- *Список работ*:

    - Виды работ - реестр "Каталог товаров и услуг"

- *Сумма*. Представляет собой [поле для ввода чисел](#numeric_field). 

- *Сумма (прописью)*. Однострочное поле для ввода текстовой информации.

- *Дата подписания акта*. Поле выбора даты. Дата, введенная в этом поле, будет 
отображена в формате:

>> "%число%" %название_месяца_в_родительном_падеже% %год% г.

- *Передал*. Необходимо выбрать запись из реестра "Контакты" с помощью 
[компонента выбора записи реестра](#registrychooser). 

- *Принял*. Поле для выбора пользователя с помощью 
[компонента выбора пользователя](#userchooser).

**Форма Приложения №8 (илл. "Акт приема-передачи товара. Третья часть"):**

![Акт приема-передачи товара. Третья часть](resources/img/storage/act3.png)

- *Номер договора*. Однострочное поле для ввода текстовой информации.

- *Дата заключения договора*. Поле выбора даты. Дата, введенная в этом поле, будет 
отображена в формате:

>> "%число%" %название_месяца_в_родительном_падеже% %год% г.

- *Заказчик*. Необходимо выбрать запись из реестра "Контакты" с помощью 
[компонента выбора записи реестра](#registrychooser). 

- *ИИН/БИН заказчика*. Представляет собой [поле для ввода чисел](#numeric_field). 

- *Исполнитель*. Поле для выбора пользователя с помощью 
[компонента выбора пользователя](#userchooser).

- *ИИН/БИН исполнителя*. Представляет собой [поле для ввода чисел](#numeric_field). 

- *Договор*. Необходимо выборать договор из реестра "Договоры поставки 
(единовременная оплата)" с помощью [компонента выбора записи реестра](#registrychooser).

- *Номер договора*. Однострочное поле для ввода текстовой информации. Автоматически 
заполняется номером договора, выбранного в поле "Договор".

- *Дата заключения договора*. Поле выбора даты, по умолчанию заполняется датой договора, 
выбранного в поле "Договор". Дата, введенная в этом поле, будет отображена в формате:

>> "%число%" %название_месяца_в_родительном_падеже% %год% г.

- *Выполненные работы*:

    - *Номер*. Представляет собой поле для ввода текста.

    - *Наименование*. Необходимо выбрать товар из реестра "Каталог товаров и услуг" с 
помощью [компонента выбора записи реестра](#registrychooser). 

    - *Дата*. Поле выбора даты выполнения работы (оказания услуги).

    - *Сведения об отчете*. Представляет собой поле для ввода текста.

    - *Единица измерения*. Представляет собой поле для ввода текста. Необходимо указать единицу
измерения работы/услуги.

    - *Количество*. Представляет собой [поле для ввода чисел](#numeric_field). 

    - *Цена*. Представляет собой [поле для ввода чисел](#numeric_field). Необходимо указать 
стоимость выполнения единицы работы/услуги.

    - *Стоимость*. Представляет собой [поле для ввода чисел](#numeric_field). Необходимо указать 
общую стоимость выполнения работы/услуги.

> Возможно указание нескольких работ/услуг, для этого необходимо кликнуть по лейблу 
"+Добавить блок", после чего добавятся вышеупомянутые компоненты. При необходимости 
удалить блок с компонентами можно, кликнув на крестик в конце блока.

- *Итоговое количество*. Представляет собой [поле для ввода чисел](#numeric_field). Необходимо 
указать количество единиц выполненных работ/оказанных услуг.

- *Итоговая стоимость*. Представляет собой [поле для ввода чисел](#numeric_field). Необходимо 
указать общую стоимость выполненных работ/оказанных услуг.

- *Наименование запасов*. Однострочное поле для ввода текстовой информации.

- *Количество запасов*. Представляет собой [поле для ввода чисел](#numeric_field).

- *Стоимость запасов*. Представляет собой [поле для ввода чисел](#numeric_field).

- *Количество страниц*. Представляет собой [поле для ввода чисел](#numeric_field). 

- *Список приложений*. Однострочное поле для ввода текстовой информации.

- *Дата подписания (принятия) работ (услуг)*. Поле выбора даты. Дата, введенная в этом поле, 
будет отображена в формате:

>> "%число%" %название_месяца_в_родительном_падеже% %год% г.

- *Заказчик*. Необходимо выбрать представителя организации Заказчика из 
реестра "Контакты" с помощью [компонента выбора записи реестра](#registrychooser). 

- *Исполнитель*. Поле для выбора пользователя с помощью 
[компонента выбора пользователя](#userchooser).

**Отправить заказчику:**

- *Источник адреса*. Необходимо выбрать из выпадающего списка одно из значений. 
По нажатию на кнопку со стрелкой вниз раскрывается список со всеми возможными 
значениями:

    - "Аккаунт"  
    - "Контакт"  
    - "Ручной ввод" 

- *Выбрать аккаунт/контакт*. Поле выбора записи из реестра "Аккаунты" или "Контакты" 
(в зависимости от выбранного значения поля "Источник адреса") с помощью 
[компонента выбора записи реестра](#registrychooser). Данное поле не отображается, если
в поле "Источник адреса" выбрано значение "Ручной ввод".

- *E-mail*. Однострочное поле для ввода текстовой информации. Если в поле "Источник адреса" 
выбрано значение "Аккаунт" или "Контакт", то в данном поле отображается первый указанный 
E-mail выбранного аккаунта/контакта, и поле недоступно для редактирования. Если в поле 
"Источник адреса" выбрано значение "Ручной ввод", то в данном поле требуется указать 
электронный адрес, на который требуется отправить печатную форму договора.

-   *Владелец*. Поле заполняется автоматически подразделением создающего пользователя. 
    Запись в данном реестре доступна владельцу и всем его родительским подразделениям.
    Поле обязательно для заполнения, мультивыбор недоступен.

3. Для сохранения записи реестра необходимо нажать на кнопку "Создать акт". 

> **Примечание:** для реестра настроено событие активации - отправка печатной формы документа на 
адрес, указанный в поле "E-mail". Для корректной отправки документа требуется 
[настроить аккаунт электронной почты](#user_settings).

4. Для перехода в режим просмотра используется кнопка "Режим редактирования". При повторном 
нажатии на нее запись реестра отображается в режиме редактирования.

**Счет-фактура**

Реестр "Счет-фактуры" по умолчанию находится в группе реестров 
"Шаблоны документов". Реестр позволяет формировать шаблон счет-фактуры 
на основании ранее созданного договора. 

При выборе данного реестра в основной рабочей области отображается таблица со 
столбцами, настроенными разработчиком Synergy в конфигураторе. По умолчанию 
отображаются столбцы:

- Номер
- Дата
- Грузополучатель
- Получатель
- Стоимость реализации

Для создания записи данного реестра необходимо:

1. Выделить его в навигаторе и кликнуть по кнопке "Создать", либо выбрать 
в контекстном меню кнопки "Создать" пункт "Новая запись". Также нажать кнопку
"Создать", далее выбрать "Шаблоны документов" и "Счет-фактура".

2. В открывшемся окне необходимо заполнить следующие данные:

- *Номер счета*. Однострочное поле для ввода текстовой информации.

- *Дата счета*. Поле выбора даты, по умолчанию заполняется текущей датой. Дата, 
введенная в этом поле, будет отображена в формате:

>> %чч%.%ММ%.%гггг% г.

- *Основание (договор поставки)*: поля, предназначенные для указания договора, 
на основании которого составляется счет-фактура. Поскольку договоры с разными 
формами оплаты расположены в разных реестрах, на выбор пользователю предоставляется 
два поля. Необходимо заполнить поле, соответствующее типу используемого договора.

    - *Единовременная оплата*. Необходимо выбрать договор из реестра "Договоры поставки 
(единовременная оплата)" с помощью [компонента выбора записи реестра](#registrychooser). 

    - *Оплата частями*. Необходимо выбрать договор из реестра "Договоры поставки 
(оплата частями)" с помощью [компонента выбора записи реестра](#registrychooser). 

- *Сведения о поставщике*: группа полей, в которой указываются сведения об 
организации-поставщике.

    - *Наименование*. Поле для выбора подразделения. По умолчанию в поле выбрано 
головное подразделение организации, заблокировано для изменения. Название организации, 
отображаемое в этом поле, указывается администратором Synergy.

    - *БИН*. Однострочное поле для ввода текстовой информации. Корректным значением 
поля считается число из 12 цифр.

    - *Адрес*. Представляет собой многострочное поле для ввода текстовой информации.

    - *ИИК*. Однострочное поле для ввода текстовой информации. Необходимо ввести ИИК
 организации с указанием наименования банка.

    - *БИК*. Однострочное поле для ввода текстовой информации.

    - *Свидетельство о постановке на регистрационный учет по НДС*:

        - *Серия*. Однострочное поле для ввода текстовой информации.

        - *Номер*. Однострочное поле для ввода текстовой информации.

        - *Дата выдачи*. Поле выбора даты. Дата, введенная в этом поле, 
будет отображена в формате:

>>> %чч%.%ММ%.%гггг% г.

- *Номер договора (контракта) на поставку*. Однострочное поле для ввода номера 
договора (контракта) на поставку. Автоматически заполняется номером договора, выбранного 
в разделе "Основание (договор поставки)".

- *Дата договора (контракта) на поставку*. Поле выбора даты. Дата, введенная в 
этом поле, будет отображена в формате:

>> %чч%.%ММ%.%гггг% г.

- *Условия оплаты по договору (контракту)*. Необходимо выбрать из выпадающего списка 
одно из значений. По нажатию на кнопку со стрелкой вниз раскрывается список со всеми 
возможными значениями. Перечень значений зависит от элементов справочника 
["Условия оплаты"](#dictionaryPaymentMode).

- *Адрес*: группа полей, где указывается адрес поставки товаров или предоставления 
услуг. 

    - *Республика*. Однострочное поле для ввода текстовой информации. По умолчанию 
значение поля: "Республика Казахстан".

    - *Город*. Необходимо выбрать из выпадающего списка одно из значений. По нажатию на 
кнопку со стрелкой вниз раскрывается список со всеми возможными значениями. Перечень 
значений зависит от элементов справочника ["Города Казахстана"](#dictionaryCities). 
Автоматически заполняется городом поставки товара из договора, выбранного в разделе 
"Основание (договор поставки)".

    - *Улица*. Однострочное поле для ввода текстовой информации. Автоматически заполняется 
адресом поставки товара из договора, выбранного в разделе "Основание (договор поставки)".

- *Доверенность*. Однострочное поле для ввода текстовой информации. По умолчанию 
значение поля: "без доверенности".

- *Способ отправления*. Необходимо выбрать из выпадающего списка одно из значений. 
По нажатию на кнопку со стрелкой вниз раскрывается список со всеми возможными 
значениями. Перечень значений зависит от элементов справочника 
["Способы отправления"](#dictionaryDeliverytMode).

- *Товарно-транспортная накладная*. Однострочное поле для ввода текстовой информации. 

- *Грузоотправитель*: группа полей, где указываются сведения об организации, непосредственно 
отправившей товар, выполнившей работу или оказавшей услугу.

    - *БИН*. Однострочное поле для ввода текстовой информации. Корректным значением 
поля считается число из 12 цифр.
    
    - *Наименование*. Однострочное поле для ввода текстовой информации.

    - *Адрес*. Представляет собой многострочное поле для ввода текстовой информации.

- *Грузополучатель*: группа полей, где указываются сведения об организации, непосредственно 
получившей товар, работу или услугу.

    - *БИН*. Однострочное поле для ввода текстовой информации. Корректным значением 
поля считается число из 12 цифр.
    
    - *Наименование*. Однострочное поле для ввода текстовой информации. 

    - *Адрес*. Представляет собой многострочное поле для ввода текстовой информации.

- *Получатель*: группа полей, где указываются сведения об организации, являвшейся заказчиком 
товара, работы или услуги.

    - *Наименование*. Необходимо выбрать представителя организации Заказчика из 
реестра "Аккаунты" с помощью [компонента выбора записи реестра](#registrychooser). Автоматически 
заполняется наименованием заказчика из договора, выбранного в разделе "Основание 
(договор поставки)".

    - *БИН*. Однострочное поле для ввода текстовой информации. Корректным значением 
поля считается число из 12 цифр.

    - *Адрес*. Представляет собой многострочное поле для ввода текстовой информации.

    - *ИИК*. Однострочное поле для ввода текстовой информации. Необходимо ввести ИИК
 организации с указанием наименования банка.

    - *БИК*. Однострочное поле для ввода текстовой информации.

- *Перечень закупаемых товаров*: таблица, содержащая перечень товаров, работ или услуг. 
Часть полей заполняется автоматически на основании соответствующей таблицы из договора, 
выбранного в разделе "Основание (договор поставки)".

    - *№ п/п*. Представляет собой поле для ввода текста. В поле вводится номер 
позиции заказа. При наличии этих данных в указанном договоре заполняется автоматически.

    - *Наименование товаров (работ, услуг)*. Необходимо выбрать товар из реестра 
"Прайс-лист" с помощью [компонента выбора записи реестра](#registrychooser). 
При наличии этих данных в указанном договоре заполняется автоматически.

    - *Ед. изм.* Представляет собой поле для ввода текста. В поле необходимо 
указать единицу измерения выбранного товара, работы или услуги. При наличии 
этих данных в указанном договоре заполняется автоматически. 

    - *Кол-во (объем)*. Представляет собой [числовое поле](#numeric_field). 
В поле необходимо указать количество экземпляров выбранного товара, работы или услуги. 
При наличии этих данных в указанном договоре заполняется автоматически. 

    - *Цена (KZT)*. Представляет собой [числовое поле](#numeric_field). 
В поле необходимо указать цену единицы товара, работы или услуги. При наличии этих 
данных в указанном договоре заполняется автоматически. 

    - *Стоимость товаров (работ, услуг) без НДС*. Представляет собой 
[поле для ввода чисел](#numeric_field). В поле необходимо указать итоговую стоимость 
выбранной позиции. При наличии этих данных в указанном договоре заполняется автоматически. 

    - *Ставка НДС*. Представляет собой [числовое поле](#numeric_field). В поле 
необходимо указать процентную ставку НДС. В случае, если текущая позиция не облагается НДС, 
в поле необходимо ввести значение `0`.

    - *Сумма НДС*. Представляет собой [числовое поле](#numeric_field). В поле 
необходимо указать сумму НДС для текущей позиции. 

    - *Всего стоимость реализации*. Представляет собой [числовое поле](#numeric_field). 
В поле необходимо указать итоговую стоимость текущей позиции с учетом НДС. 

    - *Ставка акциз*. Представляет собой [числовое поле](#numeric_field). В поле 
необходимо указать процентную ставку акциз. 

    - *Сумма акциз*. Представляет собой [числовое поле](#numeric_field). В поле 
необходимо указать сумму акциз для текущей позиции. 

- *Всего по счету*:

    - *Стоимость товаров (работ, услуг) без НДС*. Представляет собой 
[числовое поле](#numeric_field). В поле необходимо указать суммарную стоимость 
по всем позициям без учета НДС.

    - *Сумма НДС*. Представляет собой [числовое поле](#numeric_field). 
В поле необходимо указать сумму НДС по всем позициям.

    - *Всего стоимость реализации*. Представляет собой 
[числовое поле](#numeric_field). В поле необходимо указать итоговую стоимость 
по всем позициям с учетом НДС.

    - *Сумма акциз*. Представляет собой [числовое поле](#numeric_field). В поле 
необходимо указать сумму акциз по всем позициям.

- *Руководитель*. Необходимо выбрать руководителя организации-заказчика из 
реестра "Контакты" с помощью [компонента выбора записи реестра](#registrychooser). 
Автоматически заполняется сведениями о представителе Заказчика из договора, выбранного 
в разделе "Основание (договор поставки)".

- *Главный бухгалтер*. Однострочное поле для ввода текстовой информации. Необходимо 
указать сведения о главном бухгалтере организации-заказчика, если он предусмотрен, 
или ввести текст "не предусмотрен" в противном случае.

- *Источник адреса*. Необходимо выбрать из выпадающего списка одно из значений. 
По нажатию на кнопку со стрелкой вниз раскрывается список со всеми возможными 
значениями:

    - "Аккаунт" 
    - "Контакт"
    - "Ручной ввод"

- *Выбрать аккаунт/контакт*. Поле выбора записи из реестра "Аккаунты" или "Контакты" 
(в зависимости от выбранного значения поля "Источник адреса") с помощью 
[компонента выбора записи реестра](#registrychooser). Данное поле не отображается, если
в поле "Источник адреса" выбрано значение "Ручной ввод".

- *E-mail*. Однострочное поле для ввода текстовой информации. Если в поле "Источник адреса" 
выбрано значение "Аккаунт" или "Контакт", то в данном поле отображается первый указанный 
E-mail выбранного аккаунта/контакта, и поле недоступно для редактирования. Если в поле 
"Источник адреса" выбрано значение "Ручной ввод", то в данном поле требуется указать 
электронный адрес, на который требуется отправить печатную форму счет-фактуры.

-   *Владелец*. Поле заполняется автоматически подразделением создающего пользователя. 
    Запись в данном реестре доступна владельцу и всем его родительским подразделениям.
    Поле обязательно для заполнения, мультивыбор недоступен.

![Счет-фактура](resources/img/storage/form_invoice.png)

3. Для сохранения записи реестра необходимо нажать на кнопку "Сохранить".

4. Чтобы отправить документ на адрес, указанный в поле "E-mail", необходимо
нажать на кнопку "Отправить". Для корректной отправки документа требуется 
[настроить аккаунт электронной почты](#user_settings).

5. Для перехода в режим просмотра используется кнопка "Режим редактирования".
При повторном нажатии на нее запись реестра отображается в режиме 
редактирования.


