<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output 
		indent="yes" 
		doctype-system="http://www.oasis-open.org/docbook/xml/4.4/docbookx.dtd"
		doctype-public="-//OASIS//DTD DocBook XML V4.4//EN"/>

    <!-- Copy all -->
    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>

	<!-- Add releaseinfo if not present -->
	<!-- Maybe we should explictly replace it? 
		 It seems we have to
		 add another template in that case -->
	<xsl:template match="/book/bookinfo[not(pubdate)][not(releaseinfo)]">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
			<pubdate>Дата сборки документа: 
				<xsl:processing-instruction name="dbtimestamp">
					format="Y.m.d H:M:S"
				</xsl:processing-instruction>
			</pubdate>
			<releaseinfo>Ревизия VCS: <xsl:value-of select="$vcs.revision" /></releaseinfo>
			<releaseinfo>Последним изменил: <xsl:value-of select="$vcs.changedby" /></releaseinfo>
            <xsl:apply-templates select="node()"/>
        </xsl:copy>
	</xsl:template>
	<!-- Deal with chapters -->
	<xsl:template match="/book/chapter[not(chapterinfo)]">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
			<chapterinfo>
				<pubdate>Дата сборки документа: 
					<xsl:processing-instruction name="dbtimestamp">
						format="Y.m.d H:M:S"
					</xsl:processing-instruction>
				</pubdate>
				<releaseinfo>Ревизия VCS: <xsl:value-of select="$vcs.revision" /></releaseinfo>
			</chapterinfo>
            <xsl:apply-templates select="node()"/>
        </xsl:copy>
	</xsl:template>
	<!-- Deal with sections -->
	<xsl:template match="/book/chapter/section[not(sectioninfo)]">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
			<sectioninfo>
				<pubdate>Дата сборки документа: 
					<xsl:processing-instruction name="dbtimestamp">
						format="Y.m.d H:M:S"
					</xsl:processing-instruction>
				</pubdate>
				<releaseinfo>Ревизия VCS: <xsl:value-of select="$vcs.revision" /></releaseinfo>
			</sectioninfo>
            <xsl:apply-templates select="node()"/>
        </xsl:copy>
	</xsl:template>
</xsl:stylesheet>
