### Реестры {#registries}

> **Примечание:**

> В реестрах, для которых настроены централизованные фильтры, при импорте конфигурации 
эталонное значение для условия на поле `crm_all_accessible` пусто. Таким образом, условие 
всегда ложно, и все фильтры не содержат записей. Для настройки фильтров 
необходимо после импорта конфигурации каждому условию в фильтре в качестве эталонного 
значения установить подразделение, указанное в названии фильтра (например, в фильтре 
"Отдел маркетинга Астана" в качестве эталонного значения должно быть указано подразделение 
"Отдел маркетинга Астана"). 

*   [Маркетинговое мероприятие](#registryEvent)
*   [Лид](#registryLead)
*   [Сделка](#registryDeal)
*   [Аккаунт](#registryAccount)
*   [Контакт](#registryContact)
*   [% комиссии лидогенерации](#registryComission)
*   [% комиссии продаж](#registryDealComission)
*   [Темы сотрудничества](#registryThemes)
*   [Каталог товаров и услуг](#registryItems)
*   [Договоры поставки (единовременная оплата)](#registryContractDeliveryAll)
*   [Договоры поставки (оплата частями)](#registryContractDeliveryPart)
*   [Коммерческие предложения](#registryOffer)
*   [Акты приема-передачи товара](#registryCertificates)
*   [Счет-фактуры](#registryInvoices)
*   [Ответственный за сделки](#registryDealResponsible)
*   [План продаж](#registrySalesCost)
*   [Нормативы продолжительности статусов сделки](#registryDealFlowStandard)

#### Маркетинговые мероприятия {#registryEvent}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_events                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_event                                         |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Права на реестр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Создание               |
+---------------------------+------------------------+
| Менеджеры по продажам     | Создание               |
+---------------------------+------------------------+
| Руководитель отдела       | Создание               |
| маркетинга                |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Создание               |
| продаж                    |                        |
+---------------------------+------------------------+
| Центральный аппарат       | Все                    |
+---------------------------+------------------------+

Фильтры: 

*1. "Отдел маркетинга Алматы"*

> Код: `crm_filters_marketing_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Просмотр списка,       |
| по Алматы                 | просмотр данных        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Просмотр списка,       |
| по Алматы                 | просмотр данных        |
+---------------------------+------------------------+
| Руководитель отдела       | Все                    |
| маркетинга                |                        |
+---------------------------+------------------------+

*2. "Отдел маркетинга Астана"*

> Код: `crm_filters_marketing_Astana`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Просмотр списка,       |
| по Астане                 | просмотр данных        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Просмотр списка,       |
| по Астане                 | просмотр данных        |
+---------------------------+------------------------+
| Руководитель отдела       | Все                    |
| маркетинга                |                        |
+---------------------------+------------------------+

*3. "Отдел продаж Алматы"*

> Код: `crm_filters_sales_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел продаж Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Просмотр списка,       |
| Алматы                    | просмотр данных        |
+---------------------------+------------------------+
| Специалисты по продажам   | Просмотр списка,       |
| Алматы                    | просмотр данных        |
+---------------------------+------------------------+
| Руководитель отдела       | Все                    |
| продаж                    |                        |
+---------------------------+------------------------+

*4. "Отдел продаж Астана"*

> Код: `crm_filters_sales_Astana`

> Условие: `crm_all_accessible` содержит "Отдел продаж Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Просмотр списка,       |
| Астана                    | просмотр данных        |
+---------------------------+------------------------+
| Специалисты по продажам   | Просмотр списка,       |
| Астана                    | просмотр данных        |
+---------------------------+------------------------+
| Руководитель отдела       | Все                    |
| продаж                    |                        |
+---------------------------+------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_event_main_name                               | Наименование                                           | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_event_main_cost                               | Стоимость                                              | 2                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_event_main_event                              | Мероприятие                                            | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_event_responsibleManager_responsible          | Ответственный менеджер                                 | 4                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Лиды {#registryLead}

Свойства реестра:

+--------------------------------------------------------+-------------------------------------------------------------+
| Свойство                                               | Значение                                                    |
+========================================================+=============================================================+
| Код                                                    | crm_registry_lead                                           |
+--------------------------------------------------------+-------------------------------------------------------------+
| Форма документа                                        | crm_form_lead                                               |
+--------------------------------------------------------+-------------------------------------------------------------+
| Сортировка                                             | по полю crm_form_lead_deals_budget                          |
+--------------------------------------------------------+-------------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                                 |
+--------------------------------------------------------+-------------------------------------------------------------+

Права на реестр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Создание               |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Создание               |
+---------------------------+------------------------+
| Центральный аппарат       | Просмотр списка,       |
|                           | просмотр данных        |
+---------------------------+------------------------+

Фильтры реестров: 

*1. "Отдел маркетинга Алматы"*

> Код: `crm_filters_marketing_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*2. "Отдел маркетинга Астана"*

> Код: `crm_filters_marketing_Astana`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*3. "Отдел продаж Алматы"*

> Код: `crm_filters_sales_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел продаж Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

*4. "Отдел продаж Астана"*

> Код: `crm_filters_sales_Astana`

> Условие: `crm_all_accessible` содержит "Отдел продаж Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_lead_main_account_name                        | Аккаунт                                                | 1                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_lead_deals_theme                              | Тема сотрудничества                                    | 2                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_lead_deals_budget                             | Потенциальный бюджет                                   | 3                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_lead_deals_status                             | Статус                                                 | 4                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_lead_responsibleManager_responsible           | Ответственный менеджер                                 | 5                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Сделки {#registryDeal}

Свойства реестра:

+--------------------------------------------------------+------------------------------------------------------------------------+
| Свойство                                               | Значение                                                               |
+========================================================+========================================================================+
| Код                                                    | crm_registry_deals                                                     |
+--------------------------------------------------------+------------------------------------------------------------------------+
| Форма документа                                        | crm_form_deals                                                         |
+--------------------------------------------------------+------------------------------------------------------------------------+
| Сортировка                                             | по полю ccrm_form_deal_main3_budget                                    |
+--------------------------------------------------------+------------------------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                                            |
+--------------------------------------------------------+------------------------------------------------------------------------+

Права на реестр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Создание               |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Создание               |
+---------------------------+------------------------+
| Менеджеры по продажам     | Создание               |
+---------------------------+------------------------+
| Специалисты по продажам   | Создание               |
+---------------------------+------------------------+
| Центральный аппарат       | Просмотр списка,       |
|                           | просмотр данных        |
+---------------------------+------------------------+

Фильтры реестра: 

*1. "Отдел маркетинга Алматы"*

> Код: `crm_filters_marketing_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*2. "Отдел маркетинга Астана"*

> Код: `crm_filters_marketing_Astana`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*3. "Отдел продаж Алматы"*

> Код: `crm_filters_sales_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел продаж Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

*4. "Отдел продаж Астана"*

> Код: `crm_filters_sales_Astana`

> Условие: `crm_all_accessible` содержит "Отдел продаж Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_deal_main1_lead                               | Лид                                                    | 1                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_deal_main2_theme                              | Тема сотрудничества                                    | 2                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_deal_main3_budget                             | Бюджет                                                 | 3                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_deal_responsibleManager_responsible           | Ответственный менеджер                                 | 4                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Аккаунты {#registryAccount}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_accounts                                  |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_accounts                                      |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Права на реестр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Создание               |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Создание               |
+---------------------------+------------------------+
| Менеджеры по продажам     | Создание               |
+---------------------------+------------------------+
| Специалисты по продажам   | Создание               |
+---------------------------+------------------------+
| Центральный аппарат       | Просмотр списка,       |
|                           | просмотр данных        |
+---------------------------+------------------------+

Фильтры реестра: 

*1. "Отдел маркетинга Алматы"*

> Код: `crm_filters_marketing_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*2. "Отдел маркетинга Астана"*

> Код: `crm_filters_marketing_Astana`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*3. "Отдел продаж Алматы"*

> Код: `crm_filters_sales_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел продаж Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

*4. "Отдел продаж Астана"*

> Код: `crm_filters_sales_Astana`

> Условие: `crm_all_accessible` содержит "Отдел продаж Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_account_main_name                             | Наименование                                           | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_account_main_info                             | Описание                                               | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_account_responsibleManager_responsible        | Ответственный менеджер                                 | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Контакты {#registryContact}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_contacts                                  |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_contacts                                      |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Права на реестр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Создание               |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Создание               |
+---------------------------+------------------------+
| Менеджеры по продажам     | Создание               |
+---------------------------+------------------------+
| Специалисты по продажам   | Создание               |
+---------------------------+------------------------+
| Центральный аппарат       | Просмотр списка,       |
|                           | просмотр данных        |
+---------------------------+------------------------+

Фильтры реестра: 

*1. "Отдел маркетинга Алматы"*

> Код: `crm_filters_marketing_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*2. "Отдел маркетинга Астана"*

> Код: `crm_filters_marketing_Astana`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*3. "Отдел продаж Алматы"*

> Код: `crm_filters_sales_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел продаж Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

*4. "Отдел продаж Астана"*

> Код: `crm_filters_sales_Astana`

> Условие: `crm_all_accessible` содержит "Отдел продаж Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_contact_main_fullName                         | Полное имя                                             | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contact_main_position                         | Должность                                              | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contact_responsibleManager                    | Ответственный менеджер                                 | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### % комиссии лидогенерации {#registryComission}

Свойства реестра:

+--------------------------------------------------------+-------------------------------------------------------------+
| Свойство                                               | Значение                                                    |
+========================================================+=============================================================+
| Код                                                    | crm_registry_deal_comission                                 |
+--------------------------------------------------------+-------------------------------------------------------------+
| Форма документа                                        | crm_form_deal_comission                                     |
+--------------------------------------------------------+-------------------------------------------------------------+
| Группа                                                 | менеджеры по продажам                                       |
+--------------------------------------------------------+-------------------------------------------------------------+
| Права                                                  | Просмотр списка, Просмотр данных, Изменение, Редактирование |
+--------------------------------------------------------+-------------------------------------------------------------+
| Сортировка                                             | по дате создания                                            |
+--------------------------------------------------------+-------------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                                 |
+--------------------------------------------------------+-------------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_deal_comission_main                           | % комиссии                                             |                            | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### % комиссия продаж {#registryDealComission}

Свойства реестра:

+--------------------------------------------------------+-------------------------------------------------------------+
| Свойство                                               | Значение                                                    |
+========================================================+=============================================================+
| Код                                                    | crm_registry_lead_comission                                 |
+--------------------------------------------------------+-------------------------------------------------------------+
| Форма документа                                        | crm_form_lead_comission                                     |
+--------------------------------------------------------+-------------------------------------------------------------+
| Группа                                                 | менеджеры по продажам                                       |
+--------------------------------------------------------+-------------------------------------------------------------+
| Права                                                  | Просмотр списка, Просмотр данных, Изменение, Редактирование |
+--------------------------------------------------------+-------------------------------------------------------------+
| Сортировка                                             | по дате создания                                            |
+--------------------------------------------------------+-------------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                                 |
+--------------------------------------------------------+-------------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_deal_comission_main                           | % комиссии                                             |                            | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Темы сотрудничества {#registryThemes}

Свойства реестра:

+--------------------------------------------------------+-------------------------------------------------------------+
| Свойство                                               | Значение                                                    |
+========================================================+=============================================================+
| Код                                                    | crm_registry_themes                                         |
+--------------------------------------------------------+-------------------------------------------------------------+
| Форма документа                                        | crm_form_theme                                              |
+--------------------------------------------------------+-------------------------------------------------------------+
| Сортировка                                             | по полю crm_form_theme_theme                                |
+--------------------------------------------------------+-------------------------------------------------------------+
| Направление сортировки                                 | по возрастанию                                              |
+--------------------------------------------------------+-------------------------------------------------------------+

Права на реестр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Руководитель отдела       | Создание               |
| маркетинга                |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Создание               |
| продаж                    |                        |
+---------------------------+------------------------+
| Центральный аппарат       | Все                    |
+---------------------------+------------------------+

Фильтры: 

*1. "Отдел маркетинга Алматы"*

> Код: `crm_filters_marketing_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Просмотр списка,       |
| по Алматы                 | просмотр данных        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Просмотр списка,       |
| по Алматы                 | просмотр данных        |
+---------------------------+------------------------+
| Руководитель отдела       | Все                    |
| маркетинга                |                        |
+---------------------------+------------------------+

*2. "Отдел маркетинга Астана"*

> Код: `crm_filters_marketing_Astana`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Просмотр списка,       |
| по Астане                 | просмотр данных        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Просмотр списка,       |
| по Астане                 | просмотр данных        |
+---------------------------+------------------------+
| Руководитель отдела       | Все                    |
| маркетинга                |                        |
+---------------------------+------------------------+

*3. "Отдел продаж Алматы"*

> Код: `crm_filters_sales_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел продаж Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Просмотр списка,       |
| Алматы                    | просмотр данных        |
+---------------------------+------------------------+
| Специалисты по продажам   | Просмотр списка,       |
| Алматы                    | просмотр данных        |
+---------------------------+------------------------+
| Руководитель отдела       | Все                    |
| продаж                    |                        |
+---------------------------+------------------------+

*4. "Отдел продаж Астана"*

> Код: `crm_filters_sales_Astana`

> Условие: `crm_all_accessible` содержит "Отдел продаж Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Просмотр списка,       |
| Астана                    | просмотр данных        |
+---------------------------+------------------------+
| Специалисты по продажам   | Просмотр списка,       |
| Астана                    | просмотр данных        |
+---------------------------+------------------------+
| Руководитель отдела       | Все                    |
| продаж                    |                        |
+---------------------------+------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_theme_theme                                   | Тема сотрудничества                                    | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Каталог товаров и услуг {#registryItems}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_items                                     |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_item                                          |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по полю реестра crm_form_item_name                     |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по возрастанию                                         |
+--------------------------------------------------------+--------------------------------------------------------+

Права на реестр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Руководитель отдела       | Создание               |
| маркетинга                |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Создание               |
| продаж                    |                        |
+---------------------------+------------------------+
| Центральный аппарат       | Все                    |
+---------------------------+------------------------+

Фильтры: 

*1. "Отдел маркетинга Алматы"*

> Код: `crm_filters_marketing_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Просмотр списка,       |
| по Алматы                 | просмотр данных        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Просмотр списка,       |
| по Алматы                 | просмотр данных        |
+---------------------------+------------------------+
| Руководитель отдела       | Все                    |
| маркетинга                |                        |
+---------------------------+------------------------+

*2. "Отдел маркетинга Астана"*

> Код: `crm_filters_marketing_Astana`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Просмотр списка,       |
| по Астане                 | просмотр данных        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Просмотр списка,       |
| по Астане                 | просмотр данных        |
+---------------------------+------------------------+
| Руководитель отдела       | Все                    |
| маркетинга                |                        |
+---------------------------+------------------------+

*3. "Отдел продаж Алматы"*

> Код: `crm_filters_sales_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел продаж Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Просмотр списка,       |
| Алматы                    | просмотр данных        |
+---------------------------+------------------------+
| Специалисты по продажам   | Просмотр списка,       |
| Алматы                    | просмотр данных        |
+---------------------------+------------------------+
| Руководитель отдела       | Все                    |
| продаж                    |                        |
+---------------------------+------------------------+

*4. "Отдел продаж Астана"*

> Код: `crm_filters_sales_Astana`

> Условие: `crm_all_accessible` содержит "Отдел продаж Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Просмотр списка,       |
| Астана                    | просмотр данных        |
+---------------------------+------------------------+
| Специалисты по продажам   | Просмотр списка,       |
| Астана                    | просмотр данных        |
+---------------------------+------------------------+
| Руководитель отдела       | Все                    |
| продаж                    |                        |
+---------------------------+------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_item_name                                     | Наименование товара                                    | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_item_price                                    | Цена                                                   | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_item_theme                                    | Тема сотрудничества                                    | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Реестры шаблонов документов {#registryTemplates}

Для всех реестров ниже настроено событие активации:

Маршрут активации - Действия:

- Тип действия - Отправка документа по форме

- Название - Отправка документа по форме

- Адресат - `email`

##### Договоры поставки (единовременная оплата) {#registryContractDeliveryAll}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_contracts_delivery_100                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_contract_delivery_100                         |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Права на реестр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Создание               |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Создание               |
+---------------------------+------------------------+
| Менеджеры по продажам     | Создание               |
+---------------------------+------------------------+
| Специалисты по продажам   | Создание               |
+---------------------------+------------------------+
| Центральный аппарат       | Просмотр списка,       |
|                           | просмотр данных        |
+---------------------------+------------------------+

Фильтры реестра: 

*1. "Отдел маркетинга Алматы"*

> Код: `crm_filters_marketing_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*2. "Отдел маркетинга Астана"*

> Код: `crm_filters_marketing_Astana`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*3. "Отдел продаж Алматы"*

> Код: `crm_filters_sales_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел продаж Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

*4. "Отдел продаж Астана"*

> Код: `crm_filters_sales_Astana`

> Условие: `crm_all_accessible` содержит "Отдел продаж Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_contract_delivery_100_contract_number         | Номер договора                                         | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_100_contract_date           | Дата договора                                          | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_100_theme                   | Тема договора                                          | 3                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_100_client_account          | Заказчик                                               | 4                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_100_sum_total               | Сумма договора                                         | 5                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

##### Договоры поставки (оплата частями) {#registryContractDeliveryPart}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_contracts_delivery_part                   |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_contract_delivery_part                        |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Права на реестр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Создание               |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Создание               |
+---------------------------+------------------------+
| Менеджеры по продажам     | Создание               |
+---------------------------+------------------------+
| Специалисты по продажам   | Создание               |
+---------------------------+------------------------+
| Центральный аппарат       | Просмотр списка,       |
|                           | просмотр данных        |
+---------------------------+------------------------+

Фильтры реестра: 

*1. "Отдел маркетинга Алматы"*

> Код: `crm_filters_marketing_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*2. "Отдел маркетинга Астана"*

> Код: `crm_filters_marketing_Astana`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*3. "Отдел продаж Алматы"*

> Код: `crm_filters_sales_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел продаж Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

*4. "Отдел продаж Астана"*

> Код: `crm_filters_sales_Astana`

> Условие: `crm_all_accessible` содержит "Отдел продаж Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_contract_delivery_part_contract_number        | Номер договора                                         | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_part_contract_date          | Дата договора                                          | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_part_theme                  | Тема договора                                          | 3                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_part_client_account         | Заказчик                                               | 4                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_part_sum_total              | Сумма договора                                         | 5                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

##### Акты приема-передачи товара {#registryCertificates}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_certificates                              |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_certificate                                   |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Права на реестр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Создание               |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Создание               |
+---------------------------+------------------------+
| Менеджеры по продажам     | Создание               |
+---------------------------+------------------------+
| Специалисты по продажам   | Создание               |
+---------------------------+------------------------+
| Центральный аппарат       | Просмотр списка,       |
|                           | просмотр данных        |
+---------------------------+------------------------+

Фильтры реестра: 

*1. "Отдел маркетинга Алматы"*

> Код: `crm_filters_marketing_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*2. "Отдел маркетинга Астана"*

> Код: `crm_filters_marketing_Astana`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*3. "Отдел продаж Алматы"*

> Код: `crm_filters_sales_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел продаж Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

*4. "Отдел продаж Астана"*

> Код: `crm_filters_sales_Astana`

> Условие: `crm_all_accessible` содержит "Отдел продаж Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_certificate_table3_contract                   | Основание договора                                     | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_certificate_table2_date                       | Дата акта                                              | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

##### Коммерческое предложение {#registryOffer}

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_offer                                     |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_offer                                         |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Права на реестр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Создание               |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Создание               |
+---------------------------+------------------------+
| Менеджеры по продажам     | Создание               |
+---------------------------+------------------------+
| Специалисты по продажам   | Создание               |
+---------------------------+------------------------+
| Центральный аппарат       | Просмотр списка,       |
|                           | просмотр данных        |
+---------------------------+------------------------+

Фильтры реестра: 

*1. "Отдел маркетинга Алматы"*

> Код: `crm_filters_marketing_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*2. "Отдел маркетинга Астана"*

> Код: `crm_filters_marketing_Astana`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*3. "Отдел продаж Алматы"*

> Код: `crm_filters_sales_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел продаж Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

*4. "Отдел продаж Астана"*

> Код: `crm_filters_sales_Astana`

> Условие: `crm_all_accessible` содержит "Отдел продаж Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_offer_whom_position                           | Должность                                              | 1                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_offer_whom_account	                         | Аккаунт                                                | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_offer_whom_fullname                           | ФИО                                                    | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_offer_from_user                               | От кого                                                | 4                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

##### Счет-фактуры {#registryInvoices}

Для реестра настроено событие активации:

> Маршрут активации - Действия:

> - Тип действия - Отправка документа по форме

> - Название - Отправка документа по форме

> - Адресат - `email`

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_invoices                                  |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_invoice                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Права на реестр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Создание               |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Создание               |
+---------------------------+------------------------+
| Менеджеры по продажам     | Создание               |
+---------------------------+------------------------+
| Специалисты по продажам   | Создание               |
+---------------------------+------------------------+
| Центральный аппарат       | Просмотр списка,       |
|                           | просмотр данных        |
+---------------------------+------------------------+

Фильтры реестра: 

*1. "Отдел маркетинга Алматы"*

> Код: `crm_filters_marketing_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*2. "Отдел маркетинга Астана"*

> Код: `crm_filters_marketing_Astana`

> Условие: `crm_all_accessible` содержит "Отдел маркетинга Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Маркетологи-специалисты   | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*3. "Отдел продаж Алматы"*

> Код: `crm_filters_sales_Almaty`

> Условие: `crm_all_accessible` содержит "Отдел продаж Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

*4. "Отдел продаж Астана"*

> Код: `crm_filters_sales_Astana`

> Условие: `crm_all_accessible` содержит "Отдел продаж Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Специалисты по продажам   | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_invoice_number                                | Номер                                                  | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_invoice_date                                  | Дата                                                   | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_invoice_receiver_name                         | Грузополучатель                                        | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_invoice_mainreceiver_name                     | Получатель                                             | 4                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_invoice_order_summ_total                      | Стоимость реализации                                   | 5                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Ответственный за сделки {#registryDealResponsible}

Свойства реестра:

+--------------------------------------------------------+-------------------------------------------------------------+
| Свойство                                               | Значение                                                    |
+========================================================+=============================================================+
| Код                                                    | crm_registry_deal_responsible                               |
+--------------------------------------------------------+-------------------------------------------------------------+
| Форма документа                                        | crm_form_deal_responsible                                   |
+--------------------------------------------------------+-------------------------------------------------------------+
| Группа                                                 | менеджеры-маркетологи, менеджеры по продажам                |
+--------------------------------------------------------+-------------------------------------------------------------+
| Права                                                  | Просмотр списка, Просмотр данных, Изменение, Редактирование |
+--------------------------------------------------------+-------------------------------------------------------------+
| Сортировка                                             | по дате создания                                            |
+--------------------------------------------------------+-------------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                                 |
+--------------------------------------------------------+-------------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_deal_responsible_user                         | Ответственный менеджер                                 |                            | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### План продаж {#registrySalesCost}

Свойства реестра:

+--------------------------------------------------------+-------------------------------------------------------------+
| Свойство                                               | Значение                                                    |
+========================================================+=============================================================+
| Код                                                    | crm_registry_deals_plans                                    |
+--------------------------------------------------------+-------------------------------------------------------------+
| Форма документа                                        | crm_form_sales                                              |
+--------------------------------------------------------+-------------------------------------------------------------+
| Сортировка                                             | по дате создания                                            |
+--------------------------------------------------------+-------------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                                 |
+--------------------------------------------------------+-------------------------------------------------------------+

Права на реестр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Руководитель отдела       | Создание               |
| маркетинга                |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Создание               |
| продаж                    |                        |
+---------------------------+------------------------+
| Маркетологи-менеджеры     | Создание               |
+---------------------------+------------------------+
| Менеджеры по продажам     | Создание               |
+---------------------------+------------------------+
| Центральный аппарат       | Все                    |
+---------------------------+------------------------+

Фильтры: 

*1. "Отдел маркетинга"*

> Код: `crm_filters_marketing`

> Условие: `crm_owner` содержит "Отдел маркетинга"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Руководитель отдела       | Все                    |
| маркетинга                |                        |
+---------------------------+------------------------+

*1. "Отдел маркетинга"*

> Код: `crm_filters_sales`

> Условие: `crm_owner` содержит "Отдел продаж"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Руководитель отдела       | Все                    |
| продаж                    |                        |
+---------------------------+------------------------+

*3. "Отдел маркетинга Алматы"*

> Код: `crm_filters_marketing_Almaty`

> Условие: `crm_owner` содержит "Отдел маркетинга Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Алматы                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*4. "Отдел маркетинга Астана"*

> Код: `crm_filters_marketing_Astana`

> Условие: `crm_owner` содержит "Отдел маркетинга Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Маркетологи-менеджеры     | Все                    |
| по Астане                 |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| маркетинга                | просмотр данных        |
+---------------------------+------------------------+

*5. "Отдел продаж Алматы"*

> Код: `crm_filters_sales_Almaty`

> Условие: `crm_owner` содержит "Отдел продаж Алматы"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Алматы                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

*6. "Отдел продаж Астана"*

> Код: `crm_filters_sales_Astana`

> Условие: `crm_owner` содержит "Отдел продаж Астана"

> Права на фильтр: 

+---------------------------+------------------------+
| Группа                    | Права                  |
+===========================+========================+
| Менеджеры по продажам     | Все                    |
| Астана                    |                        |
+---------------------------+------------------------+
| Руководитель отдела       | Просмотр списка,       |
| продаж                    | просмотр данных        |
+---------------------------+------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_deal_order_sales_month                        | Месяц                                                  |                            | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_deal_order_sales_year                         | Год                                                    |                            | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_owner                                              | Автор                                                  |                            | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Нормативы продолжительности статусов сделки {#registryDealFlowStandard}

Свойства реестра:

+--------------------------------------------------------+-------------------------------------------------------------+
| Свойство                                               | Значение                                                    |
+========================================================+=============================================================+
| Код                                                    | crm_registry_deal_flow_standard                             |
+--------------------------------------------------------+-------------------------------------------------------------+
| Форма документа                                        | crm_form_deal_flow_standard                                 |
+--------------------------------------------------------+-------------------------------------------------------------+
| Группа                                                 | менеджеры по продажам                                       |
+--------------------------------------------------------+-------------------------------------------------------------+
| Права                                                  | Просмотр списка, Просмотр данных, Изменение, Редактирование |
+--------------------------------------------------------+-------------------------------------------------------------+
| Сортировка                                             | по дате создания                                            |
+--------------------------------------------------------+-------------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                                 |
+--------------------------------------------------------+-------------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_deal_flow_standard_table                      | Нормативы продолжительности статусов сделок            |                            | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
