## Менеджер по маркентингу {#marketing_specialist}

### Создание маркетингового мероприятия {#marketing_event}

В реестре «Маркетинговые мероприятия» содержится комплекс мер по привлечению клиентов 
и повышению объемов продаж.

Для создания записи необходимо:

1. Выделить реестр в навигаторе и кликнуть по кнопке «Создать», либо выбрать в контекстном 
меню кнопки «Создать» пункт «Новая запись».

2. В открывшемся окне необходимо заполнить следующие данные:

-   *Тип мероприятия*. Необходимо выбрать из выпадающего списка
    одно из значений. По нажатию на кнопку со стрелкой вниз раскрывается
    список со всеми возможными значениями. Данные значения настраиваются
    разработчиком Synergy.

-   *Наименование мероприятия* (обяз.). Представляет собой поле для ввода
    текстовой информации.

-   *Стоимость мероприятия*. Представляет собой поле для ввода чисел.
    В поле серым цветом отображается подсказка с текстом "Введите число".
    Данное поле принимает только числа и некоторые символы (точка,
    запятая).

-   *Мероприятие*. Необходимо добавить ссылку на существующий проект мероприятия.

-   *Комментарий*. Представляет собой многострочное поле для ввода
    текстовой информации.

-   *Целевой отклик*. Представляет собой поле для ввода чисел. Предназначен
    для расчета оценки эффективности.

-   *Текущий отклик*. Представляет собой количество всех лидов, связанных
    с данным мероприятием. Если для данного мероприятия не имеется лидов, 
    поле содержит значение 0. Поле заблокировано для изменения.

-   *Оценка эффективности*. Поле заблокировано для изменения. Значение поля 
    рассчитывается автоматически по формуле:

    `%значение_поля_"Текущий_отклик"% / %значение_поля_"Целевой_отклик"%`
    
    Поле по умолчанию заполнено значением 0, а также в случаях когда:

    - поле "Целевой отклик" не заполнено либо содержит значение 0;

    - поле "Текущий отклик " содержит значение 0.

-   *Ответственный менеджер*. Поле автоматически заполняется пользователем,
    создающим запись реестра. При необходимости можно изменить данное
    значение (см. [Компонент выбора пользователя](#userchooser)).

-   *Владелец*. Поле автоматически заполняется подразделением создающего 
    пользователя. Поле обязательно для заполнения, мультивыбор недоступен.

-   *Для кого*. В поле доступен мультивыбор подразделений. В поле указываются 
    подразделения, которым должна быть доступна текущая запись. Также запись
    доступна:

    - владельцу и всем его родительским подразделениям, в том числе корневому 
      поразделению оргструктуры;

    - всем подразделениям, указанным в поле "Для кого", и их дочерним подразделениям.

![Маркетинговые мероприятия](resources/img/storage/marketing_event.png)

3. Для сохранения записи реестра необходимо нажать на кнопку «Сохранить». Сохраненные 
   данные отобразятся в модулях «Маркетинг» и «Управление продажами».

4. Для перехода в режим просмотра используется кнопка «Режим редактирования». При 
   повторном нажатии на нее запись реестра отображается в режиме редактирования.


### Создание лида {#lead}

В реестре "Лиды" отображается список лидов. Лиды являются зарегистрированным 
потребительским интересом, который можно конвертировать в "Сделку".

Для создания записи необходимо:

1. Выделить реестр в навигаторе и кликнуть по кнопке "Создать", либо выбрать 
в контекстном меню кнопки "Создать" пункт "Новая запись". Также из любого 
другого модуля, при нажатии кнопки "Создать" пункт "Запись лида".

2. В открывшемся окне необходимо заполнить следующие данные:

-   *Мероприятие*. В данном поле указывается мероприятие, в следствие
    которого появился данный лид. Необходимо выбрать одно из созданных ранее
    мероприятий из реестра ["Маркетинговые мероприятия"](#marketing_event)
    в [компоненте выбора записи реестра](#registrychooser).

-   *Источник лида*. В данном поле указывается контактное лицо, если выше
    не было указано мероприятие. Необходимо выбрать один из созданных ранее
    контактов из реестра ["Контакты"](#contact) в [компоненте выбора записи реестра](#registrychooser).

-   *Сделка*. Данное поле неактивно для изменений. Его значение автоматически
    заполняется значением сделки, которая создается при переходе лида
    в конечный статус.

-   *Контакт*. Необходимо создать новый контакт нажатием на кнопку "+Создать",
    либо выбрать контакт среди существующих из реестра [Контакты](#contact) нажатием 
    на кнопку "Выбрать из реестра". После выбора контакта на форму добавятся его
    контакты.

-   *Связь с выбранным Контактом*. Заполняется автоматически при выборе контакта
    в [компоненте функции связи](#reg_create_connection).

-   *Аккаунт*. Необходимо создать новый аккаунт нажатием на кнопку "+Создать",
    либо выбрать аккаунт среди существующих из реестра [Аккаунты](#account) нажатием 
    на кнопку "Выбрать из реестра". После выбора акканута на форму добавятся его
    контакты.

-   *Связь с выбранным Аккаунтом*. Заполняется автоматически при выборе контакта
    в [компоненте функции связи](#reg_create_connection).

-   *Тема сотрудничества*. Необходимо выбрать одну из созданных ранее
    тем из реестра "Темы сотрудничества" в [компоненте выбора записи реестра](#registrychooser).

-   *Потенциальный бюджет*. Представляет собой поле для ввода чисел.
    В поле серым цветом отображается подсказка с текстом "Введите число".
    Данное поле принимает только числа и некоторые символы (точка,
    запятая).

-   *Статус*. Необходимо выбрать из выпадающего списка одно из значений.
    По нажатию на кнопку со стрелкой вниз раскрывается список со всеми
    возможными значениями. Данные значения настраиваются разработчиком Synergy.

-   *Ответственный менеджер*. Поле автоматически заполняется пользователем,
    создающим запись реестра. При необходимости можно изменить данное
    значение (см. [Компонент выбора пользователя](#userchooser)).

-   *Владелец*. Поле заполняется автоматически подразделением создающего пользователя. 
    Запись в данном реестре доступна владельцу и всем его родительским подразделениям.
    Поле обязательно для заполнения, мультивыбор недоступен.

-   *Активности*:

    -   *Пиктограмма типа активности*. Изображение выбирается автоматически
        в зависимости от выбранного типа активности. Данные изображения
        настраиваются разработчиком Synergy.  

    -   *Тип активности*. Необходимо выбрать из выпадающего списка одно из
        значений. По нажатию на кнопку со стрелкой вниз раскрывается список
        со всеми возможными значениями. Данные значения настраиваются
        разработчиком Synergy.  

    -   *Комментарий*. Представляет собой однострочное поле для ввода текстовой
        информации.

    -   *Дата*. Представляет собой поле для выбора даты. По умолчанию
        заполняется текущей датой.

![Лиды](resources/img/storage/lead.png)

3. После статуса присутствует кнопка "Конвертировать в сделку" (название кнопки
   настраивается разработчиком Synergy). Данная кнопка присутствует для всех
   неконечных статусов. Для конечного статуса данная кнопка отсутствует. По
   нажатию на нее статус лида меняется на конечный статус, открывается
   проигрыватель формы новой сделки. Аналогично при выборе в выпадающем списке
   конечного статуса и сохранении изменений, кнопка исчезает и открывается
   проигрыватель формы новой сделки. После изменения статуса на конечный
   значение статуса становится неактивным для изменения. С примером справочника,
   настроенного для
   [типовой конфигурации](http://tdd.lan.arta.kz/docs/cases/crm/methodologist-manual/html/),
   можно ознакомиться [здесь](#dictionaryLeadStatus).

4. При создании нового аккаунта либо контакта c помощью модифицированного
   компонента выбора записи реестра производится сопоставление полей. Значение
   лида в создаваемом аккаунте или контакте автоматически заполняется текущим
   значением лида.

5. Для сохранения записи реестра необходимо нажать на кнопку "Сохранить". Сохраненные 
   данные отобразятся в модуле Управление маркетингом, вкладке "Поток", на столбце
   того статуса, что был указан в карточке.

6. Для перехода в режим просмотра используется кнопка "Режим редактирования".
   При повторном нажатии на нее запись реестра отображается в режиме
   редактирования.


### Создание контакта {#contact}

В реестре "Контакты" отображаются все сохраненные контакты. Контактом
считается человек, работающий в организации-аккаунте, с которым вы
взаимодействуете для заключения сделок.

Для создания записи необходимо:

1. Выделить реестр в навигаторе и кликнуть по кнопке "Создать", либо выбрать 
в контекстном меню кнопки "Создать" пункт "Новая запись". Также при выборе 
"Создать" пункта "Запись Контакта" из любого модуля интерфейса.

2. В открывшемся окне необходимо заполнить следующие данные:

-   *Лид*. Необходимо выбрать лид из реестра ["Лиды"](#lead) в [компоненте
    выбора записи реестра](#registrychooser). Возможно указание нескольких
    лидов, для этого необходимо кликнуть по лейблу "+Добавить блок", после
    чего добавится еще один пустой компонент выбора записи реестра. При
    необходимости удалить строку с компонентом можно, кликнув на крестик
    в конце строки.

    >   *Примечание*
    >
    >   Для созданных в окне лида контактов значение лида уже заполнено.

-   *Фото контакта*. Необходимо прикрепить фото с компьютера или из
    хранилища в [компоненте выбора файла](#filechooser).

-   *Полное имя* (обяз.). Представляет собой поле для ввода текстовой
    информации.

-   *Должность*. Представляет собой многострочное поле для ввода текстовой
    информации.

-   *Дата рождения*. Необходимо указать дату рождения контакта. По нажатию
    на кнопку справа открывается календарь с возможностью выбора года, месяца
    и даты. По нажатию на год или месяц появляется выпадающий список с
    возможными вариантами. По нажатию на лейбл сегодня поле заполняется
    текущей датой. По умолчанию выделен голубым цветом и подчеркнут текущий
    день. После выбора даты поле ввода заполняется указанным значением.

-   *Статус*. Необходимо выбрать из выпадающего списка одно из значений.
    По нажатию на кнопку со стрелкой вниз раскрывается список со всеми
    возможными значениями. Данные значения настраиваются разработчиком
    Synergy.

-   *Информация*. Представляет собой многострочное поле для ввода текстовой
    информации. Предназначен для какой-либо дополнительной информации о
    контакте.

-   *Контактные данные:*

    -   *Телефон*. Необходимо выбрать из выпадающего списка тип телефона
        и указать номер в текстовом поле. Возможно указание нескольких
        номеров телефонов, для этого необходимо кликнуть по лейблу
        "+Добавить блок", после чего добавятся выпадающий список и
        текстовое поле. При необходимости удалить строку с компонентами
        можно, кликнув на крестик в конце строки.

    -   *Адрес*. Необходимо выбрать из выпадающего списка тип адреса
        и указать значение адреса в текстовом поле. Возможно указание
        нескольких адресов, для этого необходимо кликнуть по лейблу
        "+Добавить блок", после чего добавятся выпадающий список и
        текстовое поле. При необходимости удалить строку с компонентами
        можно, кликнув на крестик в конце строки.

    -   *E-mail*. Необходимо выбрать из выпадающего списка тип почты
        и указать электронную почту в текстовом поле. Возможно указание
        нескольких почт, для этого необходимо кликнуть по лейблу
        "+Добавить блок", после чего добавятся выпадающий список и
        текстовое поле. При необходимости удалить строку с компонентами
        можно, кликнув на крестик в конце строки.

    -   *Социальные сети*. Необходимо выбрать из выпадающего списка тип
        социальной сети и указать логин социальной сети в текстовом поле.
        Возможно указание нескольких ссылок, для этого необходимо кликнуть
        по лейблу "+Добавить блок", после чего добавятся выпадающий список и
        ссылка. При необходимости удалить строку с компонентами можно,
        кликнув на крестик в конце строки.

-   *Ответственный менеджер*. Поле автоматически заполняется пользователем,
    создающим запись реестра. При необходимости можно изменить данное
    значение (см. [Компонент выбора пользователя](#userchooser)).

-   *Владелец*. Поле заполняется автоматически подразделением создающего пользователя. 
    Запись в данном реестре доступна владельцу и всем его родительским подразделениям.
    Поле обязательно для заполнения, мультивыбор недоступен.

![Контакты](resources/img/storage/contact.png)

3. Для сохранения записи реестра необходимо нажать на кнопку "Сохранить".

4. Для перехода в режим просмотра используется кнопка "Режим редактирования".
   При повторном нажатии на нее запись реестра отображается в режиме
   редактирования.

>**Примечание**
>
>При настройки IP телефонии и интеграции с прочими приложениями, пользователь 
>может связаться с контактом из интерфейса.


### Создание аккаунта {#account}

В реестре "Аккаунты" отображается сохраненные аккаунты. Аккаунтом
является организация или подразделение организации, с которым
имеются деловые отношения.

Для создания записи необходимо:

1. Выделить реестр в навигаторе и кликнуть по кнопке "Создать", либо выбрать 
в контекстном меню кнопки "Создать" пункт "Новая запись". Также при выборе
"Создать" пункта "Запись аккаунта" из любого модуля интерфейса.

2. В открывшемся окне необходимо заполнить следующие данные:

-   *Лид*. Необходимо выбрать лид из реестра ["Лиды"](#lead) в [компоненте
    выбора записи реестра](#registrychooser). Возможно указание нескольких
    лидов, для этого необходимо кликнуть по лейблу "+Добавить блок", после
    чего добавится еще один пустой компонент выбора записи реестра. При
    необходимости удалить строку с компонентом можно, кликнув на крестик
    в конце строки.

    >   *Примечание*
    >
    >   Для созданных в окне лида аккаунтов значение лида уже заполнено.

-   *Логотип организации*. Необходимо прикрепить логотип с компьютера или из
    хранилища в [компоненте выбора файла](#filechooser).

-   *Наименование* (обяз.). Представляет собой поле для ввода текстовой
    информации.

-   *Описание*. Представляет собой многострочное поле для ввода текстовой
    информации.

-   *Вид деятельности*. Представляет собой многострочное поле для ввода
    текстовой информации.

-   *Выручка*. Представляет собой поле для ввода текстовой информации.

-   *Численность штата*. Представляет собой поле для ввода текстовой
    информации.

-   *Статус*. Необходимо выбрать из выпадающего списка одно из значений.
    По нажатию на кнопку со стрелкой вниз раскрывается список со всеми
    возможными значениями. Данные значения настраиваются разработчиком
    Synergy.

-   *Контактные данные аккаунта*:

    -   *Телефон*. Необходимо выбрать из выпадающего списка тип телефона
        и указать номер в текстовом поле. Возможно указание нескольких
        номеров телефонов, для этого необходимо кликнуть по лейблу
        "+Добавить блок", после чего добавятся выпадающий список и
        текстовое поле. При необходимости удалить строку с компонентами
        можно, кликнув на крестик в конце строки.

    -   *Адрес*. Необходимо выбрать из выпадающего списка тип адреса
        и указать значение адреса в текстовом поле. Возможно указание
        нескольких адресов, для этого необходимо кликнуть по лейблу
        "+Добавить блок", после чего добавятся выпадающий список и
        текстовое поле. При необходимости удалить строку с компонентами
        можно, кликнув на крестик в конце строки.

    -   *E-mail*. Необходимо выбрать из выпадающего списка тип почты
        и указать электронную почту в текстовом поле. Возможно указание
        нескольких почт, для этого необходимо кликнуть по лейблу
        "+Добавить блок", после чего добавятся выпадающий список и
        текстовое поле. При необходимости удалить строку с компонентами
        можно, кликнув на крестик в конце строки.

    -   *Социальные сети*. Необходимо выбрать из выпадающего списка тип
        социальной сети и указать логин социальной сети в текстовом поле.
        Возможно указание нескольких ссылок, для этого необходимо кликнуть
        по лейблу "+Добавить блок", после чего добавятся выпадающий список и
        ссылка. При необходимости удалить строку с компонентами можно,
        кликнув на крестик в конце строки.

-   *Материнский аккаунт*. Необходимо выбрать родительский аккаунт из
    реестра ["Аккаунты"](#account) в [компоненте выбора записи реестра](#registrychooser).
    Данная компания поможет в ориентировании между крупными холдингами с ДО, 
    и определении контакта с влиянием.

-   *Дочерние аккаунты*. Необходимо выбрать из спиcка уже созданных аккаунтов
    в реестре "Аккаунты", можно указать несколько аккаунтов. Возможно указание
    нескольких дочерних аккаунтов, для этого необходимо кликнуть по лейблу
    "+Добавить блок", после чего добавится компонент выбора записи реестра.
    При необходимости удалить строку с компонентом можно, кликнув на крестик
    в конце строки. Данная компания поможет в ориентировании между крупными 
    холдингами с ДО, и определении контакта с влиянием.

-   *Ответственный менеджер*. Поле автоматически заполняется пользователем,
    создающим запись реестра. При необходимости можно изменить данное
    значение (см. [Компонент выбора пользователя](#userchooser)).

-   *Владелец*. Поле заполняется автоматически подразделением создающего пользователя. 
    Запись в данном реестре доступна владельцу и всем его родительским подразделениям.
    Поле обязательно для заполнения, мультивыбор недоступен.

![Аккаунты](resources/img/storage/account1.png)

3. Для сохранения записи реестра необходимо нажать на кнопку "Сохранить".

4. Для перехода в режим просмотра используется кнопка "Режим редактирования".
   При повторном нажатии на нее запись реестра отображается в режиме
   редактирования.


### Работа с лидами {#lead_work}

Для работы с лидами необходимо:

1. [Создать лид](#lead)

2. Созданную карточку можно увидеть в модуле "Управление маркетингом", в разделе
   "Потоки". В данном модуле плашки означают лидов, а столбцы отображают текущий
   статус лида.

3. Все работы менеджера по маркетингу фиксируются в реестре "Лиды" в поле 
   "Активности".

4. Виды активностей могут отличаться для каждого из заказчиков, но значения
   по умолчанию можно увидеть в справочнике [Типы активностей](#dictionaryActivityType)

5. Чтобы добавить активность необходимо заполнить следующие данные:

-   *Пиктограмма типа активности*. Изображение выбирается автоматически
    в зависимости от выбранного типа активности. Данные изображения
    настраиваются разработчиком Synergy. 

-   *Тип активности*. Необходимо выбрать из выпадающего списка одно из
    значений. По нажатию на кнопку со стрелкой вниз раскрывается список
    со всеми возможными значениями. Данные значения настраиваются
    разработчиком Synergy. 

-   *Комментарий*. Представляет собой однострочное поле для ввода текстовой
    информации.

-   *Дата*. Представляет собой поле для выбора даты. По умолчанию
    заполняется текущей датой.

6. Файлы могут быть прикреплены в папки «Приложения» и «Прочие». Для этого 
   нажимаем "+" слева.  Прикреплять файлы к работе можно следующими вариантами: 

-   С хранилища. Выбор файлов будет осуществлен из Хранилища. Но в коробке 
    CRM хранилище файлов недоступно.

-   С компьютера. Выбор файлов будет осуществлен из компьютера пользователя.

-   Создать новый текстовый документ. Буден создан новый документ, в котором
    необходимо заполнить текст.

-   Сканировать. Сканер и приложение Synergy Agent устанавливаются разработчиком
    Synergy отдельно.

   Файл с компьютера можно загрузить не только с помощью пункта меню, но и перетащив 
   необходимый файл (или несколько файлов) в область «Файлы». 

7. Чтобы изменить статус лида необходимо в реестре в поле "Статус" изменить
   значение. Для этого необходимо открыть форму на редактирование, затем в
   выпадающем списке выбрать необходимое значение из списка. После вносения изменений
   необхоимо сохранить форму. Также статус лида можно поменять в модуле 
   "Управление маркетингом" раздела "Потоки" перенеся плашку в нужный статус.


### Конвертировать в сделку {#deal_convert}

В реестре "Сделки" отображаются сохраненные сделки. Сделкой считается
возможность сотрудничества с аккаунтом, которая через выполнение
задач конвертируется в продажу. 

Для конвертации в сделку необходимо:

1. В реестре "Лиды" присутствует кнопка "Конвертировать в сделки" для всех
   неконечных статусов. Название кнопки может меняться разработчиком Synergy.
   Для конечного статуса данная кнопка отсутствует.
   По нажатию на кнопку статус лида меняется на конечный статус, открывается
   проигрыватель формы новой сделки. Аналогично при выборе в выпадающем списке
   конечного статуса и сохранении изменений, кнопка исчезает и открывается
   проигрыватель формы новой сделки. После изменения статуса на конечный,
   значение статуса становится неактивным для изменения. Также в модуле 
   "Управление маркетингом" - "Поток" при перетаскивании плашки лида в статус 
   "В сделку". В этом случае также откроется проигрыватель формы с новой сделкой.

3. В открывшемся окне необходимо заполнить следующие данные, которые не были 
   сопоставлены при конвертации:

-   *Тема*. Необходимо выбрать тему из реестра "Темы сотрудничества" с помощью
[компонента выбора записи реестра](#registrychooser).

-   *Описание*. Представляет собой многострочное текстовое поле, в которое необходимо 
заполнить описание сделки.

-   *Заказ:*

    -   *№*. Представляет собой поле для ввода текста. В поле вводится номер
позиции заказа.

    -   *Наименование товара*. Необходимо выбрать товар из реестра "Каталог товаров и услуг"
с помощью [компонента выбора записи реестра](#registrychooser).

    -   *Ед. изм.* Представляет собой текстовое поле, в которое необходимо
указать единицу измерения выбранного товара.

    -   *Количество*. Представляет собой [числовое поле](#numeric_field), в которое
нужно указать количество экземпляров выбранного товара.

    -   *Цена за ед.* Представляет собой [числовое поле](#numeric_field),в которое
необходимо указать цену за единицу выбранного товара.

    -   *Сумма, тенге*. Представляет собой [числовое поле](#numeric_field), в которое
необходимо указать итоговую стоимость выбранного товара.

> Возможно указание нескольких товаров, для этого необходимо кликнуть по лейблу
"+Добавить блок", после чего добавятся вышеупомянутые компоненты. При необходимости
удалить блок с компонентами можно, кликнув на крестик в конце блока.

-   *Бюджет*. Представляет собой [числовое поле](#numeric_field). Поле
    неактивно для редактирования. Автоматически заполняется общей суммой
    всех сумм, указанных в заказах.

-   *Статус*.  Необходимо выбрать из выпадающего списка одно из значений.
    По нажатию на кнопку со стрелкой вниз раскрывается список со всеми
    возможными значениями. Данные значения настраиваются разработчиком
    Synergy.

-   *Причина отказа*. Представляет собой многострочное поле для ввода
    текстовой информации. Данное поле отображается только для статуса,
    при котором сделка отменяется, производится отказ. Для типовой
    конфигурации таким статусом является "Отказ".

-   *Задачи*:

    -   *Проект*. Необходимо выбрать проект либо портфель, задачей которого
        является данная сделка. По нажатию на кнопку справа от поля ввода
        открывается диалоговое окно выбора портфеля или проекта.

        ![Выбор портфеля или проекта](resources/img/storage/project_chooser.png)

        В данном окне отображаются портфели и проекты, которые доступны
        пользователя минимум на чтение. При этом избранные и личные проекты
        пользователя отсутствуют. Доступен выбор только одного портфеля или
        проекта. Выделенный проект или портфель выделяется голубым цветом.
        По нажатию на кнопку "Выбрать" поле заполняется выбранным значением
        портфеля или проекта в виде тега. Данный тег можно удалить, нажав на
        крестик и подтвердив действие.

    Возможно указание нескольких проектов/портфелей, для этого необходимо
    кликнуть по лейблу "+Добавить блок", после чего добавится компонент выбора
    портфеля или проекта. При необходимости удалить строку с компонентом можно,
    кликнув на крестик в конце строки.

-   *Документы.* Необходимо прикрепить файл с компьютера, из хранилища или
    создать новый с помощью [компонента выбора файла](#filechooser). Возможно
    добавление нескольких файлов, для этого необходимо кликнуть по лейблу
    "+Добавить блок", после чего добавится компонент выбора файла. При
    необходимости удалить строку с компонентом можно, кликнув на крестик
    в конце строки.

-   *Ответственный менеджер*. Поле автоматически заполняется пользователем,
    создающим запись реестра. При необходимости можно изменить данное
    значение нажав на кнопку справа от поля и в открывшемся окне выбрать 
    необходимого пользователя (см. [Компонент выбора пользователя](#userchooser)).

-   *Владелец*. Поле заполняется автоматически подразделением создающего пользователя. 
    Запись в данном реестре доступна владельцу и всем его родительским подразделениям.
    Поле обязательно для заполнения, мультивыбор недоступен.

-   *Отделение*. Поле для выбора подразделения. По умолчанию заполняется
    департаментом создающего пользователя.

-   *Активности*:
    -   *Пиктограмма типа активности*. Изображение выбирается автоматически
        в зависимости от выбранного типа активности. Данные изображения
        настраиваются разработчиком Synergy.  

    -   *Тип активности*. Необходимо выбрать из выпадающего списка одно из
        значений. По нажатию на кнопку со стрелкой вниз раскрывается список
        со всеми возможными значениями. Данные значения настраиваются
        разработчиком Synergy.  

    -   *Комментарий*. Представляет собой однострочное поле для ввода текстовой
        информации.

    -   *Дата*. Представляет собой поле для выбора даты. По умолчанию
        заполняется текущей датой.

![Сделки](resources/img/storage/deal1.png)

4. Для сохранения записи реестра необходимо нажать на кнопку "Сохранить". Сохраненные
данные отобразятся в модулях "Маркетинг" и "Управление продажами".

5. Для перехода в режим просмотра используется кнопка "Режим редактирования".
При повторном нажатии на нее запись реестра отображается в режиме редактирования.

>**Примечание:**
>
>Также запись в реестре можно создать через реестр ["Лиды"](#lead) по нажатию 
>на кнопку "Конвертировать в сделку" или при выборе в выпадающем списке конечного 
>статуса "В сделку" и сохранении изменений открывается проигрыватель формы новой сделки.

