### Действия с документом {#sec.documents_actions}

Набор управляющих кнопок зависит от просматриваемой работы по документу,
либо от отсутствия таковой:

-   документ не по реестру, отсутствуют работы;

-   документ не по реестру, присутствуют работы;

-   документ по реестру, отсутствует реестр ответа;

-   документ по реестру, присутствует реестр ответа.

Для каждого варианта API будет возвращать информацию о доступном наборе
кнопок, для каждой кнопки указываются: цвета, название, идентификатор
действия, идентификатор операции и значение лейбла.

+------------------------+------------------------+--------------------------------+----------------------------------------------------+
| Идентификатор действия | Идентификатор операции | Значение лейбла                | Примечание                                         |
+========================+========================+================================+====================================================+
| REGISTRY               | RUN                    | согласно API (запуск маршрута) | отображается только для документов по реестру      |
+------------------------+------------------------+--------------------------------+----------------------------------------------------+
| REGISTRY               | ANSWER                 | согласно API (создание ответа) | отображается только для документов по реестру      |
+------------------------+------------------------+--------------------------------+----------------------------------------------------+
| RESOLUTION             |                        | Резолюция                      |                                                    |
+------------------------+------------------------+--------------------------------+----------------------------------------------------+
| COMPLETE               | PROCESS                | Завершить                      | отображается только при наличии работ по документу |
+------------------------+------------------------+--------------------------------+----------------------------------------------------+
| COMPLETE               | PROGRESS               | Ответить                       | отображается только при наличии работ по документу |
+------------------------+------------------------+--------------------------------+----------------------------------------------------+
| COMPLETE               | STATUS                 | Завершить                      | отображается только при наличии работ по документу |
+------------------------+------------------------+--------------------------------+----------------------------------------------------+
| COMPLETE               | POINT_RESULT           | Завершить                      | отображается только при наличии работ по документу |
+------------------------+------------------------+--------------------------------+----------------------------------------------------+
| RESULT                 |                        | Результат                      | отображается только при наличии работ по документу |
+------------------------+------------------------+--------------------------------+----------------------------------------------------+
| SEND                   | AGREEMENT              | согласно API (согласование)    |                                                    |
+------------------------+------------------------+--------------------------------+----------------------------------------------------+
| SEND                   | APPROVAL               | согласно API (утверждение)     |                                                    |
+------------------------+------------------------+--------------------------------+----------------------------------------------------+
| SEND                   | ACQUAINTANCE           | согласно API (ознакомление)    |                                                    |
+------------------------+------------------------+--------------------------------+----------------------------------------------------+
| REASSIGN               |                        | согласно API (перепоручение)   |                                                    |
+------------------------+------------------------+--------------------------------+----------------------------------------------------+
| TRANSMIT               |                        | согласно API (передача)        | отображается только при наличии работ по документу |
+------------------------+------------------------+--------------------------------+----------------------------------------------------+

По нажатию кнопки с идентификатором операции `RUN` открывается экран 
запуска маршрута ([Запуск маршрута](#sec.documents_route_starting)).

В мобильном клиенте возможны следующие 2 варианта запуска маршрута:

*   документ по реестру еще не активирован (поле `activate` = false) и не 
    находится в процессе (поле `processing` = false): в окне информации о 
    документе имеется кнопка с идентификатором операции `RUN`, по нажатию 
    которой открывается / запускается маршрут *активации* элемента;

*   документ по реестру активирован (поле `activate` = true) и не 
    находится в процессе (поле `processing` = false): в окне редактирования 
    файла по форме имеется кнопка "Сохранить", по нажатию которой открывается 
    / запускается маршрут *изменения* элемента;

*   маршрут *удаления* элемента посредством мобильного клиента вызвать 
    нельзя ввиду отсутствия модуля «Реестры», откуда это действие выполняется.

Кнопка с идентификатором операции `ANSWER` может отображаться, только если 
документ по реестру активирован (поле `activate` = true) и только если 
форма реестра ответа имеет мобильное представление. По нажатию этой кнопки 
открывается экран создания документа по реестру ответа 
([Создание документов](#sec.document_creation)).

Остальные действия аналогичны действиям в потоках работ 
([Действия с работой](#sec.workflow_work_actions)), включая действие 
подписания документа, но за тем исключением, что вместо названия работы 
необходимо использовать краткое содержание документа.

<#include "documents/documents_route_starting.md">

