Список документов для смартфона {#sec.documents_list}
-------------------------------

Экран со списком документов для смартфона представлен на илл. 
«Список документов журнала для смартфона» и илл. «Список 
документов пользователя для смартфона».

![Список документов журнала для смартфона](resources/img/documents/main.png)

![Список документов пользователя для смартфона](resources/img/documents/main1.png)

**Элементы управления экрана со списком документов.**

+--------------------------------------------------------------+------------------------+-----------------------------------------------------+
| Элемент управления                                           | Расположение на экране | Описание                                            |
+==============================================================+========================+=====================================================+
| *Верхняя панель*                                             |                        |                                                     |
+--------------------------------------------------------------+------------------------+-----------------------------------------------------+
| ![](resources/img/workflow/elements/button_filters.png)\     | Слева                  | "Навигатор" - кнопка перехода к                     |
|                                                              |                        | [фильтрам документов](#sec.documents_filters)       |
+--------------------------------------------------------------+------------------------+-----------------------------------------------------+
| "Документы"                                                  | По центру              | Выпадающий список для переключения между модулями   |
+--------------------------------------------------------------+------------------------+-----------------------------------------------------+
| ![](resources/img/workflow/elements/button_work_create.png)\ | Справа                 | "Создать" - кнопка                                  |
|                                                              |                        | [создания документа](#sec.workflow_document_create) |
+--------------------------------------------------------------+------------------------+-----------------------------------------------------+
| *Рабочая область*                                            |                        |                                                     |
+--------------------------------------------------------------+------------------------+-----------------------------------------------------+
|                                                              | Вся рабочая область    | Плашки, отображающие информацию о документе         |
|                                                              | ниже верхней панели    |                                                     |
+--------------------------------------------------------------+------------------------+-----------------------------------------------------+

По нажатию на "Документы" на верхней панели не отображаются 
все кнопки, под панелью открывается выпадающий список с 
модулями:

*   [Работы](#chap_workflow);
*   [Документы](#chap.documents);
*   [Файлы](#chap.files).

До вызова выпадающего списка стрелка отображается указателем 
вниз, по вызову меняется указателем вверх. По нажатию вне 
области выпадающего списка, а также по указателю и шапке 
списка, он скрывается. По нажатию на текущий модуль список 
обновляется, на другой модуль - открывается соответствующий 
модуль.

Документы в списке отображаются с постепенной догрузкой. 
Изначально подгружается такое количество документов, чтобы 
список был полностью заполнен и появился скролл (минимум 30). 
При прокрутке пользователем вниз и достижении конца списка, 
список документов дополняется (количество документов в новой 
"порции" должно быть равно количеству документов в первой 
"порции").

При прокрутке пользователем в начале списка вверх (действие 
dropdown) список документов обновляется.

Список документов сортируется согласно условиям 
просматриваемого фильтра.

По нажатию на кнопку "+" вызывается меню (аналогичное в 
модуле «Работы»), в построении которого участвуют пункты 
параметра `document_items`:

*   `favorite_documents`;
*   `all_documents`.

В остальном, логика этого меню и экрана «Избранное» не 
отличается от таковой в [работах](#sec.workflow_create_menu).

**Неполная плашка документа.**

Плашка документа - это компонент, отображающий информацию о 
документе. Плашки могут быть разных размеров.

Неполные плашки документа бывают двух видов (в зависимости 
от просматриваемого фильтра):

-   Плашка документа журнала (фильтры "Журналы" и "Дела")

    ![Документ "на регистрации"](resources/img/documents/elements/plashka_document_for_registration.png)

    !["Зарегистрированный" документ](resources/img/documents/elements/plashka_document_registered.png)

    !["Бракованный" документ](resources/img/documents/elements/plashka_document_defective.png)

    !["Отклоненный" документ](resources/img/documents/elements/plashka_document_draft.png)

-   Плашка документа пользователя (фильтр «Все»)

    !["Созданный" пользователем документ](resources/img/documents/elements/plashka_document_new.png)

    !["Полученный" документ](resources/img/documents/elements/plashka_document_inbox.png)

    !["Отправленный" документ](resources/img/documents/elements/plashka_document_outbox.png)

> **Примечание**
>
> Если созданный / полученный / отправленный документ 
> зарегистрирован, то плашка должна отображаться:
>
> -   для активного узла дерева "Журналы" и "Дела" - как 
>     плашка документа журнала;
>
> -   для активного узла дерева "Все" - как плашка 
>     документа пользователя.

*Элементы неполной плашки документа журнала.*

+-----------------------------------------------------------------+-----------------------------------+--------------------+
| Элемент                                                         | Описание                          | Поле API           |
+=================================================================+===================================+====================+
| *Левый блок, 1 строка*                                          |                                   |                    |
+-----------------------------------------------------------------+-----------------------------------+--------------------+
| ![](resources/img/documents/elements/system_document.png)\      | Признак происхождения / Признак   | type /             |
|                                                                 | наложенной на документ резолюции  | hasResolution      |
+-----------------------------------------------------------------+-----------------------------------+--------------------+
| ![](resources/img/documents/elements/document_on_proccess.png)\ | Признак нахождения документа в    | inProgress         |
|                                                                 | процессе                          |                    |
+-----------------------------------------------------------------+-----------------------------------+--------------------+
| NNNNN                                                           | Номер документа (только для       | number             |
|                                                                 | зарегистрированных документов)    |                    |
+-----------------------------------------------------------------+-----------------------------------+--------------------+
| Фамилия И.О.                                                    | Автор / Корреспондент (только для | author /           |
|                                                                 | зарегистрированных документов)    | correspondentOrg / |
|                                                                 | зарегистрированных документов)    | correspondent      |
+-----------------------------------------------------------------+-----------------------------------+--------------------+
| *Левый блок, 2-4 строки*                                        |                                   |                    |
+-----------------------------------------------------------------+-----------------------------------+--------------------+
|                                                                 | Краткое содержание документа, в   | name, content      |
|                                                                 | т.ч. со значащим содержимым       |                    |
+-----------------------------------------------------------------+-----------------------------------+--------------------+
| *Правый блок*                                                   |                                   |                    |
+-----------------------------------------------------------------+-----------------------------------+--------------------+
| ![](resources/img/workflow/elements/progress_done_icon.png)\    | Статус зарегистрированного        | statusID /         |
|                                                                 | документа / признак бракованности | defective          |
|                                                                 | документа                         |                    |
+-----------------------------------------------------------------+-----------------------------------+--------------------+
| ![](resources/img/documents/elements/registered_document.png)\  | Признак зарегистрированности      | registered /       |
|                                                                 | документа / признак отклоненности | statusID =         |
|                                                                 | документа                         | REJECTED           |
+-----------------------------------------------------------------+-----------------------------------+--------------------+
| ![](resources/img/workflow/elements/hook.png)\                  | Признак наличия дочерних          | hasChildren        |
|                                                                 | документов                        |                    |
+-----------------------------------------------------------------+-----------------------------------+--------------------+

*Элементы неполной плашки документа пользователя.*

+-----------------------------------------------------------------+----------------------------------+---------------+
| Элемент                                                         | Описание                         | Поле API      |
+=================================================================+==================================+===============+
| *Левый блок, 1 строка*                                          |                                  |               |
+-----------------------------------------------------------------+----------------------------------+---------------+
| ![](resources/img/documents/elements/system_document.png)\      | Признак происхождения / Признак  | type /        |
|                                                                 | наложенной на документ резолюции | hasResolution |
+-----------------------------------------------------------------+----------------------------------+---------------+
| ![](resources/img/documents/elements/document_on_proccess.png)\ | Признак нахождения документа в   | inProgress    |
|                                                                 | процессе                         |               |
+-----------------------------------------------------------------+----------------------------------+---------------+
| От: Фамилия И.О.                                                | Список адресатов                 | from / to     |
+-----------------------------------------------------------------+----------------------------------+---------------+
| *Левый блок, 2-4 строки*                                        |                                  |               |
+-----------------------------------------------------------------+----------------------------------+---------------+
|                                                                 | Краткое содержание документа, в  | name, content |
|                                                                 | т.ч. со значащим содержимым      |               |
+-----------------------------------------------------------------+----------------------------------+---------------+
| *Правый блок*                                                   |                                  |               |
+-----------------------------------------------------------------+----------------------------------+---------------+
| ДД.ММ.ГГ ЧЧ:ММ                                                  | Дата создания / получения /      | createDate    |
|                                                                 | отправления документа            |               |
+-----------------------------------------------------------------+----------------------------------+---------------+
| ![](resources/img/workflow/elements/hook.png)\                  | Признак наличия дочерних         | hasChildren   |
|                                                                 | документов                       |               |
+-----------------------------------------------------------------+----------------------------------+---------------+

*Признак происхождения* отображается в виде пиктограммы, выбор
пиктограммы зависит от поля API "type":

+------------------------------------------------------------+--------------------+-----------+
| Иконка                                                     | Описание           | Константа |
+============================================================+====================+===========+
| ![](resources/img/documents/elements/system_document.png)\ | Документ системы   | DOCUMENT  |
+------------------------------------------------------------+--------------------+-----------+
| ![](resources/img/documents/elements/email_document.png)\  | Электронное письмо | EMAIL     |
+------------------------------------------------------------+--------------------+-----------+

Если на документ наложена резолюция (поле API "hasResolution"), 
то, независимо от признака, должна отображаться иконка 
резолюции ![](resources/img/documents/elements/resolution.png) 
вместо иконки признака происхождения.

*Признак нахождения документа в процессе* отображается в виде 
пиктограммы 
![](resources/img/documents/elements/document_on_proccess.png) 
и присутствует только для документов со свойством "inProgress".

*Номер документа* отображается только для зарегистрированных 
документов журнала (поле API "number"). Если номер документа 
полностью не помещается на строке плашки, с правого края он 
должен быть затемнен градиентом из прозрачного в цвет фона.

*Автор / Корреспондент* отображается только для 
зарегистрированных документов журнала после номера 
(разделителем между номером и автором/корреспондентом должен 
быть знак "тире" с пробелами по обе стороны), заполняется:

-   для журнала внутренних документов - автором (в формате 
    "Фамилия И.О.", поле API "author");

-   для журнала входящих / исходящих документов -
    корреспондентом-организацией (поле API "correspondentOrg") 
    / корреспондентом (поле API "correspondent", при 
    отсутствии корреспондента-организации) / пусто (при 
    отсутствии обоих полей корреспондента).

Если автор/корреспондент полностью не помещается на строке 
плашки, с правого края он должен быть затемнен градиентом из 
прозрачного в цвет фона.

*Статус зарегистрированного документа журнала (поле API 
"statusID"):*

-   завершенный - константа "FINISHED" (статус "Завершен") -
    отображается в виде пиктограммы 
    ![](resources/img/workflow/elements/progress_done_icon.png)

-   незавершенный - константа "IN\_PROGRESS" (статусы "В 
    работе" / "Истекает срок" / "Есть просроченные") - 
    отображается в виде пиктограммы 
    ![](resources/img/documents/elements/calendar.png)

Если документ бракованный (поле API "defective"), то 
независимо от того, завершенный или незавершенный документ, 
его краткое содержание выделяется цветом `#b7b7b7` и 
отображается пиктограмма 
![](resources/img/documents/elements/defective_document.png).

*Признак зарегистрированности документа журнала* (поле API 
"registered") отображается в виде пиктограммы, выбор 
пиктограммы зависит от того, зарегистрирован ли документ 
журнала:

+----------------------------------------------------------------------+--------------------------+-----------+
| Иконка                                                               | Описание                 | Константа |
+======================================================================+==========================+===========+
| ![](resources/img/documents/elements/registered_document.png)\       | Документ зарегистрирован | true      |
+----------------------------------------------------------------------+--------------------------+-----------+
| ![](resources/img/documents/elements/document_for_registration.png)\ | Документ на регистрации  | false     |
+----------------------------------------------------------------------+--------------------------+-----------+

Если документ отклоненный (поле API "statusID" = 
"REJECTED"), то независимо от признака 
зарегистрированности, его краткое содержание выделяется 
цветом `#487cc2` и отображается пиктограмма 
![](resources/img/documents/elements/draft_document.png).

> **Примечание**
>
> Если документ одновременно отклоненный и бракованный, 
> краткое содержание документа выделяется цветом 
> бракованного `#b7b7b7`, последовательность иконок 
> следующая: сначала бракованность, потом отклоненность.

*Список адресатов/адресантов* отображается только для
полученных/отправленных документов пользователя:

-   фильтр "Полученные" (поле API "from") - подпись "От:" 
    и список пользователей в формате "Фамилия И.О.", 
    перечисленных через запятую;

-   фильтр "Отправленные" (поле API "to") - подпись 
    "Кому:" и список пользователей в формате 
    "Фамилия И.О.", перечисленных через запятую;

-   остальные фильтры (включая "Все"):

    -   только полученный документ (поле API "from") - 
        подпись "От:" и список пользователей в формате 
        "Фамилия И.О.", перечисленных через запятую;

    -   только отправленный документ (поле API "to") - 
        подпись "Кому:" и список пользователей в формате 
        "Фамилия И.О.", перечисленных через запятую;

    -   и полученный, и отправленный документ - подписи 
        "От:" и "Кому:" (на две строки) и список 
        пользователей в формате "Фамилия И.О.", 
        перечисленных через запятую.

Если весь список адресатов/адресантов полностью не 
помещается на строке плашки, с правого края он должен 
быть затемнен градиентом из прозрачного в цвет фона.

*Дата создания / получения / отправления документа* 
отображается только для документов пользователя (поле 
API "createDate") и заполняется датой и временем 
последнего выполненного действия с документом в формате 
"ДД.ММ.ГГ ЧЧ:ММ".

*Краткое содержание документа (поле API "name"), через 
дефис значащее содержимое (поле API "content"),* 
отображаются максимум на 3 (три) строки. Если текст 
краткого содержания содержит менее трех строк, то должна 
меняться минимальная высота плашки в соответствии с 
количеством строк краткого содержания (но не более трех 
строк). Если же полностью не помещается на плашке, то с 
правого края третьей строки оно должно быть затемнено 
градиентом из прозрачного в цвет фона.

Цвет краткого содержания документа журнала зависит от 
его свойств и времени, оставшегося до завершения работ 
по документу:

+-----------------------------------------+-----------------+--------------------------+
| Условие                                 | Поле API        | Цвет краткого содержания |
+=========================================+=================+==========================+
| если хотя бы одна работа по маршруту    | is_expired      | `#be3d3d`                |
| документа просрочена                    |                 |                          |
+-----------------------------------------+-----------------+--------------------------+
| если хотя бы у одной работы по маршруту | is_soon_expired | `#a57020`                |
| документа истекает срок                 |                 |                          |
+-----------------------------------------+-----------------+--------------------------+
| если документ бракованный               | defective       | `#b7b7b7`                |
+-----------------------------------------+-----------------+--------------------------+
| иначе                                   |                 | `#487cc2`                |
+-----------------------------------------+-----------------+--------------------------+

Краткое содержание документов пользователя (раздел "Все") 
всегда выделяются цветом `#487cc2`. Значащее содержимое 
всегда и везде выделяется только цветом `#83aade` 
(независимо от любых других условий).

Если по данному документу имеются непросмотренные 
уведомления (поле API "is_new" = true), документ должен 
быть выделен полужирным.

Жирное выделение документа снимется тогда, когда 
пользователь просмотрит информацию о нем.

**Полная плашка документа.**

Посмотреть больше информации о документе (илл. «Полная 
плашка документа (смартфон)»), не открывая его полную 
информацию, можно следующими тремя способами:

1.  двойным нажатием по неполной плашке;

2.  масштабированием плашки разведением пальцев (сведением 
    пальцев для обратного действия);

3.  выбрав пункт контекстного меню "Показать информацию" 
    (пункт "Скрыть информацию" для обратного действия).

![Полная плашка документа (смартфон)](resources/img/documents/main2.png)

Порядок отображения полей:

+-----------------------------------------------------------------+-----------------------------------+---------------------+
| Элемент                                                         | Описание                          | Поле API            |
+=================================================================+===================================+=====================+
| *1 строка*                                                      |                                   |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| ![](resources/img/documents/elements/system_document.png)\      | Признак происхождения             | type                |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| ![](resources/img/documents/elements/resolution.png)\           | Признак наложенной на документ    | hasResolution       |
|                                                                 | резолюции                         |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| ![](resources/img/documents/elements/document_on_proccess.png)\ | Признак нахождения документа в    | inProgress          |
|                                                                 | процессе                          |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| ![](resources/img/documents/elements/control_document.png)\     | Признак контрольности документа   | controlled          |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| ![](resources/img/documents/elements/defective_document.png)\   | Признак бракованности документа   | defective           |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| ![](resources/img/documents/elements/draft_document.png)\       | Признак отклоненности документа   | statusID = REJECTED |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| *2 строка*                                                      |                                   |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| NNNNN                                                           | Номер документа (только для       | number              |
|                                                                 | зарегистрированных документов)    |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| Фамилия И.О.                                                    | Автор / Корреспондент (только для | author /            |
|                                                                 | зарегистрированных документов)    | correspondentOrg /  |
|                                                                 | зарегистрированных документов)    | correspondent       |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| *3 строка*                                                      |                                   |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
|                                                                 | Краткое содержание документа, в   | name, content       |
|                                                                 | т.ч. со значащим содержимым       |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| *4 строка*                                                      |                                   |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| Создано: ДД.ММ.ГГ ЧЧ:ММ                                         | Дата создания / получения /       | createDate          |
|                                                                 | отправления документа             |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| *5 строка*                                                      |                                   |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| От: Фамилия И.О.                                                | Список адресатов                  | from / to           |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| *6 строка*                                                      |                                   |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| Регистрация                                                     | Статическая подпись,              |                     |
|                                                                 | сигнализирующая о начале блока    |                     |
|                                                                 | информации о зарегистрированном   |                     |
|                                                                 | документе (только для             |                     |
|                                                                 | зарегистрированных документов)    |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| ![](resources/img/documents/elements/calendar.png)\             | Статус зарегистрированного        | statusID            |
|                                                                 | документа                         |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| ![](resources/img/documents/elements/registered_document.png)\  | Признак зарегистрированности      | registered          |
|                                                                 | документа                         |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| *7 строка*                                                      |                                   |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| Зарегистрировал: Фамилия И.О.                                   | Пользователь, зарегистрировавший  | regUser             |
|                                                                 | документ (только для              |                     |
|                                                                 | зарегистрированных документов)    |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| Дата: ДД.ММ.ГГ                                                  | Дата регистрации документа        | regDate             |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| *8 строка*                                                      |                                   |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| Отписано: Фамилия И.О.                                          | Пользователь, которому отписан    | user                |
|                                                                 | документ (только для              |                     |
|                                                                 | зарегистрированных незавершенных  |                     |
|                                                                 | документов)                       |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| *9 строка*                                                      |                                   |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+
| На исполнении: Фамилия И.О.                                     | Список пользователей, у которых   | resUsers            |
|                                                                 | документ находится на исполнении  |                     |
|                                                                 | (только для зарегистрированных    |                     |
|                                                                 | незавершенных документов)         |                     |
+-----------------------------------------------------------------+-----------------------------------+---------------------+

Полное описание полей представлено в 
[Список документов для планшета](#sec.documents_list_tablet), 
при этом вся информация (в т.ч. краткое содержание, список 
адресатов и пользователей на исполнении) отображается полностью.

**Возможные действия с плашкой документа:**

1.  При выделении плашки (tap) открывается экран с информацией 
    о документе (независимо от прав пользователя).

2.  При двойном нажатии по плашке смартфона (double tap), а 
    также при масштабировании плашки сведением и разведением 
    пальцев (`pinch-to-zoom`), она переключается между режимами 
    "полная" / "неполная".

3.  В результате долгого нажатия по плашке документа появляется 
    меню с пунктами, доступными для любого пользователя:

    1.  "Показать информацию" / "Скрыть информацию" - для 
        переключения между режимами плашки "полная" / 
        "неполная";

    2.  "Скрыть" / "Восстановить" (поле hide) - только для 
        активного узла дерева "Все".

**Переходы на другие экраны.**

Чтобы перейти к 
[дочерним документам](#sec.documents_subsidiary_docs), 
пользователь проводит пальцем от правой стороны плашки к левой.

По нажатию на кнопку "Фильтры", а также проведя пальцем от 
левой стороны экрана к правой, раскрывается панель навигатора 
[фильтров документов](#sec.documents_filters).

По нажатию на кнопку "Создать" открывается выпадающий список с 
пунктами, по нажатию которого открывается экран 
[создания документов](#sec.document_creation).

По нажатию на плашку документа открывается экран полной 
[информации о документе](#sec.documents_docinfo).

В результате долгого нажатия по плашке активного узла дерева 
"Все" появляется меню с 
[пунктом "Скрыть" / "Восстановить"](#sec.documents_hide).

По нажатию на кнопку "Назад":

*   для переключателя "Запомнить меня" со значением "Выкл" - 
    открывается экран [авторизации](#sec.autorise);
*   для переключателя "Запомнить меня" со значением "Вкл" - 
    происходит [закрытие приложения](#sec.app_exit).

> **Примечание**
>
> Метод получения списка документов описан в javadoc:
>
> kz.arta.synergy.server.api.rest.docs#getDocumentsList.
> 
> http://tdd.lan.arta.kz/docs/synergy/trunk/sdk-doc/javadoc/kz/arta/synergy/server/api/rest/storage/StorageService.html#listFiles%28java.lang.String,%20boolean,%20java.lang.String%29


