Список документов для планшета {#sec.documents_list_tablet}
------------------------------

Экран со списком документов представлен на илл. «Список документов для
планшета (журналы, дела)» и илл. «Список документов для планшета
(документы)».

![Список документов для планшета (журналы,
дела)](resources/img/documents/iOS/ipad_documents.png)

![Список документов для планшета
(документы)](resources/img/documents/iOS/ipad_documents_2.png)

**Элементы управления экрана со списком документов** аналогичны списку
документов для смартфона ([Список документов для
смартфона](#sec.documents_list)).

**Полная плашка документа (планшет).**

Плашки документа также бывают двух видов (в зависимости от
просматриваемого фильтра):

-   Плашка документа журнала (фильтры "Журналы" и "Дела")

-   Плашка документа пользователя (фильтр "Все")

*Элементы плашки документа журнала.*

  Элемент                                                                  Описание                                                                                                                    Поле API
  ------------------------------------------------------------------------ --------------------------------------------------------------------------------------------------------------------------- -------------------------------------------
  *Левый блок, 1 строка*
  ![](resources/img/documents/elements/system_document.png)                Признак происхождения                                                                                                       type
  ![](resources/img/documents/elements/resolution.png)                     Признак наложенной на документ резолюции                                                                                    hasResolution
  ![](resources/img/documents/elements/document_on_proccess.png)           Признак нахождения документа в процессе                                                                                     inProgress
  NNNNN                                                                    Номер документа (только для зарегистрированных документов)                                                                  number
  Фамилия И.О.                                                             Автор / Корреспондент (только для зарегистрированных документов)                                                            author / correspondentOrg / correspondent
  *Левый блок, 2-4 строки*
                                                                           Краткое содержание документа, в т.ч. со значащим содержимым                                                                 name, content
  *Левый блок, 5 строка*
  На исполнении: Фамилия И.О.                                              Список пользователей, у которых документ находится на исполнении (только для зарегистрированных незавершенных документов)   resUsers
  *Правый блок, 1 строка*
  ![](resources/img/documents/elements/calendar.png)                       Статус зарегистрированного документа                                                                                        statusID
  ![](resources/img/documents/elements/registered_document.png) ДД.ММ.ГГ   Признак зарегистрированности документа                                                                                      registered / regDate
  ![](resources/img/documents/elements/control_document.png)               Признак контрольности документа                                                                                             controlled
  ![](resources/img/documents/elements/defective_document.png)             Признак бракованности документа                                                                                             defective
  ![](resources/img/documents/elements/draft_document.png)                 Признак отклоненности документа                                                                                             statusID = REJECTED
  *Правый блок, 2 строка*
  ![](resources/img/documents/elements/registered_user.png) Фамилия И.О.   Пользователь, зарегистрировавший документ (только для зарегистрированных документов)                                        regUser
  *Правый блок, 5 строка*
  Отписано: Фамилия И.О.                                                   Пользователь, которому отписан документ (только для зарегистрированных незавершенных документов)                            user
  *Правый нижний блок*
  ![](resources/img/workflow/elements/hook.png)                            Признак наличия дочерних документов                                                                                         hasChildren

*Элементы плашки документа пользователя.*

  Элемент                                                          Описание                                                      Поле API
  ---------------------------------------------------------------- ------------------------------------------------------------- ---------------
  *Левый блок, 1 строка*
  ![](resources/img/documents/elements/system_document.png)        Признак происхождения                                         type
  ![](resources/img/documents/elements/resolution.png)             Признак наложенной на документ резолюции                      hasResolution
  ![](resources/img/documents/elements/document_on_proccess.png)   Признак нахождения документа в процессе                       inProgress
  От: Фамилия И.О.                                                 Список адресатов                                              from / to
  Левый блок, 2-4 строки
                                                                   Краткое содержание документа, в т.ч. со значащим содержимым   name, content
  Правый блок
  Создано: ДД.ММ.ГГ ЧЧ:ММ                                          Дата создания / получения / отправления документа             createDate
  ![](resources/img/workflow/elements/hook.png)                    Признак наличия дочерних документов                           hasChildren

*Признак происхождения* отображается в виде пиктограммы, выбор
пиктограммы зависит от поля API "type":

  Иконка                                                      Описание             Константа
  ----------------------------------------------------------- -------------------- -----------
  ![](resources/img/documents/elements/system_document.png)   Документ системы     
  ![](resources/img/documents/elements/email_document.png)    Электронное письмо   

*Признак наложенной на документ резолюции (поле API "hasResolution")*
отображается в виде пиктограммы
![](resources/img/documents/elements/resolution.png) и присутствует
только для документов со свойством \_\_\_\_\_\_\_.

*Признак нахождения документа в процессе* отображается в виде
пиктограммы
![](resources/img/documents/elements/document_on_proccess.png) и
присутствует только для документов со свойством "inProgress".

*Номер документа* отображается только для зарегистрированных документов
журнала (поле API "number").

*Автор / Корреспондент* отображается только для зарегистрированных
документов журнала после номера (разделителем между номером и
автором/корреспондентом должен быть знак "тире" с пробелами по обе
стороны), заполняется:

-   для журнала внутренних документов - автором (в формате"Фамилия
    И.О.", поле API "author");

-   для журнала входящих / исходящих документов -
    корреспондентом-организацией (поле API "correspondentOrg") /
    корреспондентом (поле API "correspondent", при отсутствии
    корреспондента-организации) / пусто (при отсутствии обоих полей
    корреспондента).

*Статус зарегистрированного документа журнала (поле API "statusID"):*

-   завершенный - константа "FINISHED" (статус "Завершен") -
    отображается в виде пиктограммы
    ![](resources/img/workflow/elements/progress_done_icon.png)

-   незавершенный - константа "IN\_PROGRESS" (статусы "В работе" /
    "Истекает срок" / "Есть просроченные") - отображается в виде
    пиктограммы ![](resources/img/documents/elements/calendar.png)

*Признак зарегистрированности документа журнала* (поле API "registered")
отображается в виде пиктограммы и даты регистрации (для
зарегистрированного документа, (поле API "regDate") в формате
"ДД.ММ.ГГ". Выбор пиктограммы зависит от того, зарегистрирован ли
документ журнала:

  Иконка                                                                Описание                   Константа
  --------------------------------------------------------------------- -------------------------- -----------
  ![](resources/img/documents/elements/registered_document.png)         Документ зарегистрирован   true
  ![](resources/img/documents/elements/document_for_registration.png)   Документ на регистрации    false

*Признак контрольности документа* отображается в виде пиктограммы
![](resources/img/documents/elements/control_document.png) и
присутствует только для документов со свойством "controlled".

*Признак бракованности документа* присутствует только для документов со
свойством "defective", его краткое содержание выделяется цветом \#b7b7b7
и отображается пиктограмма
![](resources/img/documents/elements/defective_document.png).

*Признак отклоненности документа* присутствует только для документов со
свойством "statusID"="REJECTED", его краткое содержание выделяется
цветом \#487cc2 и отображается пиктограмма
![](resources/img/documents/elements/draft_document.png).

> **Замечание**
>
> Если документ одновременно отклоненный и бракованный, краткое
> содержание документа выделяется цветом бракованного \#b7b7b7,
> последовательность иконок следующая: сначала бракованность, потом
> отклоненность.

*Пользователь, зарегистрировавший документ* отображается только для
зарегистрированных документов журнала (поле API "regUser") с иконкой
![](resources/img/documents/elements/registered_user.png) и текстом в
формате "Фамилия И.О."

*Пользователь, которому отписан документ* отображается только для
зарегистрированных документов журнала (поле API "user") с подписью,
загруженной при авторизации (например "Отписано:") и текстом в формате
"Фамилия И.О.", занимает не более 1/3 ширины плашки (выравнивание по
правому краю).

*Список пользователей, у которых документ находится на исполнении*
отображается только для зарегистрированных документов журнала (поле API
"resUsers") и содержит подпись "На исполнении:" и список пользователей
(в зависимости от настройки "отображать ли конечных пользователей на
исполнении") в формате "Фамилия И.О." через запятую. Занимает не более
2/3 ширины плашки (выравнивание по левому краю).

*Список адресатов/адресантов* отображается только для
полученных/отправленных документов пользователя:

-   фильтр "Полученные" (поле API "from") - подпись "От:" и список
    пользователей в формате "Фамилия И.О.", перечисленных через запятую;

-   фильтр "Отправленные" (поле API "to") - подпись "Кому:" и список
    пользователей в формате "Фамилия И.О.", перечисленных через запятую;

-   остальные фильтры (включая "Все"):

    -   только полученный документ (поле API "from") - подпись "От:" и
        список пользователей в формате "Фамилия И.О.", перечисленных
        через запятую;

    -   только отправленный документ (поле API "to") - подпись "Кому:" и
        список пользователей в формате "Фамилия И.О.", перечисленных
        через запятую;

    -   и полученный, и отправленный документ - подписи "От:" и "Кому:"
        (на одну строку) и список пользователей в формате "Фамилия
        И.О.", перечисленных через запятую.

Если весь список адресатов/адресантов полностью не помещается на строке
плашки, с правого края он должен быть затемнен градиентом из прозрачного
в цвет фона.

*Дата создания / получения / отправления документа* отображается только
для документов пользователя (поле API "createDate") и заполняется
подписью:

-   "Создано:" - если на плашке нет полей "От" и "Кому";

-   "Получено:" - если на плашке есть только поле "От";

-   "Отправлено:" - если на плашке есть только поле "Кому";

соответственно и датой и временем последнего выполненного действия с
документом в формате "ДД.ММ.ГГ ЧЧ:ММ".

*Краткое содержание документа (поле API "name"), через дефис значащее
содержимое (поле API "content"),* отображаются максимум на 3 (три)
строки. Если текст краткого содержания содержит менее трех строк, то
должна меняться минимальная высота плашки в соответствии с количеством
строк краткого содержания (но не более трех строк). Если же полностью не
помещается на плашке, то с правого края третьей строки оно должно быть
затемнено градиентом из прозрачного в цвет фона.

Цвет краткого содержания документа журнала зависит от его свойств и
времени, оставшегося до завершения работ по документу:

  Условие                                                           Поле API            Цвет краткого содержания
  ----------------------------------------------------------------- ------------------- --------------------------
  Если хотя бы одна работа по маршруту документа просрочена         is\_expired         \#be3d3d
  Если хотя бы у одной работы по маршруту документа истекает срок   is\_soon\_expired   \#a57020
  Если документ бракованный                                         defective           \#b7b7b7
  Иначе                                                                                 \#487cc2

Краткое содержание документов пользователя (раздел "Все") всегда
выделяются цветом \#487cc2. Значащее содержимое всегда и везде
выделяется только цветом \#83aade (независимо от любых других условий).

Если по данному документу имеются непросмотренные уведомления (поле API
"is\_new"=true), документ должен быть выделен полужирным.

Жирное выделение документа снимется тогда, когда пользователь просмотрит
информацию о нем.

**Возможные действия с плашкой документа:**

1.  При выделении плашки (tap) открывается экран с информацией о
    документе (не зависимо от прав пользователя).

2.  Двойное нажатие по плашке (double tap), а также масштабирование
    плашки сведением и разведением пальцев (pinch-to-zoom) отсутствует.

3.  В результате долгого нажатия по плашке документа появляется меню с
    пунктом, доступным для любого пользователя:

    1.  "Скрыть" / "Восстановить" (поле hide) - только для активного
        узла дерева "Все".

**Переходы на другие экраны** аналогичны списку документов для смартфона
([Список документов для смартфона](#sec.documents_list)).

