#### Запуск маршрута {#sec.documents_route_starting}

По нажатию управляющей кнопки при отсутствии настроенного маршрута сообщается 
"Данные сохранены" и запускается пустой маршрут (запись должна сразу получить 
статус "активирована", поле `activate` = true). При наличии же маршрута, в 
зависимости от настроек этого маршрута события, возможны следующие 2 варианта:

*   если в каждом из блоков (предварительный `before` / действия `action` / 
    последующий `after`) значение настройки "Отображать ли при сохранении" = 
    false, то без открытия экранов должно происходить действие запуска 
    маршрута;
    
*   если же хотя бы в одном из блоков (предварительный `before` / действия 
    `action` / последующий `after`) значение настройки "Отображать ли при 
    сохранении" = true, то открывается экран запуска маршрута (илл. «Запуск 
    маршрута»).

> **Примечание**
> 
> В случае, если в РКК документа работы настроена валидация его полей 
> перед отправкой, то по нажатию на кнопку запуска маршрута действие не 
> произойдет (экран "Запуск маршрута" не откроется) с ошибкой (-ами):
> 
> `Данный тип документа требует указание дела. Выберите его в карточке и 
> отправьте повторно. Если список пуст, обратитесь к методологу`
> 
> `Данный тип документа требует определения исполнителя. Выберите его в 
> карточке и отправьте повторно`

> **Примечание**
> 
> Метод получения описания маршрутов реестра описан в javadoc:
> 
> kz.arta.synergy.server.api.rest.registry#route.

**Экран запуска маршрута.**

При открытии экрана API должно возвращать следующую информацию:

-   `name` - краткое содержание документа (из метода 
    kz.arta.synergy.server.api.rest.docs#getDocumentInfo;

-   описание маршрута по событию, определенный в конфигураторе для
    данного реестра (из метода 
    kz.arta.synergy.server.api.rest.registry#route;

-   закрывать ли окно документа после отправки на активацию (из метода 
    kz.arta.synergy.server.api.rest.registry#route.

![Запуск маршрута](resources/img/documents/route_running.png)

![Запуск маршрута](resources/img/documents/iOS/route_running_iOS.png)

Заголовок экрана - «Запуск маршрута». Вверху экрана отображается поле 
«Формулировка», заполненное по умолчанию значением поля "Краткое 
содержание" в РКК документа. Поле редактируемо.

Далее идут панели согласно предварительно настроенного в конфигураторе
маршрута. Для каждого из блоков отображается отдельная панель с 
соответствующим заголовком:

*   `before` - «Предварительные этапы»;
*   `action` - «Действия»;
*   `after` - «Последующие этапы».

Панель содержит все элементы всех этапов маршрута.

Если значение настройки "Отображать ли при сохранении" (поле `showOnSave`) 
= true, то панель соответствующей части маршрута должна отображаться (даже 
в случае отсутствия в ней этапов), иначе - не отображаться.

Каждый элемент этапа содержит следующую информацию об этапе:

> *Полное_название_этапа*
> 
> Ответственный: *Фамилия И.О.*
> 
> либо
> 
> Адресат: *Фамилия И.О.*
> 
> Тип работы: *Тип_работы`*

Поле "Ответственный" всегда (даже при отсутствии значения) должно 
отображаться только для следующих типов работ:

*   работа (`ASSIGNMENT_ITEM`);
*   согласование (`AGREEMENT_ITEM`);
*   утверждение (`APPROVAL_ITEM`);
*   ознакомление (`ACQUAINTANCE_ITEM`);
*   резолюция (`RESOLUTION_ACTION`).

Поле "Адресат", в свою очередь, для типа:

*   отправка документа (`SEND_DOCUMENT`).

Для всех остальных типов работ строчка с ответственным никогда 
отображаться не должна.

Поле "Тип работы" заполняется названием процесса (поле API `name`).

> **Примечание**
> 
> Метод получения настроек процессов описан в javadoc:
> 
> kz.arta.synergy.server.api.rest.settings#getProcesses.

Далее отображается управляющая кнопка «Запустить» (с идентификатором 
PREFERRED). Она имеет фиксированное положение, остальные поля и панели 
данного экрана не имеют фиксированного положения, прокручиваются (если все 
поля вмещаются в экран, то кнопка должна быть внизу экрана, а не сразу за 
контентом).

1.  В результате нажатия по любой панели (в т.ч. по заголовку) открывается 
    экран редактирования соответствующей части маршрута (илл. «Редактируемый 
    блок»).

2.  Если пользователь нажимает на кнопку "Назад", возвращается экран 
    информации о документе 
    ([Информация о документе](#sec.documents_docinfo)) в том же состоянии, 
    которое было до вызова данного экрана.

3.  Для выполнения действия пользователь нажимает на кнопку "Запустить". 
    Действие выполняется при выполнении следующих условий:

    *   заполнено поле формулировки, иначе необходимо выдавать ошибку:
        
        `Необходимо заполнить краткое содержание`
        
    *   во всех редактируемых блоках указаны пользователи - ответственные 
        за этапы маршрута, иначе необходимо выдавать ошибку:
        
        `Необходимо заполнить ответственного в некоторых этапах маршрута`

    > **Примечание**
    > 
    > В случае, если требуется подпись перед отправкой, то по нажатию на 
    > кнопку "Запустить" действие не произойдет (маршрут не запустится) 
    > с ошибкой:
    > 
    > `Необходимо подписать документ до того как вы его сможете отослать.`

    В случае успешного сохранения сообщается "Данные сохранены", экран 
    запуска маршрута закрывается, открывается:

    *   если значение настройки "закрывать ли окно документа после 
        отправки на активацию" (поле `closeAfterActivation`) = false, то 
        экран информации о документе 
        ([Информация о документе](#sec.documents_docinfo));

    *   иначе - экран со списком документов 
        ([Список документов для смартфона](#sec.documents_list)) либо 
        ([Список документов для планшета](#sec.documents_list_tablet)).

    Данные при этом обновляются, запускается настроенный маршрут.

**Редактирование маршрута.**

По нажатию на любой блок маршрута открывается экран редактирования 
соответствующей части маршрута (илл. «Редактируемый блок»). Заголовок 
экрана берется из заголовка блока.

![Блок маршрута](resources/img/documents/unit_edited.png)

![Блок маршрута](resources/img/documents/iOS/unit_edited_iOS.png)

Для блоков с предварительными и последующими этапами вверху экрана 
отображается кнопка "Добавить этап" (с идентификатором NOT_PREFFERED), по 
нажатию которой открывается экран редактирования этапа маршрута (илл. 
«Новый этап маршрута»). В блоке с действия такой конпки быть не должно.

Далее отображаются панели. Панель содержит элементы, в зависимости от 
количества подэтапов в ней. Каждая панель означает последовательные этапы 
данной части маршрута (последовательность сверху вниз), каждая плашка 
внутри панели - параллельные элементы этапа.

Каждый элемент панели содержит аналогичную информацию об этапе/подэтапе,
как и на экране запуска маршрута.

Далее отображается управляющяя кнопка «Готово» (с идентификатором 
PREFERRED). Она имеет фиксированное положение, остальные кнопки и панели 
данного экрана не имеют фиксированного положения, прокручиваются (если все 
поля вмещаются в экран, то кнопка должна быть внизу экрана, а не сразу за 
контентом).

Следующие пункты 1 и 2 действительны только для блоков с предварительными и 
последующими этапами, т.к. блок с действиями нередактируемый.

1.  В результате нажатия (действие tap) по элементу панели открывается экран 
    редактирования данного этапа маршрута (илл. «Редактирование этапа 
    маршрута») с заполненными данными.

2.  В результате долгого нажатия по элементу панели вызывается меню со 
    следующими пунктами:

    *   "Добавить элемент этапа": открывается экран создания нового этапа 
        маршрута (илл. «Новый этап маршрута»).
    
    *   "Переместить этап выше": выбранная панель перемещается выше на одну 
        позицию. Пункт меню недоступен для первой в списке панели.
    
    *   "Переместить этап ниже": выбранная панель перемещается ниже на одну 
        позицию. Пункт меню недоступен для последней в списке панели.
    
    *   "Удалить элемент этапа": запрашивается подтверждение удаления с 
        сообщением:
        
        `Вы действительно хотите удалить данный элемент этапа?`
        
        Если пользователь подтверждает удаление, выбранный элемент панели 
        удаляется. Пункт меню недоступен для панели с единственным элементом.
    
    *   "Удалить этап": запрашивается подтверждение удаления с сообщением:
        
        `Вы действительно хотите удалить данный этап?`
        
        Если пользователь подтверждает удаление, выбранная панель удаляется 
        из списка этапов данного блока.

3.  Если пользователь нажимает на кнопку "Назад", мобильный клиент возвращает 
    экран запуска маршрута (илл. «Запуск маршрута») в том состоянии, которое 
    было до вызова данного экрана.

4.  Для сохранения маршрута пользователь нажимает на кнопку "Готово". 
    Сохранение локальное. Действие выполняется при выполнении следующего 
    условия:

    *   во всех редактируемых блоках указаны пользователи - ответственные 
        за этапы маршрута, иначе необходимо выдавать ошибку:
        
        `Необходимо заполнить ответственного в некоторых этапах маршрута`

    В случае успешного сохранения сообщается "Данные сохранены", открывается 
    экран запуска маршрута (илл. «Запуск маршрута»). Данные в этом экране 
    обновляются согласно введеным изменениям.

**Создание и редактирование этапа маршрута.**

По нажатию на экране редактирования маршрута на кнопку «Добавить этап» / на 
экране редактирования маршрута на пункт контекстного меню «Добавить элемент 
этапа» / на экране редактирования этапа маршрута на кнопку «Добавить 
параллельный» открывается экран создания нового этапа маршрута (илл. «Новый 
этап маршрута»). Заголовок экрана всегда "Новый этап".

![Новый этап маршрута](resources/img/documents/route_stage_new.png)

![Новый этап маршрута](resources/img/documents/iOS/route_stage_new_iOS.png)

По нажатию на экране редактирования маршрута на какой-либо элемент панели 
открывается экран редактирования соответствующего элемента этапа маршрута 
(илл. «Редактирование этапа маршрута»). Заголовок экрана всегда "Этап".

![Редактирование этапа маршрута](resources/img/documents/route_stage_edit.png)

![Редактирование этапа маршрута](resources/img/documents/iOS/route_stage_edit_iOS.png)

Все поля экрана не имеют фиксированной высоты, экран прокручивается. Вверху 
экрана редактирования этапа маршрута отображается кнопка "Добавить параллельный" 
(с идентификатором NOT_PREFFERED). По его нажатию открывается экран создания 
этапа мрашрута (илл. «Новый этап маршрута»).

Параметры экрана:

+------------------------------+--------------------------------------------------------------------------------+---------------------------------------------------------+
| Параметр                     | Описание                                                                       | Значение по умолчанию                                   |
+==============================+================================================================================+=========================================================+
| Номер этапа                  | Отображается для всех типов действий. Нередактируемое поле ввода.              | *Создание* и *Редактирование* - текущий номер этапа.    |
+------------------------------+--------------------------------------------------------------------------------+---------------------------------------------------------+
| Тип действия (`typeID`)      | Отображается для всех типов действий. Открывается список из возможных значений | *Создание* - первый вариант из списка.                  |
|                              | (полученных при загрузке приложения).                                          |                                                         |
|                              |                                                                                | *Редактирование* - тип действия текущего этапа.         |
+------------------------------+--------------------------------------------------------------------------------+---------------------------------------------------------+
| Название (`name`)            | Отображается для всех типов действий, обязательно для заполнения. Вводится     | *Создание* - поле пустое, placeholder - "Введите        |
|                              | полное название этапа (автоматический подбор согласно выбранного действия,     | название". Для типа действия "блокирующий процесс"      |
|                              | как в платформе, не поддерживается).                                           | заполняется значением по умолчанию `event.blocking.`.   |
|                              |                                                                                | Для типа действия "маршрут" заполняется названием       |
|                              |                                                                                | выбранного маршрута.                                    |
|                              |                                                                                |                                                         |
|                              |                                                                                | *Редактирование* - текущее название этапа.              |
+------------------------------+--------------------------------------------------------------------------------+---------------------------------------------------------+
| Ответственный либо Адресат   | Не отображается для типов действий "блокирующий процесс", "регистрация",       | *Создание* - поле пустое, placeholder - "Выберите       |
| (`userID`)                   | "маршрут", для остальных типов обязательно для заполнения. Открывается экран   | ответственного".                                        |
|                              | "Пользователи" с параметрами:                                                  |                                                         |
|                              |                                                                                | *Редактирование* - текущий ответственный этапа.         |
|                              | *  множественный выбор пользователей;                                          |                                                         |
|                              | *  если значение настройки "разрешено ли ставить работы неподчиненным" =       |                                                         |
|                              |    true, отображать всех пользователей, иначе - только подчиненных.            |                                                         |
+------------------------------+--------------------------------------------------------------------------------+---------------------------------------------------------+
| Длительность/Дата завершения | Не отображается для типов действий "блокирующий процесс", "маршрут", "отправка | *Создание* - в списке первый вариант, в поле ввода -    |
| (`lengthType` и `length`)    | документа", для остальных типов обязательно для заполнения. Состоит из двух    | значение по умолчанию, placeholder при необходимости -  |
|                              | компонентов. В первом открывается список со значениями:                        | "Введите длительность" для первых двух вариантов из     |
|                              |                                                                                | списка.                                                 |
|                              | *  `Длительность (ч)`                                                          |                                                         |
|                              | *  `Длительность (д)`                                                          | *Редактирование* - текущие значения длительности либо   |
|                              | *  `Дата завершения` в формате ДД/ММ/ГГГГ                                      | даты завершения этапа.                                  |
|                              |                                                                                |                                                         |
|                              | Для первых двух вариантов второй компонент - числовое поле ввода, для          |                                                         |
|                              | последнего варианта - стандартный компонент выбора даты.                       |                                                         |
+------------------------------+--------------------------------------------------------------------------------+---------------------------------------------------------+
| Нагрузка (`workLoadType` и   | Не отображается для типов действий "блокирующий процесс", "маршрут", "отправка | *Создание* - в списке первый вариант, в поле ввода -    |
| `workloadValue`)             | документа", "регистрация", для остальных типов обязательно для заполнения.     | значение по умолчанию, placeholder при необходимости -  |
|                              | Состоит из двух компонентов. В первом открывается список со значениями,        | "Введите нагрузку".                                     |
|                              | настроенными в конфигураторе. Для выбранного типа нагрузки второй компонент    |                                                         |
|                              | (числовое поле ввода) заполняется значением по умолчанию.                      | *Редактирование* - текущее значение нагрузки            |
+------------------------------+--------------------------------------------------------------------------------+---------------------------------------------------------+
| Возврат (`returnNumber`)     | Отображается только для типов действий "согласование", "утверждение",          | *Создание* - "Нет".                                     |
|                              | "блокирующий процесс" и "регистраци". Открывается список из возможных          |                                                         |
|                              | значений.                                                                      | *Редактирование* - текущее значение возврата.           |
+------------------------------+--------------------------------------------------------------------------------+---------------------------------------------------------+
| Форма завершения             | Отображается только для типа действия "работа". Открывается список из          | *Создание* - "Нет".                                     |
| (`completionFormID`)         | возможных значений (полученных при загрузке приложения) и значения "Нет",      |                                                         |
|                              | значение "Нет" должно быть в списке первым. Если список форм завершения пуст,  | *Редактирование* - текущая форма завершения этапа.      |
|                              | поле не должно быть отображено.                                                |                                                         |
+------------------------------+--------------------------------------------------------------------------------+---------------------------------------------------------+
| Код (`code`)                 | Отображается для всех типов действий, не обязательно для заполнения. Поле      | *Создание* - поле пустое, placeholder - "Введите код".  |
|                              | ввода. Должно содержать уникальное в рамках всего маршрута значение.           |                                                         |
|                              |                                                                                | *Редактирование* - текущий код этапа.                   |
+------------------------------+--------------------------------------------------------------------------------+---------------------------------------------------------+

> **Примечание**
> 
> Метод получения нагрузок по умолчанию описан в javadoc:
> 
> kz.arta.synergy.server.api.rest.projects#getWorkLoads.

*"Номер этапа"* должен формироваться на клиенте по следующему принципу:

*   каждому этапу присвается номер по порядку их следования;
*   каждый элемент этапа имеет номер этапа, в котором он расположен;
*   при добавлении нового этапа ему присваивается номер `N+1`, где N - это 
    последний номер этапа в данном блоке маршрута;
*   при добавлении нового (параллельного) элемента этапа ему присваивается 
    номер текущего этапа, откуда было вызвано создание данного элемента;
*   при перемещении этапов выше / ниже порядковый номер этапа должен, 
    соответственно, уменьшиться / увеличиться на единицу;
*   при удалении этапа у всех последующих этапов номер должен уменьшиться на 
    единицу.

Поле *"Тип действия"* содержит процессы, название и порядок следования в списке 
которых определяется API.

> **Примечание**
> 
> Метод получения настроек процессов описан в javadoc:
> 
> kz.arta.synergy.server.api.rest.settings#getProcesses.

При выборе пункта выбора маршрута (тип `ROUTE_ITEM`) открывается экран «Выбор 
маршрута» (илл. «Выбор маршрута»).

Поле *"Длительность/Дата завершения"* должно заполняться значениями по следующему 
принципу:

*   по умолчанию выбран вариант «Длительность (ч)», значением должно являться:
    *   `default_work_length` - для типов действий «Работа», «Резолюция», 
        «Регистрация»;
    *   `default_agreement_length` - для типа действия «Согласование»;
    *   `default_approvement_length` - для типа действия «Утверждение»;
    *   `default_acquaintance_length` - для типа действия «Ознакомление».

*   значение варианта «Длительность (д)» должно рассчитываться относительно 
    значения, введенного в варианте «Длительность (ч)», по формуле:
    
    > «Длительность (ч)» / «Длительность рабочего дня» (поле API `day_length`)

*   при возврате в вариант «Длительность (ч)» значение должно рассчитываться уже 
    относительно значения, введенного в варианте «Длительность (д)», по формуле:
    
    > «Длительность (д)» * «Длительность рабочего дня» (поле API `day_length`)

*   значение варианта «Дата завершения» значение должно рассчитываться 
    относительно значения, введенного в варианте «Длительность (д)», по формуле:
    
    > «Длительность (д)» + текущая дата
    
*   при возврате из варианта «Дата завершения» в любой другой вариант, значение 
    длительности не должно перерассчитываться относительно значения, введенного 
    в варианте «Дата завершения», т.е. должны сохранять предыдущие значения.

> **Примечание**
> 
> Метод получения значений длительности по умолчанию описан в javadoc:
> 
> kz.arta.synergy.server.api.rest.settings#getSettings.

Поле *"Нагрузка"* пока должно содержать единственное поле ввода (без выпадающего 
списка), в которое вводится как значение нагрузки, так и её тип. Возможные варианты 
типов нагрузки:

*   `%` (пример: «20%» «20 %»)
*   `ч` (пример: «8ч» или «8 ч»)
*   `д` (пример: «1.5д» «1.5 д»)

Дробная часть должна быть отделена точкой, само значение обязательно должно 
заканчиваться на один из трех вышеперечисленных символов.

Содержимое выпадающего списка *"Возврат"* должно формироваться на клиенте по 
следующему принципу:

*   первым в списке всегда должен быть пункт «Нет»;
*   далее должны отображаться номера предшествующих этапов;
*   если после удаления какого-либо этапа номер возврата ссылается на 
    несуществующий номер этапа, автоматически должен произойти сброс значения 
    возврата на «Нет»;
*   аналогично, если после перемещения выше / ниже какого-либо этапа номер 
    возврата ссылается на несуществующий номер этапа, автоматически должен 
    произойти сброс значения возврата на «Нет».

Значение поля *"Код"* присвается этапу целиком, а не только элементу этапа. 
Таким образом, если у любого элемента этапа заполняется поле кода, у остальных 
элементов данного этапа необходимо автоматически отображать данный же код. 
Соответственно, при удалении кода в одном из элементов этапа, он удаляется у 
всех элементов данного этапа.

С учетом всех описаний каждый тип действия должен содержать следующий набор 
полей:

*   работа (тип `ASSIGNMENT_ITEM`):
    *   Номер этапа
    *   Тип действия
    *   Название
    *   Ответственный
    *   Длительность/Дата завершения
    *   Нагрузка
    *   Форма завершения
    *   Код
*   согласование (тип `AGREEMENT_ITEM`) и утверждение (тип `APPROVAL_ITEM`):
    *   Номер этапа
    *   Тип действия
    *   Название
    *   Ответственный
    *   Длительность/Дата завершения
    *   Нагрузка
    *   Возврат
    *   Код
*   ознакомление (тип `ACQUAINTANCE_ITEM`) и резолюция (тип `RESOLUTION_ACTION`):
    *   Номер этапа
    *   Тип действия
    *   Название
    *   Ответственный
    *   Длительность/Дата завершения
    *   Нагрузка
    *   Код
*   блокирующий процесс (тип `BLOCKING_PROCESS`):
    *   Номер этапа
    *   Тип действия
    *   Название
    *   Возврат
    *   Код
*   отправка документа (тип `SEND_DOCUMENT`):
    *   Номер этапа
    *   Тип действия
    *   Название
    *   Адресат
    *   Код
*   регистрация (тип `REGISTRATION_ITEM`):
    *   Номер этапа
    *   Тип действия
    *   Название
    *   Длительность/Дата завершения
    *   Возврат
    *   Код
*   маршрут (тип `ROUTE_ITEM`):
    *   Номер этапа
    *   Тип действия
    *   Название
    *   Код

Далее отображается управляющяя кнопка «Готово» (с идентификатором 
PREFERRED).

1.  Если пользователь на экране редактирования этапа маршрута нажимает на 
    кнопку "Назад", мобильный клиент возвращает экран редактирования маршрута 
    (илл. «Блок маршрута») в том состоянии, которое было до вызова данного 
    экрана.

2.  Для сохранения этапа пользователь нажимает на кнопку "Готово". Сохранение 
    локальное. Действие выполняется, только если заполнены обязательные поля. 
    Ошибки валидации:
    
    *   не заполнено поле "Название":

        `Введите название`

    *   не заполнено поле "Ответственный":

        `Введите ответственного`

    *   не заполнено поле "Длительность/Дата завершения" с выбранным значением 
        "Длительность (ч)" либо "длительность (д)":

        `Введите длительность`

    *   не заполнено поле "Длительность/Дата завершения" с выбранным значением
        "Дата завершения":

        `Введите дату завершения`

    *   в поле "Длительность/Дата завершения" с выбранным значением "Дата 
        завершения" указана уже прошедшая дата:

        `Некорректная дата завершения`

    *   не заполнено поле "Нагрузка", либо заполнено не по формату:

        `Укажите нагрузку`

    *   значение поля "Код" уже присвоено другому этапу:

        `Данный код уже используется`
    
    В случае неуспешного сохранения поле выделяется красным цветом `#c02929` и 
    выдается сообщение об ошибке, пользователь остается на экране создания / 
    редактирования этапа маршрута. В случае же успешного сохранения сообщается 
    "Данные сохранены", открывается экран редактирования маршрута (илл. «Блок 
    маршрута»).
    
    Новый добавленный этап добавляется в список последним. При выборе нескольких 
    пользователей необходимо создавать группу параллельных этапов с дублирующейся 
    информацией.
    
    Отредактированный же этап обновляет соответствующую плашку панели.

**Выбор маршрута.**

Для выбранного действия "Маршрут" открывается экран выбора маршрута
(илл. «Выбор маршрута»). При открытии экрана API должно возвращать
следующую информацию:

*   `routeName` - список маршрутов, доступных авторизованному пользователю;
*   `authorName` - ФИО автора каждого из маршрутов.

![Выбор маршрута](resources/img/documents/route_choose.png)

![Выбор маршрута](resources/img/documents/iOS/route_choose.png)

Внизу экрана отображается управляющая кнопка "Добавить этап" «Готово» (с 
идентификатором PREFERRED). Она имеет фиксированное положение, остальную 
часть экрана занимает панель со списком маршрутов. Прокрутка списка 
скроллом осуществляется внутри панели, если панель вмещаются в экран, то 
кнопка должна быть внизу экрана, а не сразу за контентом.

Каждый элемент списка состоит из: "Фамилия И.О." автора маршрута на первой 
строке, на второй и далее - полное название маршрута.

По нажатию на элемент списка он выделяется.

1.  Если пользователь на экране выбора маршрута нажимает на кнопку "Назад", 
    мобильный клиент возвращает экран создания / редактирования этапа 
    маршрута (илл. «Новый этап маршрута», илл. «Редактирование этапа 
    маршрута») в том состоянии, которое было до вызова данного экрана (в 
    поле "Тип действия" должен отображаться предыдущий выбранный тип).

2.  Для сохранения выбранного маршрута пользователь нажимает на кнопку 
    "Готово". Сохранение локальное. Действие выполняется, только если
    выделен маршрут, иначе необходимо не выполнять действие и выдавать 
    ошибку:
    
    `Выберите маршрут`
    
    В случае успешного сохранения сообщается "Данные сохранены", 
    открывается экран создания / редактирования этапа маршрута (илл. 
    «Новый этап маршрута», илл. «Редактирование этапа маршрута»). Данные в 
    этом экране обновляются согласно введеным изменениям, а именно:
    
    *   в поле "Тип действия" добавляется новый пункт в список - выбранный 
        маршрут
    *   он же сменяет предыдущее значение в поле "Тип действия";
    *   набор полей экрана переопределяется согласно выбранного типа.

> **Примечание**
> 
> Метод получения списка маршрутов, доступных пользователю по умолчанию описан 
> в javadoc:
> 
> kz.arta.synergy.server.api.rest.docflow.doc#getRoutes.

