Список файлов {#sec.files_list}
-------------------------------

Экран со списком файлов представлен на илл. «Список файлов».

![Список файлов](resources/img/files/main.png)

**Элементы управления экрана со списком файлов.**

+--------------------------------------------------------------+------------------------+--------------------------------------------------------+
| Элемент управления                                           | Расположение на экране | Описание                                               |
+==============================================================+========================+========================================================+
| *Верхняя панель*                                             |                        |                                                        |
+--------------------------------------------------------------+------------------------+--------------------------------------------------------+
| ![](resources/img/workflow/elements/button_filters.png)\     | Слева                  | "Навигатор" - кнопка перехода к                        |
|                                                              |                        | [навигатору хранилища](#sec.files_navigator)           |
+--------------------------------------------------------------+------------------------+--------------------------------------------------------+
| "Файлы"                                                      | По центру              | Выпадающий список для переключения между модулями      |
+--------------------------------------------------------------+------------------------+--------------------------------------------------------+
| ![](resources/img/workflow/elements/button_work_create.png)\ | Справа                 | "Создать" - кнопка [добавления файла](#sec.files_add), |
|                                                              |                        | [создания новой папки](#sec.files_create) и            |
|                                                              |                        | и [создания документа](#sec.workflow_document_create)  |
+--------------------------------------------------------------+------------------------+--------------------------------------------------------+
| ![](resources/img/files/elements/search.png)\                | Левее кнопки "Создать" | "Поиск" - кнопка для перехода к                        |
|                                                              |                        | [поиску по файлам](#sec.files_search)                  |
+--------------------------------------------------------------+------------------------+--------------------------------------------------------+
| *Компонент "Путь"*                                           | Ниже верхней панели    | Компонент, отображающий путь до текущей открытой папки |
+--------------------------------------------------------------+------------------------+--------------------------------------------------------+
| *Рабочая область*                                            |                        |                                                        |
+--------------------------------------------------------------+------------------------+--------------------------------------------------------+
|                                                              | Вся рабочая область    | Плашки, отображающие информацию о папке / файле        |
|                                                              | ниже пути              |                                                        |
+--------------------------------------------------------------+------------------------+--------------------------------------------------------+

По нажатию на "Файлы" на верхней панели не отображаются все 
кнопки, под панелью открывается выпадающий список с модулями 
(илл. «Переключение между модулями»):

*   [Работы](#chap_workflow);
*   [Документы](#chap.documents);
*   [Файлы](#chap.files).

![Переключение между модулями](resources/img/files/main_menu.png)

До вызова выпадающего списка стрелка отображается указателем 
вниз, по вызову меняется указателем вверх. По нажатию вне 
области выпадающего списка, а также по указателю и шапке 
списка, он скрывается. По нажатию на текущий модуль список 
обновляется, на другой модуль - открывается соответствующий 
модуль.

Компонент *"Путь"* содержит полный путь до папки хранилища 
(`path`). Содержимое компонента: полные названия папок от 
корневой родительской до текущей открытой, включая её саму. 
При этом путь должен быть не абсолютным согласно хранилища, 
а относительным согласно его расположения в дереве папок.

> Например, из структуры папок Хранилище -> Папка 1 -> Папка 
> 1.1 пользователю согласно его ролям доступна только Папка 
> 1.1. В качестве пути будет отображаться не полный 
> (абсолютный) путь `Хранилище -> Папка 1 -> Папка 1.1`, а 
> относительный `Папка 1.1`.

Каждый элемент пути, кроме последнего, отделен от предыдущего 
/ следующего символом 
![](resources/img/files/elements/icon_breadcrumbs.png). Если 
все элементы не помещаются на ширину экрана, только в данном 
компоненте должен активироваться горизонтальный скролл, при 
этом слева и справа невмещающиеся названия должны затемняться 
градиентом из прозрачного в цвет фона.

Кроме того, каждый элемент пути является кликабельной ссылкой 
на соответствующую папку. Таким образом, навигация по 
хранилищу возможна тремя способами:

*   переход в любую папку хранилища, используя навигатор;
*   переход только в дочерние папки из общего списка папок и 
    файлов;
*   переход в родительские папки, используя компонент "Путь".

> *Пример навигации, используя компонент "Путь":*
> 
> Для того, чтобы вернуться "на уровень выше", необходимо в 
> пути выбрать предпоследний элемент и нажать на него.
> 
> Для того, чтобы вернуться "домой" (т.е. в корневой элемент),
> необходимо в пути выбрать самый первый элемент (при 
> необходимости прокрутив компонент по горизонтали) и нажать 
> на него.

*Папки и файлы в списке* отображаются все сразу. При 
прокрутке пользователем в начале списка вверх (действие 
dropdown) список обновляется.

Список папок и файлов сортируется следующим образом. Сначала 
отображаются папки, затем файлы, между собой элементы должны 
быть отсортированы по названию в порядке возрастания (сначала 
0-9, затем A-Z, затем А-Я).

**Плашка элемента хранилища.**

Плашка папки / файла - это компонент, отображающий информацию 
об элементе хранилища. Плашки могут быть разных размеров.

![Плашка папки](resources/img/files/elements/folder_billet.png)

![Плашка файла](resources/img/files/elements/file_billet.png)

+-----------------------------------------------+-----------------------------+-------------------------------------+-------------+
| Элемент                                       | Расположение                | Описание                            | Поле API    |
+===============================================+=============================+=====================================+=============+
| ![](resources/img/files/elements/folder.png)\ | В левой части всей плашки   | Тип элемента хранилища              | `is_folder` |
+-----------------------------------------------+-----------------------------+-------------------------------------+-------------+
|                                               | Справа от иконки; все       | Полное название папки или файла     | `name`      |
|                                               | строки, кроме последней     |                                     |             |
+-----------------------------------------------+-----------------------------+-------------------------------------+-------------+
| Абдрешен Л.С.                                 | Справа от иконки; последняя | ФИО пользователя, выполнившего      | `userName`  |
|                                               | строка плашки, слева        | последнее изменение папки или файла |             |
+-----------------------------------------------+-----------------------------+-------------------------------------+-------------+
| 01.01.16 09:00:00                             | Справа от иконки; последняя | Дата и время последнего изменения   | `modified`  |
|                                               | строка плашки, справа       | папки или файла                     |             |
+-----------------------------------------------+-----------------------------+-------------------------------------+-------------+

*Тип элемента хранилища* отображается в виде пиктограммы папки 
(`is_folder` = true) или файла (`is_folder` = false). Пример 
иконки папки приведен в таблице выше. Иконки файлов зависят от 
расширения, они аналогичны таковым в панели вложений 
[работы](#sec.workflow_attachments).

*Пользователь*, выполнивший последнее изменение элемента 
хранилища. Отображается в формате %Фамилия И.О.%

*Дата и время* последнего изменения элемента хранилища. 
Отображается в формате %ДД.ММ.ГГ ЧЧ:ММ:СС%.

**Возможные действия на экране.**

По нажатию на кнопку "Навигатор", а также проведя пальцем от 
левой стороны экрана к правой, раскрывается левая панель 
[навигатора по хранилищу](#sec.files_navigator)).

По нажатию на кнопку "+" вызывается меню «Создать» (аналогичное 
в модуле «Работы»), в построении которого участвуют пункты 
параметра `files_items`:

*   `favorite_documents`;
*   `all_documents`;
*   `upload_document`;
*   `new_folder`.

![Меню создания в модуле "Файлы"](resources/img/files/main_create.png)

Действия `favorite_documents` и `all_documents` соответствуют 
пунктам [создания документов](#sec.document_creation).

Действие `upload_document` соответствует групповому пункту 
[добавления файла в хранилище](#sec.files_add), который по 
умолчанию всегда раскрыт, а также двум подпунктам «С 
устройства» и «Сфотографировать».

Действие `new_folder` соответствует пункту 
[создания новой папки](#sec.files_create).

Кнопка "+" может отсутствовать вовсе, см. подробнее в разделе 
[Действия в хранилище](#sec.files_actions). В таком случае 
кнопка "Поиск" должна переместиться на место кнопки "Создать". 
В целом же логика меню «Создать» и экрана «Избранное» не 
отличается от таковой в [работах](#sec.workflow_create_menu).

По нажатию на кнопку поиска открывается отдельный экран 
[«Поиск»](#sec.files_search).

По нажатию на элемент пути обновляется список: в нем должно 
отображаться содержимое соответствующей папки.

По нажатию на кнопку "Назад":

*   для переключателя "Запомнить меня" со значением "Выкл" - 
    открывается [экран авторизации](#sec.autorise);
*   для переключателя "Запомнить меня" со значением "Вкл" - 
    происходит [закрытие приложения](#sec.app_exit).

*Возможные действия с плашкой папки:*

1.  При выделении папки (tap) обновляется список: в нем должно 
    отображаться содержимое выделенной папки.

2.  В результате долгого нажатия по плашке возможно появление 
    меню для осуществления дополнительных действий с папкой. 
    Набор пунктов меню зависит от прав пользователя на папку. 
    Если нет прав для совершения ни одного действия - меню не 
    отображается. Возможные пункты меню:

    1.  [Переименовать](#sec.files_rename);
    2.  [Переместить](#sec.files_move);
    3.  [Удалить](#sec.files_delete).

*Возможные действия с плашкой файла:*

1.  При выделении файла (tap) он скачивается на устройство и 
    открывается системными средствами.

2.  В результате долгого нажатия по плашке возможно появление 
    меню для осуществления дополнительных действий с папкой. 
    Набор пунктов меню зависит от прав пользователя на папку, 
    в которой лежит данный файл. Если нет прав для совершения 
    ни одного действия - меню не отображается. Возможные 
    пункты меню:

    1.  [Переименовать](#sec.files_rename);
    2.  [Переместить](#sec.files_move);
    3.  [Скачать](#sec.files_download);
    4.  [Скачать как PDF](#sec.files_download);
    5.  [Удалить](#sec.files_delete).

> **Примечание**
> 
> Метод получения содержимого папок хранилища описан в javadoc:
> 
> kz.arta.synergy.server.api.rest.stotage#listFiles.
> 
> http://tdd.lan.arta.kz/docs/synergy/trunk/sdk-doc/javadoc/kz/arta/synergy/server/api/rest/storage/StorageService.html#listFiles%28java.lang.String,%20boolean,%20java.lang.String%29
