### Перемещение элемента хранилища {#sec.files_move}

Функция перемещения доступна как для папок, так и для файлов, 
только в контекстном меню соответствующего элемента «Действия», 
пункт «Переместить».

Для перемещения элемента необходимо наличие права 
«Переименование / Перемещение элемента» (`MOVE`) на папку, 
в которой он расположен, а также «Добавление нового элемента» 
(`ADD`) на папку месторасположения. 

Пользователь нажимает на этот пункт меню и приложение выдает 
экран "Переместить".

![Перемещение элемента хранилища](resources/img/files/move.png)

![Перемещение элемента хранилища](resources/img/files/iOS/move_ios.png)

Панель со списком по центру и кнопка "Выбрать" внизу экрана 
имеют фиксированное положение, прокрутка списка скроллом 
осуществляется внутри панели. Внутри панели отображается 
все доступное данному пользователю хранилище системы. Каждая 
запись содержит полное название папки.

Панель со списком папок имеет следующие особенности:

*   С понижением уровня папки смещаются вправо (при этом 
    уровни вложенности, начиная с 8-й, должны иметь отступ 
    как для 7-го уровня).

*   Если папка содержит вложенные папки, то в правой части 
    отображается иконка 
    ![](resources/img/workflow/elements/favorite_undetailed.png) 
    для свернутой папки и 
    ![](resources/img/workflow/elements/favorite_detailed.png) 
    для развернутой. По нажатию на квадратную область 
    (кликабельная область аналогична навигатору в файлах) 
    вокруг иконки свернутой папки он разворачивается, и 
    наоборот. Одновременно может быть раскрыто несколько 
    деревьев папок. Развернутая папка должна содержать либо 
    вложенные папки (по умолчанию, каждый раз они свернуты), 
    либо содержащиеся в ней файлы.

    > **Примечание**
    > 
    > По умолчанию, каждая папка всегда отображается с 
    > иконкой «Развернуть», даже если вложенные папки у 
    > неё отсутствуют (особенность поведения в платформе). 
    > Таким образом, только после разворачивания папки без 
    > вложенных папок иконка «Свернуть» / «Развернуть» 
    > исчезнет, и это не является ошибкой мобильного 
    > приложения.

*   В любой строке (за исключением области иконок свернуть / 
    развернуть) папки присутствует выделение (действие tap).

После выделения папки пользователь нажимает на кнопку 
«Выбрать». Действие выполняется, только если выделена 
какая-либо папка, иначе необходимо выдавать сообщение:

`Папка не выбрана`

и не выполнять действие.

В случае успешного перемещения содержимое исходной папки 
обновляется - перемещенный элемент в списке более не 
отображается, иначе - выходит сообщение об ошибке:

*   Если на папку месторасположения отсутствует право 
    добавления нового элемента:

    `Недостаточно прав для выполнения действия`
    
    действие не осуществляется, экран перемещения остается 
    открытым;
    
*   Если название перемещаемого элемента (папки или файла) 
    совпадает с уже существующим в папке месторасположения 
    элементом:
    
    `Объект уже существует`
    
    действие не осуществляется, экран перемещения 
    закрывается.
    
> **Примечание**
> 
> Метод для перемещения элемента хранилища описан в 
> javadoc:
> 
> kz.arta.synergy.server.api.rest.storage#move.
> 
> http://tdd.lan.arta.kz/docs/synergy/trunk/sdk-doc/javadoc/kz/arta/synergy/server/api/rest/storage/StorageService.html#move%28java.lang.String,%20java.lang.String,%20java.lang.String%29

