Поиск файлов {#sec.files_search}
-------------------------------

По нажатию в модуле «Файлы» на кнопку "Поиск" открывается экран 
«Поиск» (илл. «Поиск файлов в хранилище»).

![Поиск файлов в хранилище](resources/img/files/search.png)

![Поиск файлов в хранилище](resources/img/files/iOS/search_ios.png)

Поле с поиском и кнопка "Параметры поиска" 
![](resources/img/files/elements/search_parameters.png) 
вверху и панель со списком по центру экрана имеют фиксированное 
положение, прокрутка списка скроллом осуществляется внутри 
панели. Внутри панели отображаются результаты поиска в виде 
плашек файла. Плашка должна быть аналогичной таковой в списке, 
за следующим исключением: на месте пользователя, выполнившего 
последнее изменение файла должна отображаться дата и время 
последнего изменения файла.

*Особенности поиска:*

*   поиск осуществляется в папке, которая была открыта в момент 
    перехода к данному экрану;

*   при открытии данного экрана должен автоматически происходить 
    пустой запрос поиска;

*   поиск не является "живым", т.е. он должен производиться 
    только после нажатия кнопки "Ввод" на клавиатуре либо иконки 
    лупы в поле поиска;

*   каждый новый поисковый запрос сбрасывает настроенные 
    параметры поиска до значений по умолчанию;

*   если количество результатов в категории "Все результаты" = 
    0, то кнопка "Параметры поиска" должна быть недоступна для 
    нажатия.

Пользователь нажимает по полю поиска и вводит текст запроса, 
при вводе текста иконка лупы ничем не заменяется. Пустой запрос 
поиска - отображается список со всеми файлами папки.

По нажатию на плашку файла должно происходить действие 
[скачивания файла](#sec.files_download), если есть соответствующее 
право на этот файл. Кроме того, у каждой плашки должно быть 
контектсное меню "Действия" с единственным пунктом «Перейти к 
папке». По нажатию на данный пункт меню необходимо закрывать экран 
поиска, в общем списке папок и файлов открывать папку, которая 
содержит этот файл.

Файлы - результаты поиска - отображаются с постепенной догрузкой. 
Изначально подгружается такое количество файлов, чтобы список 
был полностью заполнен и появился скролл (минимум 30). При 
прокрутке пользователем вниз список дополняется (количество 
файлов в новой "порции" должно быть равно количеству файлов в 
первой "порции").

Результаты, фильтрация и их сортировка должны подчиняться 
выставленным параметрам поиска, а если параметры поиска не 
задавались - их значениям по умолчанию.

По нажатию на кнопку *"Параметры поиска"* открывается экран 
"Параметры" (илл. «Параметры поиска»).

![Параметры поиска](resources/img/files/advanced_search.png)

![Параметры поиска](resources/img/files/iOS/advanced_search_ios.png)

Управляющая кнопка имеет фиксированное положение. Вся остальная 
область экрана прокручиваема. Содержимое экрана:

+--------------+---------------------+---------------+--------------------------------------------------------+
| Параметр     | Возможные значения  | API           | Описание                                               |
+==============+=====================+===============+========================================================+
| По категории | *  Все результаты   | aiType        | Документы - тип `AI_DOCUMENT`, картинки - `AI_IMAGE`,  |
|              | *  Документы        |               | видео - `AI_VIDEO`, аудио - `AI_AUDIO`, другие -       |
|              | *  Картинки         |               | `AI_APPLICATION`. "Все результаты" (значение по        |
|              | *  Видео            |               | умолчанию) содержит в себе файлы всех типов.           |
|              | *  Аудио            |               | Категории, по которым результаты поиска отсутствуют,   |
|              | *  Другие           |               | не должны отображаться в данном списке                 |
+--------------+---------------------+---------------+--------------------------------------------------------+
| По дате (с   | *  За все время     | modifiedFrom, | За день: ДД.ММ.ГГГГ - ДД.ММ.ГГГГ, за неделю:           |
| устройства)  | *  За день          | modifiedTo    | ДД.ММ.ГГГГ - (ДД-6).ММ.ГГГГ, за месяц: ДД.ММ.ГГГГ -    |
|              | *  За неделю        |               | ДД.(ММ-1).ГГГГ, ДД.ММ.ГГГГ - ДД.ММ.(ГГГГ-1). "За все   |
|              | *  За месяц         |               | время" (значение по умолчанию) содержит в себе файлы   |
|              | *  За год           |               | за любую дату и время изменения                        |
+--------------+---------------------+---------------+--------------------------------------------------------+
| Сортировка   | *  По релевантности | sortType      | По релевантности (значение по умолчанию) -             |
|              | *  По полулярности  |               | `SORT_RELEVANCE`, по популярности - `SORT_READSCOUNT`, |
|              | *  По дате          |               | по дате - `SORT_DATE`                                  |
+--------------+---------------------+---------------+--------------------------------------------------------+

По нажатию на кнопку "Выбрать" результаты поиска должны 
обновиться согласно измененных параметров. Если 
пользователь на экране «Параметры» нажимает на кнопку 
"Назад", мобильный клиент возвращает экран поиска в том 
состоянии, которое было до вызова данного экрана.

Измененные параметры поиска должны сохраняться только для 
текущей сессии поиска, т.е. после очередного нажатия на 
иконку лупы все параметры должны принять значения по 
умолчанию.

> **Примечание**
> 
> Метод для выполнения поиска в хранилище и возврата списка 
> найденных файлов описан в javadoc:
> 
> kz.arta.synergy.server.api.rest.storage#search.
> 
> http://tdd.lan.arta.kz/docs/synergy/trunk/sdk-doc/javadoc/kz/arta/synergy/server/api/rest/storage/StorageService.html#search%28java.lang.String,%20java.lang.String,%20java.util.List,%20java.lang.String,%20java.lang.String,%20java.lang.String,%20java.lang.String,%20int,%20int,%20boolean,%20boolean,%20boolean,%20int,%20int,%20java.lang.String%29

