Проигрыватель формы {#forms_view}
----------------------------------

Экран "Форма" открывается для отображения и/или редактирования
файлов по форме.

**Элементы управления экрана "Форма".**

+-------------------------------------------------------+------------------------+------------------------------------------+
| Элемент управления                                    | Расположение на экране | Описание                                 |
+=======================================================+========================+==========================================+
| *Верхняя панель*                                      |                        |                                          |
+-------------------------------------------------------+------------------------+------------------------------------------+
| ![](resources/img/forms/elements/button_options.png)\ | Справа                 | Кнопка открытия дополнительного меню     |
+-------------------------------------------------------+------------------------+------------------------------------------+
| ![](resources/img/forms/elements/button_save.png)\    | Левее кнопки меню      | Кнопка "Сохранить" (может отсутствовать) |
+-------------------------------------------------------+------------------------+------------------------------------------+
| *Вся рабочая область*                                 |                        | Проигрыватель формы в мобильном или      |
|                                                       |                        | основном представлении                   |
+-------------------------------------------------------+------------------------+------------------------------------------+
| Перейти к документу                                   | Внизу                  | Кнопка выхода из проигрывателя форм      |
|                                                       |                        | (может отсутствовать)                    |
+-------------------------------------------------------+------------------------+------------------------------------------+

Проигрыватель форм занимает всю область от верхней панели
до конца экрана. Слева и справа отступы отсутствуют.
Горизонтальный и вертикальный скроллы, при наличии,
находятся в данной области.

Кнопка "Перейти к документу" внизу экрана является "плавающей".
При первом открытии экрана она всегда отображается. Далее
только при прокрутке пользователем вверх кнопка "уезжает"
вниз за экран. Только при последующей прокрутке вниз
кнопка возвращается на место. Если весь контент меньше
высоты экрана, кнопка имеет фиксированное положение внизу
экрана и не "уезжает" (т.к. отсутствует вертикальный
скролл).

Форма может иметь *2 представления*:

*   мобильное
*   основное

>   **Примечание**
>   
>   Для версий мобильного приложения 3.6 и ниже используется
>   только мобильное представление формы.

Мобильное представление всегда находится в режиме
редактирования. Основное, в свою очередь может находиться
в одном из *двух режимов*:

*   режим просмотра
*   режим редактирования

При этом режим редактирования может отсутствовать, в
зависимости от текущих свойств документа, в котором
находится данный файл по форме. Параметр в API для этого
должен быть `is_editable = false`.

> **Примечание.**
>
> Методы API, передающие данный параметр:
>
> *   `rest/api/workflow/work/{workID}/attachments` -
>     получение списка всех файлов работы;
> *   `rest/api/workflow/work/{workID}/last_attachments` -
>     получение отсортированного в обратном порядке (по
>     дате добавления) списка файлов работы;
> *   `rest/api/docflow/doc/attachments` - получение
>     списка всех файлов документа;
> *   `rest/api/doc/last_attachments` - получение
>     отсортированного в обратном порядке (по дате
>     добавления) списка файлов документа.

Кнопка "Сохранить" отображается только в режиме
редактирования (как в мобильном, так и в основном
представлении).

*Рассмотрим варианты отображения контента в проигрывателе
формы, в зависимости от представления и режима формы.*

Различается набор пунктов дополнительного меню:

+------------------------+----------------------------+------------------------+----------------------------+------------------------+
| Текущее представление: | Текущее представление:     | Текущее представление: | Текущее представление:     | Текущее представление: |
| основное (просмотр),   | основное (редактирование), | основное (просмотр),   | основное (редактирование), | мобильное, основное    |
| мобильное доступно     | мобильное доступно         | мобильное недоступно   | мобильное недоступно       | доступно всегда        |
+========================+============================+========================+============================+========================+
| Мобильная версия       | Мобильная версия           | Режим редактирования   | Режим просмотра            | Полная версия          |
+------------------------+----------------------------+------------------------+----------------------------+------------------------+
| Режим редактирования   | Режим просмотра            | Скачать PDF            | Информация                 | Информация             |
+------------------------+----------------------------+------------------------+----------------------------+------------------------+
| Скачать PDF            | Информация                 | Скачать ODT            |                            |                        |
+------------------------+----------------------------+------------------------+----------------------------+------------------------+
| Скачать ODT            |                            | Скачать DOCX           |                            |                        |
+------------------------+----------------------------+------------------------+----------------------------+------------------------+
| Скачать DOCX           |                            | Скачать DOC            |                            |                        |
+------------------------+----------------------------+------------------------+----------------------------+------------------------+
| Скачать DOC            |                            | Информация             |                            |                        |
+------------------------+----------------------------+------------------------+----------------------------+------------------------+
| Информация             |                            |                        |                            |                        |
+------------------------+----------------------------+------------------------+----------------------------+------------------------+

При первом открытии экрана открывается, при наличии,
мобильное представление формы.

![Мобильное представление формы](resources/img/forms/form_mobile.png)

![Мобильное представление формы](resources/img/forms/iOS/form_mobile_ios.png)

При отсутствии мобильного представления и если
создается новый документ по форме открывается основное
представление в режиме редактирования, а если
открывается уже существующий файл по форме - основное
представление в режиме просмотра.

Переключение между представлениями доступно с помощью
пунктов меню "Мобильная версия" / "Полная версия".
При переключении представления с мобильного в основное,
оно открывается в режиме просмотра.

По умолчанию, форма масштабируется по наименьшей стороне.
Изменение масштаба осуществляется с помощью двойного тапа
либо сведением / разведением пальцев.

![Основное представление формы (режим просмотра)](resources/img/forms/form_view.png)

![Основное представление формы (режим просмотра)](resources/img/forms/iOS/form_view_ios.png)

![Основное представление формы (режим просмотра), масштаб](resources/img/forms/form_view_enlarged.png)

![Основное представление формы (режим просмотра), масштаб](resources/img/forms/iOS/form_view_enlarged_ios.png)

Переключение между режимами основного представления
доступно с помощью пунктов меню "Режим просмотра" /
"Режим редактирования".

В режиме редактирования все открываемые диалоговые
окна, вызываемые по нажатию на тот или иной компонент
формы, должны быть [нативными](#forms_components).

![Основное представление формы (режим редактирования)](resources/img/forms/form_edit.png)

![Основное представление формы (режим редактирования)](resources/img/forms/iOS/form_edit_ios.png)

![Основное представление формы (режим редактирования), масштаб](resources/img/forms/form_edit_enlarged.png)

![Основное представление формы (режим редактирования), масштаб](resources/img/forms/iOS/form_edit_enlarged_ios.png)

Только в режиме просмотра основного представления
доступна возможность формирования печатного
представления формы с помощью пунктов меню "Скачать".
Точный набор пунктов (PDF, ODT, DOCX, DOC) зависит
от настроек самого печатного представления.

Последним пунктом меню всегда является "Информация".
По его нажатию открывается одноименное системное
окно, содержащее наименование формы. Единственной
кнопкой в диалоге является "ОК", по нажатию которой
окно закрывается.

**Сохранение и выход из формы.**

По нажатию на иконку "Сохранить" и при переключении
между режимами основного представления происходит
валидация формы:

*   для мобильного представления - на заполненность
    обязательных полей (только среди отображаемых);

*   для основного представления - на заполненность
    обязательных полей и корректность заполнения
    других (определяется настройками компонентов).

В случае неуспешной валидации обязательности
отображается общая ошибка формы:

`Заполните обязательные поля`

В иных случаях неуспешного сохранения выдается
сообщение об ошибке, пользователь остается на данном
экране.

В случае же успешного сохранения выдается сообщение
"Данные сохранены", документ сохраняется, пользователь
остается на данном экране.

Если текущая версия данных уже была сохранена, то
кнопка "Сохранить" должна быть недоступна для нажатия.

По нажатию на кнопку "Перейти к документу" происходит
открывается экран
[информации о документе](#sec.documents_docinfo).
При этом, если текущая форма имеет несохраненные
изменения, выдается системное предупреждающее диалоговое
окно с текстом:

`Документ был изменен. Сохранить произведенные
изменения?`

и кнопками:

*   "Да" - происходит сохранение формы и, при успешном
    сохранении, открытие экрана
    [информации о документе](#sec.documents_docinfo);
*   "Нет" - последние изменения отменяются, открывается
    предыдущий экран;
*   "Отмена" - окно закрывается, пользователь остается
    в проигрывателе формы.

Если после внесения изменений в форме пользователь
нажимает на кнопку "Назад", выдается системное
предупреждающее диалоговое окно с текстом:

`Документ был изменен. Сохранить произведенные
изменения?`

и кнопками:

*   "Да" - происходит сохранение формы и, при успешном
    сохранении, открывается предыдущий экран;
*   "Нет" - последние изменения отменяются, открывается
    предыдущий экран;
*   "Отмена" - окно закрывается, пользователь остается
    в проигрывателе формы.

Если же изменений не было и пользователь нажимает на
кнопку "Назад", сразу возвращается предыдущий экран.

В целом, поведение проигрывателя в основном
представлении, все его альтернативные потоки,
полностью идентичны
[платформе](http://tdd.lan.arta.kz/docs/additional/spec/html/sec.conf_processes.html#sec.conf_redactor_form).
Альтернативные потоки нативных диалоговых окон описаны
отдельно в соответствующем [разделе](#forms_components).
