### Компонент для выбора пользователей {#userchooser}

Компонент для выбора пользователей представляет собой 
кликабельное поле ввода, по нажатию которой открывается 
нативный экран «Пользователи».

При открытии экрана в нем уже являются выделенными 
плашки выбранных ранее значений.

![Экран "Пользователи" с множественным выбором](resources/img/forms/user_chooser.png)

![Экран "Пользователи" с множественным выбором](resources/img/forms/iOS/user_chooser_ios.png)

![Экран "Пользователи" с единственным выбором](resources/img/forms/user_chooser_2.png)

![Экран "Пользователи" с единственным выбором](resources/img/forms/iOS/user_chooser_2_ios.png)

Для построения экрана компонент принимает следующие 
параметры:

*   имеется ли связь с компонентом;
*   единственный или множественный выбор;
*   отображать ли группы;
*   отображать ли пользователей из резерва;
*   отображать подчиненных или всех пользователей;
*   идентификатор действия.

**Элементы управления экрана "Пользователи".**

+----------------------------------------------------------+------------------------+--------------------------------------------+
| Элемент управления                                       | Расположение на экране | Описание                                   |
+==========================================================+========================+============================================+
| *Верхняя панель*                                         |                        |                                            |
+----------------------------------------------------------+------------------------+--------------------------------------------+
| ![](resources/img/workflow/elements/button_filters.png)\ | Справа                 | "Навигатор" - кнопка перехода к            |
|                                                          |                        | навигатору экрана                          |
+----------------------------------------------------------+------------------------+--------------------------------------------+
| *Компонент "Путь"*                                       | Ниже верхней панели    | Компонент, отображающий путь до выделенной |
|                                                          |                        | ноды навигатора, согласно которой          |
|                                                          |                        | отображается текущий список пользователей  |
+----------------------------------------------------------+------------------------+--------------------------------------------+
| *Рабочая область*                                        |                        |                                            |
+----------------------------------------------------------+------------------------+--------------------------------------------+
| Поле поиска                                              | Вверху основной        | Поле ввода с плейсхолдером "Поиск          |
|                                                          | области                | пользователей" и иконкой лупы справа       |
+----------------------------------------------------------+------------------------+--------------------------------------------+
| Панель со списком пользователей                          | Вся основная область   | Плашки, отображающие информацию о          |
|                                                          |                        | пользователях                              |
+----------------------------------------------------------+------------------------+--------------------------------------------+
| Выбрать                                                  | Внизу                  | Кнопка                                     |
+----------------------------------------------------------+------------------------+--------------------------------------------+

Путь, поле поиска и кнопка "Выбрать" имеют фиксированное 
положение. В оставшейся области находится прокручиваемый 
список пользователей.

По нажатию на кнопку *навигатора*, а также проведя 
пальцем от правой стороны экрана к левой, раскрывается 
правая панель навигатора (илл. «Навигатор выбора 
пользователей»).

![Навигатор выбора пользователей](resources/img/forms/user_chooser_navigator.png)

Верхняя панель содержит только надпись "Навигатор". Сам 
навигатор может содержать следующий набор узлов, каждый 
из которых отделен от предыдущего сплитом:

*   `Выбранные`
*   `Часто выбираемые`
*   `Группы` (присутствует только, если необходимо 
    отображать группы)
*   `%Название_организации%` (выделен по умолчанию при 
    открытии экрана)

Первые две ноды не имеют дочерних элементов. "Группы" 
содержат дерево групп всех уровней. 
"%Название_организации%", в свою очередь, - дерево всей 
орг.структуры.

В остальном, навигатор повторяет поведение аналогичных 
навигаторов, например, в [хранилище](#sec.files_navigator):

*   после выделения узла в навигаторе необходимо 
    автоматически отображать соответствующий список;
*   при каждом новом открытии экрана "Пользователи" все 
    узлы должны быть свернуты, кроме первого уровня 
    орг.структуры;
*   в текущем открытом экране развернутость дерева и 
    последний выделенный узел должны сохранять свои 
    значения;
*   иконки свернутости и развернутости, их кликабельная 
    область;
*   отступы дочерних элементов дерева (включая вариант, 
    при котором уровни вложенности, начиная с 8-й, должны 
    иметь отступ как для 7-го уровня);
*   градиент невмещающегося текста;
*   скрытие навигатора свайпом от левой стороны экрана 
    к правой, нажатием по левой стороне экрана либо 
    кнопкой "Назад" (для ОС Android).

Компонент *"Путь"* содержит полный путь до выделенного 
узла навигатора. Содержимое компонента: полные названия 
узлов от корневой родительской (см. примеры) до текущей 
открытой, включая ее саму.

В целом, компонент повторяет поведение пути в модуле 
["Файлы"](#sec.files_list) (наличие горизонтального 
скролла и градиентов, кликабельность элементов пути).

> Примеры.
> 
> Для ноды "Выбранные", "Часто выбираемые" путь, 
> соответственно, отображает:
> 
> * `Выбранные`
> * `Часто выбираемые`
> 
> Для выбранной группы путь отображает:
> 
> * `Группы > ДРТ > Разработчики`
> 
> Для выбранного подразделения орг.структуры путь 
> отображает:
> 
> * `Фонд поддержки молодежи > Административный отдел > 
>   Снабжение`

*Отображаемый список пользователей* зависит от того, 
что выделено в навигаторе:

*   `Выбранные` - все текущие пользователи, напротив 
    которых установлен флажок выбора;
*   `Часто выбираемые` - список часто выбираемых 
    пользователей;
*   `Группы` - список групп и/или пользователей;
*   `%Название_организации%` - список пользователей, 
    принадлежащих выбранному подразделению орг.
    структуры.

Если имеется связь с другим компонентом, то необходимо 
сужать отображаемый список согласно связи (передав в API 
соответствующий параметр).

Отображение групп работает следующим образом. Если 
недоступен множественный выбор, то возможен выбор 
только пользователей из списка групп (но не самих 
групп). Если же множественный выбор доступен, то, 
соответственно, возможен выбор группы в качестве 
выбранного элемента.

Плашки могут отличаться, в зависимости от отображаемой 
информации:

*   Плашка пользователя содержит:

    *   первый блок - ФИО (полное либо с инициалами - 
        зависит от настройки конфигуратора "Отображать 
        полное ФИО пользователя в компоненте выбора 
        пользователя");
    *   второй блок - список должностей пользователя 
        через запятую (для пользователей из резерва - 
        отсутствует);
    *   третий блок - статус календаря (при наличии, цвет 
        определяется настройками статуса).

*   Плашка группы содержит:

    *   первый блок - полное название группы;
    *   второй блок - полное название родительской 
        группы (для групп первого уровня - отсутствует).

*   Плашка контакта из адресной книги содержит:

    *   первый блок - ФИО либо название организации + 
        `<электронная почта>`;
    *   второй блок содержит лейбл `Контакт из адресной 
        книги` (цвет `#ff4800`).

*   Плашка произвольного текста содержит:

    *   первый блок - произвольный текст;
    *   второй блок содержит лейбл `Введен вручную` (цвет 
        `#ff4800`).

Во всех вариантах невмещающиеся по ширине ФИО и названия 
должностей / групп / статусов переносятся на новую 
строку. В правой части каждого элемента списка может 
находиться флажок, показывающий, выбран данный 
пользователь или нет (только для компонента с 
множественным выбором). 

Список отображается с постепенной догрузкой. Изначально 
подгружается 30 пользователей. При прокрутке 
пользователем вниз список дополняется новыми 30 
пользователями.

Список пользователей сортируется по возрастанию ФИО. 
Список групп и пользователей, в свою очередь, так: 
сначала группы, затем пользователи, между собой по 
возрастанию названия / ФИО.

*Поведение экрана:*

*   Для компонента с единственным выбором:

    *   Для выбора пользователя необходимо нажать 
        на строку, вся строка выделится фоном.

    *   Повторное нажатие на строку не снимает 
        выделение.

    *   При выделении пользователя в списке, 
        выделение предыдущего элемента снимается.

*   Для компонента с множественным выбором:

    *   Для выбора пользователя необходимо нажать на 
        строку или флажок, находящийся справа 
        соответствующего элемента списка.
    
    *   Удалить пользователя из списка выбранных 
        можно, выключив флажок, пользователь 
        удаляется из списка выбранных без 
        подтверждения.
    
    *   В контекстное меню любой плашки (во всех 
        узлах навигатора, кроме "Выбранные") 
        добавляется пункт "Выбрать всех". По его 
        нажатию происходит выделение всех еще 
        невыделенных пользователей отображаемого 
        списка.
        
        Если все пользователи отображаемого списка 
        выделены, пункт меню заменяется на "Снять 
        выделение". По его нажатию происходит 
        развыделение всех пользователей списка 
        (пункт меню снова принимает вид "Выбрать 
        всех").

*Поиск пользователей* осуществляется только внутри 
отображаемого списка и только в узлах навигатора 
"%Название_организации%" и "Группы" (а также их подузлах, 
в остальных узлах поле отсутствует вовсе). Поиск является 
"живым" и производится по названию (для групп) либо ФИО 
(для пользователей), его результаты фильтруют отображаемый 
список. При вводе текста иконка лупы заменяется на иконку 
крестика. Очистить поле ввода можно, нажав на крестик 
(крестик заменяется на иконку лупы). Пустой запрос поиска - 
отображается список со всеми пользователями данного узла 
навигатора.

Если пользователь на экране "Пользователи" нажимает 
на *кнопку "Назад"*, мобильный клиент возвращает 
пользователя к экрану, из которого он был вызван.

Если пользователь нажимает на *кнопку "Выбрать"*, 
мобильный клиент возвращает пользователя к предыдущему 
экрану, в поле компонента отображаются выбранные 
пользователи:

*   в нативных диалогах приложения - через запятую, 
    имя каждого пользователя в формате 
    `%Фамилия И.О.%`;
*   иначе - согласно проигрывателю формы.

> **Примечание**
> 
> Метод получения списка пользователей описан в javadoc:
> 
> kz.arta.synergy.server.api.rest.userchooser#getUsersExt
> 
> Метод получения списка должностей описан в javadoc:
> 
> kz.arta.synergy.server.api.rest.userchooser#getPositions
> 
> Метод получения списка подразделений описан в javadoc:
> 
> kz.arta.synergy.server.api.rest.userchooser#getDepartments
> 
> Метод получения списка часто выбираемых пользователей 
> описан в javadoc:
> 
> kz.arta.synergy.server.api.rest.userchooser#getOftenChosenUsers
> 
> Метод получения списка групп описан в javadoc:
> 
> kz.arta.synergy.server.api.rest.groups#getGroups

