Список реестров {#sec.registries_list}
-------------------------------

Экран со списком реестров представлен на илл. «Список реестров».

![Список реестров](resources/img/registries/registries_group.png)

![Окно "Реестры" (вид по умолчанию)](resources/img/registries/registry_records.png)

**Элементы управления экрана со списком записей реестра.**

+--------------------------------------------------------------+------------------------+---------------------------------------------------------+
| Элемент управления                                           | Расположение на экране | Описание                                                |
+==============================================================+========================+=========================================================+
| *Верхняя панель*                                             |                        |                                                         |
+--------------------------------------------------------------+------------------------+---------------------------------------------------------+
| ![](resources/img/workflow/elements/button_filters.png)/     | Слева                  | "Навигатор" - кнопка перехода к                         |
|                                                              |                        | [навигатору реестров](#sec.registries_navigator)        |
+--------------------------------------------------------------+------------------------+---------------------------------------------------------+
| "Реестры"                                                    | По центру              | Выпадающий список для переключения между модулями       |
+--------------------------------------------------------------+------------------------+---------------------------------------------------------+
| ![](resources/img/forms/elements/button_options.png)/        | Справа                 | Системное меню - выпадающий список с пунктами:          |
|                                                              |                        |                                                         |
|                                                              |                        | - "Полный", если отображаются краткие плашки записей    |
|                                                              |                        | реестра, или "Краткий", если отображаются полные плашки;|
|                                                              |                        |                                                         |
|                                                              |                        | - [Сортировка](#sec.registries_sort);                   |
|                                                              |                        |                                                         |
|                                                              |                        | - [Поиск](#sec.registries_search)                       |
|                                                              |                        |                                                         |
|                                                              |                        | Элемент не отображается, если выбрана группа реестров   |
+--------------------------------------------------------------+------------------------+---------------------------------------------------------+
| ![](resources/img/workflow/elements/button_work_create.png)/ | Левее кнопки "Меню"    | "Создать" - кнопка                                      |
|                                                              |                        | [добавления новой записи реестра](#sec.registries_add)  |
|                                                              |                        | и [создания документа](#sec.workflow_document_create)   |
|                                                              |                        |                                                         |
|                                                              |                        | Элемент не отображается, если выбрана группа реестров   |
+--------------------------------------------------------------+------------------------+---------------------------------------------------------+
| *Компонент "Путь"*                                           | Ниже верхней панели    | Компонент, отображающий путь до выбранного реестра      |
+--------------------------------------------------------------+------------------------+---------------------------------------------------------+
| *Рабочая область*                                            |                        |                                                         |
+--------------------------------------------------------------+------------------------+---------------------------------------------------------+
|                                                              | Вся рабочая область    | Плашки, отображающие информацию о записях выбранного    |
|                                                              | ниже пути              | реестра или реестрах, входящих в выбранную группу       |
+--------------------------------------------------------------+------------------------+---------------------------------------------------------+

> **Примечание**
>
> Метод получения доступных реестров и прав пользователя на них:
> rest/api/registry/list
>
> Метод получения записей реестра:
> rest/api/registry/getRegistryData

По нажатию на "Реестры" на верхней панели не отображаются все
кнопки, под панелью открывается выпадающий список с модулями
(илл. «Переключение между модулями»):

*   [Работы](#chap_workflow);
*   [Файлы](#chap.files);
*   [Документы](#chap.documents);
*   [Реестры](#chap.registries).

![Переключение между модулями](resources/img/registries/registries_module.png)

До вызова выпадающего списка стрелка отображается указателем
вниз, по вызову меняется указателем вверх. По нажатию вне
области выпадающего списка, а также по указателю и шапке
списка, он скрывается. По нажатию на текущий модуль происходит
переход к списку реестров, на другой модуль - открывается
соответствующий модуль.

По свайпу вниз по основному экрану обновляется список в рабочей
области, по свайпу вниз по навигатору обновляется список доступных
реестров.

Компонент *"Путь"* содержит полный путь до выбранного элемента
навигатора. Содержимое компонента:

*   для выбранной группы реестра - полные названия групп
    реестров от корневой родительской до текущей открытой,
    включая её саму;
*   для выбранного реестра - полные названия групп реестров,
    крайний элемент в списке - непосредственно реестр.

Каждый элемент пути, кроме крайнего, отделен от предыдущего
/ следующего символом
![](resources/img/files/elements/icon_breadcrumbs.png). Если
все элементы не помещаются на ширину экрана, только в данном
компоненте должен активироваться горизонтальный скролл, при
этом слева и справа невмещающиеся названия должны затемняться
градиентом из прозрачного в цвет фона.

Кроме того, каждый элемент пути является кликабельной ссылкой
на соответствующую группу реестров. Таким образом, навигация по
модулю реестров возможна тремя способами:

*   переход в любую группу реестров / реестр, используя
    навигатор;
*   переход только в дочерние группы реестров / реестры из
    общего списка групп реестров / реестров;
*   переход в родительские группы реестров, используя компонент
    "Путь".

*Список в основной области* содержит:

*   для выбранной группы реестра - дочерние группы реестров и
    реестры;
*   для выбранного реестра - непосредственно записи реестра.

В первом случае группы реестров и реестры в списке отображаются
все сразу. При прокрутке пользователем в начале списка вверх
(действие dropdown) список обновляется.

Список записей же отображается с постепенной догрузкой.
Изначально подгружается 30 записей. При прокрутке пользователем
вниз список дополняется новыми 30 записями.

**Плашка реестра, записи реестра.**

Плашка записи реестра/ группы реестров - это компонент,
отображающий информацию об элементе реестра или название группы.

При выборе *группы реестров* отображаемый список содержит
сведения о реестрах и группах реестрах, входящих в выбранную
группу:

*   для группы реестра отображается иконка группы
![](resources/img/registries/registries_group_icon.png) и
название группы (параметр `regGroupName`);

*   для реестра отображается иконка реестра
![](resources/img/registries/registries_icon.png) и
название реестра (параметр `registryName`).

При выборе *реестра* отображаемый список содержит записи этого
реестра. Каждая запись содержит пиктограмму текущего статуса
записи реестра и ее данные.

*Пиктограммы статусов записи реестра:*

+--------------------------------------------------------------+------------------------+
| Пиктограмма                                                  | Статус                 |
+==============================================================+========================+
| пиктограмма отсутствует                                      | Подготовка             |
+--------------------------------------------------------------+------------------------+
| ![](resources/img/registries/registry_progress.png)/         | В процессе             |
+--------------------------------------------------------------+------------------------+
| ![](resources/img/registries/registry_activated.png)/        | Активная               |
+--------------------------------------------------------------+------------------------+
| ![](resources/img/registries/registry_denied.png)/           | Неуспешная             |
+--------------------------------------------------------------+------------------------+

Данные записи реестра отображаются в следующем формате:

`%Название_столбца%: %значение%`

Количество данных в плашке зависит от того, какой
используется вид просмотра:

*   Краткий (по умолчанию): плашка отображает только
    те отображаемые столбцы, которые помечены как
    значащее содержимое. При отображении краткого
    списка пункт меню ![](resources/img/forms/elements/button_options.png)
    принимает значение "Полный" для переключения в полный вид.

*   Полный: плашка отображает все отображаемые столбцы.
    При отображении краткого списка пункт меню
    ![](resources/img/forms/elements/button_options.png)
    принимает значение "Краткий" для переключения в краткий вид.

> **Примечание**
>
> Если в реестре отсутствуют столбцы, помеченные как значащее
> содержимое, плашка всегда отображается в полном виде. При этом
> пункт "Краткий" не отображается в меню
> ![](resources/img/forms/elements/button_options.png).

Во всех случаях невмещающиеся по ширине названия и
значения переносятся на новую строку. При этом один
столбец должен занимать не более двух строк, иначе
текст обрезается с добавлением многоточие. Некоторые
значения столбцов могут отсутствовать, это не будет
являться ошибкой платформы или мобильного клиента.

![Окно "Реестры" (полные плашки)](resources/img/registries/registry_records_longlist.png)

При открытии экрана записи в списке сортируются
согласно преднастройкам реестра. Изменять данную
сортировку можно, выбрав соответствующий пункт меню.

**Возможные действия на экране.**

По нажатию на кнопку "Навигатор", а также проведя пальцем от
левой стороны экрана к правой, раскрывается левая панель
[навигатора по реестру](#sec.registries_navigator).

По нажатию на кнопку "+" вызывается меню «Создать» (аналогичное
в модуле «Работы»), в построении которого участвуют пункты
параметра `register_items`:

*   `favorite_documents`;
*   `all_documents`;
*   `new_record`.

Функциональность пунктов `favorite_documents` и `all_documents`
аналогична описанной в разделе
["Создание работы / документов"](#sec.workflow_create_menu).

Если название пункта меню полностью не помещается на двух
строках, с правого края второй строки оно должно быть
затемнено градиентом из прозрачного в цвет фона. В меню
отсутствуют фиксированные элементы, при развороте группы
создания документа, оно должно пропорционально увеличиться
по вертикали. При этом если количество отображаемых пунктов
меню больше высоты экрана, появляется вертикальный скролл
на все меню, исключая «шапку» (т.е. скролл должен уходить
под «шапку»).

> **Примечание:**
>
> Метод получения настроек пунктов создания записей реестров
> описан в javadoc:
>
> kz.arta.synergy.server.api.rest.common.RegistryService#getRegisterItems

Каждая из групп пунктов должна быть отделена от следующей
видимым сплитом.

Если список создания записи / документов пуст, то кнопку «+»
отрисовывать не нужно. Если же меню содержит только один пункт,
то по нажатию кнопки «+», исключая его, должно выполняться
соответствующее действие и вызываться соответствующий экран.
При формировании списка элементов в меню "Создать" необходимо
учитывать, что если у авторизованного пользователя нет права на
создание записи в текущем реестре, то пункт `new_record` не должен
отображаться.

По нажатию на кнопку "Назад" происходит [закрытие приложения](#sec.app_exit).

> **Примечение:**

> Метод получения сведений о настроенных событиях реестра
описан в javadoc:

> kz.arta.synergy.server.api.rest.common.RegistryService#getRoute

*Возможные действия с плашкой группы реестров:*

1.  При выделении папки (tap) обновляется список: в нем должны
    отображаться реестры, входящие в данную группу.

>> **Примечание:**

>> Если в группу были добавлены новые реестры, то при обновлении списка
плашки этих реестров также должны быть отображены. Если же из группы
были удалены реестры, то при обновлении списка плашки этих реестров
должны быть удалены.

2.  Обработка долгого нажатия отсутствует.

*Возможные действия с плашкой реестра:*

1.  При выделении реестра (tap) открывается список записей реестра.

2.  Обработка долгого нажатия отсутствует.

*Возможные действия с плашкой записи реестра*

1. При выделении записи реестра (tap) открывается
[проигрыватель форм](#forms_view) (при условии наличия у
авторизованного пользователя права "Просмотр данных" для
текущего реестра).

2. В результате долгого нажатия по плашке возможно появление
меню для осуществления дополнительных действий с записью. Набор
пунктов меню зависит от прав пользователя на текущий реестр.
Если нет прав для совершения ни одного действия - меню не
отображается. Возможные пункты меню:

    -  [Удалить](#sec.registries_delete)

<#include "registries/registries_add.md">
<#include "registries/registries_modify.md">
<#include "registries/registries_delete.md">
<#include "registries/registries_search.md">
