### Вложения работы {#sec.workflow_attachments}

Далее, при наличии вложений к работе, располагается панель вложений.

Панель вложений отображает максимум 3 (три) последних вложения (не важно, 
из "Приложений" или "Прочих") к работе, каждое из которых представляет 
собой плашку.

Элементы плашки вложения:

+-------------------------------------------+--------------+
| Элемент                                   | Поле API     |
+===========================================+==============+
| иконка изображения для предпросмотра, в   | icon (32x32) |
| случае его отсутствия - иконка типа файла |              |
+-------------------------------------------+--------------+
| название файла                            | `name`       |
+-------------------------------------------+--------------+

> **Примечание**
>
> Ссылка на иконку передается относительная. Доступ по этому URL-у без 
> авторизации запрещен, поэтому полная ссылка должна выглядеть так:
>
> `http(s)://user_login:user_pass@host:port/Synergy`
>
> `+` относительная ссылка из `json`, где:
>
> *   *user_login* - логин авторизованного пользователя;
> *   *user_pass* - пароль авторизованного пользователя.

В конце панели вложений отображается строка "Перейти к вложениям" с 
указанием общего количества вложений к работе 
(![](resources/img/workflow/elements/plashka_attachment_number.png)). 
По нажатию только по этой строчке мобильный клиент открывает экран 
"Вложения" со списком всех файлов работы (илл. «Вложения»).

> **Примечание**
>
> Для получения последних вложений работы необходимо использовать метод:
>
> kz.arta.synergy.server.api.rest.works.WorkFlowService#getAttachments
>
> Ссылка для просмотра файла вложений:
>
> `rest/api/storage/pdf/get?identifier=node_id`
>
> где `node_id` - идентификатор файла. Полная ссылка должна выглядеть 
> следующим образом:
>
> `http(s)://user_login:user_pass@host:port/Synergy/rest/api/storage/pdf/get?identifier=node_id`
>
> где `user_login` - логин авторизованного пользователя, `user_pass` - 
> пароль авторизованного пользователя. Без авторизации доступ к файлам 
> запрещен.

![Вложения](resources/img/workflow/attachements.png)

![Вложения](resources/img/workflow/iOS/attachements_ios.png)

На экране "Вложения" все вложенные файлы разделены на 2 панели: 
"Приложения" и "Прочие".

При прокрутке пользователем в начале списка вверх список вложений 
обновляется.

Список вложений сортируется в алфавитном порядке.

Для добавления нового вложения пользователь нажимает на кнопку "+" 
на верхней панели. Открывается меню "Добавить" с пунктами:

*   Файл с хранилища
*   Файл с устройства
*   Фото

Действия данных пунктов меню аналогичны описанным выше. Файл 
добавляется, если есть доступ, в панель "Приложения", и в 
"Прочие", если доступа нет.

В результате нажатия по плашке вложения выбранный файл скачивается 
на устройство и открывается его системными средствами. Если вложение 
имеет расширение `asfdocx`, то такой файл должен открываться в 
[проигрывателе формы](#forms_view).

> **Примечание:**
> 
> Для версий мобильного приложения 3.6 и ниже поведение при нажатии 
> по плашке вложения, имеющего расширение `asfdocx`, следующее: 
> если форма имеет печатное представление, то файл по форме должен
> скачиваться в pdf-версии согласно шаблона печатного представления,
> иначе необходимо выдавать сообщение-ошибку:
> 
> `Действие не может быть выполнено, т.к. форма не имеет печатного 
> представления`
> 
> Для версий мобильного приложения 3.6 и ниже поведение при долгом
> нажатии по плашке вложения, имеющего расширение `asfdocx`, 
> следующее: если форма имеет мобильное представление и у 
> пользователя есть право редактирования файла, то появляется
> меню "Действия", в котором присутствует пункт "Изменить" (первым 
> в списке). Пользователь нажимает на этот пункт меню и 
> приложение открывает экран редактирования файла по форме в 
> мобильном представлении, аналогичный форме завершения "форма"
> ([Проигрыватель формы](#forms_view)). Если были внесены 
> изменения, то в случае успешного сохранения на сервере должна 
> сохраниться текущая версия формы, но увеличиться версия данных.

Если документ с текущим файлом по форме относится к реестру, в 
результате сохранения возможны следующие 2 варианта событий:

*   документ по реестру еще не активирован (поле `activate` = false) 
    и не находится в процессе (поле `processing` = false): после 
    сохранения открывается окно информации о документе, в которой 
    имеется кнопка запуска маршрута с идентификатором операции 
    [`RUN`](#sec.documents_actions);

*   документ по реестру активирован (поле `activate` = true) и не 
    находится в процессе (поле `processing` = false): после 
    сохранения открывается / запускается 
    [маршрут *изменения* элемента](#sec.documents_actions).

Если у пользователя есть право на удаление вложения, в результате 
долгого нажатия по плашке вложения появляется меню "Действия", в 
котором присутствует пункт "Удалить". Пользователь нажимает на этот 
пункт меню и приложение запрашивает подтверждение выполнения 
действия с сообщением:

`Вы действительно хотите удалить данный файл?`

Если пользователь подтверждает удаление, отправляется запрос на 
сервер для удаления. В случае успешного выполнения плашка удаляется 
из списка, иначе - отображается сообщение об ошибке.

По нажатию в списке вложений на кнопку "Назад" мобильный клиент 
возвращается на экран информации о работе. В случае, если было 
хотя бы одно изменение, информация обновляется.

> **Примечание**
>
> Для получения всех вложений необходимо использовать метод:
>
> kz.arta.synergy.server.api.rest.works.WorkFlowService#getFullAttachments
>
> Метод для удаления вложения:
>
> kz.arta.synergy.server.api.rest.works.WorkFlowService#deleteAttachment

