### Комментарии работы {#sec.workflow_comments}

Далее всегда (независимо от наличия или отсутствия комментариев) 
располагается панель комментариев.

Панель комментариев в окне информации о работе всегда содержит 3 (три) 
вкладки: "Работа", "Документ" и "Личные". Переключение между вкладками 
может происходить двумя способами: по нажатию соответствующей шапки и 
с помощью свайпа вправо/влево (для активной левой вкладки свайп вправо 
должен отсутстовать, аналогично для активной правой вкладки свайп 
влево должен отсутствовать):

*   во вкладке "Работа" должны содержаться комментарии к работе (каждый 
    раз при открытии информации о работе именно данная вкладка должна 
    быть выделена по умолчанию);
*   во вкладке "Документ", соответственно, должны содержаться 
    комментарии ко всему документу;
*   во вкладке "Личные" должны отображаться личные комментарии 
    авторизованного пользователя к данной работе.

![Комментарии по вкладкам](resources/img/workflow/work_view8.png)

Каждая вкладка панели комментариев отображает не более трех 
соответствующих (к работе / к документу / личные) последних полных 
комментария, каждый из которых представляет собой плашку. Элементы 
плашки комментария:

+----------------------+-----------------------------------+----------------------+-----------+
| Элемент              | Расположение                      | Описание             | Поле API  |
+======================+===================================+======================+===========+
| %иконка_комментария% | В левом верхнем углу плашки       | Тип комментария      | `type`    |
+----------------------+-----------------------------------+----------------------+-----------+
| %Фамилия И.О.%       | Вверху справа от типа комментария | Автор комментария    | `author`  |
+----------------------+-----------------------------------+----------------------+-----------+
| 28 минут назад       | В левом нижнем углу плашки после  | Время добавления     | `created` |
|                      | текста комментария                | комментария          |           |
+----------------------+-----------------------------------+----------------------+-----------+
|                      | В основной области плашки         | Текст комментария    | `comment` |
+----------------------+-----------------------------------+----------------------+-----------+

*Тип комментария* отображается в виде пиктограммы. API возвращает
идентификатор пиктограммы (comment_icon).

+---------------------------------------------------------------+-------------------------------------------------+-----------------------+
| Иконка                                                        | Описание                                        | Идентификатор         |
+===============================================================+=================================================+=======================+
| ![](resources/img/workflow/elements/comment_icon.png)\        | комментарий самого пользователя (неличный)      | `comment_icon`        |
+---------------------------------------------------------------+-------------------------------------------------+-----------------------+
| ![](resources/img/workflow/elements/comment_icon_blue.png)\   | личный комментарий пользователя                 | `comment_icon_blue`   | 
+---------------------------------------------------------------+-------------------------------------------------+-----------------------+
| ![](resources/img/workflow/elements/comment_icon_gray.png)\   | комментарий другого пользователя                | `comment_icon_gray`   | 
+---------------------------------------------------------------+-------------------------------------------------+-----------------------+
| ![](resources/img/workflow/elements/comment_icon_green.png)\  | комментарий согласования / утверждения          | `comment_icon_green`  |
+---------------------------------------------------------------+-------------------------------------------------+-----------------------+
| ![](resources/img/workflow/elements/comment_icon_red.png)\    | комментарий отказа в согласовании / утверждении | `comment_icon_red`    |
+---------------------------------------------------------------+-------------------------------------------------+-----------------------+
| ![](resources/img/workflow/elements/comment_icon_result.png)\ | комментарий результата работы                   | `comment_icon_result` |
+---------------------------------------------------------------+-------------------------------------------------+-----------------------+

*Автор комментария* - пользователь, который оставил данный 
комментарий. Отображается в формате %Фамилия И.О.%

*Время добавления комментария*. Значение времени 
отображается по следующему принципу:

+---------------------------------------+------------------------------------------------------+
| Время добавления комментария          | Формат отображения                                   |
+=======================================+======================================================+
| *Сегодня*                             |                                                      |
+---------------------------------------+------------------------------------------------------+
| в течение часа                        | "ХХ минут(ы) назад"                                  |
+---------------------------------------+------------------------------------------------------+
| более часа назад, но в течение дня    | "Сегодня в ЧЧ:ММ"                                    |
+---------------------------------------+------------------------------------------------------+
| *Вчера*                               |                                                      |
+---------------------------------------+------------------------------------------------------+
| в течение предыдущего дня             | "Вчера в ЧЧ:ММ"                                      |
+---------------------------------------+------------------------------------------------------+
| *В течение текущей рабочей недели*    |                                                      |
+---------------------------------------+------------------------------------------------------+
| более двух дней назад, но в течение   | * "В понедельник в ЧЧ:ММ" (при просмотре комментария |
| текущей рабочей недели                |   со среды по воскресенье текущей рабочей недели)    |
|                                       | * "Во вторник в ЧЧ:ММ" (четверг - воскресенье)       |
|                                       | * "В среду в ЧЧ:ММ" (пятница - воскресенье)          |
|                                       | * "В четверг в ЧЧ:ММ" (суббота - воскресенье)        |
|                                       | * "В пятницу в ЧЧ:ММ" (только воскресенье)           |
+---------------------------------------+------------------------------------------------------+
| *Более недели назад*                  |                                                      |
+---------------------------------------+------------------------------------------------------+
| предыдущая рабочая неделя и более     | "ДД месяц ГГГГ ЧЧ:ММ"                                |
+---------------------------------------+------------------------------------------------------+

В конце панели комментариев (даже их количество в данной 
вкладке равно нулю) отображается строка "Перейти к 
комментариям" с указанием общего количества комментариев 
(![](resources/img/workflow/elements/plashka_comment_number.png)). 
По нажатию только по этой строчке мобильный клиент открывает 
экран со списком комментариев, соответствующих той вкладке, 
откуда был вызван данный экран (илл. «Список всех 
комментариев»). Название экрана должно соответствовать 
названию вкладки, откуда он был вызван.

![Список всех комментариев](resources/img/workflow/comments_view.png)

![Список всех комментариев](resources/img/workflow/iOS/comments_view.png)

Комментарии в списке отображаются с постепенной догрузкой. 
Изначально подгружается такое количество комментариев, чтобы 
список был полностью заполнен и появился скролл (минимум 30). 
При прокрутке пользователем вниз список комментариев 
дополняется (количество комментариев в новой "порции" должно 
быть равно количеству комментариев в первой "порции").

При прокрутке пользователем в начале списка вверх список 
комментариев обновляется.

Список комментариев сортируется по времени добавления по 
убыванию (т.е. последние добавленные - в начале списка).

Для добавления нового комментария пользователь нажимает на 
кнопку ![](resources/img/workflow/elements/add_comment.png) 
на верхней панели. Открывается экран для ввода текста (илл. 
«Добавление комментария»). Ввод комментария завершается 
нажатием на кнопку "Готово". Новый комментарий сразу 
добавляется первым в список комментариев:

*   комментарий, добавленный через вкладку "Работа", должен 
    добавиться как к открытой ветке работ, так и к документу;
*   комментарий, добавленный через вкладку "Документ", должен 
    добавиться как к документу, так и непосредственно к 
    открытой ветке работ;
*   комментарий, добавленный через вкладку "Личные", должен 
    добавиться непосредственно к открытой работе.

![Добавление комментария](resources/img/workflow/comment_add.png)

![Добавление комментария](resources/img/workflow/iOS/comment_add.jpg)

Если у пользователя есть право на редактирование комментария, 
в результате долгого нажатия по плашке комментария появляется 
меню "Действия", в котором присутствует пункт "Изменить" 
(первым в списке). Пользователь нажимает на этот пункт меню, 
открывается системное окно ввода текста с текущей 
формулировкой комментария. В случае успешного сохранения 
текст комментария в списке изменяется (время при этом не 
меняется), иначе - отображается сообщение об ошибке.

Если у пользователя есть право на удаление комментария, в 
результате долгого нажатия по плашке комментария появляется 
меню "Действия", в котором присутствует пункт "Удалить". 
Пользователь нажимает на этот пункт меню и приложение 
запрашивает подтверждение выполнения действия с сообщением:

`Вы действительно хотите удалить данный комментарий?`

Если пользователь подтверждает удаление, отправляется запрос 
на сервер для удаления. В случае успешного выполнения плашка 
удаляется из списка, иначе - отображается сообщение об ошибке.

По нажатию в списке комментариев на кнопку "Назад" мобильный 
клиент возвращается на экран информации о работе. В случае, 
если было хотя бы одно изменение, информация обновляется.

> **Примечание**
>
> Для получения трех последних и всех комментариев необходимо 
> использовать метод API:
>
> kz.arta.synergy.server.api.rest.works.WorkFlowService#getComments



