Создание работы / документов {#sec.workflow_create_menu}
-------------------

По нажатию в модуле «Работы» на кнопку "+" вызывается меню «Создать» 
(илл. «Пункты меню "Создать"»).

![Пункты меню "Создать"](resources/img/workflow/work_create_menu.png)

В построении меню создания участвуют пункты параметра `work_items` 
в порядке, определенном полем `position`.

*   `work` - пункт создания работы по умолчанию (для параметра 
    `dialogs` значения полей `type` = "WORK" и `default` = "true", 
    название - поле `name`). По нажатию на данный пункт открывается 
    соответствующий экран [создания работы](#sec.workflow_work_create) 
    по умолчанию.

*   `favorite_dialogs` - остальные пункты создания работы (для 
    параметра `dialogs` значения полей `type` = "WORK" и `default` 
    = "false", название - поле `name`). По нажатию на любой из 
    данных пунктов открывается соответствующий экран 
    [создания работы](#sec.workflow_work_create).

*   `favorite_documents` - избранные пункты создания документа 
    и группы, содержащие такие избранные пункты.

>   **Примечание**
> 
>   В версиях мобильного приложения 3.6 и ниже в построении меню 
>   создания участвуют только те избранные пункты создания документа, 
>   формы реестра которого имеют настроенное мобильное представление, 
>   и группы, содержащие такие избранные пункты.
    
    В правой части групп отображается иконка 
    ![](resources/img/workflow/elements/menu_undetailed.png) в 
    свернутом состоянии и 
    ![](resources/img/workflow/elements/menu_detailed.png) в 
    развернутом. По нажатию в любой области строки со свернутой 
    группой иконка разворачивается, и наоборот. Развернутая группа 
    должна содержать либо вложенные группы (по умолчанию, каждый раз 
    они свернуты), либо избранные пункты создания документов. Строки 
    с вложенными группами и пунктами от левого края должны иметь 
    отступ, при этом уровни вложенности, начиная с 4-й, должны иметь 
    отступ как для 3-го уровня. 
    
    По нажатию на пункт (не группу) открывается соответствующий экран 
    [создания документа](#sec.workflow_document_create);

*   `all_documents` - пункт, название которого должно браться из поля 
    `name`. По нажатию на данный пункт вызывается экран «Избранное» 
    со списком всех пунктов создания документов (илл. «Список всех 
    пунктов создания документов»).

Если название пункта меню полностью не помещается на двух строках, с 
правого края второй строки оно должно быть затемнено градиентом из 
прозрачного в цвет фона. В меню отсутствуют фиксированные элементы, 
при развороте группы создания документа, оно должно пропорционально 
увеличиться по вертикали. При этом если количество отображаемых 
пунктов меню больше высоты экрана, появляется вертикальный скролл на 
все меню, исключая "шапку" (т.е. скролл должен уходить под "шапку").

> *Примечание:* 
> 
> Метод получения настроек пунктов создания и диалогов создания 
> работы описан в javadoc: 
> 
> kz.arta.synergy.server.api.rest.common.SettingsService#getSettings.
> 
> Метод получения пунктов создания документа (в т.ч. только избранных) 
> описан в javadoc: 
> 
> kz.arta.synergy.server.api.rest.common.RegistryService#getFavorite.

Каждая из групп пунктов должна быть отделена от следующей видимым 
сплитом.

Если список создания работы / документов пуст, то кнопку "+" 
отрисовывать не нужно. Если же меню содержит только один пункт, 
то по нажатию кнопки "+", исключая его, должно выполняться 
соответствующее действие и вызываться соответствующий экран.

По нажатию на пункт с идентификатором `all_documents` открывается 
экран «Избранное», который содержит список всех групп и пунктов 
создания документов (илл. «Список всех пунктов создания документов»).

![Список всех пунктов создания документов](resources/img/workflow/favorite.png)

![Список всех пунктов создания документов](resources/img/workflow/iOS/favorite_ios.png)

Поле с поиском вверху экрана, панель со списком всех групп и пунктов 
создания документов по центру и кнопка "Выбрать" внизу экрана имеют 
фиксированное положение, прокрутка списка скроллом осуществляется 
внутри панели. Внутри панели отображается все дерево всех пунктов 
(как избранных, так и обычных) и групп. Каждая запись содержит 
полное название группы / пункта.

Панель со списком групп и пунктов создания документа имеет следующие 
особенности:

*   *Группы:*

    *   С понижением уровня группы и пункты смещаются вправо (при 
        этом уровни вложенности, начиная с 4-й, должны иметь отступ 
        как для 3-го уровня).
    *   В правой части групп отображается иконка 
        ![](resources/img/workflow/elements/favorite_undetailed.png) 
        в свернутом состоянии и 
        ![](resources/img/workflow/elements/favorite_detailed.png) 
        в развернутом. По нажатию в любой области строки со свернутой 
        группой иконка разворачивается, и наоборот (выделение строки 
        отсутствует). Развернутая группа должна содержать либо 
        вложенные группы (по умолчанию, каждый раз они свернуты), 
        либо избранные пункты создания документов.
    
*   *Пункты:*
    
    *   Каждый пункт располагается правее группы самого нижнего 
        уровня, в которой он находится.
    *   В правой части пунктов отображается иконка избранности. По 
        нажатию на "звезду" избранного пункта 
        ![](resources/img/workflow/elements/favorite.png) он 
        становится "обычным" 
        ![](resources/img/workflow/elements/non_favorite.png), и 
        наоборот.
    *   Только в строке пункта присутствует выделение строки 
        (действие tap).

На экране «Избранное» есть возможность "живого" поиска пунктов (не 
групп) по названиям (илл. «Поиск по пунктам создания документов»). 
Для этого пользователь нажимает по полю поиска и вводит текст 
запроса, при вводе текста иконка лупы заменяется на иконку крестика. 
Очистить поле ввода можно, нажав на крестик (крестик заменяется на 
иконку лупы). Пустой запрос поиска - отображается экран в 
первоначальном виде (илл. «Список всех пунктов создания документов»).

![Поиск по пунктам создания документов](resources/img/workflow/favorite_search.png)

![Поиск по пунктам создания документов](resources/img/workflow/iOS/favorite_search_ios.png)

При поиске панель со списком групп и пунктов создания документа 
преобразовывается:

*   во-первых, теперь она содержит только пункты (не группы) создания 
    документов;
*   во-вторых, теперь в ней не отображается дерево этих пунктов, т.е. 
    список пунктов любого уровня вложенности, которые удовлетворяют 
    условиям поиска, должен быть одноуровневым списком;
*   в-третьих, после названия пункта отображается полный путь из групп 
    до данного пункта (если пункт не содержится ни в одной группе, 
    данной строки быть не должно).

В обоих состояних экрана «Избранное» после выделения пункта 
пользователь нажимает на кнопку «Выбрать». Действие выполняется, 
только если выделен какой-либо пункт, иначе необходимо выдавать 
сообщение:

`Не выбран пункт создания документа`

и не выполнять действие. В случае успешного выполнения действия 
открывается экран [создания документа](#sec.workflow_document_create).

Если пользователь на экране «Избранное» нажимает на кнопку "Назад", 
мобильный клиент возвращает экран со списком работ в том состоянии, 
которое было до вызова данного экрана.

<#include "workflow/workflow_work_create.md">
<#include "workflow/workflow_document_create.md">

