### Действия с работой {#sec.workflow_work_actions}

Далее располагаются управляющие кнопки.

Для каждой работы API будет возвращать информацию о доступном наборе
кнопок, для каждой кнопки указываются: цвета, название, идентификатор
действия, идентификатор операции и значение лейбла.

+------------------------+------------------------+------------------------------+
| Идентификатор действия | Идентификатор операции | Значение лейбла              |
+========================+========================+==============================+
| RESOLUTION             |                        | Резолюция                    |
+------------------------+------------------------+------------------------------+
| COMPLETE               | PROCESS                | Ответить                     |
+------------------------+------------------------+------------------------------+
| COMPLETE               | PROGRESS               | Завершить                    |
+------------------------+------------------------+------------------------------+
| COMPLETE               | POINT_RESULT           | Завершить                    |
+------------------------+------------------------+------------------------------+
| COMPLETE               | RESOLUTION_ACTION      | Завершить                    |
+------------------------+------------------------+------------------------------+
| RESULT                 |                        | Результат                    |
+------------------------+------------------------+------------------------------+
| TRANSMIT               |                        | согласно API (передача)      |
+------------------------+------------------------+------------------------------+
| REASSIGN               |                        | согласно API (перепоручение) |
+------------------------+------------------------+------------------------------+
| SEND                   | AGREEMENT              | согласно API (согласование)  |
+------------------------+------------------------+------------------------------+
| SEND                   | APPROVAL               | согласно API (утверждение)   |
+------------------------+------------------------+------------------------------+
| SEND                   | ACQUAINTANCE           | согласно API (ознакомление)  |
+------------------------+------------------------+------------------------------+

Кнопки управления могут быть двух типов: одна, выполнение действия
которой является наиболее ожидаемым (зеленого цвета, идентификатор
PREFERRED), и остальные, выполнение действия которых является менее
ожидаемым (серого цвета, идентификатор NOT_PREFERRED). 

Кроме вышеперечисленных кнопок в конце данного блока может 
отображаться еще одна кнопка, позволяющая подписывать документ 
работы. Значение лейбла такой кнопки - "Подписать", она всегда 
серого цвета. Подробнее о ее доступности и функциях см. в разделе 
["Подписание документа работы"](#sec.workflow_work_sign).

Пример экрана информации о работе без панелей комментариев и вложений
показан на илл. «Информация о работе без комментариев и вложений».

![Информация о работе без комментариев и вложений](resources/img/workflow/work_view5.png)

![Информация о работе без комментариев и вложений](resources/img/workflow/iOS/work_view5.png)

<#include "workflow/workflow_resolution.md">
<#include "workflow/workflow_work_end.md">
<#include "workflow/workflow_work_result.md">
<#include "workflow/workflow_work_send.md">
<#include "workflow/workflow_work_reassign.md">
<#include "workflow/workflow_work_transmit.md">
<#include "workflow/workflow_work_sign.md">

