### Создание и редактирование работы {#sec.workflow_work_create}

На экране со списком работ по нажатию на кнопку "+" и выбору пункта меню 
создания работы открывается соответствующий экран создания работы 
(илл. «Создание работы с 1 шагом»).

![Создание работы с 1 шагом](resources/img/workflow/new_work.png)

![Создание работы с 1 шагом](resources/img/workflow/iOS/new_work.png)

Если у пользователя есть право на редактирование работы, в результате долгого 
нажатия по плашке работы появляется меню, в котором присутствует пункт 
"Изменить". Пользователь нажимает на этот пункт меню, открывается экран 
редактирования работы (илл. «Редактирование работы с 1 шагом»).

![Редактирование работы с 1 шагом](resources/img/workflow/edit_work.png)

![Редактирование работы с 1 шагом](resources/img/workflow/iOS/edit_work.png)

Параметры работы.

+----------------------+-------------------------------------------------------------------------------------------------+---------------------------------------------------------+
| Название параметра   | Описание                                                                                        | Значение по умолчанию                                   |
| (поле API)           |                                                                                                 |                                                         |
+======================+=================================================================================================+=========================================================+
| Формулировка работы  | Вводится полное название работы.                                                                | *Создание* - поле пустое, placeholder - "Введите        |
| (NAME)               |                                                                                                 | формулировку работы".                                   |
|                      |                                                                                                 |                                                         |
|                      |                                                                                                 | *Редактирование* - текущее название работы.             |
+----------------------+-------------------------------------------------------------------------------------------------+---------------------------------------------------------+
| Ответственный        | Открывается экран "Пользователи" (илл. «Экран "Пользователи" со скрытыми тегами»), параметры:   | *Создание* - флажок включен, поле пустое, placeholder - |
| (RESPONSIBLE)        |                                                                                                 | "Выберите ответственного". При отсутствии поля          |
|                      | *  выбор одного пользователя;                                                                   | "Исполнители" флажок недоступен для выключения.         |
|                      | *  если значение настройки "разрешено ли передавать работы другим исполнителям" = true,         |                                                         |
|                      |    отображать всех пользователей, иначе - только подчиненных (включая делегированных            | *Редактирование* - флажок отсутствует, само поле        |
|                      |    подчиненных);                                                                                | присутствует всегда (даже если его отображение          |
|                      | *  идентификатор действия не указывается.                                                       | отключено настройками диалога), заполнено значением     |
|                      |                                                                                                 | текущего ответственного.                                |
|                      | Поле должно автоматически очиститься и стать неактивным (независимо от его заполненности),      |                                                         |
|                      | если выключается флажок.                                                                        |                                                         |
+----------------------+-------------------------------------------------------------------------------------------------+---------------------------------------------------------+
| Автор                | Открывается экран "Пользователи" (илл. «Экран "Пользователи" со скрытыми тегами»), параметры:   | *Создание* - если настройка приложения "отображать поле |
| (AUTHOR)             |                                                                                                 | автор при создании работы" = false, поле должно         |
|                      | *  выбор одного пользователя;                                                                   | отсутствовать, иначе - поле активно, заполнено          |
|                      | *  отображать неподчиненных или нет не указывается;                                             | авторизованным пользователем.                           |
|                      | *  идентификатор действия: 101.                                                                 |                                                         |
|                      |                                                                                                 | *Редактирование* - текущий автор работы, неактивно.     |
+----------------------+-------------------------------------------------------------------------------------------------+---------------------------------------------------------+
| Исполнители          | Открывается экран "Пользователи" (илл. «Экран "Пользователи" со скрытыми тегами»), параметры:   | *Создание* - поле пустое, placeholder - "Выберите       |
| (USERS)              |                                                                                                 | исполнителей".                                          |
|                      | *  множественный выбор пользователей;                                                           |                                                         |
|                      | *  если значение настройки "разрешено ли добавлять соисполнителей к работам, не являющихся      | *Редактирование* - поле отсутствует всегда (даже если   |
|                      |    подчиненными" = true, отображать всех пользователей, если false:                             | его отображение включено настройками диалога).          |
|                      |        *   для значения настройки "ставить ли работы исполнителям от имени ответственного" =    |                                                         |
|                      |            true, отображать подчиненных ответственного (если таковой выбран);                   |                                                         |
|                      |        *   для значения настройки "ставить ли работы исполнителям от имени ответственного" =    |                                                         |
|                      |            false либо если не был выбран ответственный - отображать подчиненных данного         |                                                         |
|                      |            пользователя (включая делегированных подчиненных);                                   |                                                         |
|                      | *  идентификатор действия не указывается.                                                       |                                                         |
|                      |                                                                                                 |                                                         |
|                      | Поле должно автоматически очиститься, если сменили ответственного. Поле должно отсутствовать,   |                                                         |
|                      | если значение настройки "обязательно ли подписание документов перед отправкой" = true.          |                                                         |
+----------------------+-------------------------------------------------------------------------------------------------+---------------------------------------------------------+
| Изменить срок        | Открывается системное окно ввода даты / времени.                                                | *Создание* - значения запрашиваются с сервера при       |
| (DATES)              |                                                                                                 | открытии экрана.                                        |
|                      |                                                                                                 |                                                         |
|                      |                                                                                                 | *Редактирование* - время начала и завершения            |
|                      |                                                                                                 | текущей работы.                                         |
+----------------------+-------------------------------------------------------------------------------------------------+---------------------------------------------------------+
| Приоритет            | Открывается список для выбора одного из значений, полученных при загрузке приложения            | *Создание* - значение запрашивается с сервера при       |
| (PRIORITY)           | (параметр `current_priorities`).                                                                | загрузке приложения (параметр `prority`).               |
|                      |                                                                                                 |                                                         |
|                      |                                                                                                 | *Редактирование* - значение приоритета текущей работы.  |
+----------------------+-------------------------------------------------------------------------------------------------+---------------------------------------------------------+
| Форма завершения     | Открывается список из возможных значений, полученных при загрузке приложения (параметр          | *Создание* - "Нет".                                     |
| (COMPLETION_FORM)    | `work_completion_forms`) и значения "Нет", значение "Нет" должно быть в списке первым.          |                                                         |
|                      | Если список форм завершения пуст, поле не должно быть отображено.                               | *Редактирование* - форма завершения текущей работы.     |
|                      |                                                                                                 | Если текущая форма завершения работы отсутствует        |
|                      |                                                                                                 | в списке - "Нет".                                       |
+----------------------+-------------------------------------------------------------------------------------------------+---------------------------------------------------------+
| Комментарий к работе | Вводится комментарий к работе.                                                                  | *Создание* - поле пустое.                               |
| (COMMENT)            |                                                                                                 |                                                         |
|                      |                                                                                                 | *Редактирование* - поле всегда отсутствует.             |
+----------------------+-------------------------------------------------------------------------------------------------+---------------------------------------------------------+
| Добавить файл        | Выбирается вариант добавления: "С устройства" / "Сфотографировать". Добавленные файлы           | При *создании* и *редактировании* поля пустые.          |
| (ATTACH_FILE)        | отображаются сразу после кнопок. Отображается только название файла.                            |                                                         |
+----------------------+-------------------------------------------------------------------------------------------------+---------------------------------------------------------+

Экран создания работы может иметь несколько видов, в соответствии с выбранным 
пунктом создания. В зависимости от того, какое значение у параметра `special` в 
методе получения описания полей, зависит содержимое экрана создания работы:

*   `false`: экран должен состоять из одного шага, последовательность параметров 
    должна соответствовать таблице. В таком случае экран прокручивается, кнопка 
    «Сохранить» не имеет фиксированного положения.

*   `true`: экран может содержать несколько экранов (по количеству массивов в 
    параметре `steps`), разделенных между собой буллитами. В каждом экране набор 
    и последовательность параметров определяется API. Переключение между экранами 
    осуществляется с помощью свайпа вправо/влево (для активного левого экрана 
    свайп вправо должен отсутствовать, аналогично для активного правого экрана 
    свайп влево должен отсутствовать). В таком случае экран не прокручивается, 
    кнопка «Сохранить» и буллиты над ней имеют фиксированное положение внизу экрана.

![Создание работы с несколькими шагами](resources/img/workflow/new_work2.png)

![Создание работы с несколькими шагами](resources/img/workflow/iOS/new_work2.png)

Экран редактирования работы всегда имеет только один вид, который соответствует 
дефолтному (параметр `default` = `true`) экрану создания работы. С параметром 
`special` здесь аналогично:

*   `false`: экран должен состоять из одного шага, последовательность параметров 
    должна соответствовать таблице. В таком случае экран прокручивается, кнопка 
    «Сохранить» не имеет фиксированного положения.

*   `true`: экран может содержать несколько экранов (по количеству массивов в 
    параметре `steps`), разделенных между собой буллитами. В каждом экране набор 
    и последовательность параметров определяется API. Переключение между экранами 
    осуществляется с помощью свайпа вправо/влево (для активного левого экрана 
    свайп вправо должен отсутствовать, аналогично для активного правого экрана 
    свайп влево должен отсутствовать). В таком случае экран не прокручивается, 
    кнопка «Сохранить» и буллиты над ней имеют фиксированное положение внизу экрана.

Во всех случаях все поля экрана не имеют фиксированной высоты, а заголовком 
экрана создания работы должно являться соответствующее название пункта (параметр 
`name`). Заголовком же экрана редактирования всегда должно являться название 
дефолтного экрана создания работы.

![Редактирование работы с несколькими шагами](resources/img/workflow/edit_work2.png)

![Редактирование работы с несколькими шагами](resources/img/workflow/iOS/edit_work2.png)

При создании работы файл добавляется в папку "Приложения", при редактировании 
работы - в "Приложения", если есть доступ, в "Прочие", если доступа нет 
(выбор в какую папку файлы должны быть добавлены осуществляется на сервере, 
указывать на клиенте это не нужно).

В результате нажатия по вложению выбранный файл скачивается на устройство и 
открывается его системными средствами. Если вложение имеет расширение 
`asfdocx`, то такой файл должен открываться в [проигрывателе формы](#forms_view).

> **Примечание:**
> 
> Для версий мобильного приложения 3.6 и ниже поведение при нажатии 
> по плашке вложения, имеющего расширение `asfdocx`, следующее: 
> если форма имеет печатное представление, то файл по форме должен
> скачиваться в pdf-версии согласно шаблона печатного представления,
> иначе необходимо выдавать сообщение-ошибку:
> 
> `Действие не может быть выполнено, т.к. форма не имеет печатного 
> представления`
> 
> Для версий мобильного приложения 3.6 и ниже поведение при долгом
> нажатии по плашке вложения, имеющего расширение `asfdocx`, 
> следующее: если форма имеет мобильное представление и у 
> пользователя есть право редактирования файла, то появляется
> меню "Действия", в котором присутствует пункт "Изменить" (первым 
> в списке). Пользователь нажимает на этот пункт меню и 
> приложение открывает экран редактирования файла по форме в 
> мобильном представлении, аналогичный форме завершения "форма"
> ([Проигрыватель формы](#forms_view)). Если были внесены 
> изменения, то в случае успешного сохранения на сервере должна 
> сохраниться текущая версия формы, но увеличиться версия данных.

Для удаления только что добавленного файла пользователь долго нажимает на 
плашку вложения и в появившемся меню "Действия" выбирает пункт "Удалить".
Открывается окно подтверждения удаления с сообщением

`Вы действительно хотите удалить данный файл?`

Если пользователь подтверждает удаление, отправляется запрос на 
сервер для удаления. В случае успешного выполнения плашка удаляется 
из списка, иначе - отображается сообщение об ошибке.

Если пользователь на экране нажимает на кнопку "Назад", мобильный клиент 
возвращает экран со списком работ в том состоянии, которое было до вызова 
данного экрана.

После ввода всех необходимых параметров работы пользователь нажимает на 
кнопку "Создать" / "Сохранить". Действие создания/сохранения выполняется 
при выполнении следующих условий:

*   заполнена формулировка работы;
*   для включенного флажка заполнено поле "Ответственный", для выключенного 
    - поле "Исполнители";
*   заполнено поле "Автор" работы;
*   заполнены сроки, причем дата начала меньше даты завершения;
*   в поле "Приоритет" выбран нескрытый приоритет.

В случае успешного сохранения открывается экран со списком работ. Если была 
создана новая работа - она вставляется в верх списка. Плашка измененной 
работы обновляется (обновление всего списка не требуется).

В случае неуспешного - выдается сообщение об ошибке, действие выполняться 
не должно, пользователь остается на экране создания / редактирования работы.

*   Если не введены формулировка работы и/или ответственный (для включенного 
    флажка) - ошибка:
    
    `Заполните все поля`

*   Если для выключенного флажка не выбрано ни одного исполнителя - ошибка:
    
    `Работа не может быть создана: не указан ни ответственный, ни
    исполнители`

*   Если у просроченной работы был изменен ответственный - ошибка:
    
    `Вы не можете изменить ответственного у просроченной работы. Измените 
    дату завершения.`

*   Если у обычной (непросроченной) работы был изменен ответственный - 
    предупреждающее сообщение:
    
    `Вы действительно хотите изменить ответственного? Данная работа будет 
    удалена. Вместо нее будет создана аналогичная для нового пользователя с 
    датой начала от текущего числа.`
    
    и действиями "Да" и "Нет".

*   Работы, для которых уже был назначен приоритет, который впоследствии 
    скрыли, сохраняют его значение и цвет до тех пор, пока работу не откроют 
    на редактирование (он все еще должен являться значением компонента, но 
    при этом должен отсутствовать в выпадающем списке). Ошибка:
    
    `Выбранный приоритет работы отсутствует в справочнике приоритетов. 
    Выберите другое значение.`

> **Примечание**
>
> Метод получения описания полей диалога создания работы:
>
> kz.arta.synergy.server.api.rest.works.WorkFlowService#getWorkDialogs
>
> Метод получения дефолтных полей для создания новой работы:
>
> kz.arta.synergy.server.api.rest.works.WorkFlowService#getDefaultWorkFields
>
> Метод добавления работы:
>
> kz.arta.synergy.server.api.rest.works.WorkFlowService#createWork
>
> Метод изменения работы:
>
> kz.arta.synergy.server.api.rest.works.WorkFlowService#saveWork
>
> Метод добавления файла:
>
> kz.arta.synergy.server.api.rest.works.WorkFlowService#createAttachment
> (параметр path должен отсутсвовать)
>
> Метод добавления комментария:
>
> kz.arta.synergy.server.api.rest.works.WorkFlowService#addComment


