#### Подписание документа работы {#sec.workflow_work_sign}

Кнопка "Подписать" должна отображаться только при совпадении 
всех следующих условий:

1.  Во-первых, авторизованный пользователь должен отсутствовать 
    в текущем листе подписей документа. Для этого вызывается 
    метод API для получения списка подписей:
    
    `kz.arta.synergy.server.api.rest.docs#getSignList` 
    (передается идентификатор документа работы)
    
    и по параметру `userID` проверяется его отсутствие во всех 
    записях.

2.  Во-вторых, подписываемая работа не должна быть незавершенным 
    согласованием либо утверждением либо ознакомлением. Для этого 
    вызывается метод API для получения информации о работе:
    
    `kz.arta.synergy.server.api.rest.works#getWorksById` 
    (передается идентификатор работы)
    
    и по параметру `parent_process` проверяется тип работы. Это 
    поле не должно содержать одно из следующих значений:
    
    *   `agreement-single` (согласование)
    *   `approval-single` (утверждение)
    *   `acquaintance-single` (ознакомление)

Если хотя бы одно условие не выполняется, то кнопка "Подписать" 
отсутствует. Если выполняются оба условия одновременно, то 
кнопка отображается последней в списке.

Пользователь нажимает на соответствующую кнопку: открывается 
экран "Подписать". Для выполнения действия необходимо получить 
следующую информацию:

-   закодированная строка для идентификации подписываемых данных 
    (`rawdata` из метода API 
    `kz.arta.synergy.server.api.rest.docs#getDocumentInfo`);

-   настроена ли функция ЭЦП (`enableEDS` из метода API 
    `kz.arta.synergy.server.api.rest.common#getSettings`);

-   требуется ли ключ и сертификат (`needCert` из метода API 
    `kz.arta.synergy.server.api.rest.common#getSettings`).

> Примечание.
> 
> Если отсутствует параметр `rawdata` (это возможно в том случае, 
> если версия платформы ниже 3.6), то в экране "Подписать" при 
> нажатии на кнопку "Подписать" либо "Выбрать ЭЦП" необходимо 
> выдавать ошибку:
> 
> `Данная функция недоступна, т.к. используется версия ARTA 
> Synergy ниже 3.6`
> 
> и не выполнять действие, остается открытым экран "Подписать".

![Подписание документа без использования ЭЦП](resources/img/workflow/sign_edi_turned_off.png)

![Подписание документа без использования ЭЦП](resources/img/workflow/iOS/sign_edi_turned_off_ios.png)

![Подписание документа, файл ЭЦП еще не выбран](resources/img/workflow/sign_edi_not_choosen.png)

![Подписание документа, файл ЭЦП еще не выбран](resources/img/workflow/iOS/sign_edi_not_choosen_ios.png)

![Подписание документа, файл ЭЦП выбран](resources/img/workflow/sign_edi_choosen.png)

![Подписание документа, файл ЭЦП выбран](resources/img/workflow/iOS/sign_edi_choosen_ios.png)

Все кнопки имеют фиксированное положение внизу экрана. Вся 
остальная область прокручиваема.

Параметры завершения с действием.

+------------------------+-----------------------------------------+
| Параметр работы        | Описание                                |
+========================+=========================================+
| Использовать ЭЦП       | Флажок                                  |
+------------------------+-----------------------------------------+
| Просмотреть информацию | Кликабельный лейбл                      |
| о выбранной ЭЦП        |                                         |
+------------------------+-----------------------------------------+

Если функция ЭЦП настроена на стороне сервера (поле API 
`enableEDS = true`), а также при наличии цифровой подписи 
на устройстве, возможно его использование при подписании.

Значение по умолчанию флажка *"Использовать ЭЦП"* зависит 
от настроек, полученных при загрузке приложения (требовать 
ли ключ и сертификат, параметр в API: `needCert`):

*   "да" - флажку устанавливается значение "Вкл", его 
    изменение недоступно;
*   "нет" - флажку устанавливается значение "Выкл", его 
    изменение доступно.

Если функция ЭЦП не настроена на стороне сервера (поле API 
`enableEDS = false`), то:

*   при наличии требования ключа и сертификата (`needCert = 
    true`) - не открывая экран необходимо вывести ошибку:

    `Вы не можете использовать ЭЦП. Данная функция не 
    настроена. Обратитесь к администратору.`
    
*   иначе - флажок "Использовать ЭЦП" всегда недоступен и 
    имеет значение "Выкл".

Кликабельный лейбл *Просмотреть информацию о выбранной ЭЦП* 
отображается только в том случае, если файл ЭЦП уже выбран. 
По его нажатию открывается экран с информацией (см. ниже).

Для значения "Использовать ЭЦП" = "Выкл" внизу экрана 
отображается функциональная кнопки "Подписать" зеленого 
цвета (идентификатор PREFERRED).

Для значения "Использовать ЭЦП" = "Вкл" внизу экрана 
отображаются:

*   файл ЭЦП не выбран - только кнопка "Выбрать ЭЦП" 
    зеленого цвета (идентификатор PREFERRED);
*   файл ЭЦП выбран - сначала функциональная кнопка 
    "Подписать" зеленого цвета (идентификатор PREFERRED), 
    затем кнопка "Изменить ЭЦП" серого цвета (идентификатор 
    NOT_PREFERRED).

**Информация о выбранной ЭЦП.**

Нажатие по кликабельному лейблу "Просмотреть информацию о 
выбранной ЭЦП" открывает экран "Информация", в которой 
отображаются следующие параметры:

+--------------+------------------+---------------------------+
| Поле         | Параметр ЭЦП     | Пример                    |
+==============+==================+===========================+
| ИИН          | KEY_SERIALNUMBER | IIN910511450249           |
+--------------+------------------+---------------------------+
| Основное имя | KEY_CN           | САРСЕМБАЕВА МЕРУЕРТ       |
+--------------+------------------+---------------------------+
| Отчество     | KEY_GIVENNAME    | КОКЕШЕВНА                 |
+--------------+------------------+---------------------------+
| Организация  | KEY_O            | АО "НАЦИОНАЛЬНАЯ КОМПАНИЯ |
|              |                  | "КАЗАХСКОЕ ИНФОРМАЦИОННОЕ |
|              |                  | АГЕНТСТВО"                |
+--------------+------------------+---------------------------+
| Истекает     |                  | 31.12.2016                |
+--------------+------------------+---------------------------+

> Примечание.
> 
> Если ЭЦП выдано на физическое лицо, поле "Организация" 
> должно отсутствовать.

С данного экрана возможен только возврат на предыдущий экран 
с помощью кнопки "Назад".

![Информация о выбранной ЭЦП](resources/img/workflow/edi_information.png)

![Информация о выбранной ЭЦП](resources/img/workflow/iOS/edi_information_ios.png)

**Кнопка "Выбрать ЭЦП".**

> Примечание.
> 
> Для подписания документов с использованием ЭЦП предварительно 
> необходимо загрузить файл сертификата на устройство. Мобильным 
> приложением поддерживаются только ЭЦП с алгоритмом RSA.
> 
> Для ОС Android достаточно скопировать файл ЭЦП в любую папку 
> подключенного к компьютеру смартфона с помощью проводника.
> 
> Для iOS необходимо воспользоваться фирменной утилитой iTunes. 
> При подключенном смартфоне перейти в «iPhone» - «Настройки» - 
> «Программы». Найти среди списка программ мобильное приложение 
> Synergy и добавить файл ЭЦП в хранилище с компьютера на 
> смартфон через кнопку «Добавить файл…».

После включения флажка "Использовать ЭЦП" внизу экрана 
отображается единственная кнопка "Выбрать ЭЦП". По ее нажатию, 
в зависимости от того, происходил ли выбор ЭЦП в приложении 
ранее, открывается:

*в ОС Android:*

*   ЭЦП ранее не использовалось - окно (не экран) файлового 
    менеджера (аналогичный выбору файла с устройства) с 
    фильтром, позволяющим отображать в папках только файлы 
    цифровых подписей (с расширением `р12` и `pfx`).
    
    Если в данном окне пользователь нажимает на кнопку 
    "Назад" / "Отмена" / либо вне области окна, возвращается 
    экран "Подписать" в том же состоянии, что и до нажатия 
    кнопки "Выбрать ЭЦП".
    
    Если же пользователь нажимает на кнопку "Ок", не выбрав 
    файл, необходимо закрывать окно и выдавать сообщение:
    
    `Выберите файл ЭЦП`
    
    Пользователь выбирает файл ЭЦП и нажимает на кнопку 
    "Ок", открывается экран "Пароль ЭЦП".
    
*   ЭЦП ранее использовалось - сразу экран "Пароль ЭЦП", в 
    котором уже выбран файл последнего использовавшегося 
    сертификата.

*в iOS:*

*   ЭЦП ранее не использовалось - экран файлов приложения 
    "ЭЦП" (куда предварительно загружен файл ЭЦП) с 
    фильтром, позволяющим отображать только файлы цифровых 
    подписей (с расширением `р12` и `pfx`).
    
    Если на данном экране пользователь нажимает на кнопку 
    "Назад", возвращается экран "Подписать" в том же 
    состоянии, что и до нажатия кнопки "Выбрать ЭЦП".
    
    Выделение строки - действие tap. После выделения 
    файла пользователь нажимает на кнопку "Выбрать". 
    Действие выполняется, только если выделен какой-либо 
    файл, иначе необходимо выдавать сообщение:

    `Файл не выбран`

    и не выполнять действие. В случае успешного выполнения 
    открывается экран "Пароль ЭЦП".
        
    ![Выбор ЭЦП в iOS](resources/img/workflow/iOS/edi_chooser_ios.png)
    
*   ЭЦП ранее использовалось - сразу экран "Пароль ЭЦП", 
    в котором уже выбран файл последнего использовавшегося 
    сертификата.

В обоих вариантах под вариантом "ЭЦП ранее не использовалось" 
подразумевается, в том числе, сброс текущего выбранного 
значения ЭЦП при выходе из приложения (с помощью кнопки 
"Выйти" в [настройках](#sec.settings)).

*Пароль ЭЦП.*

Параметры экрана ввода пароля.

+----------------------+------------------------------+
| Параметр экрана      | Описание                     |
+======================+==============================+
| %название_файла_ЭЦП% | Поле ввода пароля,           |
|                      | placeholder "Введите пароль" |
+----------------------+------------------------------+
| Подписать            | Кнопка                       |
+----------------------+------------------------------+
| Изменить ЭЦП         | Кнопка                       |
+----------------------+------------------------------+

Обязательное *поле ввода пароля* с лейблом, содержащим 
полное название файла ЭЦП. В данное поле вводится пароль 
к сертификату.

По нажатию на *кнопку "Подписать"* происходит валидация 
пароля, и в случае успешного пароля - валидация самой 
подписи. В случае успешной валидации подписи открывается 
экран подписания в состоянии "выбранного ЭЦП":

*   отображается кликабельный лейбл "Просмотреть 
    информацию о выбранной ЭЦП";
*   после функциональной кнопки "Подписать" добавляется 
    кнопка "Изменить ЭЦП" серого цвета (идентификатор 
    NOT_PREFERRED).

Возможно исполнение альтернативных потоков событий 1-6.

Если на экране "Пароль ЭЦП" пользователь нажимает на 
кнопку "Назад", возвращается экран подписания в том же 
состоянии, что и до нажатия кнопки "Выбрать ЭЦП".

По нажатию на *кнопку "Изменить ЭЦП"* открывается окно/
экран выбора файла ЭЦП. При этом текущее выбранное 
значение удаляется.

*Альтернативные потоки событий.*

*   Альтернативный поток №1: не заполнено поле пароля. 
    Действие не осуществляется, выходит ошибка:

    `Введите пароль`

*   Альтернативный поток №2: введен некорректный пароль. 
    Действие не осуществляется, выходит ошибка:

    `Неверный пароль`

*   Альтернативный поток №3: выбранный ключ просрочен. 
    Действие не осуществляется, выходит ошибка:

    `Указанный ключ просрочен. Выберите другой ключ и 
    повторите попытку.`

*   Альтернативный поток №4: выбранный ключ отозван. 
    Действие не осуществляется, выходит ошибка:

    `Указанный ключ был отозван. Выберите другой ключ 
    и повторите попытку.`

*   Альтернативный поток №5: выбранный ключ не 
    действителен. Действие не осуществляется, выходит 
    ошибка:

    `Указанный ключ не действителен. Выберите другой 
    ключ и повторите попытку.`

*   Альтернативный поток №6: алгоритм выбранного ключа 
    отличается от RSA. Действие не осуществляется, 
    выходит ошибка:

    `Указанный ключ приложением не поддерживается. 
    Выберите другой ключ и повторите попытку.`

![Пароль ЭЦП](resources/img/workflow/edi_password.png)

![Пароль ЭЦП](resources/img/workflow/iOS/edi_password_ios.png)

**Функциональная кнопка.**

Пользователь нажимает на функциональную кнопку. В случае 
успешного выполнения действия открывается экран информации 
о работе, информация обновляется. В случае неуспешного - 
выдается сообщение об ошибке, пользователь остается на 
данном экране.

Если на экране подписания пользователь нажимает на кнопку 
"Назад", возвращается экран информации о работе в том же 
состоянии, что и до завершения работы.

> **Примечание.**
> 
> Метод API для верификации ЭЦП:
> kz.arta.synergy.ejb.rest.sign#verificationkey
> 
> Метод API для подписания документа:
> kz.arta.synergy.ejb.rest.docs#sign

