Список работ {#sec.workflow_works}
------------

Экран со списком работ представлен на илл. «Список работ».

![Список работ](resources/img/workflow/main.png)

**Элементы управления экрана со списком работ.**

+--------------------------------------------------------------+------------------------+---------------------------------------------------+
| Элемент управления                                           | Расположение на экране | Описание                                          |
+==============================================================+========================+===================================================+
| *Верхняя панель*                                             |                        |                                                   |
+--------------------------------------------------------------+------------------------+---------------------------------------------------+
| ![](resources/img/workflow/elements/button_filters.png)\     | Слева                  | "Навигатор" - кнопка перехода к                   |
|                                                              |                        | [фильтрам потоков работ](#sec.workflow_filters)   |
+--------------------------------------------------------------+------------------------+---------------------------------------------------+
| "Работы"                                                     | По центру              | Выпадающий список для переключения между модулями |
+--------------------------------------------------------------+------------------------+---------------------------------------------------+
| ![](resources/img/workflow/elements/button_work_create.png)\ | Справа                 | "Создать" - кнопка создания                       |
|                                                              |                        | [работы](#sec.workflow_work_create) и             |
|                                                              |                        | [документа](#sec.workflow_document_create))       |
+--------------------------------------------------------------+------------------------+---------------------------------------------------+
| *Рабочая область*                                            |                        |                                                   |
+--------------------------------------------------------------+------------------------+---------------------------------------------------+
|                                                              | Вся рабочая область    | Плашки, отображающие информацию о работе          |
|                                                              | ниже верхней панели    |                                                   |
+--------------------------------------------------------------+------------------------+---------------------------------------------------+

По нажатию на "Работы" на верхней панели не отображаются все 
кнопки, под панелью открывается выпадающий список с модулями 
(илл. «Переключение между модулями»):

*   [Работы](#chap_workflow);
*   [Документы](#chap.documents);
*   [Файлы](#chap.files).

![Переключение между модулями](resources/img/workflow/main1.png)

До вызова выпадающего списка стрелка отображается указателем 
вниз, по вызову меняется указателем вверх. По нажатию вне 
области выпадающего списка, а также по указателю и шапке 
списка, он скрывается. По нажатию на текущий модуль список 
обновляется, на другой модуль - открывается соответствующий 
модуль.

Работы в списке отображаются с постепенной догрузкой. 
Изначально подгружается такое количество работ, чтобы список 
был полностью заполнен и появился скролл (минимум 30). При 
прокрутке пользователем вниз и достижении конца списка, 
список работ дополняется (количество работ в новой "порции" 
должно быть равно количеству работ в первой "порции").

При прокрутке пользователем в начале списка вверх (действие 
dropdown) список работ обновляется.

Список работ сортируется согласно условиям просматриваемого 
фильтра.

По нажатию на кнопку "+" вызывается меню «Создать». Кроме 
того, кнопка "+" может отсутствовать вовсе, см. подробнее в 
разделе про 
[создание работы / документов](#sec.workflow_create_menu). 

**Плашка работы.**

Плашка работы - это компонент, отображающий информацию о 
работе (илл. «Плашка работы на исполнении с прогрессом»). 
Все плашки имеют одинаковый размер.

![Плашка работы на исполнении с прогрессом](resources/img/workflow/elements/work_plashka.png)

Элементы плашки работы.

+-----------------------------------------------------------------+-----------------------------+---------------------------------+-------------------------------+
| Элемент                                                         | Расположение                | Описание                        | Поле API                      |
+=================================================================+=============================+=================================+===============================+
| ![](resources/img/workflow/elements/priority_green.png)\        | В левом верхнем углу плашки | Приоритет работы                | `all_priorities`              |
+-----------------------------------------------------------------+-----------------------------+---------------------------------+-------------------------------+
| **Фамилия И.О.** (полужирное выделение)                         | Вверху плашки, справа от    | Автор работы (для работы, где   | `author`                      |
|                                                                 | приоритета                  | авторизованный пользователь -   |                               |
|                                                                 |                             | исполнитель работы)             |                               |
+-----------------------------------------------------------------+-----------------------------+---------------------------------+-------------------------------+
| Фамилия И.О (обычное выделение)                                 | Вверху плашки, справа от    | Исполнитель работы (для работы, | `user`                        |
|                                                                 | приоритета                  | где авторизованный пользователь |                               |
|                                                                 |                             | - не исполнитель работы)        |                               |
+-----------------------------------------------------------------+-----------------------------+---------------------------------+-------------------------------+
| ![](resources/img/workflow/elements/plashka_terms.png)          | В правом верхнем углу       | Срок окончания работы           | `remained-label`              |
| ![](resources/img/workflow/elements/plashka_terms_sub.png)\     | плашки                      |                                 |                               |
| 2 дн                                                            |                             |                                 |                               |
+-----------------------------------------------------------------+-----------------------------+---------------------------------+-------------------------------+
| ![](resources/img/workflow/elements/progress_status_icon.png)\  | Вверху плашки, слева от     | Иконка прогресс работы          | `work_state_icon`;            |
|                                                                 | срока окончания работы      |                                 | значением этого поля является |
|                                                                 |                             |                                 | идентификатор иконки          |
+-----------------------------------------------------------------+-----------------------------+---------------------------------+-------------------------------+
| 15%                                                             | Вверху плашки, слева от     | Подпись прогресса завершения    | `work_state_label`;           |
|                                                                 | срока окончания работы      | работы                          | значением этого поля является |
|                                                                 |                             |                                 | идентификатор значения        |
+-----------------------------------------------------------------+-----------------------------+---------------------------------+-------------------------------+
|                                                                 | Вся основная область плашки | Формулировка работы             | `name`                        |
+-----------------------------------------------------------------+-----------------------------+---------------------------------+-------------------------------+
| ![](resources/img/workflow/elements/hook.png)\                  | В правом нижнем углу плашки | Наличие дочерних работ          | `has_subprocesses`            |
+-----------------------------------------------------------------+-----------------------------+---------------------------------+-------------------------------+

*Приоритет работы* отображается в виде пиктограммы квадрата, 
залитого цветом `color` параметра `all_priorities`.

*Автор работы* - пользователь, который поставил работу данному 
пользователю. Отображается в формате %Фамилия И.О.%

*Срок окончания работы* отображается в виде пиктограммы 
календаря и подписи. API возвращает значение подписи согласно 
правилам, указанным в таблице. Если значение подписи приходит 
пустым, отображать его и пиктограмму на плашке не нужно.

+------------------------------------------+------------------------------------------+
| Положительные сроки                      | Отрицательные сроки                      |
+==========================================+==========================================+
| "ХХ мин" - работы, до завершения которых | "-ХХ мин" - работы, которые просрочились |
| осталось не более 60 минут               | не более, чем на 60 минут                |
+------------------------------------------+------------------------------------------+
| "ХХ ч" - работы, до завершения которых   | "-ХХ ч" - работы, которые просрочились   |
| осталось более 60 минут и                | более, чем на 60 минут, и                |
| менее одного рабочего дня                | менее, чем на 1 рабочий день             |
+------------------------------------------+------------------------------------------+
| "ХХ дн" - работы, до завершения которых  | "-ХХ мин" - работы, которые просрочились |
| осталось более одного рабочего дня и     | более, чем на 1 рабочий день, и          |
| менее одного месяца                      | менее, чем на 1 месяц                    |
+------------------------------------------+------------------------------------------+
| "ХХ мес" - работы, до завершения которых | "-ХХ мес" - работы, которые просрочились |
| осталось более одного месяца и           | более, чем на 1 месяц, и                 |
| менее одного года                        | менее, чем на 1 год                      |
+------------------------------------------+------------------------------------------+
| "ХХ г" - работы, до завершения которых   | "-ХХ г" - работы, которые просрочились   |
| осталось более одного года               | более, чем на 1 год                      |
+------------------------------------------+------------------------------------------+

> **Примечание**
>
> Все сроки, указанные в таблице измеряются в рабочих минутах 
> / часах / днях / месяцах и годах.

*Прогресс работы* отображается в виде пиктограммы и текстовой 
подписи. API возвращает идентификатор пиктограммы 
(`work_state_icon`) и идентификатор подписи (`work_state_label`). 
Конкретное значение подписи зависит от сочетания этих полей. 
Возможные значения перечислены в таблице. В случае, если API 
вернет комбинацию полей, отсутствующую в этой таблице, 
отображать прогресс на плашке не нужно.

+-----------------------------------------------------------------------+-----------------------------+-------------------------------+
| Иконка                                                                | Описание                    | Идентификатор иконки          |
+=======================================================================+=============================+===============================+
| ![](resources/img/workflow/elements/progress_status_icon.png)         | цифровое значение прогресса | progress_status_icon          |
| ![](resources/img/workflow/elements/progress_sub_status_icon.png)     | (пиктограмма одинакова для  |                               |
|                                                                       | всех значений процентов)    |                               |
+-----------------------------------------------------------------------+-----------------------------+-------------------------------+
| ![](resources/img/workflow/elements/progress_result_icon.png)         | работа с формой завершения, | progress_result_icon          |
| ![](resources/img/workflow/elements/progress_sub_result_icon.png)     | которую необходимо          |                               |
|                                                                       | подтвердить                 |                               |
+-----------------------------------------------------------------------+-----------------------------+-------------------------------+
| ![](resources/img/workflow/elements/progress_mfa_icon.png)            | работа на ознакомлении /    | progress_mfa_icon             |
| ![](resources/img/workflow/elements/progress_sub_mfa_icon.png)        | согласовании / утверждении  |                               |
+-----------------------------------------------------------------------+-----------------------------+-------------------------------+
| ![](resources/img/workflow/elements/progress_denied_icon.png)         | работа, которую не          | progress_denied_icon          |
| ![](resources/img/workflow/elements/progress_sub_denied_icon.png)     | согласовали / не утвердили  |                               |
+-----------------------------------------------------------------------+-----------------------------+-------------------------------+
| ![](resources/img/workflow/elements/progress_done_icon.png)           | завершенная работа          | progress_done_icon,           |
| ![](resources/img/workflow/elements/progress_sub_done_icon.png)       |                             | progress_resolution_done_icon |
+-----------------------------------------------------------------------+-----------------------------+-------------------------------+
| ![](resources/img/workflow/elements/progress_deleted_icon.png)        | удаленная работа            | progress_deleted_icon         |
| ![](resources/img/workflow/elements/progress_sub_deleted_icon.png)    |                             |                               |
+-----------------------------------------------------------------------+-----------------------------+-------------------------------+
| ![](resources/img/workflow/elements/progress_resolution_icon.png)     | работа по процессу          | progress_resolution_icon      |
| ![](resources/img/workflow/elements/progress_sub_resolution_icon.png) | резолюции                   |                               |
+-----------------------------------------------------------------------+-----------------------------+-------------------------------+

Идентификаторы для обозначения прогресса:

+-----------------------+-------------------------------+----------------------+---------------------+
| Идентификатор подписи | Идентификатор пиктограммы     | Сокращенное значение | Полное значение     |
+=======================+===============================+======================+=====================+
| agreement             | progress_mfa_icon             | Согл                 | На согласовании     |
+-----------------------+-------------------------------+----------------------+---------------------+
| agreement             | progress_done_icon            | Согласовано          | Согласовано         |
+-----------------------+-------------------------------+----------------------+---------------------+
| agreement             | progress_denied_icon          | Не согласовано       | Не согласовано      |
+-----------------------+-------------------------------+----------------------+---------------------+
| agreement             | progress_deleted_icon         | Удалено              | Удалено             |
+-----------------------+-------------------------------+----------------------+---------------------+
| approval              | progress_mfa_icon             | Утв                  | На утверждении      |
+-----------------------+-------------------------------+----------------------+---------------------+
| approval              | progress_done_icon            | Утверждено           | Утверждено          |
+-----------------------+-------------------------------+----------------------+---------------------+
| approval              | progress_denied_icon          | Не утверждено        | Не утверждено       |
+-----------------------+-------------------------------+----------------------+---------------------+
| approval              | progress_deleted_icon         | Удалено              | Удалено             |
+-----------------------+-------------------------------+----------------------+---------------------+
| acquaintance          | progress_mfa_icon             | Озн                  | На ознакомлении     |
+-----------------------+-------------------------------+----------------------+---------------------+
| acquaintance          | progress_done_icon            | Ознакомлен           | Ознакомлен          |
+-----------------------+-------------------------------+----------------------+---------------------+
| acquaintance          | progress_deleted_icon         | Удалено              | Удалено             |
+-----------------------+-------------------------------+----------------------+---------------------+
| registration          | progress_mfa_icon             | Рег                  | На регистрации      |
+-----------------------+-------------------------------+----------------------+---------------------+
| registration          | progress_done_icon            | Зарегистрировано     | Зарегистрировано    |
+-----------------------+-------------------------------+----------------------+---------------------+
| registration          | progress_denied_icon          | Не зарегистрировано  | Не зарегистрировано |
+-----------------------+-------------------------------+----------------------+---------------------+
| registration          | progress_deleted_icon         | Удалено              | Удалено             |
+-----------------------+-------------------------------+----------------------+---------------------+
| result                | progress_result_icon          | Результат            | 100%                |
+-----------------------+-------------------------------+----------------------+---------------------+
| progress              | progress_status_icon          | Прогресс_работы + %  | Слайдер со          |
|                       |                               |                      | значением прогресса |
+-----------------------+-------------------------------+----------------------+---------------------+
| progress              | progress_done_icon            | Завершено            | Завершено           |
+-----------------------+-------------------------------+----------------------+---------------------+
| progress              | progress_deleted_icon         | Удалено              | Удалено             |
+-----------------------+-------------------------------+----------------------+---------------------+
| resolution_action     | progress_resolution_icon      | Рассм                | На рассмотрении     |
+-----------------------+-------------------------------+----------------------+---------------------+
| resolution_action     | progress_resolution_done_icon | Резолюция            | Резолюция принята   |
+-----------------------+-------------------------------+----------------------+---------------------+
| resolution_action     | progress_done_icon            | Завершено            | Завершено           |
+-----------------------+-------------------------------+----------------------+---------------------+

*Формулировка работы* отображается максимум на 3 (три) строки. 
Если название работы полностью не помещается на плашке, с правого 
края третьей строки оно должно быть затемнено градиентом из 
прозрачного в цвет фона.

Цвет текста, выделение работы зависит от времени оставшегося до 
завершения работы:

+---------------------+-----------------+-------------+
| Работа              | Поле API        | Цвет текста |
+=====================+=================+=============+
| просроченная        | is_expired      | `#be3d3d`   |
+---------------------+-----------------+-------------+
| скоро истекает срок | is_soon_expired | `#a57020`   |
+---------------------+-----------------+-------------+
| иначе               |                 | `#487cc2`   |
+---------------------+-----------------+-------------+

Если по данной работе имеются непросмотренные уведомления (поле 
`is_new` = true), работа должна быть выделена полужирным, в 
качестве пиктограммы календаря, прогресса должна быть отображена 
соответствующая "жирная" пиктограмма.

Жирное выделение работы снимется тогда, когда пользователь 
просмотрит информацию о ней.

*Примеры плашек работы.*

![Работа на согласовании](resources/img/workflow/elements/work_plashka_na_soglasovanii.png)

![Несогласованная работа](resources/img/workflow/elements/work_plashka_ne_soglasovano.png)

![Утвержденная работа; работа, имеющая дочерние работы; работа с непросмотренными изменениями](resources/img/workflow/elements/work_plashka_approved_and_new_and_subsidiary.png)

![Работа с результатом](resources/img/workflow/elements/work_plashka_result.png)

![Удаленная работа](resources/img/workflow/elements/work_plashka_deleted.png)

![Завершенная работа с прогрессом](resources/img/workflow/elements/work_plashka_done_progress.png)

![Работа по процессу резолюции](resources/img/workflow/elements/work_plashka_resolution.png)

![Работа по процессу резолюции с принятой резолюцией](resources/img/workflow/elements/work_plashka_resolution_1.png)

![Завершенная без принятия резолюции работа по процессу резолюции](resources/img/workflow/elements/work_plashka_resolution_2.png)

**Возможные действия с плашкой работы:**

1.  При выделении плашки (tap) открывается экран с информацией 
    о работе (не зависимо от прав пользователя).

2.  В результате долгого нажатия по плашке возможно появление 
    меню для осуществления дополнительных действий с работой. 
    Набор пунктов меню зависит от прав пользователя на работу. 
    Если нет прав для совершения ни одного действия - меню не 
    отображается. Возможные пункты меню:

    1.  пункт меню "Изменить" (поле can_edit);
    2.  пункт меню "Удалить" (поле can_delete).

**Переходы на другие экраны.**

Чтобы перейти к 
[дочерним работам](#sec.workflow_subsidiary_works), 
пользователь проводит пальцем от правой стороны плашки к 
левой).

По нажатию на кнопку "Фильтры", а также проведя пальцем от 
левой стороны экрана к правой, раскрывается панель 
навигатора [фильтров работ](#sec.workflow_filters).

По нажатию на кнопку "Создать" открывается выпадающий список 
с пунктами 
[создания работы и/или документа](#sec.workflow_create_menu).

По нажатию на плашку работы открывается экран 
[информации о работе](#sec.workflow_workinfo).

Если у пользователя есть права на редактирование работы, в 
результате долгого нажатия по плашке работы появляется меню, 
в котором присутствует 
[пункт "Изменить"](#sec.workflow_work_create).

Если у пользователя есть права на удаление работы, в 
результате долгого нажатия по плашке работы появляется меню, 
в котором присутствует 
[пункт "Удалить"](#sec.workflow_work_delete).

По нажатию на кнопку "Назад":

*   для переключателя "Запомнить меня" со значением "Выкл" - 
    открывается экран [авторизации](#sec.autorise);
*   для переключателя "Запомнить меня" со значением "Вкл" - 
    происходит [закрытие приложения](#sec.app_exit).

> **Примечание**
>
> Метод получения списка работ описан в javadoc:
>
> kz.arta.synergy.server.api.rest.works#getWorks.


