## Внешний модуль "Маркетинг" {#sec.marketing}

### Общее {#marketing.main}

*   Модуль содержит компоненты:

    *   [Воронка лидогенерации](#marketing.pipe)
    *   [Панели стоимости и комиссии](#marketing.cost_comission)
    *   [Боковая панель](#marketing.sidePannel)
        *   [Мероприятие](#marketing.event)
        *   [Пользователи](#marketing.users)
        *   [Фильтры](#marketing.filters)

#### Воронка лидогенерации {#marketing.pipe}

*   Воронка лидогенерации представлена в виде кнопок статусов лида.

*   Статусы лида определяются записями справочника
    [crm_dict_leadStatus](#dictionaryLeadStatus).

*   Кнопки статусов содержат два типа значений:

    *   количество лидов данного статуса;
    *   коэффициент конвертации.

*   Значение отображаются в формате:

    `%название_статуса%`

    `%количество_лидов_статуса% (%коэффициент_конвертации%)`

*   Коэффициент конвертации отсутствует для кнопки первого статуса.

*   Коэффициент конвертации рассчитывается как:

    `количество лидов последующего статуса / количество лидов предыдущего
    статуса * 100%`

*   По нажатию на кнопку статуса лида откроется реестр
    [Лид](#registryLead), отфильтрованный согласно выбранным
    [мероприятиям](#marketing.event), [пользователям](#marketing.users) и статусу.

*   Изменение высоты кнопок, количества лидов и коэффициентов конвертации
    должно происходить в режиме реального времени.

*   Кнопки статусов лидов имеет форму трапеции.

*   Ширина кнопок статична:

    *   максимальная - 450px по наибольшей горизонтальной стороне кнопки;
    *   минимальная - 150px по наименьшей горизонтальной стороне кнопки.

*   Высота кнопок динамична и определяется количеством лидов
    соответствующих статусов.

*   Минимальная высота кнопок - 40px.

*   Максимальная высота всей воронки - 500px.

*   Если воронка содержит один статус, то его кнопка также отображается в
    виде трапеции на максимальную высоту всей воронки.

*   Если не выбран ни один [пользователь](#marketing.users) и ни одно
    [мероприятие](#marketing.event) (при выключенном флаге "Показывать лиды,
    не привязанные к мероприятиям"), воронка отображается пустой:

    *   значения количества лидов и коэффициента конвертации - 0;
    *   кнопки имеют минимальную высоту.

#### Панели стоимости и комиссии {#marketing.cost_comission}

1.  Стоимость лидогенерации в панели - сумма значений компонента
    [Потенциальный бюджет](#formLead) всех лидов текущей воронки.

1.  Комиссия лидогенерации в панели рассчитывается как:

    `стоимость лидогенерации * % комиссии`

    где `% комиссии` - значение поля "% комиссии" первой созданной записи
    реестра [% комиссии](#registryComission).

1.  Значение поля "% комиссии" для каждого отдельного лида идет в расчет
    при совпадении:

    *   указанного периода действия данного процента в записи реестра
        [% комиссии](#registryComission);

    *   даты смены значения в поле "Статус" соответствующей записи реестра
        [Лид](#registryLead).

1.  Если в записи реестра [% комиссии](#registryComission) указано
    несколько записей с одинаковыми датами начала, то в расчет идет
    последний % комиссии, удовлетворяющий требованиям.

#### Боковая панель {#marketing.sidePannel}

*   Изменение значений настроек боковой панели должно сопровождаться
    анимацией загрузки, во время которой все кнопки статусов лидов будут
    недоступны для нажатия.

##### Мероприятие {#marketing.event}

*   Настройка "Мероприятие" представлена компонентом выбора записи реестра
    и флагом "Показывать лиды, не привязанные к мероприятиям".

*   Компонент содержит все записи реестра
    [Маркетинговое мероприятие](#registryEvent), отображаемые в списке.

*   Список записей в компоненте ограничен правами авторизованного
    пользователя:

    *   руководителю отображаются мероприятия, в которых ответственным
        менеджером является он либо его подчиненные;
    *   пользователю отображаются только те мероприятия, в которых
        ответственным менеджером является данный пользователь.

    > **Примечание**
    >
    > Данное требование будет реализовано позднее.

*   Компонент позволяет выбрать:

    *   одно мероприятие;
    *   несколько мероприятий;
    *   все мероприятия;
    *   ни одно мероприятие.

*   Диалог выбора мероприятий выглядит аналогично диалогу выбора
    [записи реестра](http://tdd.lan.arta.kz/docs/synergy/trunk/spec/html/sec.conf_processes.html#sec.conf_form_component_registry_link).

*   Диалог выбора мероприятий дополнительно содержит флаг "Выбрать все".

*   По нажатию на флаг "Выбрать все" выделятся все мероприятия на всех
    страницах компонента.

*   Флаг "Показывать лиды, не привязанные к мероприятиям" определяет
    включение в воронку лидов, для которых компонент
    [Мероприятие](#formLead) пуст.

*   По умолчанию выбраны все мероприятия, флаг "Показывать лиды, не
    привязанные к мероприятиям" включен.

![Диалог выбора мероприятий](resources/img/eventChooser.png)

##### Пользователи {#marketing.users}

*   Настройка представлена компонентом выбора пользователей.

*   Компонент содержит авторизованного пользователя, а также его подчиненных,
    которые входят в группу "Маркетологи".

    > **Примечание**
    >
    > Так как на данный момент отсутствует импорт/экспорт групп, компонент
    > будет отображать только подчиненных руководителя. Ограничение
    > подчиненных согласно группе "Маркетологи" будет реализовано позднее.

*   Компонент позволяет выбрать:

    *   всех пользователей;
    *   нескольких пользователей;
    *   одного пользователя;
    *   ни одного пользователя.

*   По умолчанию выбран авторизованный пользователь.

##### Фильтры {#marketing.filters}

*   Доступно два параметра фильтрации:

    *   Период
    *   Статус лида

*   При фильтрации лидов за период учитывается только факт смены значения
    в поле "Статус" записи реестра [Лид](#registryLead). Если за
    указанный период значение этого поля изменялось несколько раз, то в
    воронку должно войти только последнее.

*   Параметр "Период" представлен выпадающим списком и двумя компонентами
    выбора даты, разделенными тире.

*   Выпадающий список периода содержит пункты:

    *   "За все время" - воронка содержит все лиды с момента создания
        записи реестра до текущего времени на сервере.

    *   "Прошедшая неделя" - учитываются только те лиды, у которых
        изменился статус за последнюю неделю от текущего дня на сервере.

    *   "Прошедший месяц" - учитываются только те лиды, у которых
        изменился статус за последний месяц от текущего дня на сервере.

    *   "Прошедший квартал" - учитываются только те лиды, у которых
        изменился статус за последний квартал от текущего дня на сервере.

    *   "Прошедший год" - учитываются только те лиды, у которых изменился
        статус за последний год от текущего дня на сервере.

    *   "Произвольный период" - учитываются только те лиды, у которых
        изменился статус за указанный пользователем период.

*   Компоненты выбора даты активны только при выбранном пункте
    "Произвольный период".

*   Компоненты выбора даты по умолчанию отображают период за последний
    месяц от текущего дня на сервере.

*   Параметр "Статус" представлен выпадающим списком с пунктами:

    *   "Все";
    *   значение crm_dict_leadStatus_name записи справочника
        [crm_dict_leadStatus](#dictionaryLeadStatus), у которой
        crm_dict_leadStatus_end=1;
    *   значения crm_dict_leadStatus_name всех записей справочника
        [crm_dict_leadStatus](#dictionaryLeadStatus), у которой
        crm_dict_leadStatus_quality=0.

*   Статус "Все" включает в себя все записи справочника
    [crm_dict_leadStatus](#dictionaryLeadStatus) со значением
    crm_dict_leadStatus_quality=1.

*   По умолчанию выбраны период "За все время" и статус "Все".

![Воронка лидогенерации](resources/img/funnel_1.png)

![Пустая воронка лидогенерации](resources/img/funnel_2.png)

![Фильтрация по статусу "Некачественный лид"](resources/img/funnel_3.png)


