Synergy CRM устанавливается отдельным пакетом. Возможные варианты установки:

1. Установка конфигурации CRM без данных (чистая установка)
2. Установка конфигурации CRM с демо-данными
> **Первые  2  варианта удаляют все текущие данные в системе.**
3. Установка конфигурации CRM  Install/Upgrade Configuration
4. Установка конфигурации CRM Manual с загрузкой конфигурации  пользователем

> **Примечание:**
>
> Для работы данного приложения требуется Synergy 3.11 и выше.


# Базовая установка конфигурации CRM {#basic_setting}

В терминале необходимо выполнить следующие команды:

1. Необходимо установить пакет `arta-synergy-apps-crm`:

 `# aptitude install arta-synergy-apps-crm `

2. После этого выйдет окно терминала для выбора вида установки:

![Виды установки CRM](resources/img/install_type.png)

Необходимо выбрать вид установки приложения CRM:

-   **Clean CRM** - это чистая установка, в этом случае будут удалены старые 
    схемы и хранилище, где будет установлена конфигурация CRM.

-   **Demo CRM** - это тоже чистая установка, но также содержит демо-данные.

> **Варианты установки Clean CRM и Demo CRM  удалят все данные пользователя.**

-  **Install/Upgrade Configuration** - установка, в которой автоматически загружает
   конфигурация CRM через API, не удаляя при этом информацию.

-   **Manual** - данная установка не удаляет данные, т.е. без потери информации,
   конфигурация загружается пользователем.



# Установка конфигурации CRM без данных {#crm_without_data}

Выбрав 1 вариант Clean crm, необходимо ввести URL до Synergy, на котором 
производится работа. Например: http://192.168.1.172:8080/Synergy

![Настройки пакета CRM](resources/img/package_configuration2.png)

Далее ввести пароль Mysql - `root`.

## Настройка в подсистеме администрирования и Конфигураторе: {#configure}

Для варианта 1 Clean crm будет загружена база с настроенными:

-   Чистым хранилищем

-   Пользователями:

    - Системный Пользователь Admin (от имени которого будут 
      выполняться сопоставления)

    - Пользователь1- Жуматаев

    - Пользователь2- Муканова

-   Всем разрешен доступ в систему, сгенерированы логины/пароли, прочими 
    свойствами не обладают.

-   Орг.структурой:

    - Организация (подразделение, руководитель отсутствует)

    -     - Отдел маркетинга (подразделение, руководитель Пользователь1)

    -     -     - Специалист по маркетингу (должность, на нее назначен Пользователь2)

-   Дополнительно на "Отдел маркетинга" настроено отображение только следующих модулей:

    - Ежедневник

    - Хранилище -> Реестры

    - Маркетинг

-   Группами:

    - Все маркетологи

    - Маркетологи-менеджеры (Пользователь1)

    - Маркетологи-специалисты (Пользователь2 и Системный Пользователь)

-   Прочими опциями (их значения отличаются от дефолтных):

    - форма завершения "Комментарий": "Требовать подтверждения результата" - нет

    - "Отображать полное ФИО пользователя" - да
    - "Отображать ФИО и должность пользователя на момент подписи в листе подписей" - да

    - "Отображать в ходе исполнения будущие этапы" - да

    - "Требовать ввода комментария при согласовании/утверждении" - да

    - "Требовать ввода комментария при отказе в согласовании/утверждении" - да

    - "Форма завершения по-умолчанию" - Комментарий

    - "Переназначение работ" - везде переназначить работы на непосредственного
       руководителя

    - "Название системы" - ARTA Synergy CRM

    - "Интеграция с почтой" - да (при необходимости, создать произвольные форму и реестр)


Права на реестры настраиваются в Конфигураторе, чтобы они отображались. Заходим в систему 
под пользователем с правами на реестры. Например: Жуматаев - руководитель отдела 
маркетинга (логин - Жуматаев, пароль - Жуматаев). Данный пользователь, отдел настроен по [`Настройка в подсистеме администрирования и Конфигураторе`](#configure)

> **Примечание:**
>
>Настроить "Интеграцию с почтой" - отправка уведомлений, шаблоны документов (коммерческое 
предложение, акт приема-передачи, договоры) заказчикам на почту  (при необходимости, создать 
произвольные форму и реестр). Нужно прописать настройки сервера для отправки и заполнить 
электронные адреса пользователей.

После установки системы необходимо зайти в Основное приложение Synergy и проверить модули. 
При переходе в модуль “Хранилище” должны отображаться реестры, например как на следующем рисунке:

![Хранилище](resources/img/registries.png)

На рисунке показано, как должна выглядеть система, если кликнуть на верхней 
панели модуля Маркетинг, т.к данных нет, во всех данных нулевые значения. 

![Маркетинг](resources/img/marketing.png)

Если отображается серое окно, значит при установке были допущены ошибки.Подробнее все ошибки 
рассмотрены в разделе - [`Устранение неполадок`](#Troubleshooting)


# Установка конфигурации CRM с демо-данными {#crm_with_demo}

Для варианта 2 (**Demo CRM**), в дополнение к варианту 1, будет загружены
схемы и хранилище, которое будет содержать демо-данные, т.е. записи в каждом реестре и 
соответствующая им воронка и канбан. 


# Установка конфигурации CRM - Install/Upgrade Configuration {#Install_Upgrade}

Данный вариант установки Install/Upgrade Configuration отличается от других видов тем, 
что автоматически загружается конфигурация через API, не удаляя при этом информацию 
пользователя. 

> В терминале выполняются следующие команды:

1. Перед установкой проверьте подключенные репозитории, ознакомиться по следующей 
[`ссылке`](http://tdd.lan.arta.kz/docs/synergy/trunk/admin-manual/html/install-and-setup.html#install-and-setup.internet.repos)


2. Необходимо установить пакет CRM arta-synergy-apps-crm на сервер.
Для этого выполним команду:

   # aptitude install arta-synergy-apps-crm

3. Выбрать 3 вид установки

![Виды установки CRM](resources/img/install_type.png)

4. Далее необходимо ввести URL до Synergy, на котором производится работа.
Например: http://192.168.1.172:8080/Synergy.

5. Ввести логин и пароль пользователя с доступом на Конфигуратор.

6. Создать в Административном приложении системного пользователя от имени которого, будут выполняться все сопоставления реестров в Synergy.

7. Перейти  в  файл crm.properties, который находится- 
/opt/synergy/jboss/standalone/configuration/arta/apps/crm/crm.properties и добавить следующее содержимое:

```xml
synergy.address=http://localhost:8080/Synergy
user.login=логин
user.password=пароль
```

Указать логин/пароль системного пользователя , созданного в пункте 6.

8. Для примера предлагаем следующие настройки [`Настройка в подсистеме администрирования и Конфигураторе`](#configure)

9. Настроить права на внешний модуль нужным пользователям в организационной  структуре в Подсистеме администрирования.

10. Должны быть настроены права на следующие реестры:

+---------------------------+-----------------------+----------------------+
| **Реестр**                | **Группа**            | **Права**            |
+===========================+=======================+======================+
| Маркетинговые мероприятия | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+
| Лиды                      | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+
| Сделки                    | Все маркетологи       | Просмотр списка,     |
|                           |                       | Просмотр данных,     |
|                           |                       | Создание, Изменение, |
|                           |                       | Редактирование       |
+---------------------------+-----------------------+----------------------+
| Аккаунты                  | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+
| Контакты                  | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+
| % комиссии                | Маркетологи-менеджеры | Просмотр списка,     |
|                           |                       | Просмотр данных,     |
|                           |                       | Изменение,           |
|                           |                       | Редактирование       |
+---------------------------+-----------------------+----------------------+
| Темы сотрудничества       | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+
| Каталог товаров и услуг   | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+
| Прайс-лист                | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+
| Договоры поставки         | Все маркетологи       | Все                  |
| (единовременная оплата)   |                       |                      |
+---------------------------+-----------------------+----------------------+
| Договоры поставки         | Все маркетологи       | Все                  |
| (оплата частями)          |                       |                      |
+---------------------------+-----------------------+----------------------+
| Акты приема-передачи      | Все маркетологи       | Все                  |
| товара                    |                       |                      |
+---------------------------+-----------------------+----------------------+
| Коммерческое предложение  | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+



> **Примечание:**
>
> Данные настройки создаются только для начальной установки CRM, для обновления 
приложения не применяются.


# Установка конфигурации CRM с загрузкой пользователем - Manual {#crm_manual}

Чтобы установить CRM систему на сервер без потери данных необходимо выполнить 
следующие шаги:

1. Загрузить конфигурацию в Конфигуратор по адресу,расположенному  /opt/synergy/apps/crm/crm_configuration.xml с того компьютера, где установлен пакет arta-synergy-apps-crm
2. Добавить внешний модуль в Конфигураторе  с адресом `http://host:port/crm`, 
в нашем случае - `http://192.168.1.124:8080/crm`

![Внешний модуль](resources/img/external_module.png)


> **Примечание:**
>
>Добавить и настроить права пользователям на реестры CRM  в Конфигураторе для их отображения 
в пользовательской части системы для модуля Хранилище.   Все настройки по правам пользователя 
указаны в пункте - Настройка в подсистеме администрирования и Конфигураторе.
Сопоставление полей реестров можно посмотреть [`ссылка:`](http://tdd.lan.arta.kz/docs/cases/crm/spec/html/sec.crm_conf_consist.html#user_components.matching)


# Устранение неполадок {#Troubleshooting}

1. **Проблема:** в модуле "Маркетинг" ничего не отображается

**Возможная причина:** при установке неправильно указан URL для Synergy

**Пути устранения:** dpkg-reconfigure arta-synergy-apps-crm или исправить настройки в 
Конфигураторе

2. **Проблема:** нет реестров у пользователя

**Возможная причина:** не настроены права для реестров в Конфигураторе 

**Пути устранения:** необходимо настроить права пользователю на все реестры CRM,
который будет указан в настройках файла crm.properties, так как от имени данного 
пользователя происходят сохранение данных в реестрах при сопоставлении и если прав нет, 
сохранение данных форм реестров не  произойдет. Необходимо проверить  настройки файла,
находящегося - `/opt/synergy/jboss/standalone/configuration/arta/apps/crm/crm.properties`. 
Файл должен содержать следующие данные:

```xml
synergy.address=http://localhost:8080/Synergy
	user.login=логин
	user.password=пароль
```


