### Формы {#forms}

*   [Маркетинговое мероприятие](#formEvent)
*   [Лид](#formLead)
*   [Сделка](#formDeal)
*   [Аккаунт](#formAccount)
*   [Контакт](#formContact)
*   [% комиссии лидогенерации](#formComission)
*   [% комиссии продаж](#formDealComission)
*   [Тема сотрудничества](#formTheme)
*   [Товар (услуга)](#formItem)
*   [Цена](#formPrice)
*   [Договор поставки (единовременная оплата)](#formContractDeliveryAll)
*   [Договор поставки (оплата частями)](#formContractDeliveryPart)
*   [Коммерческое предложение](#formOffer)
*   [Акт приема-передачи товара](#formCertificate)
*   [Счет-фактура](#formInvoice)
*   [Ответственный за сделки](#formDealResponsible)
*   [План продаж](#formSalesCost)
*   [Нормативы продолжительности статусов сделки](#formDealFlowStandard)

#### Маркетинговое мероприятие {#formEvent}

Код формы: crm_form_event.

Форма содержит следующие компоненты:

+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                                | Имя компонента                                         |
+========================================================+===============================================================+========================================================+
| **Тип мероприятия**                                    | выпадающий список (справочник *crm_dict_eventType*)           | crm_form_event_main_type                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Наименование мероприятия**                           | однострочное поле                                             | crm_form_event_main_name                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Стоимость**                                          | числовое поле                                                 | crm_form_event_main_cost                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Мероприятие**                                        | ссылка на портфель / проект                                   | crm_form_event_main_event                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Комментарий**                                        | многострочное поле                                            | crm_form_event_main_comment                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Целевой отклик**                                     | числовое поле                                                 | crm_form_event_main_target_response                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Текущий отклик**                                     | числовое поле                                                 | crm_form_event_main_current_response                   |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Оценка эффективности**                               | числовое поле                                                 | crm_form_event_main_rating                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Ответственный менеджер**                             | выбор пользователя                                            | crm_form_event_responsibleManager_responsible          |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+

*Поле "Текущий отклик"*:

*   Флаг "Заблокировать от изменений пользователем" включен.

*   Значение поля - количество всех лидов, связанных с данным мероприятием.

*   Если для данного мероприятия не имеется лидов, поле содержит значение 0.

*   При добавлении, изменении или удалении лида, связанного с данным
    мероприятием, значение поля "Текущий отклик" обновляется в режиме
    реального времени.

*Поле "Оценка эффективности"*:

*   Флаг "Заблокировать от изменений пользователем" включен.

*   Флаг "Ограничение десятичных знаков" включен. Значение поля - 3.

*   Значение поля рассчитывается автоматически по формуле:

    `%значение_поля_"Текущий_отклик"% / %значение_поля_"Целевой_отклик"%`

*   Поле "Оценка эффективности" не может быть пустым.

*   Поле "Оценка эффективности" заполнено значением 0 по умолчанию, а также
    в случае:
    *   поле "Целевой отклик" не заполнено либо содержит значение 0
    *   поле "Текущий отклик " содержит значение 0

*   При изменении значений полей "Текущий отклик" и "Целевой отклик"
    значение поля "Оценка эффективности" пересчитывается в режиме реального
    времени.

#### Лид {#formLead}

Код формы: crm_form_lead.

Форма содержит следующие компоненты:

+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                                | Имя компонента                                         |
+========================================================+===============================================================+========================================================+
| **Мероприятие**                                        | ссылка на реестр "Маркетингоое мероприятие"                   | crm_form_lead_main_action                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Источник лида**                                      | ссылка на реестр "Контакт"                                    | crm_form_lead_main_leadSource                          |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Сделка**                                             | ссылка на реестр "Сделка"                                     | crm_form_lead_main_deal                                |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Контакт**                                            | пользовательский компонент на реестр "Контакт"                | crm_form_lead_main_contact                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Связь с контактом из интерфейса**                    | пользовательский компонент функции связи с контактом          | crm_form_lead_main_contactConnection                   |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Аккаунт**                                            | пользовательский компонент на реестр "Аккаунт"                | crm_form_lead_main_account                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Связь с контактом из интерфейса**                    | пользовательский компонент функции связи с аккаунтом          | crm_form_lead_main_accountConnection                   |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Наименование аккаунта**                              | однострочное поле                                             | crm_form_lead_main_account_name                        |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Сотрудничество**                                     | динамическая таблица                                          | crm_form_lead_deals                                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества                                    | ссылка на реестр "Темы сотрудничества"                        | crm_form_lead_deals_theme                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Потенциальный бюджет                                   | числовое поле                                                 | crm_form_lead_deals_budget                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Статус                                                 | выпадающий список (справочник "crm_dict_dealStatus")          | crm_form_lead_deals_status                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| %кнопка_создания_сделки%                               | пользовательский компонент                                    | crm_form_lead_deals_newDeal                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Ответственный менеджер**                             | выбор пользователя                                            | crm_form_lead_responsibleManager_responsible           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Активность**                                         | пользовательская динамическая таблица                         | crm_form_lead_activity_table                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Пиктограмма типа активности                            | изображение (из справочника "crm_dict_activityType")          | crm_form_lead_activity_icon                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Тип активности                                         | выпадающий список (справочника "crm_dict_activityType")       | crm_form_lead_activity_type                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Комментарий                                            | однострочное поле                                             | crm_form_lead_activity_comment                         |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Дата                                                   | дата                                                          | crm_form_lead_activity_date                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+

*Поле "Сделка"*:

*   Флаг "Заблокировать от изменений пользователем" включен.

*   По умолчанию поле пустое.

*%кнопка_создания_сделки%*:

*   Кнопка не отображается, если в выпадающем списке "Статус" выбрана запись
    справочника [crm_dict_leadStatus](#dictionaryLeadStatus), у которой
    crm_dict_leadStatus_end=1.

*Поле "Пиктограмма типа активности"*:

*   текущее изображение зависит от выбранного значения в выпадающем списке
    "Тип активности" согласно полю crm_dict_activityType_icon справочника
    [crm_dict_activityType](#dictionaryActivityType).

*Поле "Дата"*:

*   Флаг "Заполнять текущей датой/временем" включен.

*Поле "Наимменованеи аккаунта"*:

*   Компонент является скрытым.

*   Компонент может содержать пустое значение.

*   При создании либо выборе аккаунта в модифицированном
    пользовательском компоненте ["Аккаунт"](#formLead)
    (`crm_form_lead_main_account`) новый компонент заполняется
    значением соответствующего поля
    ["Наименование"](#formAccount).

*   При изменении значения аккаунта обновляется и значение
    нового компонента.

*   При создании записи реестра "Сделка" путем смены статуса
    или нажатием на [кнопку](http://tdd.lan.arta.kz/docs/cases/crm/spec/html/sec.crm_conf_consist.html#user_components.button)
    поле crm_form_deal_responsibleManager_responsible по
    умолчанию заполняется пользователем, указанным в первой
    записи реестра "Ответственный за сделки".

#### Сделка {#formDeal}

Код формы: crm_form_deal.

Форма содержит следующие компоненты:

+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                                | Имя компонента                                         |
+========================================================+===============================================================+========================================================+
| **Лид**                                                | ссылка на реестр "Лид"                                        | crm_form_deal_main1_lead                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Тема**                                               | ссылка на реестр "Темы сотрудничества"                        | crm_form_deal_main2_theme                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Описание**                                           | многострочное поле                                            | crm_form_deal_main2_info                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Заказ**                                              | динамическая таблица                                          | crm_form_deal_order                                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
|   №                                                    | однострочное поле                                             | crm_form_deal_order_number                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
|   Наименование товара                                  | ссылка на реестр "Прайс-лист"                                 | crm_form_deal_order_orderList                          |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
|   Ед.изм.                                              | однострочное поле                                             | crm_form_deal_order_unit                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
|   Количество                                           | числовое поле                                                 | crm_form_deal_order_amount                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
|   Цена за ед.                                          | числовое поле                                                 | crm_form_deal_order_price                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
|   Сумма, тенге                                         | числовое поле                                                 | crm_form_deal_order_total                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Бюджет**                                             | числовое поле                                                 | crm_form_deal_main3_budget                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Статус**                                             | выпадающий список (справочник "crm_dict_dealStatus")          | crm_form_deal_main3_status                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Причина отказа                                         | многострочное поле                                            | crm_form_deal_main3_rejection                          |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Задачи**                                             | динамическая таблица                                          | crm_form_deal_tasks                                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Проект                                                 | ссылка на проект                                              | crm_form_deal_tasks_project                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Документы**                                          | динамическая таблица                                          | crm_form_deal_files                                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Файл                                                   | файл                                                          | crm_form_deal_files_file                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Ответственный менеджер**                             | выбор пользователя                                            | crm_form_deal_responsibleManager_responsible           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Активность**                                         | пользовательская динамическая таблица                         | crm_form_deal_activity_table                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Пиктограмма типа активности                            | изображение (из справочника "crm_dict_activityType")          | crm_form_deal_activity_icon                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Тип активности                                         | выпадающий список (справочника "crm_dict_activityType")       | crm_form_deal_activity_type                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Комментарий                                            | однострочное поле                                             | crm_form_deal_activity_comment                         |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Дата                                                   | дата                                                          | crm_form_deal_activity_date                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Предыдущий статус**                                  | выпадающий список (справочник «crm_dict_dealStatus»)          | crm_form_deal_previous_status                          |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Время нахождения в статусе**                         | числовое поле                                                 | crm_form_deal_previous_status_duration                 |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Просроченность**                                     | числовое поле                                                 | crm_form_deal_expired                                  |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Переход в негативный статус**                        | числовое поле                                                 | crm_form_deal_refused                                  |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Год**                                                | числовое поле                                                 | crm_form_deal_order_sales_year                         |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Месяц**                                              | выпадающий список (справочник "crm_dict_months")              | crm_form_deal_order_sales_month                        |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Отделение**                                          | компонент выбора подразделений                                | crm_form_deal_sales_pk1                                |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Конечный положительный статус**                      | числовое поле                                                 | crm_form_deal_end                                      |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+

*Поле "Лид"*:

*   Флаг "Заблокировать от изменений пользователем" включен.

*Поле "Сумма"*:

*   Значение поля рассчитывается как:

    `%стоимость_в_прайс-листе% * crm_form_deal_order_orderAmount`

*   Флаг "Заблокировать от изменений пользователем" включен.

*Поле "Бюджет"*:

*   Флаг "Заблокировать от изменений пользователем" включен.

*   Значение поля - сумма значений всех полей "Сумма".

*Поле "Причина отказа"*:

*   Поле отображается только в случае, если поле "Статус" имеет значение
    "Отказ".

*Поле "Пиктограмма типа активности"*:

*   текущее изображение зависит от выбранного значения в выпадающем списке
    "Тип активности" согласно полю crm_dict_activityType_icon справочника
    [crm_dict_activityType](#dictionaryActivityType).

*Поле "Дата"*:

*   Флаг "Заполнять текущей датой/временем" включен.

*Поле "Предыдущий статус"*:

*   Значение поля - предыдущее значение поля "Статус" (crm_form_deal_main3_status).

*   Если статус сделки ранее не изменялся - поле содежит текущее значение
    поля "Статус" (crm_form_deal_main3_status).

*   Значение компонента актуализируется в 00:00:00.

*   Компонент скрыт.

*Поле "Время нахождения в статусе"*:

*   Значение поля рассчитывается как:

    `дата и время сохранения текущего статуса - дата и время сохранения предыдущего статуса`

*   Если статус сделки ранее не изменялся - поле содержит значение "0".

*   Значение компонента актуализируется в 00:00:00.

*   Компонент скрыт.

*Поле "Просроченность"*:

*   Поле не может быть пустым.

*   Просроченность для сделки со статусом, имеющим значение
    crm_dict_dealStatus_end=1 или crm_dict_dealStatus_quality=0, не
    рассчитывается, поле содержит значение "0".

*   Значение поля определется условиями:

    *   фактическое время нахождения в статусе больше либо равно значению
        поля "Продолжительность (в днях)"
        (crm_form_deal_flow_standart_duration) соответствующего статуса.

    *   суммарное время нахождения в неконечных статусах больше либо равно
        сумме значений полей
        "Продолжительность (в днях)"
        (crm_form_deal_flow_standart_duration) всех неконечных статусов.

        > **Примечание:**
        >
        > * Для предрасчетов просроченности используется первая запись реестра
        >   "Нормативы продолжительности статусов сделки".
        >  
        > * Если документ по форме имеет несколько значений "Продолжительность
        >   (в днях)" для одного статуса, в предрасчет идет последнее.
        >
        > * Если для статуса не указано значение "Продолжительность (в днях)"
        >   в предрасчет идет значение поля "Продолжительность по умолчанию
        >   (в днях)" (crm_form_deal_flow_standard_default_duration).
        >
        > * При смене статуса на предыдущий (согласно полю crm_dict_dealStatus_value
        >   справочника Статусы сделки) все
        >   продолжительности статусов аннулируются до того статуса, который
        >   будет являться предыдущим относительного нового.


*   Если выполняется хотя бы одно условие, описанное выше, то поле
    "Просроченность" содержит значение "1".

*   Если не выполняется ни одно условие, описанное выше, то поле
    "Просроченность" содержит значение "0".

*   Значение компонента актуализируется в 00:00:00.

*   Компонент скрыт.

*Поле "Переход в негативный статус"*:

*   Поле не может быть пустым.

*   Значение поля определется текущим статусом:

    *   Если выпадающий список "Статус сделки" имеет значение записи
        справочника [Статусы сделки](#dictionaryDealStatus)
        crm_dict_dealStatus_quality=0, поле "Переход в негативный статус"
        содержит значение 1.

    *   Если выпадающий список "Статус сделки" имеет значение записи
        справочника [Статусы сделки](#dictionaryDealStatus)
        crm_dict_dealStatus_quality=1, поле "Переход в негативный статус"
        содержит значение 0.

*   Значение компонента актуализируется в 00:00:00.

*   Компонент скрыт.

*Поле "Год":*

*   Поле скрыто.

*   Значение поля - год последнего изменения статуса сделки.

*Поле "Месяц":*

*   Поле скрыто.

*   Значение поля - месяц последнего изменения статуса сделки.

*Поле "Отделение":*

*   Флаги "Обязательное поле" и "Заполнять департаментом создающего
    пользователя" включен.

*Поле "Конечный положительный статус":*

*   Поле скрыто.

*   Значение поля:

    *   1 - текущий статус сделки имеет значение crm_dict_dealStatus_end=1;
    *   0 - все остальные статусы.

#### Аккаунт {#formAccount}

Код формы: crm_form_account.

Форма содержит следующие компоненты:

+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                           | Имя компонента                                         |
+========================================================+==========================================================+========================================================+
| **Лид**                                                | ссылка на реестр "Лид"                                   | crm_form_account_lead_lead                             |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Логотип**                                            | файл                                                     | crm_form_account_logo                                  |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Наименование**                                       | однострочное поле                                        | crm_form_account_main_name                             |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Описание**                                           | многострочное поле                                       | crm_form_account_main_info                             |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Вид деятельности**                                   | дата                                                     | crm_form_account_main_activityCategory                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Выручка**                                            | числовое поле                                            | crm_form_account_main_revenue                          |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Численность штата**                                  | многострочное поле                                       | crm_form_account_main_staffAmount                      |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Статус**                                             | выпадающий список (справочник *crm_dict_accountStatus*)  | crm_form_account_main_status                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Телефон**                                            | динамическая таблица                                     | crm_form_account_phone                                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип номера телефона                                    | выпадающий список (справочник *crm_dict_phone*)          | crm_form_account_phone_phoneCombo                      |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Номер телефона                                         | однострочное поле                                        | crm_form_account_phone_phone                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **E-mail**                                             | динамическая таблица                                     | crm_form_account_email                                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип почтового адреса                                   | выпадающий список (справочник *crm_dict_email*)          | crm_form_account_email_emailCombo                      |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Почтовый адрес                                         | однострочное поле                                        | crm_form_account_email_email                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Адрес**                                              | динамическая таблица                                     | crm_form_account_address                               |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип адреса                                             | выпадающий список (справочник *crm_dict_address*)        | crm_form_account_address_addressCombo                  |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Адрес                                                  | многострочное поле                                       | crm_form_account_address_address                       |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Социальные сети**                                    | динамическая таблица                                     | crm_form_account_socialNetworks                        |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип социальной сети                                    | выпадающий список (справочник *crm_dict_socialNetworks*) | crm_form_account_socialNetworks_socialNetworksCombo    |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Социальная сеть                                        | однострочное поле                                        | crm_form_account_socialNetworks_socialNetworks         |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Материнский аккаунт**                                | ссылка на реестр *Аккаунт*                               | crm_form_account_parentAccount_parentAccount           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Дочерние аккаунты**                                  | динамическая таблица                                     | crm_form_account_childAccount                          |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Аккаунты                                               | ссылка на реестр *Аккаунт*                               | crm_form_account_childAccount_account                  |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Ответственный менеджер**                             | выбор пользователя                                       | crm_form_account_responsibleManager_responsible        |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+

#### Контакт {#formContact}

Код формы: crm_form_contact.

Форма содержит следующие компоненты:

+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                           | Имя компонента                                         |
+========================================================+==========================================================+========================================================+
| **Лид**                                                | ссылка на реестр "Лид"                                   | crm_form_contact_lead_lead                             |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Фото**                                               | файл                                                     | crm_form_contact_photo                                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Полное имя**                                         | однострочное поле                                        | crm_form_contact_main_fullName                         |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Должность**                                          | многострочное поле                                       | crm_form_contact_main_position                         |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Дата рождения**                                      | дата                                                     | crm_form_contact_main_birthDate                        |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Статус**                                             | выпадающий список (справочник *crm_dict_contactStatus*)  | crm_form_contact_main_status                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Информация**                                         | многострочное поле                                       | crm_form_contact_main_info                             |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Телефон**                                            | динамическая таблица                                     | crm_form_contact_phone                                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип номера телефона                                    | выпадающий список (справочник *crm_dict_phone*)          | crm_form_contact_phone_phoneCombo                      |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Номер телефона                                         | однострочное поле                                        | crm_form_contact_phone_phone                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **E-mail**                                             | динамическая таблица                                     | crm_form_contact_email                                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип почтового адреса                                   | выпадающий список (справочник *crm_dict_email*)          | crm_form_contact_email_emailCombo                      |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Почтовый адрес                                         | однострочное поле                                        | crm_form_contact_email_email                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Адрес**                                              | динамическая таблица                                     | crm_form_contact_address                               |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип адреса                                             | выпадающий список (справочник *crm_dict_address*)        | crm_form_contact_address_addressCombo                  |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Адрес                                                  | многострочное поле                                       | crm_form_contact_address_address                       |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Социальные сети**                                    | динамическая таблица                                     | crm_form_contact_socialNetworks                        |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип социальной сети                                    | выпадающий список (справочник *crm_dict_socialNetworks*) | crm_form_contact_socialNetworks_socialNetworksCombo    |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Социальная сеть                                        | однострочное поле                                        | crm_form_contact_socialNetworks_socialNetworks         |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Ответственный менеджер**                             | выбор пользователя                                       | crm_form_contact_responsibleManager_responsible        |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+

#### % комиссии лидогенерации {#formComission}

Код формы: crm_form_lead_comission.

Форма содержит следующие компоненты:

+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                         | Имя компонента                                         |
+========================================================+========================================================+========================================================+
| **% комссии**                                          | динамическая таблица                                   | crm_form_lead_comission_main                           |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Дата начала                                            | дата                                                   | crm_form_lead_comission_main_start_date                |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Дата окончания                                         | дата                                                   | crm_form_lead_comission_main_finish_date               |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| % комиссии                                             | числовое поле                                          | crm_form_lead_comission_main_comission                 |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+

*Динамическая таблица "% комиссии"*:

*   Форматная строка:

    `[Значение ${crm_form_comission_main_deal_comission}% с ${crm_form_lead_comission_main_start_date} по ${crm_form_lead_comission_main_finish_date}]`

*Поле "Дата начала"*:

*   Флаги "Заблокировать от изменений пользователем" и "Заполнять текущей
    датой/временем" включены.

*Поле "Дата окончания"*:

*   Флаг "Заблокировать от изменений пользователем" включен.

*   Компонент в последней строке заполняется текущей датой при добавлении
    новой строки динамической таблицы.

*Поле "% комиссии"*:

*   Значение поля по умолчанию при создании записи реестра - *5*.

#### % комиссия продаж {#formDealComission}

Код формы: crm_form_deal_comission.

Форма содержит следующие компоненты:

+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                         | Имя компонента                                         |
+========================================================+========================================================+========================================================+
| **% комссии**                                          | динамическая таблица                                   | crm_form_deal_comission_main                           |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Дата начала                                            | дата                                                   | crm_form_deal_comission_main_start_date                |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Дата окончания                                         | дата                                                   | crm_form_deal_comission_main_finish_date               |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| % комиссии                                             | числовое поле                                          | crm_form_deal_comission_main_comission                 |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+

*Динамическая таблица "% комиссии"*:

*   Форматная строка:

    `[Значение ${crm_form_comission_main_deal_comission}% с ${crm_form_deal_comission_main_start_date} по ${crm_form_deal_comission_main_finish_date}]`

*Поле "Дата начала"*:

*   Флаги "Заблокировать от изменений пользователем" и "Заполнять текущей
    датой/временем" включены.

*Поле "Дата окончания"*:

*   Флаг "Заблокировать от изменений пользователем" включен.

*   Компонент в последней строке заполняется текущей датой при добавлении
    новой строки динамической таблицы.

*Поле "% комиссии"*:

*   Значение поля по умолчанию при создании записи реестра - *5*.

#### Тема сотрудничества {#formTheme}

Код формы: crm_form_theme.

Форма содержит следующие компоненты:

+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                         | Имя компонента                                         |
+========================================================+========================================================+========================================================+
| Тема сотрудничества                                    | однострочное поле                                      | crm_form_theme_theme                                   |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+

#### Товар (услуга) {#formItem}

Код формы: crm_form_item.

Форма содержит следующие компоненты:

+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                                | Имя компонента                                         |
+========================================================+===============================================================+========================================================+
| ID товара                                              | номер (шаблон номера "Номер товара в каталоге")               | crm_form_item_id                                       |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Наименование                                           | однострочное поле                                             | crm_form_item_name                                     |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Описание                                               | многострочное поле                                            | crm_form_item_description                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+

#### Цена {#formPrice}

Код формы: crm_form_price.

Форма содержит следующие компоненты:

+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                                | Имя компонента                                         |
+========================================================+===============================================================+========================================================+
| Товар                                                  | ссылка на реестр "Каталог товаров и услуг"                    | crm_form_price_item_name                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Описание                                               | многострочное поле                                            | crm_form_price_description                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Единица измерения                                      | однострочное поле                                             | crm_form_price_unit                                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Цена                                                   | числовое поле                                                 | crm_form_price_price                                   |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+

Для компонента "Товар" настроено сопоставление:

*   `crm_form_item_description` - `crm_form_price_description` - `EQUAL`.

#### Формы шаблонов документов {#formsTemplates}

Для всех форм ниже одинаково настроен **компонент выбора адресата**:

***Для выпадающего списка "Источник адреса" настроены следующие значения:***

*   Аккаунт - 0

*   Контакт - 1

*   Ручной ввод - 2

При этом:

*	Если в поле *`choice`* выбрано значение "Аккаунт", то доступно поле
`account_link`, поле `contact_link` скрыто.

*	Если в поле *`choice`* выбрано значение "Контакт", то доступно поле
`contact_link`, поле `account_link` скрыто.

*	Если в поле *`choice`* выбрано значение "Ручной ввод", то поля
`account_link` и `contact_link` оба скрыты.

***Для компонента "Выбрать аккаунт" настроено сопоставление:***

*   `crm_form_account_email` - `crm_form_account_email` - `EQUAL`

***Для компонента "Выбрать контакт" настроено сопоставление:***

*   `crm_form_contact_email` - `crm_form_contact_email` - `EQUAL`

Таблицы "Адреса аккаунта" и "Адреса контакта" являются служебными
и не отображаются пользователю.

***Поведение поля `choice`***

Если в поле *`choice`* выбрано значение "Аккаунт", то должно быть доступно
поле `account_link`, поле `contact_link` скрыто.

Если в поле *`choice`* выбрано значение "Контакт", то должно быть доступно
поле `contact_link`, поле `account_link` скрыто.

Если в поле *`choice`* выбрано значение "Ручной ввод", то поля `account_link`
и `contact_link` должны быть скрыты.

***Поведение поля `email`***

1. Для случая, когда заполняется поле `account_link`, в поле *`email`* требуется
отображать значение поля *`crm_form_contact_email.crm_form_contact_email_email`*.
В случае, если таблица *`crm_form_contact_email`* для выбранного контакта содержит
больше одного элемента, выбирать значение в зависимости от значения поля
*`crm_form_contact_email.crm_form_contact_email_emailCombo`* по значение с минимальным
порядковым номером записи справочника crm_dict_email.

2. Для случая, когда заполняется поле `contact_link`, в поле *`email`* требуется
отображать значение поля *`crm_form_account_email.crm_form_account_email_email`*.
В случае, если таблица *`crm_form_account_email`* для выбранного контакта содержит
больше одного элемента, выбирать значение в зависимости от значения поля
*`crm_form_account_email.crm_form_account_email_emailCombo`* тем же приоритетам,
что и для пункта 1.

3. Для случая, когда в поле *`choice`* выбрано значение "Ручной ввод", поле *`email`*
должно заполняться вручную.

##### Договор поставки (единовременная оплата) {#formContractDeliveryAll}

Код формы: crm_form_contract_delivery_100.

Форма содержит следующие компоненты:

+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Поле                             | Тип компонента                                    | Имя компонента                                         |
+==================================+===================================================+========================================================+
| **Номер договора**               | однострочное поле                                 | crm_form_contract_delivery_100_contract_number         |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Город**                        | выпадающий список (справочник crm_dict_cities)    | crm_form_contract_delivery_100_city_from               |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата договора**                | выбор даты                                        | crm_form_contract_delivery_100_contract_date           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Основание (сделка)**           | ссылка на реестр "Сделки"                         | crm_form_contract_delivery_100_deal                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Заказчик (аккаунт)**           | ссылка на реестр "Аккаунты"                       | crm_form_contract_delivery_100_client_account          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Заказчик (контакт)**           | ссылка на реестр "Контакты"                       | crm_form_contract_delivery_100_client_client           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Основание заказчика**          | однострочное поле                                 | crm_form_contract_delivery_100_client_reason           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Поставщик (организация)**      | выбор подразделений (всегда выбрана корневая нода)| crm_form_contract_delivery_100_provider                |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Представитель поставщика**     | выбор пользователя                                | crm_form_contract_delivery_100_provider_name           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Основание поставщика**         | однострочное поле                                 | crm_form_contract_delivery_100_provider_base           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Товар**                        | однострочное поле (тема сотрудничества из         | crm_form_contract_delivery_100_theme                   |
|                                  | выбранной записи в поле "Основание (сделка))"     |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Срок поставки товара**         | числовое поле                                     | crm_form_contract_delivery_100_time                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Срок поставки (прописью)**     | однострочное поле                                 | crm_form_contract_delivery_100_time_by_text            |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Город поставки**               | выпадающий список (справочник crm_dict_cities)    | crm_form_contract_delivery_100_city_to                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адрес**                        | однострочное поле                                 | crm_form_contract_delivery_100_address                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Общая сумма договора**         | числовое поле                                     | crm_form_contract_delivery_100_sum_total               |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Сумма договора (прописью)**    | однострочное поле                                 | crm_form_contract_delivery_100_sum_total_by_text       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Срок предоставления Акта**     | числовое поле                                     | crm_form_contract_delivery_100_act_time                |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Срок действия договора**       | выбор даты                                        | crm_form_contract_delivery_100_contract_time_to        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Юридический адрес Заказчика**  | многострочное поле                                | crm_form_contract_delivery_100_client_requisites1      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Юридический адрес Поставщика** | многострочное поле                                | crm_form_contract_delivery_100_provider_requisites1    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Реквизиты Заказчика**          | ссылка                                            | crm_form_contract_delivery_100_client_requisites2      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Реквизиты Поставщика**         | многострочное поле                                | crm_form_contract_delivery_100_provider_requisites2    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора (приложение)**  | однострочное поле                                 | crm_form_contract_delivery_100_contract_number_appendix|
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата договора (приложение)**   | выбор даты                                        | crm_form_contract_delivery_100_contract_date_appendix  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Перечень закупаемых товаров**  | динамическая таблица (из группы полей "Заказ"     | crm_form_contract_delivery_100_items                   |
|                                  | сделки, указанной в поле "Основание (сделка)")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   №                              | однострочное поле                                 | crm_form_deal_order_number                             |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Наименование Товара            | ссылка на реестр "Прайс-лист"                     | crm_form_deal_order_orderList                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Ед.изм.                        | однострочное поле                                 | crm_form_deal_order_unit                               |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Кол-во                         | числовое поле                                     | crm_form_deal_order_amount                             |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Цена за ед., тенге             | числовое поле                                     | crm_form_deal_order_price                              |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Сумма, тенге                   | числовое поле                                     | crm_form_deal_order_total                              |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Итого**                        | числовое поле                                     | crm_form_contract_delivery_100_items_total             |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Подпись заказчика**            | ссылка на реестр "Контакты"                       | crm_form_contract_delivery_100_client_account_appendix |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Подпись поставщика**           | выбор пользователя                                | crm_form_contract_delivery_100_provider_name_appendix  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Источник адреса**              | выпадающий список                                 | choice                                                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выбрать аккаунт**              | ссылка на реестр "Аккаунты"                       | account_link                                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выбрать контакт**              | ссылка на реестр "Контакты"                       | contact_link                                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **E-mail**                       | однострочное поле                                 | email                                                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адреса аккаунта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_account_email                                 |
|                                  | аккаунта, указанного в поле "Выбрать аккаунт")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Актуальный адрес аккаунта**    | однострочное поле                                 | crm_form_account_email_email                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адреса контакта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_contact_email                                 |
|                                  | контакта, указанного в поле "Выбрать контакт")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Актуальный адрес контакта**    | однострочное поле                                 | crm_form_contact_email_email                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+

*Компоненты выбора даты*:

*   Формат даты всех компонентов выбора дат - `"${dd}" ${monthed} ${yyyy}г.`

##### Договор поставки (оплата частями) {#formContractDeliveryPart}

Код формы: crm_form_contract_delivery_part.

Форма содержит следующие компоненты:

+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| Поле                             | Тип компонента                                    | Имя компонента                                           |
+==================================+===================================================+==========================================================+
| **Номер договора**               | однострочное поле                                 | crm_form_contract_delivery_part_contract_number          |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Город**                        | выпадающий список (справочник crm_dict_cities)    | crm_form_contract_delivery_part_city_from                |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Дата договора**                | выбор даты                                        | crm_form_contract_delivery_part_contract_date            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Основание (сделка)**           | ссылка на реестр "Сделки"                         | crm_form_contract_delivery_part_deal                     |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Заказчик (аккаунт)**           | ссылка на реестр "Аккаунты"                       | crm_form_contract_delivery_part_client_account           |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Заказчик (контакт)**           | ссылка на реестр "Контакты"                       | crm_form_contract_delivery_part_client_client            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Основание заказчика**          | однострочное поле                                 | crm_form_contract_delivery_part_client_reason            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Поставщик (организация)**      | выбор подразделений (всегда выбрана корневая нода)| crm_form_contract_delivery_part_provider                 |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Представитель поставщика**     | выбор пользователя                                | crm_form_contract_delivery_part_provider_name            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Основание поставщика**         | однострочное поле                                 | crm_form_contract_delivery_part_provider_base            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Товар**                        | однострочное поле (тема сотрудничества из         | crm_form_contract_delivery_part_theme                    |
|                                  | выбранной записи в поле "Основание (сделка))"     |                                                          |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Срок поставки товара**         | числовое поле                                     | crm_form_contract_delivery_part_time                     |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Срок поставки (прописью)**     | однострочное поле                                 | crm_form_contract_delivery_part_time_by_text             |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Город поставки**               | выпадающий список (справочник crm_dict_cities)    | crm_form_contract_delivery_part_city_to                  |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Адрес**                        | однострочное поле                                 | crm_form_contract_delivery_part_address                  |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Общая сумма договора**         | числовое поле                                     | crm_form_contract_delivery_part_sum_total                |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Сумма договора (прописью)**    | однострочное поле                                 | crm_form_contract_delivery_part_sum_total_by_text        |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Размер аванса**                | однострочное поле                                 | crm_form_contract_delivery_part_avans                    |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Срок выплаты аванса**          | однострочное поле                                 | crm_form_contract_delivery_part_avans_time               |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Размер доплаты**               | однострочное поле                                 | crm_form_contract_delivery_part_balance                  |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Срок предоставления Акта**     | числовое поле                                     | crm_form_contract_delivery_part_act_time                 |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Срок действия договора**       | выбор даты                                        | crm_form_contract_delivery_part_contract_time_to         |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Юридический адрес Заказчика**  | многострочное поле                                | crm_form_contract_delivery_part_client_requisites1       |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Юридический адрес Поставщика** | многострочное поле                                | crm_form_contract_delivery_part_provider_requisites1     |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Реквизиты Заказчика**          | ссылка                                            | crm_form_contract_delivery_part_client_requisites2       |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Реквизиты Поставщика**         | многострочное поле                                | crm_form_contract_delivery_part_provider_requisites2     |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Номер договора (приложение)**  | однострочное поле                                 | crm_form_contract_delivery_part_contract_number_appendix |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Дата договора (приложение)**   | выбор даты                                        | crm_form_contract_delivery_part_contract_date_appendix   |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Перечень закупаемых товаров**  | динамическая таблица (из группы полей "Заказ"     | crm_form_contract_delivery_part_items                    |
|                                  | сделки, указанной в поле "Основание (сделка)")    |                                                          |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   №                              | однострочное поле                                 | crm_form_deal_order_number                               |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   Наименование Товара            | ссылка на реестр "Прайс-лист"                     | crm_form_deal_order_orderList                            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   Ед.изм.                        | однострочное поле                                 | crm_form_deal_order_unit                                 |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   Кол-во                         | числовое поле                                     | crm_form_deal_order_amount                               |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   Цена за ед., тенге             | числовое поле                                     | crm_form_deal_order_price                                |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   Сумма, тенге                   | числовое поле                                     | crm_form_deal_order_total                                |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Итого**                        | числовое поле                                     | crm_form_contract_delivery_part_items_total              |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Подпись заказчика**            | ссылка на реестр "Контакты"                       | crm_form_contract_delivery_part_client_account_appendix  |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Подпись поставщика**           | выбор пользователя                                | crm_form_contract_delivery_part_provider_name_appendix   |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Источник адреса**              | выпадающий список                                 | choice                                                   |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Выбрать аккаунт**              | ссылка на реестр "Аккаунты"                       | account_link                                             |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Выбрать контакт**              | ссылка на реестр "Контакты"                       | contact_link                                             |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **E-mail**                       | однострочное поле                                 | email                                                    |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Адреса аккаунта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_account_email                                   |
|                                  | аккаунта, указанного в поле "Выбрать аккаунт")    |                                                          |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Актуальный адрес аккаунта**    | однострочное поле                                 | crm_form_account_email_email                             |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Адреса контакта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_contact_email                                   |
|                                  | контакта, указанного в поле "Выбрать контакт")    |                                                          |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Актуальный адрес контакта**    | однострочное поле                                 | crm_form_contact_email_email                             |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+

*Компоненты выбора даты*:

*   Формат даты всех компонентов выбора дат - `"${dd}" ${monthed} ${yyyy}г.`

##### Акт приема-передачи товара {#formCertificate}

Код формы: crm_form_certificate.

Форма содержит следующие компоненты:

+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Поле                             | Тип компонента                                    | Имя компонента                                         |
+==================================+===================================================+========================================================+
| **Заказчик**                     | ссылка на реестр "Аккаунты"                       | crm_form_certificate_table1_customer                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Поставщик**                    | компонент выбора подразделений                    | crm_form_certificate_table1_supplier                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Город**                        | выпадающий список (справочник crm_dict_cities)    | crm_form_certificate_table2_city                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата**                         | дата                                              | crm_form_certificate_table2_date                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Договор**                      | ссылка на реестр "Договоры поставки"              | crm_form_certificate_table3_contract                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table4_number                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table4_date                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Товар**                        | динамическая таблица                              | crm_form_certificate_table5                            |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| П/п                              | числовое поле                                     | crm_form_certificate_table5_n                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Наименование                     | ссылка на реестр "Каталог товаров и услуг"        | crm_form_certificate_table5_goods                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Количество                       | числовое поле                                     | crm_form_certificate_table5_amount                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Сумма                            | числовое поле                                     | crm_form_certificate_table5_summ                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Общая стоимость товара**       | числовое поле                                     | crm_form_certificate_table6_cost                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table7_number                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table7_date                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table8_number                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table9_date                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Аккаунт заказчика**            | ссылка на реестр "Аккаунт"                        | crm_form_certificate_table10_account                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Контакт заказчика**            | ссылка на реестр "Контакт"                        | crm_form_certificate_table10_contact                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Договор заказчика**            | ссылка на реестр "Договоры поставки"              | crm_form_certificate_table11_contract                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Подразделение исполнителя**    | компонент выбора подразделений                    | crm_form_certificate_table12_account                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Исполнитель**                  | компонент выбора пользователей                    | crm_form_certificate_table12_contact                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Договор исполнителя**          | ссылка на реестр "Договоры поставки"              | crm_form_certificate_table13_contract                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table14_number                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table15_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Список работ**                 | динамическая таблица                              | crm_form_certificate_table16                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Виды работ                       | ссылка на реестр "Каталог товаров и услуг"        | crm_form_certificate_table16_goods                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Сумма**                        | числовое поле                                     | crm_form_certificate_table17_summ1                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Сумма (прописью)**             | однострочное поле                                 | crm_form_certificate_table17_summ2                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата**                         | дата                                              | crm_form_certificate_table18_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Передал**                      | ссылка на реестр "Контакт"                        | crm_form_certificate_table19_supplier                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Принял**                       | компонент выбора пользователей                    | crm_form_certificate_table19_customer                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table20_number                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table21_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Заказчик**                     | ссылка на реестр "Контакт"                        | crm_form_certificate_table22_customer                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **ИИН/БИН заказчика**            | числовое поле                                     | crm_form_certificate_table22_customerID                |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Исполнитель**                  | компонент выбора пользователей                    | crm_form_certificate_table22_responder                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **ИИН/БИН исполнителя**          | числовое поле                                     | crm_form_certificate_table22_responderID               |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Договор**                      | ссылка на реестр "Договоры поставки"              | crm_form_certificate_table23_contract                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table23_number                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table23_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выполненные работы**           | динамическая таблица                              | crm_form_certificate_table24                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Номер                            | числовое поле                                     | crm_form_certificate_table16_goods                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Наименование                     | ссылка на реестр "Каталог товаров и услуг"        | crm_form_certificate_table24_goods                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Дата                             | дата                                              | crm_form_certificate_table24_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Сведения об отчете               | однострочное поле                                 | crm_form_certificate_table24_comment                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Единица измерения                | однострочное поле                                 | crm_form_certificate_table24_unit                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Количество                       | числовое поле                                     | crm_form_certificate_table24_amount                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Цена                             | числовое поле                                     | crm_form_certificate_table24_price                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость                        | числовое поле                                     | crm_form_certificate_table24_summ                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Итоговое количество**          | числовое поле                                     | crm_form_certificate_table25_finalAmount               |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Итоговая стоимость**           | числовое поле                                     | crm_form_certificate_table25_finalSumm                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Наименование запасов**         | однострочное поле                                 | crm_form_certificate_table26_name                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Количество запасов**           | числовое поле                                     | crm_form_certificate_table26_amount                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Стоимость запасов**            | числовое поле                                     | crm_form_certificate_table26_cost                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Количество страниц**           | числовое поле                                     | crm_form_certificate_table27_amount                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Список приложений**            | однострочное поле                                 | crm_form_certificate_list                              |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата подписания**              | дата                                              | crm_form_certificate_table28_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Заказчик**                     | ссылка на реестр "Контакт"                        | crm_form_certificate_table29_customer                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Исполнитель**                  | компонент выбора пользователей                    | crm_form_certificate_table29_responder                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Источник адреса**              | выпадающий список                                 | choice                                                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выбрать аккаунт**              | ссылка на реестр "Аккаунты"                       | account_link                                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выбрать контакт**              | ссылка на реестр "Контакты"                       | contact_link                                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **E-mail**                       | однострочное поле                                 | email                                                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адреса аккаунта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_account_email                                 |
|                                  | аккаунта, указанного в поле "Выбрать аккаунт")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Актуальный адрес аккаунта**    | однострочное поле                                 | crm_form_account_email_email                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адреса контакта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_contact_email                                 |
|                                  | контакта, указанного в поле "Выбрать контакт")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Актуальный адрес контакта**    | однострочное поле                                 | crm_form_contact_email_email                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+

*Компоненты выбора даты*:

*   Формат даты всех компонентов выбора дат - `"${dd}" ${monthed} ${yyyy}г.`

##### Коммерческое предложение {#formOffer}

Код формы: crm_form_offer.

Форма содержит следующие компоненты:

+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                                | Имя компонента                                         |
+========================================================+===============================================================+========================================================+
| Аккаунт                                                | ссылка на реестр "Аккаунты"                                   | crm_form_offer_account                                 |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Контакты для шапки справа                              | ссылка на реестр "Контакты"                                   | crm_form_offer_contact1                                |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Контакты для ИО в центре после Уважаемый               | ссылка на реестр "Контакты"                                   | crm_form_offer_contact2                                |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Должность                                              | однострочное поле                                             | crm_form_offer_whom_position                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Аккаунт3                                               | однострочное поле                                             | crm_form_offer_whom_account                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| ФИО                                                    | однострочное поле                                             | crm_form_offer_whom_fullname                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Уважаемый                                              | однострочное поле                                             | crm_form_offer_address_dear                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| ИО в обращении                                         | однострочное поле                                             | crm_form_offer_address_fullname                        |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Количество листов                                      | однострочное поле                                             | crm_form_offer_attachment_number                       |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Должность отправителя                                  | выбор должности                                               | crm_form_offer_from_position                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| ФИО отправителя                                        | выбор пользователя                                            | crm_form_offer_from_user                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Организация отправителя                                | однострочное поле                                             | crm_form_offer_from_organization                       |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Прайс-листы                                            | динамическая таблица                                          | crm_form_offer_price                                   |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Прайс-лист                                             | ссылка на реестр "Прайс-лист"                                 | crm_form_offer_price_price                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Стоимость реализации проекта                           | динамическая таблица                                          | crm_form_offer_project_price                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Номер                                                  | однострочное поле                                             | crm_form_offer_project_price_number                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Название товара или услуги                             | однострочное поле                                             | crm_form_offer_project_price_item_name                 |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Цена                                                   | числовое поле                                                 | crm_form_offer_project_price_price                     |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Описание                                               | многострочное поле                                            | crm_form_offer_project_price_description               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Сумма                                                  | числовое поле                                                 | crm_form_offer_project_summa_summa                     |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Источник адреса                                        | выпадающий список                                             | choice                                                 |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Выбрать аккаунт                                        | ссылка на реестр "Аккаунты"                                   | account_link                                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Выбрать контакт                                        | ссылка на реестр "Контакты"                                   | contact_link                                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| E-mail                                                 | однострочное поле                                             | email                                                  |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Адреса аккаунта                                        | динамическая таблица (из группы полей "E-mail"                | crm_form_account_email                                 |
|                                                        | аккаунта, указанного в поле "Выбрать аккаунт")                |                                                        |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Актуальный адрес аккаунта                              | однострочное поле                                             | crm_form_account_email_email                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Адреса контакта                                        | динамическая таблица (из группы полей "E-mail"                | crm_form_contact_email                                 |
|                                                        | контакта, указанного в поле "Выбрать контакт")                |                                                        |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Актуальный адрес контакта                              | однострочное поле                                             | crm_form_contact_email_email                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+

*Для компонента "Аккаунт" настроено сопоставление*:

*   `crm_form_account_main_name` - `crm_form_offer_whom_account` - `EQUAL`

*Для компонента "Контакты для шапки справа" настроено сопоставление:*

*   `crm_form_contact_main_fullName` - `crm_form_offer_whom_fullname` - `EQUAL`

*   `crm_form_contact_main_position` - `crm_form_offer_whom_position` - `EQUAL`

*Для компонента "Контакты для ИО в центре после Уважаемый" настроено сопоставление:*

*   `crm_form_contact_main_fullName` - `crm_form_offer_address_fullname` - `POSTFIX` - !

*Для компонента "ФИО отправителя" настроены:*

*   связь с компонентом `crm_form_offer_from_position`

*   включена опция "Изменить формат отображения ФИО в зависимости от языка системы"
    с форматом `${l} ${f.short}.${p.short.dot}`

    `%стоимость_в_прайс-листе% * crm_form_deal_order_orderAmount`

*Для компонента "Прайс-лист" настроено сопоставление:*

*   `crm_form_price_item_name` - `crm_form_offer_project_price_item_name` - `EQUAL`   

*   `crm_form_price_price` - `crm_form_offer_project_price_price` - `EQUAL`

*   `crm_form_price_description` - `crm_form_offer_project_price_description` - `EQUAL`

*Для поля "Описание":*

*   включена опция "Не удалять пробелы в начале строки"

##### Счет-фактура {#formInvoice}

Код формы: crm_form_invoice.

Форма содержит следующие компоненты:

+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Поле                             | Тип компонента                                    | Имя компонента                                         |
+==================================+===================================================+========================================================+
| **Номер счета**                  | однострочное поле                                 | crm_form_invoice_number                                |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата счета**                   | выбор даты                                        | crm_form_invoice_date                                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Основание (договор поставки)** | группа полей                                      |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Единовременная оплата            | ссылка на реестр "Договоры поставки               | crm_form_invoice_contract_100                          |
|                                  | (единовременная оплата)"                          |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Оплата частями                   | ссылка на реестр "Договоры поставки               | crm_form_invoice_contract_part                         |
|                                  | (оплата частями)"                                 |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Сведения о поставщике**        | группа полей                                      |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Наименование                     | выбор подразделений (всегда выбрана корневая нода)| crm_form_invoice_provider_name                         |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| БИН                              | однострочное поле                                 | crm_form_invoice_provider_bin                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Адрес                            | многострочное поле                                | crm_form_invoice_provider_address                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| ИИК                              | однострочное поле                                 | crm_form_invoice_provider_iik                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| БИК                              | однострочное поле                                 | crm_form_invoice_provider_bik                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Свидетельство о постановке на**| группа полей                                      |                                                        |
| **регистрационный учет по НДС**  |                                                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Серия                            | однострочное поле                                 | crm_form_invoice_provider_nds_series                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Номер                            | однострочное поле                                 | crm_form_invoice_provider_nds_number                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Дата выдачи                      | числовое поле                                     | crm_form_invoice_provider_nds_date                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора (контракта)**   | однострочное поле (номер договора, выбранного в   | crm_form_invoice_contract_number                       |
| **на поставку**                  | группе полей "Основание (договор поставки)")      |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата договора (контракта)**    | однострочное поле (дата договора, выбранного в    | crm_form_invoice_contract_date                         |
| **на поставку**                  | группе полей "Основание (договор поставки)")      |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Условия оплаты по договору**   | выпадающий список (справочник                     | crm_form_invoice_conditions                            |
| **(контракту)**                  | crm_dict_paymentMode)                             |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адрес: республика**            | однострочное поле (значение по умолчанию:         | crm_form_invoice_republic                              |
|                                  | "Республика Казахстан")                           |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адрес: город**                 | выпадающий список (справочник crm_dict_cities)    | crm_form_invoice_city                                  |
|                                  | (город поставки из договора, выбранного в поле    |                                                        |
|                                  | "Основание (договор поставки)")                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адрес: улица**                 | однострочное поле  (адрес поставки из договора,   | crm_form_invoice_address                               |
|                                  | выбранного в поле "Основание (договор поставки)") |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Доверенность**                 | однострочное поле (значение по умолчанию:         | crm_form_invoice_vicarious                             |
|                                  | "без доверенности")                               |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Способ отправления**           | выпадающий список (справочник                     | crm_form_invoice_departure                             |
|                                  | crm_dict_deliveryMode)                            |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Товарно-транспортная**         | однострочное поле                                 | crm_form_invoice_ttn                                   |
|  **накладная**                   |                                                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Грузоотправитель**             | группа полей                                      |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| БИН                              | однострочное поле                                 | crm_form_invoice_sender_bin                            |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Наименование                     | однострочное поле (наименование организации       | crm_form_invoice_sender_name                           |
|                                  | поставщика из договора, выбранного в поле         |                                                        |
|                                  | "Основание (договор поставки)")                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Адрес                            | многострочное поле                                | crm_form_invoice_sender_address                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Грузополучатель**              | группа полей                                      |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| БИН                              | однострочное поле                                 | crm_form_invoice_receiver_bin                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Наименование                     | однострочное поле                                 | crm_form_invoice_receiver_name                         |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Адрес                            | многострочное поле                                | crm_form_invoice_receiver_address                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Получатель**                   | группа полей                                      |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Наименование                     | однострочное поле (наименование организации       | crm_form_invoice_mainreceiver_name                     |
|                                  | заказчика из договора, выбранного в поле          |                                                        |
|                                  | "Основание (договор поставки)")                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| БИН                              | однострочное поле                                 | crm_form_invoice_mainreceiver_bin                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Адрес                            | многострочное поле                                | crm_form_invoice_mainreceiver_address                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| ИИК                              | однострочное поле                                 | crm_form_invoice_mainreceiver_iik                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| БИК                              | однострочное поле                                 | crm_form_invoice_mainreceiver_bik                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Перечень закупаемых товаров**  | динамическая таблица (из группы полей "Перечень   | crm_form_invoice_order                                 |
|                                  | закупаемых товаров) договора, указанного в поле   |                                                        |
|                                  | "Основание (договор поставки)")                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   № п/п                          | однострочное поле                                 | crm_form_deal_order_number                             |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Наименование товаров (работ,   | ссылка на реестр "Прайс-лист"                     | crm_form_deal_order_orderList                          |
| услуг)                           |                                                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Ед. изм.                       | однострочное поле                                 | crm_form_deal_order_unit                               |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Кол-во (объем)                 | числовое поле                                     | crm_form_deal_order_amount                             |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Цена (KZT)                     | числовое поле                                     | crm_form_deal_order_price                              |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Стоимость товаров (работ,      | числовое поле                                     | crm_form_deal_order_total                              |
| услуг) без НДС                   |                                                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Ставка НДС                     | числовое поле                                     | crm_form_invoice_order_nds                             |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Сумма НДС                      | числовое поле                                     | crm_form_invoice_order_nds_summ                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Всего стоимость реализации     | числовое поле                                     | crm_form_invoice_order_summ_by_item                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Ставка акциз                   | числовое поле                                     | crm_form_invoice_order_akciz                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Сумма акциз                    | числовое поле                                     | crm_form_invoice_order_akciz_summ                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Всего по счету**               | группа полей                                      |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Стоимость товаров (работ,      | числовое поле                                     | crm_form_invoice_order_total                           |
| услуг) без НДС                   |                                                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Сумма НДС                      | числовое поле                                     | crm_form_invoice_order_nds_summ_total                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Всего стоимость реализации     | числовое поле                                     | crm_form_invoice_order_summ_total                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Сумма акциз                    | числовое поле                                     | crm_form_invoice_order_akciz_summ_total                |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Руководитель**                 | ссылка на реестр "Контакты" (поле "Заказчик       | crm_form_invoice_client_client                         |
|                                  | (контакт)" договора, выбранного в поле "Основание |                                                        |
|                                  | (договор поставки)")                              |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Главный бухгалтер**            | однострочное поле                                 | crm_form_invoice_booker                                |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Источник адреса**              | выпадающий список                                 | choice                                                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выбрать аккаунт**              | ссылка на реестр "Аккаунты"                       | account_link                                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выбрать контакт**              | ссылка на реестр "Контакты"                       | contact_link                                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **E-mail**                       | однострочное поле                                 | email                                                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адреса аккаунта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_account_email                                 |
|                                  | аккаунта, указанного в поле "Выбрать аккаунт")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Актуальный адрес аккаунта**    | однострочное поле                                 | crm_form_account_email_email                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адреса контакта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_contact_email                                 |
|                                  | контакта, указанного в поле "Выбрать контакт")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Актуальный адрес контакта**    | однострочное поле                                 | crm_form_contact_email_email                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+

*Компоненты выбора даты*:

*   Формат даты всех компонентов выбора дат - `${dd}.${mm}.${yyyy} г.`

*Однострочные поля*:

*   Маска ввода всех полей "БИН" - `############`

#### Ответственный за сделки {#formDealResponsible}

Код формы: crm_form_deal_responsible.

Форма содержит следующие компоненты:

+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                         | Имя компонента                                         |
+========================================================+========================================================+========================================================+
| Ответственный за сделку                                | компонент выбора пользователей                         | crm_form_deal_responsible_user                         |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+

#### План продаж {#formSalesCost}

Код формы: crm_form_sales.

Форма содержит следующие компоненты:

+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Поле                             | Тип компонента                                    | Имя компонента                                         |
+==================================+===================================================+========================================================+
| **Год**                          | числовое поле                                     | crm_form_deal_order_sales_year                         |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Месяц**                        | выпадающий список (справочник "crm_dict_months")  | crm_form_deal_order_sales_month                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **План продаж**                  | динамическая таблица                              | crm_form_deal_main2_theme_sales                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Отделение                        | компонент выбора подразделений                    | crm_form_deal_sales_pk1                                |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c1                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c1                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c2                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c2                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c3                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c3                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c4                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c4                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c5                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c5                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c6                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c6                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c7                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c7                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c8                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c8                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c9                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c9                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c10                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c10                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c11                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c11                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c12                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c12                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c13                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c13                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c14                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c14                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Конечный положительный статус**| числовое поле                                     | crm_form_deal_end                                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+

*Динамическая таблица "План продаж":*

*   Флаг "Отобразить границы" включен.

*   Форматная строка:

    `[${crm_form_sales_cost_cost} и ${crm_form_sales_cost_value} для ${crm_form_sales_cost_position}]`

*   Разделитель свертки - `, `

*Поле "Отделение":*

*   Флаг "Обязательное поле" включен.

*Поле "Тема сотрудничества":*

*   Флаг "Обязательное поле" включен.

*Поле "Стоимость продаж":*

*   Значение поля по умолчанию - 0.

*Поле "Конечный положительный статус":*

*   Поле скрыто.

*   Значение поля по умолчанию - 1.

    > **Примечание:**
    >
    > В случае, если значение поля будет изменено, дашбоард модуля
    > "Продуктивность" будет работать некорректно, и это не будет являться
    > ошибкой Synergy.

#### Нормативы продолжительности статусов сделки {#formDealFlowStandard}

Код формы: crm_form_deal_flow_standard.

Форма содержит следующие компоненты:

+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                         | Имя компонента                                         |
+========================================================+========================================================+========================================================+
| **Нормативы продолжительности статусов сделки**        | динамическая таблица                                   | crm_form_deal_flow_standard_table                      |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Статус сделки                                          | выпадающий список (справочник "crm_dict_dealStatus")   | crm_form_deal_flow_standard_status                     |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Продолжительность (в днях)                             | числовое поле                                          | crm_form_deal_flow_standard_duration                   |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| **Продолжительность по умолчанию (в днях)**            | числовое поле                                          | crm_form_deal_flow_standard_default_duration           |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+

*Динамическая таблица "Нормативы продолжительности статусов сделки"*:

*   Форматная строка:

    `[${crm_form_deal_flow_standard_duration} для ${crm_form_deal_flow_standard_status}]`

*   Разделитель свертки - `, `

*Поле "Продолжительность (в днях)"*:

*   Значение поля по умолчанию - 1.

*Поле "Продолжительность по умолчанию (в днях)"*:

*   Значение поля по умолчанию - 1.
