## Дашборды (аналитика) {#crm_dashboards}

Для интеграции аналитических дашбордов в Synergy используется 
комбинация инструментов **Elasticsearch** и **Kibana**.

[Elasticsearch (ES)](https://www.elastic.co/products/elasticsearch) - 
это мощный инструмент для полнотекстового поиска и анализа данных. 
Он позволяет быстро загружать, выполнять поиск и анализировать 
большие объемы данных. Однако ES не имеет специальной визуальной 
оболочки, и его использование возможно с помощью набора специальных 
API. 

[Kibana](https://www.elastic.co/products/kibana) - это платформа 
для анализа и визуализации данных. Kibana обрабатывает данные, 
загруженные в ES, и работает только параллельно с ним. Если 
работа с ES предполагает использование специального синтаксиса 
команд, то Kibana позволяет обрабатывать те же данные с 
помощью визуального интерфейса. При этом Kibana содержит 
интерпретатор, позволяющий использование всех возможностей и 
специальных команд ES. 

Индексация и обработка исходных данных Synergy производится с 
помощью ES, дальнейший анализ и визуализация - с помощью Kibana. 
Для подробного изучения всех возможностей и способов использования 
этих инструментов рекомендуем обращаться к официальной документации: 

- [Elasticsearch](https://www.elastic.co/guide/en/elasticsearch/reference/current/getting-started.html);

- [Kibana](https://www.elastic.co/guide/en/kibana/current/introduction.html).

Задача визуализации данных в общем случае, а также общие термины и правила 
работы рассмотрены в документе 
["Руководство по работе с аналитическими дашбордами"](http://tdd.lan.arta.kz/docs/synergy/trunk/sdk-doc/html/sec.dashboards.html). 
Настоящий раздел содержит подробное описание дашбордов, входящих в 
типовую кофигурацию приложения CRM.

> **Примечание:**

> По умолчанию все диаграммы и дашборды конфигурируются в браузере по 
адресу: `<server_host>:5601`. Обратите внимание, что Kibana **не имеет 
встроенных средств для контроля доступа**: при переходе по адресу любой 
пользователь имеет полные права на запись, редактирование и удаление 
данных. Если требуется обеспечение защиты, предлагаем использовать 
средства `nginx reverse proxy`. 

### Используемые шаблоны индексов {#crm_dashboards_index_patterns}

Созданы шаблоны индексов: 

- `r-crm-registry_deals` - индекс данных реестра ["Сделки"](#registryDeal);

- `deals-status-history` - служебный индекс учета времени нахождения сделки 
в статусе;

- `r-crm-registry_accounts` - индекс данных реестра ["Аккаунты"](#registryAccount);

- `r-crm-registry_events` - индекс данных реестра ["Маркетинговые мероприятия"](#registryEvent);

- `r-crm-registry_invoices` - индекс данных реестра ["Счет-фактуры"](#registryInvoices);

- `r-crm-registry_lead` - индекс данных реестра ["Лиды"](#registryLead);

- `r-crm_registry_deals_plans_custom` - служебный индекс данных реестра ["План продаж"](#registrySalesCost);

- `r-crm_registry_deals*` - шаблон, объединяющий данные реестра ["Сделки"](#registryDeal) 
и служебный индекс `r-crm_registry_deals_plans_custom`.

Индекс `deals-status-history` создается и рассчитывается автоматически при 
запусе Synergy. Индекс `r-crm_registry_deals_plans_custom` создается при 
создании записей в реестре ["План продаж"](#registrySalesCost). Остальные 
индексы включены в типовую конфигурацию.

### Управление маркетингом {#dashboards_marketing}

**Общие настройки дашборда:** 

- период обновления: 30 секунд

- источник данных для публикации: `Embedded iframe`

- опубликован в пользовательском компоненте `crm_component_leads_dashboard`, 
где в параметрах размера фрейма указано `100%` для высоты и ширины.

Дашборд "Аналитика" в модуле "Управление маркетингом" состоит из диаграмм: 

1. **Количество аккаунтов**

Отображает одно число - общее количество неудаленных записей в реестре 
["Аккаунты"](#registryAccount).

> - тип диаграммы: Metric

> - шаблон индекса: `r-crm_registry_accounts`

> - условие на отображаемые данные: `deleted:0`

> - тип агрегации: `Count`

> - отображаемое название параметра: "Количество аккаунтов"

2. **Количество лидов**

Отображает одно число - общее количество неудаленных записей в реестре 
["Лиды"](#registryLead).

> - тип диаграммы: `Metric`

> - шаблон индекса: `r-crm_registry_lead `

> - условие на отображаемые данные: `deleted:0`

> - тип агрегации: `Count`

> - отображаемое название параметра: "Количество лидов"

3. **Средний предполагаемый чек по лидам**

Отображает одно число: среднее значение поля "Потенциальный бюджет" по 
всем неудаленных записях реестра ["Лиды"](#registryLead).

> - тип диаграммы: `Metric`

> - шаблон индекса: `r-crm_registry_lead`

> - условие на отображаемые данные: `deleted:0`

> - тип агрегации: `Average`

> - поле агрегации: `crm_form_lead_deals_budget_key_double`

> - отображаемое название параметра: "Средний предполагаемый чек по лидам"

4. **Маркетинговые мероприятия**

Отображает список неудаленных записей реестра ["Маркетинговые мероприятия"](#registryEvent) 
с детализацией по дате создания, наименованию мероприятия, бюджету, 
целевому и текущему отклику, а также оценке эффективности мероприятия.

> - тип диаграммы: `Data table`

> - шаблон индекса: `r-crm_registry_events` 

> - условие на отображаемые данные: `deleted:0`

> Параметры агрегации: 

>> Числовые (`metrics`):

>> - тип агрегации: `Sum`

>> - поле агрегации: `crm_form_event_main_rating_key_double`

>> - отображаемое название параметра: "Оценка эффективности"

>> Групповые агрегации (поля таблицы, `buckets`):

>>> *Дата создания:*

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Date Histogram`

>>> - поле агрегации: `created`

>>> - интервал агрегации даты: `Second`

>>> - отображаемое название параметра: "Дата создания"

>>> *Наименование:* 

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Terms`

>>> - поле агрегации: `crm_form_event_main_name_value_sort`

>>> - способ сортировки: `Term`

>>> - направление сортировки: `Descending`

>>> - количество отображаемых результатов: 10000

>>>> **Примечание:**

>>>> Этот параметр обязателен для каждой диаграммы Kibana. Он означает, 
сколько документов, удовлетворяющих условиям (как примененных к диаграмме, 
так и ко всему дашборду в целом) будет отображено на диаграмме. Его 
необходимо устанавливать и периодически актуализировать с учетом 
предполагаемого количества записей в каждом реестре Synergy.

>>> - отображаемое название параметра: "Наименование"

>>> *Бюджет:* 

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Terms`

>>> - поле агрегации: `crm_form_event_main_cost_key_double`

>>> - способ сортировки: `metric: Оценка эффективности`

>>> - направление сортировки: `Descending`

>>> - количество отображаемых результатов: 10000

>>> - отображаемое название параметра: "Бюджет"

>>> *Целевой отклик:* 

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Terms`

>>> - поле агрегации: `crm_form_event_main_target_response_key_double`

>>> - способ сортировки: `metric: Оценка эффективности`

>>> - направление сортировки: `Descending`

>>> - количество отображаемых результатов: 10000

>>> - отображаемое название параметра: "Целевой отклик"

>>> *Текущий отклик:* 

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Terms`

>>> - поле агрегации: `crm_form_event_main_current_response_key_double`

>>> - способ сортировки: `metric: Оценка эффективности`

>>> - направление сортировки: `Descending`

>>> - количество отображаемых результатов: 10000

>>> - отображаемое название параметра: "Текущий отклик"

### Управление продажами {#dashboards_sales}

**Общие настройки дашборда:** 

- период обновления: 30 секунд

- источник данных для публикации: `Embedded iframe`

- опубликован в пользовательском компоненте `crm_component_deals_dashboard`, 
где в параметрах размера фрейма указано `100%` для высоты и ширины.

Дашборд "Аналитика" в модуле "Управление продажами" состоит из диаграмм: 

1. **Топ прайс-листа**

Отображает 10 наиболее продаваемых позиций реестра [Прайс-лист](#registryPriceList) - 
наименование и количество проданных товаров, указанных в записях реестра 
[Счет-фактуры](#registryInvoices).

> - тип диаграммы: `Data table`

> - шаблон индекса: `r-crm_registry_invoices` 

> - условие на отображаемые данные: 
`deleted:0 NOT crm_form_deal_order_orderList_value_sort:""`

> Параметры агрегации: 

>> Числовые (`metrics`):

>> - тип агрегации: `Sum`

>> - поле агрегации: `crm_form_deal_order_amount_key_double`

>> - отображаемое название параметра: "Количество (единиц)"

>> Групповые агрегации (поля таблицы, `buckets`):

>>> *Услуга/товар:* 

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Terms`

>>> - поле агрегации: `crm_form_deal_order_orderList_value_sort`

>>> - способ сортировки: `metric: Количество (единиц)`

>>> - направление сортировки: `Descending`

>>> - количество отображаемых результатов: 10

>>> - отображаемое название параметра: "Услуга/товар"

2. **Среднее время прохождения сделками статусов**

Отображает среднее время прохождения сделками каждого из статусов (в днях) 
на основании записей рееестра [Сделки](#registryDeal).

> **Примечание:**

> Данная диаграмма содержит только те статусы, которые являются текущими 
для сделок - записей в реестре [Сделки](#registryDeal).

> - тип диаграммы: `Data table`

> - шаблон индекса: `deals_status_history` 

> - условие на отображаемые данные: `deleted:0`

> Параметры агрегации: 

>> Числовые (`metrics`):

>> - тип агрегации: `Average`

>> - поле агрегации: `status_duration_key_double`

>> - отображаемое название параметра: "Длительность статуса (в днях)"

>> Групповые агрегации (поля таблицы, `buckets`):

>>> *Статус сделки:* 

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Terms`

>>> - поле агрегации: `crm_form_deal_main3_status_value_sort`

>>> - способ сортировки: `metric: Длительность статуса (в днях)`

>>> - направление сортировки: `Descending`

>>> - количество отображаемых результатов: 5

>>> - отображаемое название параметра: "Статус сделки"

> Опции диаграммы:

>> количество записей на страницу: 5

>> отображать итоговый результат: `false`

3. **Количество сделок по статусам**

Отображает общее количество сделок в каждом из статусов (при их наличии) 
на основании записей рееестра [Сделки](#registryDeal).

> - тип диаграммы: `Data table`

> - шаблон индекса: `r-crm_registry_deals` 

> - условие на отображаемые данные: `deleted:0`

> Параметры агрегации: 

>> Числовые (`metrics`):

>> *Количество:*

>> - тип агрегации: `Count`

>> - отображаемое название параметра: "Количество"

>> *Стоимость сделок:*

>> - тип агрегации: `Sum`

>> - поле агрегации: `crm_form_deal_main3_budget_key_double`

>> - отображаемое название параметра: "Стоимость сделок"

>> Групповые агрегации (поля таблицы, `buckets`):

>>> *Статус сделки:* 

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Terms`

>>> - поле агрегации: `crm_form_deal_main3_status_value_sort`

>>> - способ сортировки: `metric: Количество`

>>> - направление сортировки: `Descending`

>>> - количество отображаемых результатов: 5

>>> - отображаемое название параметра: "Статус сделки"

> Опции диаграммы:

>> количество записей на страницу: 5

>> отображать итоговый результат: `true`

>> функция итогового результата: `sum`

3. **Количество сделок с отказом**

Отображает общее количество сделок, перешедших в негативный статус 
(`crm_dict_dealStatus_quality=0` справочника [Статусы сделки](#dictionaryDealStatus)), 
с указанием их предыдущего положительного статуса.

> - тип диаграммы: `Data table`

> - шаблон индекса: `r-crm_registry_deals` 

> - условие на отображаемые данные: `deleted:0 NOT crm_form_deal_refused_key_double:0`

> Параметры агрегации: 

>> Числовые (`metrics`):

>> *Количество:*

>> - тип агрегации: `Sum`

>> - поле агрегации: `crm_form_deal_refused_key_double`

>> - отображаемое название параметра: "Количество отказов"

>> *Стоимость сделок:*

>> - тип агрегации: `Sum`

>> - поле агрегации: `crm_form_deal_main3_budget_key_double`

>> - отображаемое название параметра: "Стоимость сделок"

>> Групповые агрегации (поля таблицы, `buckets`):

>>> *Статус сделки:* 

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Terms`

>>> - поле агрегации: `crm_form_deal_previous_status_value_sort`

>>> - способ сортировки: `metric: Стоимость сделок`

>>> - направление сортировки: `Descending`

>>> - количество отображаемых результатов: 5

>>> - отображаемое название параметра: "Этап отказа от сделки"

> Опции диаграммы:

>> количество записей на страницу: 4

>> отображать итоговый результат: `true`

>> функция итогового результата: `sum`

4. **Количество просроченных сделок по статусам**

Отображает количество сделок, не сменивших статус за время, указанное 
в документе по форме ["Нормативы продолжительности статусов сделки"](#formDealFlowStandard) 
для соответствующего статуса. Диаграмма не содержит статусов, которые 
не являются предыдущими для сделок - записей в реестре [Сделки](#registryDeal). 

> - тип диаграммы: `Data table`

> - шаблон индекса: `r-crm_registry_deals` 

> - условие на отображаемые данные: `deleted:0 NOT crm_form_deal_expired_key_double:0`

> Параметры агрегации: 

>> Числовые (`metrics`):

>> *Количество:*

>> - тип агрегации: `Sum`

>> - поле агрегации: `crm_form_deal_expired_key_double`

>> - отображаемое название параметра: "Количество сделок, не сменивших 
статус своевременно"

>> *Стоимость сделок:*

>> - тип агрегации: `Sum`

>> - поле агрегации: `crm_form_deal_main3_budget_key_double`

>> - отображаемое название параметра: "Стоимость сделок"

>> Групповые агрегации (поля таблицы, `buckets`):

>>> *Статус сделки:* 

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Terms`

>>> - поле агрегации: `crm_form_deal_previous_status_value_sort`

>>> - способ сортировки: `metric: Стоимость сделок`

>>> - направление сортировки: `Descending`

>>> - количество отображаемых результатов: 7

>>> - отображаемое название параметра: "Статус сделки"

> Опции диаграммы:

>> количество записей на страницу: 4

>> отображать итоговый результат: `true`

>> функция итогового результата: `sum`

5. **Список сделок**

Отображает список всех неудаленных записей реестра [Сделки](#registryDeal) 
с детализацией по лидам, темам сотрудничества, статусам, ответственным менеджерам, 
причинам отказа от сделки (если она указана), а также с указанием стоимости 
сделки. 

> - тип диаграммы: `Data table`

> - шаблон индекса: `r-crm_registry_deals` 

> - условие на отображаемые данные: `deleted:0`

> Параметры агрегации: 

>> Числовые (`metrics`):

>> - тип агрегации: `Sum`

>> - поле агрегации: `crm_form_deal_main3_budget_key_double`

>> - отображаемое название параметра: "Стоимость сделки"

>> Групповые агрегации (поля таблицы, `buckets`):

>>> *Лид:* 

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Terms`

>>> - поле агрегации: `crm_form_deal_main1_lead_value_sort`

>>> - способ сортировки: `metric: Стоимость сделки`

>>> - направление сортировки: `Descending`

>>> - количество отображаемых результатов: 10000

>>> - отображаемое название параметра: "Лид"

>>> *Тема сотрудничества:* 

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Terms`

>>> - поле агрегации: `crm_form_deal_main2_theme_value_sort`

>>> - способ сортировки: `metric: Стоимость сделки`

>>> - направление сортировки: `Descending`

>>> - количество отображаемых результатов: 10000

>>> - отображаемое название параметра: "Тема сотрудничества"

>>> *Статус:* 

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Terms`

>>> - поле агрегации: `crm_form_deal_responsibleManager_responsible_value_sort`

>>> - способ сортировки: `metric: Стоимость сделки`

>>> - направление сортировки: `Descending`

>>> - количество отображаемых результатов: 10000

>>> - отображаемое название параметра: "Ответственный менеджер"

>>> *Причина отказа от сделки:* 

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Terms`

>>> - поле агрегации: `crm_form_deal_main3_rejection_value_sort`

>>> - способ сортировки: `metric: Стоимость сделки`

>>> - направление сортировки: `Descending`

>>> - количество отображаемых результатов: 10000

>>> - отображаемое название параметра: "Причина отказа от сделки"

> Опции диаграммы:

>> количество записей на страницу: 10

>> отображать частично заполненные строки: `true`

>> отображать итоговый результат: `true`

>> функция итогового результата: `sum`

### Продуктивность {#dashboards_productivity}

**Общие настройки дашборда:** 

- период обновления: 30 секунд

- источник данных для публикации: `Embedded iframe`

- опубликован в пользовательском компоненте `crm_component_deals_productivity`, 
где в параметрах размера фрейма указано `100%` для высоты и ширины.

Дашборд "Продуктивность" в модуле "Управление продажами" состоит из диаграмм: 

1. **Отделения**

Отображает список подразделений организации. Диаграмма не содержит подразделений, 
для которых не было указано ни одного планового показателя стоимости в реестре 
[План продаж](#registrySalesCost).

> - тип диаграммы: `Data table`

> - шаблон индекса: `r-crm_registry_deals_plans_custom` 

> - условие на отображаемые данные: `deleted:0`

> Параметры агрегации: 

>> Числовые (`metrics`):

>> *Количество:*

>> - тип агрегации: `Average`

>> - поле агрегации: `plan_key_double`

>> - отображаемое название параметра: "Средняя плановая стоимость продаж"

>> Групповые агрегации (поля таблицы, `buckets`):

>>> *Отделение:* 

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Terms`

>>> - поле агрегации: `crm_form_deal_sales_pk1_value_sort`

>>> - способ сортировки: `Term`

>>> - направление сортировки: `Descending`

>>> - количество отображаемых результатов: 30

>>> - отображаемое название параметра: "Отделение"

> Опции диаграммы:

>> количество записей на страницу: 5

2. **Месяцы**

Отображает список месяцев согласно справочнику [Месяцы](#dictionaryMonths). 
Диаграмма не содержит месяцев, в которые ни одна сделка не перешла в 
положительный конечный статус (`crm_dict_dealStatus_end=1`), согласно 
записям реестра [Сделки](#registryDeal).

> - тип диаграммы: `Data table`

> - шаблон индекса: `r-crm_registry_deals_plans_custom` 

> - условие на отображаемые данные: `deleted:0`

> Параметры агрегации: 

>> Числовые (`metrics`):

>> *Количество:*

>> - тип агрегации: `Average`

>> - поле агрегации: `plan_key_double`

>> - отображаемое название параметра: "Средняя плановая стоимость продаж"

>> Групповые агрегации (поля таблицы, `buckets`):

>>> *Отделение:* 

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Terms`

>>> - поле агрегации: `crm_form_deal_sales_pk1_value_sort`

>>> - способ сортировки: `Term`

>>> - направление сортировки: `Descending`

>>> - количество отображаемых результатов: 12

>>> - отображаемое название параметра: "Месяц"

> Опции диаграммы:

>> количество записей на страницу: 6

3. **Исполнение плана**

Отображает три числа:

- суммарное значение вмех плановых показателей по стоимости продаж;

- суммарное значение бюджета всех закрытых сделок;

- процент исполнения плана продаж, рассчитываемый таким образом: 

> %факт_продаж% / %план_продаж% * 100%

>>> **Примечание 1:**

>>> В диаграмме для подсчета факта продаж учитываются только сделки, 
перешедшие в положительный конечный статус (`crm_dict_dealStatus_end=1`), 
согласно записям реестра [Сделки](#registryDeal).

>>> **Примечание 2:**

>>> Для построения диаграммы используется специфический тип визуализации - 
`Extended metric`. Он не включается в основной инструментарий Kibana, но 
устанавливается автоматически при установке пакета kibana из репозитория 
Synergy. 

> - тип диаграммы: `Extended metric`

> - шаблон индекса: `r-crm_registry_deals*` 

> - условие на отображаемые данные: `deleted:0 && crm_form_deal_end_key_double:1`

> Параметры агрегации: 

>> *Суммарное значение плана продаж:*

>> - тип агрегации: `Sum`

>> - поле агрегации: `plan_key_double`

>> - используемое название параметра: `sum_cost`

> *Суммарное значение фактических продаж:*

>> - тип агрегации: `Sum`

>> - поле агрегации: `crm_form_deal_main3_budget_key_double`

>> - используемое название параметра: `sum_budget`

> Вычисляемые параметры (вкладка `Options`):

>>> **Примечание 3:**

>>> Во всех полях `Formula` используется синтаксис языка JavaScript. 
Помимо непосредственного вычисления процента исполнения плана продаж, 
дополнительно используются функции: 

>>> - `toLocaleString()` - формат отображения числа, при котором в 
качестве разделителя тысяч используется пробел;

>>> - `.toFixed(2)` - округление числа до второго знака после запятой 
(до сотых).

>> *План продаж:*

>> - формула: `(metrics['sum_cost'].value).toLocaleString()`

>> - отображаемое название параметра: "План продаж"

>> *Факт продаж:*

>> - формула: `(metrics['sum_budget'].value).toLocaleString()`

>> - отображаемое название параметра: "Факт продаж"

>> *Процент исполнения плана продаж:*

>> - формула: `(((metrics['sum_budget'].value / metrics['sum_cost'].value)) *100).toFixed(2)`

>> - отображаемое название параметра: "% исполнения плана продаж"

4. **Исполнение плана по темам сотрудничества**

Отображает суммарные значения плана продаж, сумму потенциального 
бюджета по всем сделкам, перешедшим в положительный конечный статус 
(`crm_dict_dealStatus_end=1`), в разрезе [тем сотрудничества]((#registryThemes)). 
В диаграмму включаются только те темы сотрудничества, для которых 
был указан хотя бы один плановый показатель в реестре 
[План продаж](#registrySalesCost).

> - тип диаграммы: `Data table`

> - шаблон индекса: `r-crm_registry_deals*` 

> - условие на отображаемые данные: `deleted:0 && crm_form_deal_end_key_double:1`

> Параметры агрегации: 

>> Числовые (`metrics`):

>>> *План продаж*

>>> - тип агрегации: `Sum`

>>> - поле агрегации: `plan_key_double`

>>> - отображаемое название параметра: "План продаж"

>>> *Факт продаж*

>>> - тип агрегации: `Sum`

>>> - поле агрегации: `crm_form_deal_main3_budget_key_double`

>>> - отображаемое название параметра: "Факт продаж"

>> Групповые агрегации (поля таблицы, `buckets`):

>>> *Тема сотрудничества:* 

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Terms`

>>> - поле агрегации: `crm_form_deal_main2_theme_value_sort`

>>> - способ сортировки: `metric: План продаж`

>>> - направление сортировки: `Descending`

>>> - количество отображаемых результатов: 30

>>> - отображаемое название параметра: "Тема сотрудничества"

> Опции диаграммы:

>> количество записей на страницу: 10

>> отображать итоговый результат: `true`

>> функция итогового результата: `sum`

5. **Исполнение плана по темам (гистрограмма)**

Отображает показатели плана и факта продаж в разрезе тем сотрудничества 
в виде гистограммы (столбиковой диаграммы, Bar chart). Диаграмма представляет 
собой визуализацию данных в таблице **Исполнение плана по темам сотрудничества**.

> - тип диаграммы: `Vertical bar chart`

> - шаблон индекса: `r-crm_registry_deals*` 

> - условие на отображаемые данные: `deleted:0 && crm_form_deal_end_key_double:1`

> Параметры агрегации: 

>> Числовые (`metrics`, ось Y):

>>> *План продаж*

>>> - тип агрегации: `Sum`

>>> - поле агрегации: `plan_key_double`

>>> - отображаемое название параметра: "План продаж"

>>> *Факт продаж*

>>> - тип агрегации: `Sum`

>>> - поле агрегации: `crm_form_deal_main3_budget_key_double`

>>> - отображаемое название параметра: "Факт продаж"

>> Групповые агрегации (`buckets`, ось X):

>>> *Тема сотрудничества:* 

>>> - тип разделения: `Split Rows`

>>> - тип агрегации: `Terms`

>>> - поле агрегации: `crm_form_deal_main2_theme_value_sort`

>>> - способ сортировки: `metric: План продаж`

>>> - направление сортировки: `Descending`

>>> - количество отображаемых результатов: 30

>>> - отображаемое название параметра: "Тема сотрудничества"

> Опции диаграммы:

>> раположение столбцов: сгруппированное


