## Встроенные объекты конфигурации {#sec.buildin_objects}

Конфигурация Synergy CRM включает в себя встроенные объекты:

*   [Группы](#groups)

*   [Счетчики](#counters):
    *   [Счетчик каталога товаров и услуг](#countersCatalog)

*   [Шаблоны номеров](#pattern_number):
    *   [Номер товара в каталоге](#pattern_number_Catalog)

*   [Формы](#forms):
    *   [Маркетинговое мероприятие](#formEvent)
    *   [Лид](#formLead)
    *   [Сделка](#formDeal)
    *   [Аккаунт](#formAccount)
    *   [Контакт](#formContact)
    *   [% комиссии лидогенерации](#formComission)
    *   [% комиссии продаж](#formDealComission)
    *   [Тема сотрудничества](#formTheme)
    *   [Товар (услуга)](#formItem)
    *   [Цена](#formPrice)
    *   [Договор поставки (единовременная оплата)](#formContractDeliveryAll)
    *   [Договор поставки (оплата частями)](#formContractDeliveryPart)
    *   [Коммерческое предложение](#formOffer)
    *   [Акт приема-передачи товара](#formCertificate)
    *   [Счет-фактура](#formInvoice)
    *   [Ответственный за сделки](#formDealResponsible)
    *   [План продаж](#formSales)
    *   [Нормативы продолжительности статусов сделки](#formDealFlowStandard)

*   [Пользовательские компоненты](#userModules)
    *   [crm_component_canban_deal](#uMCanbanDeal)
    *   [crm_component_deals_dashboard](#uMDealsDashboard)
    *   [crm_component_deals_productivity](#uMDealsProductivity)
    *   [crm_component_deal_button](#uMDealButton)
    *   [crm_component_funnel](#uMFunnel)
    *   [crm_component_funnel_deal](#uMFunnelDeal)
    *   [crm_component_group_button](#uMGroupButton)
    *   [crm_component_group_button_deal](#uMGroupButtonDeal)
    *   [crm_component_leads_dashboard](#uMLeadsDashboard)
    *   [crm_component_notifications](#uMNotifications)
    *   [crm_component_registry_chooser](#uMRegistryChooser)

*   [Внешние модули-компоненты](#externalModuleComponents)
    *   [crm_notifications](#eMNotifications)

*   [Реестры](#registries):
    *   [Маркетинговое мероприятие](#registryEvent)
    *   [Лид](#registryLead)
    *   [Сделка](#registryDeal)
    *   [Аккаунт](#registryAccount)
    *   [Контакт](#registryContact)
    *   [% комиссии лидогенерации](#registryComission)
    *   [% комиссии продаж](#registryDealComission)
    *   [Темы сотрудничества](#registryThemes)
    *   [Каталог товаров и услуг](#registryItems)
    *   [Прайс-лист](#registryPriceList)
    *   [Договоры поставки (единовременная оплата)](#registryContractDeliveryAll)
    *   [Договоры поставки (оплата частями)](#registryContractDeliveryPart)
    *   [Коммерческие предложения](#registryOffer)
    *   [Акты приема-передачи товара](#registryCertificates)
    *   [Счет-фактуры](#registryInvoices)
    *   [Ответственный за сделки](#registryDealResponsible)
    *   [План продаж](#registrySalesCost)
    *   [Нормативы продолжительности статусов сделки](#registryDealFlowStandard)

*   [Группы реестров](#registriesGroup)
    *   [Базовый учет продаж](#group_marketing)
        *   [Каталог товаров и услуг](#group_catalog)
        *   [Шаблоны документов](#group_documentTemplates)

*   [Справочники](#dictionaries)
    *   [Статусы лида](#dictionaryLeadStatus)
    *   [Статусы сделки](#dictionaryDealStatus)
    *   [Статусы аккаунта](#dictionaryAccountStatus)
    *   [Статусы контакта](#dictionaryContactStatus)
    *   [Типы мероприятий](#dictionaryEventType)
    *   [Типы активностей](#dictionaryActivityType)
    *   [Телефон](#dictionaryPhone)
    *   [Адрес](#dictionaryAddress)
    *   [Почта](#dictionaryEmail)
    *   [Социальные сети](#dictionarySocialNetworks)
    *   [Действия напоминаний](#dictionaryremindActions)
    *   [Города Казахстана](#dictionaryCities)
    *   [Условия оплаты](#dictionaryPaymentMode)
    *   [Способы отправления](#dictionaryDeliveryMode)
    *   [Месяцы](#dictionaryMonths)

*   [Создание документов](#createDoc)
    *   [Запись аккаунта](#accountRecord)
    *   [Запись контакта](#contactRecord)
    *   [Запись лида](#leadRecord)
    *   [Запись мероприятия](#eventRecord)
    *   [Шаблоны документов](#docTemplates)
        *   [Акт приема-передачи](#certificate)
        *   [Договор поставки (единовременная оплата)](#contract100)
        *   [Договор поставки (оплата частями)](#contractPart)
        *   [Коммерческое предложение](#offer)

*   [Внешние модули](#externalModules)
    *   [Управление маркетингом](#marketing)
    *   [Управление продажами](#sales)

### Группы {#groups}

Группы пользователей с такими кодами:

*   Все маркетологи - crm_groups_all_marketing_specialists
    *   Маркетологи-менеджеры - crm_groups_marketing_managers
    *   Маркетологи-специалисты - crm_groups_marketing_specialists

*   Все специалисты по продажам - crm_groups_all_sales_specialists
    *   Менеджеры по продажам - crm_groups_sales_managers
    *   Специалисты по продажам - crm_groups_sales_specialists

### Счетчики {#counters}

#### Счетчик каталога товаров и услуг {#countersCatalog}

Свойства счетчика:

+--------------------------+----------------------------------------+
| Свойство                 | Значение                               |
+==========================+========================================+
| Код                      | crm_counter_catalog                    |
+--------------------------+----------------------------------------+
| Начальное значение       | 1                                      |
+--------------------------+----------------------------------------+
| Следующее значение       | 1                                      |
+--------------------------+----------------------------------------+
| Период сброса            | Никогда                                |
+--------------------------+----------------------------------------+

### Шаблоны номеров {#pattern_number}

#### Номер товара в каталоге {#pattern_number_Catalog}

Свойства шаблона номера:

+--------------------------+----------------------------------------+
| Свойство                 | Значение                               |
+==========================+========================================+
| Название                 | Номер товара в каталоге                |
+--------------------------+----------------------------------------+
| Формула                  | {crm_counter_catalog}                  |
+--------------------------+----------------------------------------+
| Код                      | crm_number_catalog                     |
+--------------------------+----------------------------------------+

### Формы {#forms}

#### Маркетинговое мероприятие {#formEvent}

Код формы: crm_form_event.

Форма содержит следующие компоненты:

+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                                | Имя компонента                                         |
+========================================================+===============================================================+========================================================+
| **Тип мероприятия**                                    | выпадающий список (справочник *crm_dict_eventType*)           | crm_form_event_main_type                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Наименование мероприятия**                           | однострочное поле                                             | crm_form_event_main_name                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Стоимость**                                          | числовое поле                                                 | crm_form_event_main_cost                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Мероприятие**                                        | ссылка на портфель / проект                                   | crm_form_event_main_event                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Комментарий**                                        | многострочное поле                                            | crm_form_event_main_comment                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Целевой отклик**                                     | числовое поле                                                 | crm_form_event_main_target_response                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Текущий отклик**                                     | числовое поле                                                 | crm_form_event_main_current_response                   |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Оценка эффективности**                               | числовое поле                                                 | crm_form_event_main_rating                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Ответственный менеджер**                             | выбор пользователя                                            | crm_form_event_responsibleManager_responsible          |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+

*Поле "Текущий отклик"*:

*   Флаг "Заблокировать от изменений пользователем" включен.

*   Значение поля - количество всех лидов, связанных с данным мероприятием.

*   Если для данного мероприятия не имеется лидов, поле содержит значение 0.

*   При добавлении, изменении или удалении лида, связанного с данным
    мероприятием, значение поля "Текущий отклик" обновляется в режиме
    реального времени.

*Поле "Оценка эффективности"*:

*   Флаг "Заблокировать от изменений пользователем" включен.

*   Флаг "Ограничение десятичных знаков" включен. Значение поля - 3.

*   Значение поля рассчитывается автоматически по формуле:

    `%значение_поля_"Текущий_отклик"% / %значение_поля_"Целевой_отклик"%`

*   Поле "Оценка эффективности" не может быть пустым.

*   Поле "Оценка эффективности" заполнено значением 0 по умолчанию, а также
    в случае:
    *   поле "Целевой отклик" не заполнено либо содержит значение 0
    *   поле "Текущий отклик " содержит значение 0

*   При изменении значений полей "Текущий отклик" и "Целевой отклик"
    значение поля "Оценка эффективности" пересчитывается в режиме реального
    времени.

#### Лид {#formLead}

Код формы: crm_form_lead.

Форма содержит следующие компоненты:

+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                                | Имя компонента                                         |
+========================================================+===============================================================+========================================================+
| **Мероприятие**                                        | ссылка на реестр "Маркетингоое мероприятие"                   | crm_form_lead_main_action                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Источник лида**                                      | ссылка на реестр "Контакт"                                    | crm_form_lead_main_leadSource                          |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Сделка**                                             | ссылка на реестр "Сделка"                                     | crm_form_lead_main_deal                                |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Контакт**                                            | пользовательский компонент на реестр "Контакт"                | crm_form_lead_main_contact                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Связь с контактом из интерфейса**                    | пользовательский компонент функции связи с контактом          | crm_form_lead_main_contactConnection                   |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Аккаунт**                                            | пользовательский компонент на реестр "Аккаунт"                | crm_form_lead_main_account                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Связь с контактом из интерфейса**                    | пользовательский компонент функции связи с аккаунтом          | crm_form_lead_main_accountConnection                   |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Наименование аккаунта**                              | однострочное поле                                             | crm_form_lead_main_account_name                        |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Сотрудничество**                                     | динамическая таблица                                          | crm_form_lead_deals                                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества                                    | ссылка на реестр "Темы сотрудничества"                        | crm_form_lead_deals_theme                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Потенциальный бюджет                                   | числовое поле                                                 | crm_form_lead_deals_budget                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Статус                                                 | выпадающий список (справочник "crm_dict_dealStatus")          | crm_form_lead_deals_status                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| %кнопка_создания_сделки%                               | пользовательский компонент                                    | crm_form_lead_deals_newDeal                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Ответственный менеджер**                             | выбор пользователя                                            | crm_form_lead_responsibleManager_responsible           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Активность**                                         | пользовательская динамическая таблица                         | crm_form_lead_activity_table                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Пиктограмма типа активности                            | изображение (из справочника "crm_dict_activityType")          | crm_form_lead_activity_icon                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Тип активности                                         | выпадающий список (справочника "crm_dict_activityType")       | crm_form_lead_activity_type                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Комментарий                                            | однострочное поле                                             | crm_form_lead_activity_comment                         |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Дата                                                   | дата                                                          | crm_form_lead_activity_date                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+

*Поле "Сделка"*:

*   Флаг "Заблокировать от изменений пользователем" включен.

*   По умолчанию поле пустое.

*%кнопка_создания_сделки%*:

*   Кнопка не отображается, если в выпадающем списке "Статус" выбрана запись
    справочника [crm_dict_leadStatus](#dictionaryLeadStatus), у которой
    crm_dict_leadStatus_end=1.

*Поле "Пиктограмма типа активности"*:

*   текущее изображение зависит от выбранного значения в выпадающем списке
    "Тип активности" согласно полю crm_dict_activityType_icon справочника
    [crm_dict_activityType](#dictionaryActivityType).

*Поле "Дата"*:

*   Флаг "Заполнять текущей датой/временем" включен.

*Поле "Наимменованеи аккаунта"*:

*   Компонент является скрытым.

*   Компонент может содержать пустое значение.

*   При создании либо выборе аккаунта в модифицированном
    пользовательском компоненте ["Аккаунт"](#formLead)
    (`crm_form_lead_main_account`) новый компонент заполняется
    значением соответствующего поля
    ["Наименование"](#formAccount).

*   При изменении значения аккаунта обновляется и значение
    нового компонента.

#### Сделка {#formDeal}

Код формы: crm_form_deal.

Форма содержит следующие компоненты:

+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                                | Имя компонента                                         |
+========================================================+===============================================================+========================================================+
| **Лид**                                                | ссылка на реестр "Лид"                                        | crm_form_deal_main1_lead                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Тема**                                               | ссылка на реестр "Темы сотрудничества"                        | crm_form_deal_main2_theme                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Описание**                                           | многострочное поле                                            | crm_form_deal_main2_info                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Заказ**                                              | динамическая таблица                                          | crm_form_deal_order                                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
|   №                                                    | однострочное поле                                             | crm_form_deal_order_number                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
|   Наименование товара                                  | ссылка на реестр "Прайс-лист"                                 | crm_form_deal_order_orderList                          |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
|   Ед.изм.                                              | однострочное поле                                             | crm_form_deal_order_unit                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
|   Количество                                           | числовое поле                                                 | crm_form_deal_order_amount                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
|   Цена за ед.                                          | числовое поле                                                 | crm_form_deal_order_price                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
|   Сумма, тенге                                         | числовое поле                                                 | crm_form_deal_order_total                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Бюджет**                                             | числовое поле                                                 | crm_form_deal_main3_budget                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Статус**                                             | выпадающий список (справочник "crm_dict_dealStatus")          | crm_form_deal_main3_status                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Причина отказа                                         | многострочное поле                                            | crm_form_deal_main3_rejection                          |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Задачи**                                             | динамическая таблица                                          | crm_form_deal_tasks                                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Проект                                                 | ссылка на проект                                              | crm_form_deal_tasks_project                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Документы**                                          | динамическая таблица                                          | crm_form_deal_files                                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Файл                                                   | файл                                                          | crm_form_deal_files_file                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Ответственный менеджер**                             | выбор пользователя                                            | crm_form_deal_responsibleManager_responsible           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Активность**                                         | пользовательская динамическая таблица                         | crm_form_deal_activity_table                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Пиктограмма типа активности                            | изображение (из справочника "crm_dict_activityType")          | crm_form_deal_activity_icon                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Тип активности                                         | выпадающий список (справочника "crm_dict_activityType")       | crm_form_deal_activity_type                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Комментарий                                            | однострочное поле                                             | crm_form_deal_activity_comment                         |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Дата                                                   | дата                                                          | crm_form_deal_activity_date                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Предыдущий статус**                                  | выпадающий список (справочник «crm_dict_dealStatus»)          | crm_form_deal_previous_status                          |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Время нахождения в статусе**                         | числовое поле                                                 | crm_form_deal_previous_status_duration                 |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Просроченность**                                     | числовое поле                                                 | crm_form_deal_expired                                  |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| **Переход в негативный статус**                        | числовое поле                                                 | crm_form_deal_refused                                  |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+

*Поле "Лид"*:

*   Флаг "Заблокировать от изменений пользователем" включен.

*Поле "Сумма"*:

*   Значение поля рассчитывается как:

    `%стоимость_в_прайс-листе% * crm_form_deal_order_orderAmount`

*   Флаг "Заблокировать от изменений пользователем" включен.

*Поле "Бюджет"*:

*   Флаг "Заблокировать от изменений пользователем" включен.

*   Значение поля - сумма значений всех полей "Сумма".

*Поле "Причина отказа"*:

*   Поле отображается только в случае, если поле "Статус" имеет значение
    "Отказ".

*Поле "Пиктограмма типа активности"*:

*   текущее изображение зависит от выбранного значения в выпадающем списке
    "Тип активности" согласно полю crm_dict_activityType_icon справочника
    [crm_dict_activityType](#dictionaryActivityType).

*Поле "Дата"*:

*   Флаг "Заполнять текущей датой/временем" включен.

*Поле "Предыдущий статус"*:

*   Значение поля - предыдущее значение поля "Статус" (crm_form_deal_main3_status).

*   Если статус сделки ранее не изменялся - поле содежит текущее значение
    поля "Статус" (crm_form_deal_main3_status).

*   Значение компонента актуализируется в 00:00:00.

*   Компонент скрыт.

*Поле "Время нахождения в статусе"*:

*   Значение поля рассчитывается как:

    `дата и время сохранения текущего статуса - дата и время сохранения предыдущего статуса`

*   Если статус сделки ранее не изменялся - поле содержит значение "0".

*   Значение компонента актуализируется в 00:00:00.

*   Компонент скрыт.

*Поле "Просроченность"*:

*   Поле не может быть пустым.

*   Просроченность для сделки со статусом, имеющим значение
    crm_dict_dealStatus_end=1 или crm_dict_dealStatus_quality=0, не
    рассчитывается, поле содержит значение "0".

*   Значение поля определется условиями:

    *   фактическое время нахождения в статусе больше либо равно значению
        поля "Продолжительность (в днях)"
        (crm_form_deal_flow_standart_duration) соответствующего статуса.

    *   суммарное время нахождения в неконечных статусах больше либо равно
        сумме значений полей
        "Продолжительность (в днях)"
        (crm_form_deal_flow_standart_duration) всех неконечных статусов.

        > **Примечание:**
        >
        > * Для предрасчетов просроченности используется первая запись реестра
        >   "Нормативы продолжительности статусов сделки".
        >  
        > * Если документ по форме имеет несколько значений "Продолжительность
        >   (в днях)" для одного статуса, в предрасчет идет последнее.
        >
        > * Если для статуса не указано значение "Продолжительность (в днях)"
        >   в предрасчет идет значение поля "Продолжительность по умолчанию
        >   (в днях)" (crm_form_deal_flow_standard_default_duration).
        >
        > * При смене статуса на предыдущий (согласно полю crm_dict_dealStatus_value
        >   справочника Статусы сделки) все
        >   продолжительности статусов аннулируются до того статуса, который
        >   будет являться предыдущим относительного нового.


*   Если выполняется хотя бы одно условие, описанное выше, то поле
    "Просроченность" содержит значение "1".

*   Если не выполняется ни одно условие, описанное выше, то поле
    "Просроченность" содержит значение "0".

*   Значение компонента актуализируется в 00:00:00.

*   Компонент скрыт.

*Поле "Переход в негативный статус"*:

*   Поле не может быть пустым.

*   Значение поля определется текущим статусом:

    *   Если выпадающий список "Статус сделки" имеет значение записи
        справочника Статусы сделки
        crm_dict_dealStatus_quality=0, поле "Переход в негативный статус"
        содержит значение 1.

    *   Если выпадающий список "Статус сделки" имеет значение записи
        справочника Статусы сделки
        crm_dict_dealStatus_quality=1, поле "Переход в негативный статус"
        содержит значение 0.

*   Значение компонента актуализируется в 00:00:00.

*   Компонент скрыт.

#### Аккаунт {#formAccount}

Код формы: crm_form_account.

Форма содержит следующие компоненты:

+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                           | Имя компонента                                         |
+========================================================+==========================================================+========================================================+
| **Лид**                                                | ссылка на реестр "Лид"                                   | crm_form_account_lead_lead                             |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Логотип**                                            | файл                                                     | crm_form_account_logo                                  |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Наименование**                                       | однострочное поле                                        | crm_form_account_main_name                             |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Описание**                                           | многострочное поле                                       | crm_form_account_main_info                             |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Вид деятельности**                                   | дата                                                     | crm_form_account_main_activityCategory                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Выручка**                                            | числовое поле                                            | crm_form_account_main_revenue                          |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Численность штата**                                  | многострочное поле                                       | crm_form_account_main_staffAmount                      |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Статус**                                             | выпадающий список (справочник *crm_dict_accountStatus*)  | crm_form_account_main_status                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Телефон**                                            | динамическая таблица                                     | crm_form_account_phone                                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип номера телефона                                    | выпадающий список (справочник *crm_dict_phone*)          | crm_form_account_phone_phoneCombo                      |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Номер телефона                                         | однострочное поле                                        | crm_form_account_phone_phone                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **E-mail**                                             | динамическая таблица                                     | crm_form_account_email                                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип почтового адреса                                   | выпадающий список (справочник *crm_dict_email*)          | crm_form_account_email_emailCombo                      |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Почтовый адрес                                         | однострочное поле                                        | crm_form_account_email_email                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Адрес**                                              | динамическая таблица                                     | crm_form_account_address                               |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип адреса                                             | выпадающий список (справочник *crm_dict_address*)        | crm_form_account_address_addressCombo                  |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Адрес                                                  | многострочное поле                                       | crm_form_account_address_address                       |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Социальные сети**                                    | динамическая таблица                                     | crm_form_account_socialNetworks                        |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип социальной сети                                    | выпадающий список (справочник *crm_dict_socialNetworks*) | crm_form_account_socialNetworks_socialNetworksCombo    |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Социальная сеть                                        | однострочное поле                                        | crm_form_account_socialNetworks_socialNetworks         |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Материнский аккаунт**                                | ссылка на реестр *Аккаунт*                               | crm_form_account_parentAccount_parentAccount           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Дочерние аккаунты**                                  | динамическая таблица                                     | crm_form_account_childAccount                          |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Аккаунты                                               | ссылка на реестр *Аккаунт*                               | crm_form_account_childAccount_account                  |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Ответственный менеджер**                             | выбор пользователя                                       | crm_form_account_responsibleManager_responsible        |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+

#### Контакт {#formContact}

Код формы: crm_form_contact.

Форма содержит следующие компоненты:

+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                           | Имя компонента                                         |
+========================================================+==========================================================+========================================================+
| **Лид**                                                | ссылка на реестр "Лид"                                   | crm_form_contact_lead_lead                             |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Фото**                                               | файл                                                     | crm_form_contact_photo                                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Полное имя**                                         | однострочное поле                                        | crm_form_contact_main_fullName                         |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Должность**                                          | многострочное поле                                       | crm_form_contact_main_position                         |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Дата рождения**                                      | дата                                                     | crm_form_contact_main_birthDate                        |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Статус**                                             | выпадающий список (справочник *crm_dict_contactStatus*)  | crm_form_contact_main_status                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Информация**                                         | многострочное поле                                       | crm_form_contact_main_info                             |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Телефон**                                            | динамическая таблица                                     | crm_form_contact_phone                                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип номера телефона                                    | выпадающий список (справочник *crm_dict_phone*)          | crm_form_contact_phone_phoneCombo                      |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Номер телефона                                         | однострочное поле                                        | crm_form_contact_phone_phone                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **E-mail**                                             | динамическая таблица                                     | crm_form_contact_email                                 |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип почтового адреса                                   | выпадающий список (справочник *crm_dict_email*)          | crm_form_contact_email_emailCombo                      |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Почтовый адрес                                         | однострочное поле                                        | crm_form_contact_email_email                           |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Адрес**                                              | динамическая таблица                                     | crm_form_contact_address                               |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип адреса                                             | выпадающий список (справочник *crm_dict_address*)        | crm_form_contact_address_addressCombo                  |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Адрес                                                  | многострочное поле                                       | crm_form_contact_address_address                       |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Социальные сети**                                    | динамическая таблица                                     | crm_form_contact_socialNetworks                        |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Тип социальной сети                                    | выпадающий список (справочник *crm_dict_socialNetworks*) | crm_form_contact_socialNetworks_socialNetworksCombo    |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| Социальная сеть                                        | однострочное поле                                        | crm_form_contact_socialNetworks_socialNetworks         |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+
| **Ответственный менеджер**                             | выбор пользователя                                       | crm_form_contact_responsibleManager_responsible        |
+--------------------------------------------------------+----------------------------------------------------------+--------------------------------------------------------+

#### % комиссии лидогенерации {#formComission}

Код формы: crm_form_lead_comission.

Форма содержит следующие компоненты:

+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                         | Имя компонента                                         |
+========================================================+========================================================+========================================================+
| **% комссии**                                          | динамическая таблица                                   | crm_form_lead_comission_main                           |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Дата начала                                            | дата                                                   | crm_form_lead_comission_main_start_date                |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Дата окончания                                         | дата                                                   | crm_form_lead_comission_main_finish_date               |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| % комиссии                                             | числовое поле                                          | crm_form_lead_comission_main_comission                 |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+

*Динамическая таблица "% комиссии"*:

*   Форматная строка:

    `[Значение ${crm_form_comission_main_deal_comission}% с ${crm_form_lead_comission_main_start_date} по ${crm_form_lead_comission_main_finish_date}]`

*Поле "Дата начала"*:

*   Флаги "Заблокировать от изменений пользователем" и "Заполнять текущей
    датой/временем" включены.

*Поле "Дата окончания"*:

*   Флаг "Заблокировать от изменений пользователем" включен.

*   Компонент в последней строке заполняется текущей датой при добавлении
    новой строки динамической таблицы.

*Поле "% комиссии"*:

*   Значение поля по умолчанию при создании записи реестра - *5*.

#### % комиссия продаж {#formDealComission}

Код формы: crm_form_deal_comission.

Форма содержит следующие компоненты:

+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                         | Имя компонента                                         |
+========================================================+========================================================+========================================================+
| **% комссии**                                          | динамическая таблица                                   | crm_form_deal_comission_main                           |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Дата начала                                            | дата                                                   | crm_form_deal_comission_main_start_date                |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Дата окончания                                         | дата                                                   | crm_form_deal_comission_main_finish_date               |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| % комиссии                                             | числовое поле                                          | crm_form_deal_comission_main_comission                 |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+

*Динамическая таблица "% комиссии"*:

*   Форматная строка:

    `[Значение ${crm_form_comission_main_deal_comission}% с ${crm_form_deal_comission_main_start_date} по ${crm_form_deal_comission_main_finish_date}]`

*Поле "Дата начала"*:

*   Флаги "Заблокировать от изменений пользователем" и "Заполнять текущей
    датой/временем" включены.

*Поле "Дата окончания"*:

*   Флаг "Заблокировать от изменений пользователем" включен.

*   Компонент в последней строке заполняется текущей датой при добавлении
    новой строки динамической таблицы.

*Поле "% комиссии"*:

*   Значение поля по умолчанию при создании записи реестра - *5*.

#### Тема сотрудничества {#formTheme}

Код формы: crm_form_theme.

Форма содержит следующие компоненты:

+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                         | Имя компонента                                         |
+========================================================+========================================================+========================================================+
| Тема сотрудничества                                    | однострочное поле                                      | crm_form_theme_theme                                   |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+

#### Товар (услуга) {#formItem}

Код формы: crm_form_item.

Форма содержит следующие компоненты:

+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                                | Имя компонента                                         |
+========================================================+===============================================================+========================================================+
| ID товара                                              | номер (шаблон номера "Номер товара в каталоге")               | crm_form_item_id                                       |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Наименование                                           | однострочное поле                                             | crm_form_item_name                                     |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Описание                                               | многострочное поле                                            | crm_form_item_description                              |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+

#### Цена {#formPrice}

Код формы: crm_form_price.

Форма содержит следующие компоненты:

+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                                | Имя компонента                                         |
+========================================================+===============================================================+========================================================+
| Товар                                                  | ссылка на реестр "Каталог товаров и услуг"                    | crm_form_price_item_name                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Описание                                               | многострочное поле                                            | crm_form_price_description                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Единица измерения                                      | однострочное поле                                             | crm_form_price_unit                                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Цена                                                   | числовое поле                                                 | crm_form_price_price                                   |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+

Для компонента "Товар" настроено сопоставление:

*   `crm_form_item_description` - `crm_form_price_description` - `EQUAL`.

#### Формы шаблонов документов {#formsTemplates}

Для всех форм ниже одинаково настроен **компонент выбора адресата**:

***Для выпадающего списка "Источник адреса" настроены следующие значения:***

*   Аккаунт - 0

*   Контакт - 1

*   Ручной ввод - 2

При этом:

*	Если в поле *`choice`* выбрано значение "Аккаунт", то доступно поле
`account_link`, поле `contact_link` скрыто.

*	Если в поле *`choice`* выбрано значение "Контакт", то доступно поле
`contact_link`, поле `account_link` скрыто.

*	Если в поле *`choice`* выбрано значение "Ручной ввод", то поля
`account_link` и `contact_link` оба скрыты.

***Для компонента "Выбрать аккаунт" настроено сопоставление:***

*   `crm_form_account_email` - `crm_form_account_email` - `EQUAL`

***Для компонента "Выбрать контакт" настроено сопоставление:***

*   `crm_form_contact_email` - `crm_form_contact_email` - `EQUAL`

Таблицы "Адреса аккаунта" и "Адреса контакта" являются служебными
и не отображаются пользователю.

***Поведение поля `choice`***

Если в поле *`choice`* выбрано значение "Аккаунт", то должно быть доступно
поле `account_link`, поле `contact_link` скрыто.

Если в поле *`choice`* выбрано значение "Контакт", то должно быть доступно
поле `contact_link`, поле `account_link` скрыто.

Если в поле *`choice`* выбрано значение "Ручной ввод", то поля `account_link`
и `contact_link` должны быть скрыты.

***Поведение поля `email`***

1. Для случая, когда заполняется поле `account_link`, в поле *`email`* требуется
отображать значение поля *`crm_form_contact_email.crm_form_contact_email_email`*.
В случае, если таблица *`crm_form_contact_email`* для выбранного контакта содержит
больше одного элемента, выбирать значение в зависимости от значения поля
*`crm_form_contact_email.crm_form_contact_email_emailCombo`* по значение с минимальным
порядковым номером записи справочника crm_dict_email.

2. Для случая, когда заполняется поле `contact_link`, в поле *`email`* требуется
отображать значение поля *`crm_form_account_email.crm_form_account_email_email`*.
В случае, если таблица *`crm_form_account_email`* для выбранного контакта содержит
больше одного элемента, выбирать значение в зависимости от значения поля
*`crm_form_account_email.crm_form_account_email_emailCombo`* тем же приоритетам,
что и для пункта 1.

3. Для случая, когда в поле *`choice`* выбрано значение "Ручной ввод", поле *`email`*
должно заполняться вручную.

##### Договор поставки (единовременная оплата) {#formContractDeliveryAll}

Код формы: crm_form_contract_delivery_100.

Форма содержит следующие компоненты:

+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Поле                             | Тип компонента                                    | Имя компонента                                         |
+==================================+===================================================+========================================================+
| **Номер договора**               | однострочное поле                                 | crm_form_contract_delivery_100_contract_number         |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Город**                        | выпадающий список (справочник crm_dict_cities)    | crm_form_contract_delivery_100_city_from               |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата договора**                | выбор даты                                        | crm_form_contract_delivery_100_contract_date           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Основание (сделка)**           | ссылка на реестр "Сделки"                         | crm_form_contract_delivery_100_deal                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Заказчик (аккаунт)**           | ссылка на реестр "Аккаунты"                       | crm_form_contract_delivery_100_client_account          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Заказчик (контакт)**           | ссылка на реестр "Контакты"                       | crm_form_contract_delivery_100_client_client           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Основание заказчика**          | однострочное поле                                 | crm_form_contract_delivery_100_client_reason           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Поставщик (организация)**      | выбор подразделений (всегда выбрана корневая нода)| crm_form_contract_delivery_100_provider                |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Представитель поставщика**     | выбор пользователя                                | crm_form_contract_delivery_100_provider_name           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Основание поставщика**         | однострочное поле                                 | crm_form_contract_delivery_100_provider_base           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Товар**                        | однострочное поле (тема сотрудничества из         | crm_form_contract_delivery_100_theme                   |
|                                  | выбранной записи в поле "Основание (сделка))"     |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Срок поставки товара**         | числовое поле                                     | crm_form_contract_delivery_100_time                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Срок поставки (прописью)**     | однострочное поле                                 | crm_form_contract_delivery_100_time_by_text            |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Город поставки**               | выпадающий список (справочник crm_dict_cities)    | crm_form_contract_delivery_100_city_to                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адрес**                        | однострочное поле                                 | crm_form_contract_delivery_100_address                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Общая сумма договора**         | числовое поле                                     | crm_form_contract_delivery_100_sum_total               |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Сумма договора (прописью)**    | однострочное поле                                 | crm_form_contract_delivery_100_sum_total_by_text       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Срок предоставления Акта**     | числовое поле                                     | crm_form_contract_delivery_100_act_time                |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Срок действия договора**       | выбор даты                                        | crm_form_contract_delivery_100_contract_time_to        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Юридический адрес Заказчика**  | многострочное поле                                | crm_form_contract_delivery_100_client_requisites1      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Юридический адрес Поставщика** | многострочное поле                                | crm_form_contract_delivery_100_provider_requisites1    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Реквизиты Заказчика**          | ссылка                                            | crm_form_contract_delivery_100_client_requisites2      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Реквизиты Поставщика**         | многострочное поле                                | crm_form_contract_delivery_100_provider_requisites2    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора (приложение)**  | однострочное поле                                 | crm_form_contract_delivery_100_contract_number_appendix|
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата договора (приложение)**   | выбор даты                                        | crm_form_contract_delivery_100_contract_date_appendix  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Перечень закупаемых товаров**  | динамическая таблица (из группы полей "Заказ"     | crm_form_contract_delivery_100_items                   |
|                                  | сделки, указанной в поле "Основание (сделка)")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   №                              | однострочное поле                                 | crm_form_deal_order_number                             |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Наименование Товара            | ссылка на реестр "Прайс-лист"                     | crm_form_deal_order_orderList                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Ед.изм.                        | однострочное поле                                 | crm_form_deal_order_unit                               |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Кол-во                         | числовое поле                                     | crm_form_deal_order_amount                             |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Цена за ед., тенге             | числовое поле                                     | crm_form_deal_order_price                              |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Сумма, тенге                   | числовое поле                                     | crm_form_deal_order_total                              |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Итого**                        | числовое поле                                     | crm_form_contract_delivery_100_items_total             |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Подпись заказчика**            | ссылка на реестр "Контакты"                       | crm_form_contract_delivery_100_client_account_appendix |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Подпись поставщика**           | выбор пользователя                                | crm_form_contract_delivery_100_provider_name_appendix  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Источник адреса**              | выпадающий список                                 | choice                                                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выбрать аккаунт**              | ссылка на реестр "Аккаунты"                       | account_link                                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выбрать контакт**              | ссылка на реестр "Контакты"                       | contact_link                                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **E-mail**                       | однострочное поле                                 | email                                                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адреса аккаунта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_account_email                                 |
|                                  | аккаунта, указанного в поле "Выбрать аккаунт")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Актуальный адрес аккаунта**    | однострочное поле                                 | crm_form_account_email_email                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адреса контакта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_contact_email                                 |
|                                  | контакта, указанного в поле "Выбрать контакт")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Актуальный адрес контакта**    | однострочное поле                                 | crm_form_contact_email_email                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+

*Компоненты выбора даты*:

*   Формат даты всех компонентов выбора дат - `"${dd}" ${monthed} ${yyyy}г.`

##### Договор поставки (оплата частями) {#formContractDeliveryPart}

Код формы: crm_form_contract_delivery_part.

Форма содержит следующие компоненты:

+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| Поле                             | Тип компонента                                    | Имя компонента                                           |
+==================================+===================================================+==========================================================+
| **Номер договора**               | однострочное поле                                 | crm_form_contract_delivery_part_contract_number          |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Город**                        | выпадающий список (справочник crm_dict_cities)    | crm_form_contract_delivery_part_city_from                |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Дата договора**                | выбор даты                                        | crm_form_contract_delivery_part_contract_date            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Основание (сделка)**           | ссылка на реестр "Сделки"                         | crm_form_contract_delivery_part_deal                     |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Заказчик (аккаунт)**           | ссылка на реестр "Аккаунты"                       | crm_form_contract_delivery_part_client_account           |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Заказчик (контакт)**           | ссылка на реестр "Контакты"                       | crm_form_contract_delivery_part_client_client            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Основание заказчика**          | однострочное поле                                 | crm_form_contract_delivery_part_client_reason            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Поставщик (организация)**      | выбор подразделений (всегда выбрана корневая нода)| crm_form_contract_delivery_part_provider                 |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Представитель поставщика**     | выбор пользователя                                | crm_form_contract_delivery_part_provider_name            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Основание поставщика**         | однострочное поле                                 | crm_form_contract_delivery_part_provider_base            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Товар**                        | однострочное поле (тема сотрудничества из         | crm_form_contract_delivery_part_theme                    |
|                                  | выбранной записи в поле "Основание (сделка))"     |                                                          |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Срок поставки товара**         | числовое поле                                     | crm_form_contract_delivery_part_time                     |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Срок поставки (прописью)**     | однострочное поле                                 | crm_form_contract_delivery_part_time_by_text             |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Город поставки**               | выпадающий список (справочник crm_dict_cities)    | crm_form_contract_delivery_part_city_to                  |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Адрес**                        | однострочное поле                                 | crm_form_contract_delivery_part_address                  |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Общая сумма договора**         | числовое поле                                     | crm_form_contract_delivery_part_sum_total                |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Сумма договора (прописью)**    | однострочное поле                                 | crm_form_contract_delivery_part_sum_total_by_text        |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Размер аванса**                | однострочное поле                                 | crm_form_contract_delivery_part_avans                    |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Срок выплаты аванса**          | однострочное поле                                 | crm_form_contract_delivery_part_avans_time               |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Размер доплаты**               | однострочное поле                                 | crm_form_contract_delivery_part_balance                  |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Срок предоставления Акта**     | числовое поле                                     | crm_form_contract_delivery_part_act_time                 |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Срок действия договора**       | выбор даты                                        | crm_form_contract_delivery_part_contract_time_to         |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Юридический адрес Заказчика**  | многострочное поле                                | crm_form_contract_delivery_part_client_requisites1       |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Юридический адрес Поставщика** | многострочное поле                                | crm_form_contract_delivery_part_provider_requisites1     |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Реквизиты Заказчика**          | ссылка                                            | crm_form_contract_delivery_part_client_requisites2       |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Реквизиты Поставщика**         | многострочное поле                                | crm_form_contract_delivery_part_provider_requisites2     |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Номер договора (приложение)**  | однострочное поле                                 | crm_form_contract_delivery_part_contract_number_appendix |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Дата договора (приложение)**   | выбор даты                                        | crm_form_contract_delivery_part_contract_date_appendix   |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Перечень закупаемых товаров**  | динамическая таблица (из группы полей "Заказ"     | crm_form_contract_delivery_part_items                    |
|                                  | сделки, указанной в поле "Основание (сделка)")    |                                                          |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   №                              | однострочное поле                                 | crm_form_deal_order_number                               |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   Наименование Товара            | ссылка на реестр "Прайс-лист"                     | crm_form_deal_order_orderList                            |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   Ед.изм.                        | однострочное поле                                 | crm_form_deal_order_unit                                 |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   Кол-во                         | числовое поле                                     | crm_form_deal_order_amount                               |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   Цена за ед., тенге             | числовое поле                                     | crm_form_deal_order_price                                |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
|   Сумма, тенге                   | числовое поле                                     | crm_form_deal_order_total                                |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Итого**                        | числовое поле                                     | crm_form_contract_delivery_part_items_total              |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Подпись заказчика**            | ссылка на реестр "Контакты"                       | crm_form_contract_delivery_part_client_account_appendix  |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Подпись поставщика**           | выбор пользователя                                | crm_form_contract_delivery_part_provider_name_appendix   |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Источник адреса**              | выпадающий список                                 | choice                                                   |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Выбрать аккаунт**              | ссылка на реестр "Аккаунты"                       | account_link                                             |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Выбрать контакт**              | ссылка на реестр "Контакты"                       | contact_link                                             |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **E-mail**                       | однострочное поле                                 | email                                                    |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Адреса аккаунта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_account_email                                   |
|                                  | аккаунта, указанного в поле "Выбрать аккаунт")    |                                                          |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Актуальный адрес аккаунта**    | однострочное поле                                 | crm_form_account_email_email                             |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Адреса контакта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_contact_email                                   |
|                                  | контакта, указанного в поле "Выбрать контакт")    |                                                          |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+
| **Актуальный адрес контакта**    | однострочное поле                                 | crm_form_contact_email_email                             |
+----------------------------------+---------------------------------------------------+----------------------------------------------------------+

*Компоненты выбора даты*:

*   Формат даты всех компонентов выбора дат - `"${dd}" ${monthed} ${yyyy}г.`

##### Акт приема-передачи товара {#formCertificate}

Код формы: crm_form_certificate.

Форма содержит следующие компоненты:

+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Поле                             | Тип компонента                                    | Имя компонента                                         |
+==================================+===================================================+========================================================+
| **Заказчик**                     | ссылка на реестр "Аккаунты"                       | crm_form_certificate_table1_customer                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Поставщик**                    | компонент выбора подразделений                    | crm_form_certificate_table1_supplier                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Город**                        | выпадающий список (справочник crm_dict_cities)    | crm_form_certificate_table2_city                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата**                         | дата                                              | crm_form_certificate_table2_date                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Договор**                      | ссылка на реестр "Договоры поставки"              | crm_form_certificate_table3_contract                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table4_number                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table4_date                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Товар**                        | динамическая таблица                              | crm_form_certificate_table5                            |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| П/п                              | числовое поле                                     | crm_form_certificate_table5_n                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Наименование                     | ссылка на реестр "Каталог товаров и услуг"        | crm_form_certificate_table5_goods                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Количество                       | числовое поле                                     | crm_form_certificate_table5_amount                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Сумма                            | числовое поле                                     | crm_form_certificate_table5_summ                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Общая стоимость товара**       | числовое поле                                     | crm_form_certificate_table6_cost                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table7_number                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table7_date                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table8_number                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table9_date                       |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Аккаунт заказчика**            | ссылка на реестр "Аккаунт"                        | crm_form_certificate_table10_account                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Контакт заказчика**            | ссылка на реестр "Контакт"                        | crm_form_certificate_table10_contact                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Договор заказчика**            | ссылка на реестр "Договоры поставки"              | crm_form_certificate_table11_contract                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Подразделение исполнителя**    | компонент выбора подразделений                    | crm_form_certificate_table12_account                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Исполнитель**                  | компонент выбора пользователей                    | crm_form_certificate_table12_contact                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Договор исполнителя**          | ссылка на реестр "Договоры поставки"              | crm_form_certificate_table13_contract                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table14_number                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table15_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Список работ**                 | динамическая таблица                              | crm_form_certificate_table16                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Виды работ                       | ссылка на реестр "Каталог товаров и услуг"        | crm_form_certificate_table16_goods                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Сумма**                        | числовое поле                                     | crm_form_certificate_table17_summ1                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Сумма (прописью)**             | однострочное поле                                 | crm_form_certificate_table17_summ2                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата**                         | дата                                              | crm_form_certificate_table18_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Передал**                      | ссылка на реестр "Контакт"                        | crm_form_certificate_table19_supplier                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Принял**                       | компонент выбора пользователей                    | crm_form_certificate_table19_customer                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table20_number                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table21_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Заказчик**                     | ссылка на реестр "Контакт"                        | crm_form_certificate_table22_customer                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **ИИН/БИН заказчика**            | числовое поле                                     | crm_form_certificate_table22_customerID                |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Исполнитель**                  | компонент выбора пользователей                    | crm_form_certificate_table22_responder                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **ИИН/БИН исполнителя**          | числовое поле                                     | crm_form_certificate_table22_responderID               |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Договор**                      | ссылка на реестр "Договоры поставки"              | crm_form_certificate_table23_contract                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора**               | однострочное поле                                 | crm_form_certificate_table23_number                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата заключения договора**     | дата                                              | crm_form_certificate_table23_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выполненные работы**           | динамическая таблица                              | crm_form_certificate_table24                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Номер                            | числовое поле                                     | crm_form_certificate_table16_goods                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Наименование                     | ссылка на реестр "Каталог товаров и услуг"        | crm_form_certificate_table24_goods                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Дата                             | дата                                              | crm_form_certificate_table24_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Сведения об отчете               | однострочное поле                                 | crm_form_certificate_table24_comment                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Единица измерения                | однострочное поле                                 | crm_form_certificate_table24_unit                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Количество                       | числовое поле                                     | crm_form_certificate_table24_amount                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Цена                             | числовое поле                                     | crm_form_certificate_table24_price                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость                        | числовое поле                                     | crm_form_certificate_table24_summ                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Итоговое количество**          | числовое поле                                     | crm_form_certificate_table25_finalAmount               |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Итоговая стоимость**           | числовое поле                                     | crm_form_certificate_table25_finalSumm                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Наименование запасов**         | однострочное поле                                 | crm_form_certificate_table26_name                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Количество запасов**           | числовое поле                                     | crm_form_certificate_table26_amount                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Стоимость запасов**            | числовое поле                                     | crm_form_certificate_table26_cost                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Количество страниц**           | числовое поле                                     | crm_form_certificate_table27_amount                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Список приложений**            | однострочное поле                                 | crm_form_certificate_list                              |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата подписания**              | дата                                              | crm_form_certificate_table28_date                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Заказчик**                     | ссылка на реестр "Контакт"                        | crm_form_certificate_table29_customer                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Исполнитель**                  | компонент выбора пользователей                    | crm_form_certificate_table29_responder                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Источник адреса**              | выпадающий список                                 | choice                                                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выбрать аккаунт**              | ссылка на реестр "Аккаунты"                       | account_link                                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выбрать контакт**              | ссылка на реестр "Контакты"                       | contact_link                                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **E-mail**                       | однострочное поле                                 | email                                                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адреса аккаунта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_account_email                                 |
|                                  | аккаунта, указанного в поле "Выбрать аккаунт")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Актуальный адрес аккаунта**    | однострочное поле                                 | crm_form_account_email_email                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адреса контакта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_contact_email                                 |
|                                  | контакта, указанного в поле "Выбрать контакт")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Актуальный адрес контакта**    | однострочное поле                                 | crm_form_contact_email_email                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+

*Компоненты выбора даты*:

*   Формат даты всех компонентов выбора дат - `"${dd}" ${monthed} ${yyyy}г.`

##### Коммерческое предложение {#formOffer}

Код формы: crm_form_offer.

Форма содержит следующие компоненты:

+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                                | Имя компонента                                         |
+========================================================+===============================================================+========================================================+
| Аккаунт                                                | ссылка на реестр "Аккаунты"                                   | crm_form_offer_account                                 |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Контакты для шапки справа                              | ссылка на реестр "Контакты"                                   | crm_form_offer_contact1                                |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Контакты для ИО в центре после Уважаемый               | ссылка на реестр "Контакты"                                   | crm_form_offer_contact2                                |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Должность                                              | однострочное поле                                             | crm_form_offer_whom_position                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Аккаунт3                                               | однострочное поле                                             | crm_form_offer_whom_account                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| ФИО                                                    | однострочное поле                                             | crm_form_offer_whom_fullname                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Уважаемый                                              | однострочное поле                                             | crm_form_offer_address_dear                            |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| ИО в обращении                                         | однострочное поле                                             | crm_form_offer_address_fullname                        |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Количество листов                                      | однострочное поле                                             | crm_form_offer_attachment_number                       |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Должность отправителя                                  | выбор должности                                               | crm_form_offer_from_position                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| ФИО отправителя                                        | выбор пользователя                                            | crm_form_offer_from_user                               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Организация отправителя                                | однострочное поле                                             | crm_form_offer_from_organization                       |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Прайс-листы                                            | динамическая таблица                                          | crm_form_offer_price                                   |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Прайс-лист                                             | ссылка на реестр "Прайс-лист"                                 | crm_form_offer_price_price                             |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Стоимость реализации проекта                           | динамическая таблица                                          | crm_form_offer_project_price                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Номер                                                  | однострочное поле                                             | crm_form_offer_project_price_number                    |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Название товара или услуги                             | однострочное поле                                             | crm_form_offer_project_price_item_name                 |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Цена                                                   | числовое поле                                                 | crm_form_offer_project_price_price                     |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Описание                                               | многострочное поле                                            | crm_form_offer_project_price_description               |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Сумма                                                  | числовое поле                                                 | crm_form_offer_project_summa_summa                     |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Источник адреса                                        | выпадающий список                                             | choice                                                 |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Выбрать аккаунт                                        | ссылка на реестр "Аккаунты"                                   | account_link                                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Выбрать контакт                                        | ссылка на реестр "Контакты"                                   | contact_link                                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| E-mail                                                 | однострочное поле                                             | email                                                  |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Адреса аккаунта                                        | динамическая таблица (из группы полей "E-mail"                | crm_form_account_email                                 |
|                                                        | аккаунта, указанного в поле "Выбрать аккаунт")                |                                                        |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Актуальный адрес аккаунта                              | однострочное поле                                             | crm_form_account_email_email                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Адреса контакта                                        | динамическая таблица (из группы полей "E-mail"                | crm_form_contact_email                                 |
|                                                        | контакта, указанного в поле "Выбрать контакт")                |                                                        |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+
| Актуальный адрес контакта                              | однострочное поле                                             | crm_form_contact_email_email                           |
+--------------------------------------------------------+---------------------------------------------------------------+--------------------------------------------------------+

*Для компонента "Аккаунт" настроено сопоставление*:

*   `crm_form_account_main_name` - `crm_form_offer_whom_account` - `EQUAL`

*Для компонента "Контакты для шапки справа" настроено сопоставление:*

*   `crm_form_contact_main_fullName` - `crm_form_offer_whom_fullname` - `EQUAL`

*   `crm_form_contact_main_position` - `crm_form_offer_whom_position` - `EQUAL`

*Для компонента "Контакты для ИО в центре после Уважаемый" настроено сопоставление:*

*   `crm_form_contact_main_fullName` - `crm_form_offer_address_fullname` - `POSTFIX` - !

*Для компонента "ФИО отправителя" настроены:*

*   связь с компонентом `crm_form_offer_from_position`

*   включена опция "Изменить формат отображения ФИО в зависимости от языка системы"
    с форматом `${l} ${f.short}.${p.short.dot}`

    `%стоимость_в_прайс-листе% * crm_form_deal_order_orderAmount`

*Для компонента "Прайс-лист" настроено сопоставление:*

*   `crm_form_price_item_name` - `crm_form_offer_project_price_item_name` - `EQUAL`   

*   `crm_form_price_price` - `crm_form_offer_project_price_price` - `EQUAL`

*   `crm_form_price_description` - `crm_form_offer_project_price_description` - `EQUAL`

*Для поля "Описание":*

*   включена опция "Не удалять пробелы в начале строки"

##### Счет-фактура {#formInvoice}

Код формы: crm_form_invoice.

Форма содержит следующие компоненты:

+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Поле                             | Тип компонента                                    | Имя компонента                                         |
+==================================+===================================================+========================================================+
| **Номер счета**                  | однострочное поле                                 | crm_form_invoice_number                                |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата счета**                   | выбор даты                                        | crm_form_invoice_date                                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Основание (договор поставки)** | группа полей                                      |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Единовременная оплата            | ссылка на реестр "Договоры поставки               | crm_form_invoice_contract_100                          |
|                                  | (единовременная оплата)"                          |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Оплата частями                   | ссылка на реестр "Договоры поставки               | crm_form_invoice_contract_part                         |
|                                  | (оплата частями)"                                 |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Сведения о поставщике**        | группа полей                                      |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Наименование                     | выбор подразделений (всегда выбрана корневая нода)| crm_form_invoice_provider_name                         |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| БИН                              | однострочное поле                                 | crm_form_invoice_provider_bin                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Адрес                            | многострочное поле                                | crm_form_invoice_provider_address                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| ИИК                              | однострочное поле                                 | crm_form_invoice_provider_iik                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| БИК                              | однострочное поле                                 | crm_form_invoice_provider_bik                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Свидетельство о постановке на**| группа полей                                      |                                                        |
| **регистрационный учет по НДС**  |                                                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Серия                            | однострочное поле                                 | crm_form_invoice_provider_nds_series                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Номер                            | однострочное поле                                 | crm_form_invoice_provider_nds_number                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Дата выдачи                      | числовое поле                                     | crm_form_invoice_provider_nds_date                     |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Номер договора (контракта)**   | однострочное поле (номер договора, выбранного в   | crm_form_invoice_contract_number                       |
| **на поставку**                  | группе полей "Основание (договор поставки)")      |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Дата договора (контракта)**    | однострочное поле (дата договора, выбранного в    | crm_form_invoice_contract_date                         |
| **на поставку**                  | группе полей "Основание (договор поставки)")      |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Условия оплаты по договору**   | выпадающий список (справочник                     | crm_form_invoice_conditions                            |
| **(контракту)**                  | crm_dict_paymentMode)                             |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адрес: республика**            | однострочное поле (значение по умолчанию:         | crm_form_invoice_republic                              |
|                                  | "Республика Казахстан")                           |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адрес: город**                 | выпадающий список (справочник crm_dict_cities)    | crm_form_invoice_city                                  |
|                                  | (город поставки из договора, выбранного в поле    |                                                        |
|                                  | "Основание (договор поставки)")                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адрес: улица**                 | однострочное поле  (адрес поставки из договора,   | crm_form_invoice_address                               |
|                                  | выбранного в поле "Основание (договор поставки)") |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Доверенность**                 | однострочное поле (значение по умолчанию:         | crm_form_invoice_vicarious                             |
|                                  | "без доверенности")                               |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Способ отправления**           | выпадающий список (справочник                     | crm_form_invoice_departure                             |
|                                  | crm_dict_deliveryMode)                            |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Товарно-транспортная**         | однострочное поле                                 | crm_form_invoice_ttn                                   |
|  **накладная**                   |                                                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Грузоотправитель**             | группа полей                                      |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| БИН                              | однострочное поле                                 | crm_form_invoice_sender_bin                            |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Наименование                     | однострочное поле (наименование организации       | crm_form_invoice_sender_name                           |
|                                  | поставщика из договора, выбранного в поле         |                                                        |
|                                  | "Основание (договор поставки)")                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Адрес                            | многострочное поле                                | crm_form_invoice_sender_address                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Грузополучатель**              | группа полей                                      |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| БИН                              | однострочное поле                                 | crm_form_invoice_receiver_bin                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Наименование                     | однострочное поле                                 | crm_form_invoice_receiver_name                         |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Адрес                            | многострочное поле                                | crm_form_invoice_receiver_address                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Получатель**                   | группа полей                                      |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Наименование                     | однострочное поле (наименование организации       | crm_form_invoice_mainreceiver_name                     |
|                                  | заказчика из договора, выбранного в поле          |                                                        |
|                                  | "Основание (договор поставки)")                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| БИН                              | однострочное поле                                 | crm_form_invoice_mainreceiver_bin                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Адрес                            | многострочное поле                                | crm_form_invoice_mainreceiver_address                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| ИИК                              | однострочное поле                                 | crm_form_invoice_mainreceiver_iik                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| БИК                              | однострочное поле                                 | crm_form_invoice_mainreceiver_bik                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Перечень закупаемых товаров**  | динамическая таблица (из группы полей "Перечень   | crm_form_invoice_order                                 |
|                                  | закупаемых товаров) договора, указанного в поле   |                                                        |
|                                  | "Основание (договор поставки)")                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   № п/п                          | однострочное поле                                 | crm_form_deal_order_number                             |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Наименование товаров (работ,   | ссылка на реестр "Прайс-лист"                     | crm_form_deal_order_orderList                          |
| услуг)                           |                                                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Ед. изм.                       | однострочное поле                                 | crm_form_deal_order_unit                               |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Кол-во (объем)                 | числовое поле                                     | crm_form_deal_order_amount                             |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Цена (KZT)                     | числовое поле                                     | crm_form_deal_order_price                              |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Стоимость товаров (работ,      | числовое поле                                     | crm_form_deal_order_total                              |
| услуг) без НДС                   |                                                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Ставка НДС                     | числовое поле                                     | crm_form_invoice_order_nds                             |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Сумма НДС                      | числовое поле                                     | crm_form_invoice_order_nds_summ                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Всего стоимость реализации     | числовое поле                                     | crm_form_invoice_order_summ_by_item                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Ставка акциз                   | числовое поле                                     | crm_form_invoice_order_akciz                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Сумма акциз                    | числовое поле                                     | crm_form_invoice_order_akciz_summ                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Всего по счету**               | группа полей                                      |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Стоимость товаров (работ,      | числовое поле                                     | crm_form_invoice_order_total                           |
| услуг) без НДС                   |                                                   |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Сумма НДС                      | числовое поле                                     | crm_form_invoice_order_nds_summ_total                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Всего стоимость реализации     | числовое поле                                     | crm_form_invoice_order_summ_total                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
|   Сумма акциз                    | числовое поле                                     | crm_form_invoice_order_akciz_summ_total                |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Руководитель**                 | ссылка на реестр "Контакты" (поле "Заказчик       | crm_form_invoice_client_client                         |
|                                  | (контакт)" договора, выбранного в поле "Основание |                                                        |
|                                  | (договор поставки)")                              |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Главный бухгалтер**            | однострочное поле                                 | crm_form_invoice_booker                                |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Источник адреса**              | выпадающий список                                 | choice                                                 |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выбрать аккаунт**              | ссылка на реестр "Аккаунты"                       | account_link                                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Выбрать контакт**              | ссылка на реестр "Контакты"                       | contact_link                                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **E-mail**                       | однострочное поле                                 | email                                                  |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адреса аккаунта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_account_email                                 |
|                                  | аккаунта, указанного в поле "Выбрать аккаунт")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Актуальный адрес аккаунта**    | однострочное поле                                 | crm_form_account_email_email                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Адреса контакта**              | динамическая таблица (из группы полей "E-mail"    | crm_form_contact_email                                 |
|                                  | контакта, указанного в поле "Выбрать контакт")    |                                                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Актуальный адрес контакта**    | однострочное поле                                 | crm_form_contact_email_email                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+

*Компоненты выбора даты*:

*   Формат даты всех компонентов выбора дат - `${dd}.${mm}.${yyyy} г.`

*Однострочные поля*:

*   Маска ввода всех полей "БИН" - `############`


#### Ответственный за сделки {#formDealResponsible}

Код формы: crm_form_deal_responsible.

Форма содержит следующие компоненты:

+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                         | Имя компонента                                         |
+========================================================+========================================================+========================================================+
| Ответственный за сделку                                | компонент выбора пользователей                         | crm_form_deal_responsible_user                         |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+

##### План продаж {#formSales}

Код формы: crm_form_sales.

Форма содержит следующие компоненты:

+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Поле                             | Тип компонента                                    | Имя компонента                                         |
+==================================+===================================================+========================================================+
| **Год**                          | числовое поле                                     | crm_form_deal_order_sales_year                         |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Месяц**                        | выпадающий список (справочник "crm_dict_months")  | crm_form_deal_order_sales_month                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **План продаж**                  | динамическая таблица                              | crm_form_deal_main2_theme_sales                        |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Отделение                        | компонент выбора подразделений                    | crm_form_deal_sales_pk1                                |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c1                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c1                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c2                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c2                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c3                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c3                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c4                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c4                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c5                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c5                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c6                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c6                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c7                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c7                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c8                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c8                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c9                           |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c9                    |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c10                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c10                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c11                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c11                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c12                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c12                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c13                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c13                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Тема сотрудничества              | ссылка на реестра "Тема сотрудничества"           | crm_form_deal_main2_theme_c14                          |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| Стоимость продаж                 | числовое поле                                     | crm_form_deal_main2_theme_pvalue_c14                   |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+
| **Конечный положительный статус**| числовое поле                                     | crm_form_deal_end                                      |
+----------------------------------+---------------------------------------------------+--------------------------------------------------------+

*Динамическая таблица "План продаж":*

*   Флаг "Отобразить границы" включен.

*Поле "Год":*

*   Флаги "Обязательное поле" и "Ограничение десятичных знаков" включены.

*Поле "Отделение":*

*   Флаг "Обязательное поле" включен.

*Поле "Тема сотрудничества":*

*   Флаг "Обязательное поле" включен.

*Поле "Стоимость продаж":*

*   Значение поля по умолчанию - 0.

*Поле "Конечный положительный статус":*

*   Поле скрыто.

*   Значение поля по умолчанию - 1.

    > **Примечание:**
    >
    > В случае, если значение поля будет изменено, дашбоард модуля
    > "Продуктивность" будет работать некорректно. И это не будет являться
    > ошибкой Synergy.

#### Нормативы продолжительности статусов сделки {#formDealFlowStandard}

Код формы: crm_form_deal_flow_standard.

Форма содержит следующие компоненты:

+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Поле                                                   | Тип компонента                                         | Имя компонента                                         |
+========================================================+========================================================+========================================================+
| **Нормативы продолжительности статусов сделки**        | динамическая таблица                                   | crm_form_deal_flow_standard_table                      |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Статус сделки                                          | выпадающий список (справочник "crm_dict_dealStatus")   | crm_form_deal_flow_standard_status                     |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| Продолжительность (в днях)                             | числовое поле                                          | crm_form_deal_flow_standard_duration                   |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+
| **Продолжительность по умолчанию (в днях)**            | числовое поле                                          | crm_form_deal_flow_standard_default_duration           |
+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+

*Динамическая таблица "Нормативы продолжительности статусов сделки"*:

*   Форматная строка:

    `[${crm_form_deal_flow_standard_duration} для ${crm_form_deal_flow_standard_status}]`

*   Разделитель свертки - `, `

*Поле "Продолжительность (в днях)"*:

*   Значение поля по умолчанию - 1.

*Поле "Продолжительность по умолчанию (в днях)"*:

*   Значение поля по умолчанию - 1.

<#include "crm_consist/buildin_objects_user_modules.md">

### Внешние модули-компоненты {#externalModuleComponents}

#### crm_notifications {#eMNotifications}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Код                                                    | crm_notifications                                        |
+--------------------------------------------------------+----------------------------------------------------------+
| Место размещения                                       | onLoad                                                   |
+--------------------------------------------------------+----------------------------------------------------------+
| Название пользовательского компонента                  | crm_component_notifications                              |
+--------------------------------------------------------+----------------------------------------------------------+
| Тип вставки                                            | ADD                                                      |
+--------------------------------------------------------+----------------------------------------------------------+

### Реестры {#registries}

#### Маркетинговые мероприятия {#registryEvent}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_events                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_event                                         |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи, все специалисты по продажам           |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_event_main_name                               | Наименование                                           | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_event_main_cost                               | Стоимость                                              | 2                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_event_main_event                              | Мероприятие                                            | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_event_responsibleManager_responsible          | Ответственный менеджер                                 | 4                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Лиды {#registryLead}

Свойства реестра:

+--------------------------------------------------------+-------------------------------------------------------------+
| Свойство                                               | Значение                                                    |
+========================================================+=============================================================+
| Код                                                    | crm_registry_lead                                           |
+--------------------------------------------------------+-------------------------------------------------------------+
| Форма документа                                        | crm_form_lead                                               |
+--------------------------------------------------------+-------------------------------------------------------------+
| Группа                                                 | все маркетологи, все специалисты по продажам                |
+--------------------------------------------------------+-------------------------------------------------------------+
| Права (все маркетологи)                                | все                                                         |
+--------------------------------------------------------+-------------------------------------------------------------+
| Права (все специалисты по продажам)                    | Просмотр списка, Просмотр данных, Изменение, Редактирование |
+--------------------------------------------------------+-------------------------------------------------------------+
| Сортировка                                             | по полю crm_form_lead_deals_budget                          |
+--------------------------------------------------------+-------------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                                 |
+--------------------------------------------------------+-------------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_lead_main_account_name                        | Аккаунт                                                | 1                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_lead_deals_theme                              | Тема сотрудничества                                    | 2                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_lead_deals_budget                             | Потенциальный бюджет                                   | 3                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_lead_deals_status                             | Статус                                                 | 4                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_lead_responsibleManager_responsible           | Ответственный менеджер                                 | 5                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Сделки {#registryDeal}

При создании записи реестра "Сделка" путем смены статуса или нажатием на
[кнопку](http://tdd.lan.arta.kz/docs/cases/crm/spec/html/sec.crm_conf_consist.html#user_components.button)
поле crm_form_deal_responsibleManager_responsible по умолчанию заполняется
пользователем, указанным в первой записи реестра "Ответственный за сделки".

Свойства реестра:

+--------------------------------------------------------+------------------------------------------------------------------------+
| Свойство                                               | Значение                                                               |
+========================================================+========================================================================+
| Код                                                    | crm_registry_deals                                                     |
+--------------------------------------------------------+------------------------------------------------------------------------+
| Форма документа                                        | crm_form_deals                                                         |
+--------------------------------------------------------+------------------------------------------------------------------------+
| Группа                                                 | все маркетологи, все специалисты по продажам                           |
+--------------------------------------------------------+------------------------------------------------------------------------+
| Права (все маркетологи)                                | Просмотр списка, Просмотр данных, Создание, Редактирование, Изменение  |
+--------------------------------------------------------+------------------------------------------------------------------------+
| Права (все специалисты по продажам)                    | все                                                                    |
+--------------------------------------------------------+------------------------------------------------------------------------+
| Сортировка                                             | по полю ccrm_form_deal_main3_budget                                    |
+--------------------------------------------------------+------------------------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                                            |
+--------------------------------------------------------+------------------------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_deal_main1_lead                               | Лид                                                    | 1                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_deal_main2_theme                              | Тема сотрудничества                                    | 2                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_deal_main3_budget                             | Бюджет                                                 | 3                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_deal_responsibleManager_responsible           | Ответственный менеджер                                 | 4                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Аккаунты {#registryAccount}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_accounts                                  |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_accounts                                      |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи, все специалисты по продажам           |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_account_main_name                             | Наименование                                           | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_account_main_info                             | Описание                                               | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_account_responsibleManager_responsible        | Ответственный менеджер                                 | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Контакты {#registryContact}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_contacts                                  |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_contacts                                      |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи, все специалисты по продажам           |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_contact_main_fullName                         | Полное имя                                             | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contact_main_position                         | Должность                                              | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contact_responsibleManager                    | Ответственный менеджер                                 | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### % комиссии лидогенерации {#registryComission}

Свойства реестра:

+--------------------------------------------------------+-------------------------------------------------------------+
| Свойство                                               | Значение                                                    |
+========================================================+=============================================================+
| Код                                                    | crm_registry_deal_comission                                 |
+--------------------------------------------------------+-------------------------------------------------------------+
| Форма документа                                        | crm_form_deal_comission                                     |
+--------------------------------------------------------+-------------------------------------------------------------+
| Группа                                                 | менеджеры по продажам                                       |
+--------------------------------------------------------+-------------------------------------------------------------+
| Права                                                  | Просмотр списка, Просмотр данных, Изменение, Редактирование |
+--------------------------------------------------------+-------------------------------------------------------------+
| Сортировка                                             | по дате создания                                            |
+--------------------------------------------------------+-------------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                                 |
+--------------------------------------------------------+-------------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_deal_comission_main                           | % комиссии                                             |                            | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### % комиссия продаж {#registryDealComission}

Свойства реестра:

+--------------------------------------------------------+-------------------------------------------------------------+
| Свойство                                               | Значение                                                    |
+========================================================+=============================================================+
| Код                                                    | crm_registry_lead_comission                                 |
+--------------------------------------------------------+-------------------------------------------------------------+
| Форма документа                                        | crm_form_lead_comission                                     |
+--------------------------------------------------------+-------------------------------------------------------------+
| Группа                                                 | менеджеры по продажам                                       |
+--------------------------------------------------------+-------------------------------------------------------------+
| Права                                                  | Просмотр списка, Просмотр данных, Изменение, Редактирование |
+--------------------------------------------------------+-------------------------------------------------------------+
| Сортировка                                             | по дате создания                                            |
+--------------------------------------------------------+-------------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                                 |
+--------------------------------------------------------+-------------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_deal_comission_main                           | % комиссии                                             |                            | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Темы сотрудничества {#registryThemes}

Свойства реестра:

+--------------------------------------------------------+-------------------------------------------------------------+
| Свойство                                               | Значение                                                    |
+========================================================+=============================================================+
| Код                                                    | crm_registry_themes                                         |
+--------------------------------------------------------+-------------------------------------------------------------+
| Форма документа                                        | crm_form_theme                                              |
+--------------------------------------------------------+-------------------------------------------------------------+
| Группа                                                 | все маркетологи, все специалисты по продажам                |
+--------------------------------------------------------+-------------------------------------------------------------+
| Права                                                  | Все                                                         |
+--------------------------------------------------------+-------------------------------------------------------------+
| Сортировка                                             | по полю crm_form_theme_theme                                |
+--------------------------------------------------------+-------------------------------------------------------------+
| Направление сортировки                                 | по возрастанию                                              |
+--------------------------------------------------------+-------------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_theme_theme                                   | Тема сотрудничества                                    | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Каталог товаров и услуг {#registryItems}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_items                                     |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_item                                          |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи, все специалисты по продажам           |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по полю реестра crm_form_item_name                     |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по возрастанию                                         |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_item_name                                     | Наименование товара                                    | 2                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_item_id                                       | Код товара                                             | 1                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Прайс-лист {#registryPriceList}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_price_list                                |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_price                                         |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи, все специалисты по продажам           |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по полю реестра crm_form_price_item_name               |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по возрастанию                                         |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_price_unit                                    | Единица измерения                                      | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_price_price                                   | Цена                                                   | 3                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_price_item_name                               | Наименование товара                                    | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Реестры шаблонов документов {#registryTemplates}

Для всех реестров ниже настроено событие активации:

Маршрут активации - Действия:

- Тип действия - Отправка документа по форме

- Название - Отправка документа по форме

- Адресат - `email`

##### Договоры поставки (единовременная оплата) {#registryContractDeliveryAll}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_contracts_delivery_100                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_contract_delivery_100                         |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи, все специалисты по продажам           |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_contract_delivery_100_contract_number         | Номер договора                                         | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_100_contract_date           | Дата договора                                          | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_100_theme                   | Тема договора                                          | 3                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_100_client_account          | Заказчик                                               | 4                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_100_sum_total               | Сумма договора                                         | 5                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

##### Договоры поставки (оплата частями) {#registryContractDeliveryPart}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_contracts_delivery_part                   |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_contract_delivery_part                        |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи, все специалисты по продажам           |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_contract_delivery_part_contract_number        | Номер договора                                         | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_part_contract_date          | Дата договора                                          | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_part_theme                  | Тема договора                                          | 3                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_part_client_account         | Заказчик                                               | 4                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_part_sum_total              | Сумма договора                                         | 5                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

##### Акты приема-передачи товара {#registryCertificates}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_certificates                              |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_certificate                                   |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи, все специалисты по продажам           |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_certificate_table3_contract                   | Основание договора                                     | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_certificate_table2_date                       | Дата акта                                              | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

##### Коммерческое предложение {#registryOffer}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_offer                                     |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_offer                                         |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи, все специалисты по продажам           |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_offer_whom_position                           | Должность                                              | 1                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_offer_whom_account	                         | Аккаунт                                                | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_offer_whom_fullname                           | ФИО                                                    | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_offer_from_user                               | От кого                                                | 4                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

##### Счет-фактуры {#registryInvoices}

Для реестра настроено событие активации:

> Маршрут активации - Действия:

> - Тип действия - Отправка документа по форме

> - Название - Отправка документа по форме

> - Адресат - `email`

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_invoices                                  |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_invoice                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи, все специалисты по продажам           |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_invoice_number                                | Номер                                                  | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_invoice_date                                  | Дата                                                   | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_invoice_receiver_name                         | Грузополучатель                                        | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_invoice_mainreceiver_name                     | Получатель                                             | 4                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_invoice_order_summ_total                      | Стоимость реализации                                   | 5                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Ответственный за сделки {#registryDealResponsible}

Свойства реестра:

+--------------------------------------------------------+-------------------------------------------------------------+
| Свойство                                               | Значение                                                    |
+========================================================+=============================================================+
| Код                                                    | crm_registry_deal_responsible                               |
+--------------------------------------------------------+-------------------------------------------------------------+
| Форма документа                                        | crm_form_deal_responsible                                   |
+--------------------------------------------------------+-------------------------------------------------------------+
| Группа                                                 | менеджеры-маркетологи, менеджеры по продажам                |
+--------------------------------------------------------+-------------------------------------------------------------+
| Права                                                  | Просмотр списка, Просмотр данных, Изменение, Редактирование |
+--------------------------------------------------------+-------------------------------------------------------------+
| Сортировка                                             | по дате создания                                            |
+--------------------------------------------------------+-------------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                                 |
+--------------------------------------------------------+-------------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_deal_responsible_user                         | Ответственный менеджер                                 |                            | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### План продаж {#registrySalesCost}

Свойства реестра:

+--------------------------------------------------------+-------------------------------------------------------------+
| Свойство                                               | Значение                                                    |
+========================================================+=============================================================+
| Код                                                    | crm_registry_deals_plans                                    |
+--------------------------------------------------------+-------------------------------------------------------------+
| Форма документа                                        | crm_form_sales                                              |
+--------------------------------------------------------+-------------------------------------------------------------+
| Группа                                                 | менеджеры по продажам                                       |
+--------------------------------------------------------+-------------------------------------------------------------+
| Права                                                  | все                                                         |
+--------------------------------------------------------+-------------------------------------------------------------+
| Сортировка                                             | по дате создания                                            |
+--------------------------------------------------------+-------------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                                 |
+--------------------------------------------------------+-------------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_deal_order_sales_month                        | Месяц                                                  |                            | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_deal_order_sales_year                         | Год                                                    |                            | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Нормативы продолжительности статусов сделки {#registryDealFlowStandard}

Свойства реестра:

+--------------------------------------------------------+-------------------------------------------------------------+
| Свойство                                               | Значение                                                    |
+========================================================+=============================================================+
| Код                                                    | crm_registry_deal_flow_standard                             |
+--------------------------------------------------------+-------------------------------------------------------------+
| Форма документа                                        | crm_form_deal_flow_standard                                 |
+--------------------------------------------------------+-------------------------------------------------------------+
| Группа                                                 | менеджеры по продажам                                       |
+--------------------------------------------------------+-------------------------------------------------------------+
| Права                                                  | Просмотр списка, Просмотр данных, Изменение, Редактирование |
+--------------------------------------------------------+-------------------------------------------------------------+
| Сортировка                                             | по дате создания                                            |
+--------------------------------------------------------+-------------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                                 |
+--------------------------------------------------------+-------------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_deal_flow_standard_table                      | Нормативы продолжительности статусов сделок            |                            | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+


### Группы реестров {#registriesGroup}

Конфигурация групп реестров зависит от выбранного
[типа установки CRM](http://tdd.lan.arta.kz/docs/cases/crm/additional/html/basic_setting.html):

При установке типа Clean CRM и Demo CRM:

*   [Базовый учет продаж](#group_marketing)
    *   [Каталог товаров и услуг](#group_catalog)
    *   [Шаблоны документов](#group_documentTemplates)

При установке типа Install/Upgrade Configuration:

*   [Каталог товаров и услуг](#group_catalog)
*   [Шаблоны документов](#group_documentTemplates)
*   [Настройки маркетинга и управления продаж](#group_settings)

#### Базовый учёт продаж {#group_marketing}

Код группы реестров: crm_registryGroup_marketing

Группы:

*   [Каталог товаров и услуг](#group_catalog)
*   [Шаблоны документов](#group_documentTemplates)
*   [Настройки маркетинга и управления продаж](#group_settings)

Реестры:

*   [Аккаунты](#registryAccount)
*   [Контакты](#registryContact)
*   [Лиды](#registryLead)
*   [Маркетинговые мероприятия](#registryEvent)
*   [Сделки](#registryDeal)

#### Каталог товаров и услуг {#group_catalog}

Код группы реестров: crm_registryGroup_catalog

Реестры:

*   [Каталог товаров и услуг](#registryItems)
*   [Прайс-лист](#registryPriceList)
*   [Темы сотрудничества](#registryThemes)

#### Шаблоны документов {#group_documentTemplates}

Код группы реестров: crm_registryGroup_documentTemplates

Реестры:

*   [Акты приема-передачи товара](#registryCertificates)
*   [Договоры поставки (единовременная оплата)](#registryContractDeliveryAll)
*   [Договоры поставки (оплата частями)](#registryContractDeliveryPart)
*   [Коммерческие предложения](#registryOffer)
*   [Счет-фактуры](#registryInvoices)

#### Настройки маркетинга и управления продаж {#group_settings}

Код группы реестров: crm_registryGroup_settings

Реестры:

*   [% комиссии лидогенерации](#registryComission)
*   [% комиссии продаж](#registryDealComission)
*   [Ответственный за сделки](#registryDealResponsible)
*   [План продаж](#registrySalesCost)

### Справочники {#dictionaries}

#### Статусы лида {#dictionaryLeadStatus}

Код справочника: crm_dict_leadStatus.

Поля справочника:

+--------------------------------+-------------------+-------------------------------+------------------+
| **Код**                        | **Имя**           | **Комментарий**               | **Переводить**   |
+================================+===================+===============================+==================+
| crm_dict_leadStatus_name       | Название          |                               | Да               |
+--------------------------------+-------------------+-------------------------------+------------------+
| crm_dict_leadStatus_value      | Порядковый номер  | Не может иметь значение,      | Нет              |
|                                | пункта в          | равное 0                      |                  |
|                                | выпадающем списке |                               |                  |
+--------------------------------+-------------------+-------------------------------+------------------+
| crm_dict_leadStatus_quality    | Качество          | 0 - negative                  | Нет              |
|                                |                   |                               |                  |
|                                |                   | 1 - positive                  |                  |
+--------------------------------+-------------------+-------------------------------+------------------+
| crm_dict_leadStatus_end        | Законченность     | Имеет смысл только для        | Нет              |
|                                |                   | crm_dict_leadStatus_quality=1 |                  |
|                                |                   |                               |                  |
|                                |                   | 0 - not end                   |                  |
|                                |                   |                               |                  |
|                                |                   | 1 - end                       |                  |
+--------------------------------+-------------------+-------------------------------+------------------+
| crm_dict_leadStatus_color      | Цвет панели в     |                               | Нет              |
|                                | воронке           |                               |                  |
+--------------------------------+-------------------+-------------------------------+------------------+
| crm_dict_leadStatus_buttonName | Название кнопки   | Имеет смысл только для:       | Нет              |
|                                |                   |                               |                  |
|                                |                   | crm_dict_leadStatus_quality=1 |                  |
|                                |                   |                               |                  |
|                                |                   | crm_dict_leadStatus_end=1     |                  |
+--------------------------------+-------------------+-------------------------------+------------------+

Данные справочника по умолчанию:

+--------------------------------+-----------------------------+--------------+-------------------+-------------------+--------------------------------+
| **Название**                   | **Порядковый номер пункта** | **Качество** | **Законченность** | **Цвет панели в** | **Название кнопки**            |
|                                | **в выпадающем списке**     |              |                   | **воронке**       |                                |
+================================+=============================+==============+===================+===================+================================+
| Первичная регистрация          | 1                           | 1            | 0                 | `#de682d`         |                                |
+--------------------------------+-----------------------------+--------------+-------------------+-------------------+--------------------------------+
| Квалификация                   | 2                           | 1            | 0                 | `#ee902d`         |                                |
+--------------------------------+-----------------------------+--------------+-------------------+-------------------+--------------------------------+
| Взращивание                    | 3                           | 1            | 0                 | `#f3c02d`         |                                |
+--------------------------------+-----------------------------+--------------+-------------------+-------------------+--------------------------------+
| Подтверждение интереса         | 4                           | 1            | 0                 | `#c9d02c`         |                                |
+--------------------------------+-----------------------------+--------------+-------------------+-------------------+--------------------------------+
| В сделку                       | 5                           | 1            | 1                 | `#9fcb2c`         | Конвертировать в сделку        |
+--------------------------------+-----------------------------+--------------+-------------------+-------------------+--------------------------------+
| Некачественный лид             | 6                           | 0            |                   | `#b82b2b`         |                                |
+--------------------------------+-----------------------------+--------------+-------------------+-------------------+--------------------------------+

Если некоторые параметры не были указаны, то им присваиваются значения
по умолчанию:

*   не указан crm_dict_leadStatus_quality:
    *   crm_dict_leadStatus_quality=1
    *   crm_dict_leadStatus_end=0

*   не указан crm_dict_leadStatus_end:
    *   crm_dict_leadStatus_end=0

*   не указаны crm_dict_leadStatus_quality и crm_dict_leadStatus_end:
    *   crm_dict_leadStatus_quality=1
    *   crm_dict_leadStatus_end=0

*   не указан crm_dict_leadStatus_color:
    *   crm_dict_leadStatus_color=#f3c02d

Запись с данными crm_dict_leadStatus_quality=1 и crm_dict_leadStatus_end=1
должна быть одна. Если таких записей несколько, то данные значения
применяются только для первой созданной записи. Остальным записям из списка
присваивается значение crm_dict_leadStatus_end=0.

Список статусов лида, для которых crm_dict_leadStatus_value=0 либо не
указан вовсе, сортируются по параметру crm_dict_leadStatus_name в локали С
в алфавитном порядке.

#### Статусы сделки {#dictionaryDealStatus}

Код справочника: crm_dict_dealStatus.


Поля справочника:

+--------------------------------+-------------------+-------------------------------+------------------+
| **Код**                        | **Имя**           | **Комментарий**               | **Переводить**   |
+================================+===================+===============================+==================+
| crm_dict_dealStatus_type       | Тип               |                               | Да               |
+--------------------------------+-------------------+-------------------------------+------------------+
| crm_dict_dealStatus_value      | Порядковый номер  | Не может иметь значение,      | Нет              |
|                                | пункта в          | равное 0                      |                  |
|                                | выпадающем списке |                               |                  |
+--------------------------------+-------------------+-------------------------------+------------------+
| crm_dict_dealStatus_quality    | Качество          | 0 - negative                  | Нет              |
|                                |                   |                               |                  |
|                                |                   | 1 - positive                  |                  |
+--------------------------------+-------------------+-------------------------------+------------------+
| crm_dict_dealStatus_end        | Законченность     | Имеет смысл только для        | Нет              |
|                                |                   | crm_dict_dealStatus_quality=1 |                  |
|                                |                   |                               |                  |
|                                |                   | 0 - not end                   |                  |
|                                |                   |                               |                  |
|                                |                   | 1 - end                       |                  |
+--------------------------------+-------------------+-------------------------------+------------------+
| crm_dict_dealStatus_color      | Цвет панели в     |                               | Нет              |
|                                | воронке           |                               |                  |
+--------------------------------+-------------------+-------------------------------+------------------+

Данные справочника по умолчанию:

+--------------------------------+-----------------------------+--------------+-------------------+-------------------+
| **Тип**                        | **Порядковый номер пункта** | **Качество** | **Законченность** | **Цвет панели в** |
|                                | **в выпадающем списке**     |              |                   | **воронке**       |
+================================+=============================+==============+===================+===================+
| Уточнение потребности          | 1                           | 1            | 0                 | `#ee902d`         |
+--------------------------------+-----------------------------+--------------+-------------------+-------------------+
| Подготовка приложения          | 2                           | 1            | 0                 | `#f3c02d`         |
+--------------------------------+-----------------------------+--------------+-------------------+-------------------+
| Защита предложения             | 3                           | 1            | 0                 | `#c9d02c`         |
+--------------------------------+-----------------------------+--------------+-------------------+-------------------+
| Закрытие сделки                | 4                           | 1            | 1                 | `#9fcb2c`         |
+--------------------------------+-----------------------------+--------------+-------------------+-------------------+
| Отказ                          | 5                           | 0            |                   | `#b82b2b`         |
+--------------------------------+-----------------------------+--------------+-------------------+-------------------+

Если некоторые параметры не были указаны, то им присваиваются значения
по умолчанию:

*   не указан crm_dict_dealStatus_quality:
    *   crm_dict_dealStatus_quality=1
    *   crm_dict_dealStatus_end=0

*   не указан crm_dict_dealStatus_end:
    *   crm_dict_dealStatus_end=0

*   не указаны crm_dict_dealStatus_quality и crm_dict_dealStatus_end:
    *   crm_dict_dealStatus_quality=1
    *   crm_dict_dealStatus_end=0

*   не указан crm_dict_dealStatus_color:
    *   crm_dict_dealStatus_color=#f3c02d

Запись с данными crm_dict_dealStatus_quality=1 и crm_dict_dealStatus_end=1
должна быть одна. Если таких записей несколько, то данные значения
применяются только для первой созданной записи. Остальным записям из списка
присваивается значение crm_dict_dealStatus_end=0.

Список статусов сделок, для которых crm_dict_dealStatus_value=0 либо не
указан вовсе, сортируются по параметру crm_dict_dealStatus_type в локали С
в алфавитном порядке.

#### Статусы аккаунта {#dictionaryAccountStatus}

Код справочника: crm_dict_accountStatus.

Поля справочника:

+--------------------------------+-------------------+-------------------+------------------+
| **Код**                        | **Имя**           | **Комментарий**   | **Переводить**   |
+================================+===================+===================+==================+
| crm_dict_accountStatus_type    | Тип               |                   | Да               |
+--------------------------------+-------------------+-------------------+------------------+
| crm_dict_accountStatus_value   | Порядковый номер  |                   | Нет              |
|                                | пункта в          |                   |                  |
|                                | выпадающем списке |                   |                  |
+--------------------------------+-------------------+-------------------+------------------+

Данные справочника по умолчанию:

+--------------------------------+--------------------------------+
| **Тип**                        | **Порядковый номер пункта в**  |
|                                | **выпадающем списке**          |
+================================+================================+
| Клиент                         | 1                              |
+--------------------------------+--------------------------------+
| Потенциальный клиент           | 2                              |
+--------------------------------+--------------------------------+

#### Статусы контакта {#dictionaryContactStatus}

Код справочника: crm_dict_contactStatus.

Поля справочника:

+--------------------------------+-------------------+-------------------+------------------+
| **Код**                        | **Имя**           | **Комментарий**   | **Переводить**   |
+================================+===================+===================+==================+
| crm_dict_contactStatus_type    | Тип               |                   | Да               |
+--------------------------------+-------------------+-------------------+------------------+
| crm_dict_contactStatus_value   | Порядковый номер  |                   | Нет              |
|                                | пункта в          |                   |                  |
|                                | выпадающем списке |                   |                  |
+--------------------------------+-------------------+-------------------+------------------+

Данные справочника по умолчанию:

+--------------------------------+--------------------------------+
| **Тип**                        | **Порядковый номер пункта в**  |
|                                | **выпадающем списке**          |
+================================+================================+
| Активен                        | 1                              |
+--------------------------------+--------------------------------+
| В отпуске                      | 2                              |
+--------------------------------+--------------------------------+
| Не активен                     | 3                              |
+--------------------------------+--------------------------------+
| В командировке                 | 4                              |
+--------------------------------+--------------------------------+

#### Типы мероприятий {#dictionaryEventType}

Код справочника: crm_dict_eventType.

Поля справочника:

+--------------------------------+-------------------+-------------------+------------------+
| **Код**                        | **Имя**           | **Комментарий**   | **Переводить**   |
+================================+===================+===================+==================+
| crm_dict_eventType_type        | Тип               |                   | Да               |
+--------------------------------+-------------------+-------------------+------------------+
| crm_dict_eventType_value       | Порядковый номер  |                   | Нет              |
|                                | пункта в          |                   |                  |
|                                | выпадающем списке |                   |                  |
+--------------------------------+-------------------+-------------------+------------------+

Данные справочника по умолчанию:

+--------------------------------+--------------------------------+
| **Тип**                        | **Порядковый номер пункта в**  |
|                                | **выпадающем списке**          |
+================================+================================+
| Входящий маркетинг             | 1                              |
+--------------------------------+--------------------------------+
| Исходящий маркетинг            | 2                              |
+--------------------------------+--------------------------------+

#### Типы мероприятий {#dictionaryActivityType}

Код справочника: crm_dict_activityType

Поля справочника:

+--------------------------------+-------------------+--------------------------+------------------+
| **Код**                        | **Имя**           | **Комментарий**          | **Переводить**   |
+================================+===================+==========================+==================+
| crm_dict_activityType_type     | Тип               |                          | Да               |
+--------------------------------+-------------------+--------------------------+------------------+
| crm_dict_activityType_value    | Порядковый номер  |                          | Нет              |
|                                | пункта в          |                          |                  |
|                                | выпадающем списке |                          |                  |
+--------------------------------+-------------------+--------------------------+------------------+
| crm_dict_activityType_icon     | Пиктограмма       | Путь до пиктограммы      | Нет              |
|                                |                   |в папке images/activities |                  |
+--------------------------------+-------------------+--------------------------+------------------+

Данные справочника по умолчанию:

+--------------------------------+--------------------------------+--------------------------------------+
| **Тип**                        | **Порядковый номер пункта в**  | **Пиктограмма**                      |
|                                | **выпадающем списке**          |                                      |
+================================+================================+======================================+
| Отправил документ              | 1                              | images/activities/sendDocument.png   |
+--------------------------------+--------------------------------+--------------------------------------+
| Позвонил                       | 2                              | images/activities/call.png           |
+--------------------------------+--------------------------------+--------------------------------------+
| Выставил счет                  | 3                              | images/activities/makeOutInvoice.png |
+--------------------------------+--------------------------------+--------------------------------------+
| Встретился                     | 4                              | images/activities/meeting.png        |
+--------------------------------+--------------------------------+--------------------------------------+
| Создал еще один лид            | 5                              | images/activities/newLead.png        |
+--------------------------------+--------------------------------+--------------------------------------+
| Поздравил с праздником         | 6                              | images/activities/event.png          |
+--------------------------------+--------------------------------+--------------------------------------+

#### Телефон {#dictionaryPhone}

Код справочника: crm_dict_phone.

Поля справочника:

+--------------------------------+-------------------+-------------------+------------------+
| **Код**                        | **Имя**           | **Комментарий**   | **Переводить**   |
+================================+===================+===================+==================+
| crm_dict_phone_type            | Тип               |                   | Да               |
+--------------------------------+-------------------+-------------------+------------------+
| crm_dict_phone_value           | Порядковый номер  |                   | Нет              |
|                                | пункта в          |                   |                  |
|                                | выпадающем списке |                   |                  |
+--------------------------------+-------------------+-------------------+------------------+

Данные справочника по умолчанию:

+--------------------------------+--------------------------------+
| **Тип**                        | **Порядковый номер пункта в**  |
|                                | **выпадающем списке**          |
+================================+================================+
| Рабочий                        | 1                              |
+--------------------------------+--------------------------------+
| Мобильный                      | 2                              |
+--------------------------------+--------------------------------+
| Факс                           | 3                              |
+--------------------------------+--------------------------------+
| Домашний                       | 4                              |
+--------------------------------+--------------------------------+
| Telegram                       | 5                              |
+--------------------------------+--------------------------------+
| Viber                          | 6                              |
+--------------------------------+--------------------------------+
| Другой                         | 7                              |
+--------------------------------+--------------------------------+

#### Адрес {#dictionaryAddress}

Код справочника: crm_dict_address.

Поля справочника:

+--------------------------------+-------------------+-------------------+------------------+
| **Код**                        | **Имя**           | **Комментарий**   | **Переводить**   |
+================================+===================+===================+==================+
| crm_dict_address_type          | Тип               |                   | Да               |
+--------------------------------+-------------------+-------------------+------------------+
| crm_dict_address_value         | Порядковый номер  |                   | Нет              |
|                                | пункта в          |                   |                  |
|                                | выпадающем списке |                   |                  |
+--------------------------------+-------------------+-------------------+------------------+

Данные справочника по умолчанию:

+--------------------------------+--------------------------------+
| **Тип**                        | **Порядковый номер пункта в**  |
|                                | **выпадающем списке**          |
+================================+================================+
| Основной                       | 1                              |
+--------------------------------+--------------------------------+
| Рабочий                        | 2                              |
+--------------------------------+--------------------------------+
| Домашний                       | 3                              |
+--------------------------------+--------------------------------+
| Другой                         | 4                              |
+--------------------------------+--------------------------------+

#### Почта {#dictionaryEmail}

Код справочника: crm_dict_email.

Поля справочника:

+--------------------------------+-------------------+-------------------+------------------+
| **Код**                        | **Имя**           | **Комментарий**   | **Переводить**   |
+================================+===================+===================+==================+
| crm_dict_email_type            | Тип               |                   | Да               |
+--------------------------------+-------------------+-------------------+------------------+
| crm_dict_email_value           | Порядковый номер  |                   | Нет              |
|                                | пункта в          |                   |                  |
|                                | выпадающем списке |                   |                  |
+--------------------------------+-------------------+-------------------+------------------+

Данные справочника по умолчанию:

+--------------------------------+--------------------------------+
| **Тип**                        | **Порядковый номер пункта в**  |
|                                | **выпадающем списке**          |
+================================+================================+
| Официальный                    | 1                              |
+--------------------------------+--------------------------------+
| Рабочий                        | 2                              |
+--------------------------------+--------------------------------+
| Личный                         | 3                              |
+--------------------------------+--------------------------------+
| Другой                         | 4                              |
+--------------------------------+--------------------------------+

#### Социальные сети {#dictionarySocialNetworks}

Код справочника: crm_dict_socialNetworks.

Поля справочника:

+--------------------------------+-------------------+-------------------+------------------+
| **Код**                        | **Имя**           | **Комментарий**   | **Переводить**   |
+================================+===================+===================+==================+
| crm_dict_socialNetworks_type   | Тип               |                   | Да               |
+--------------------------------+-------------------+-------------------+------------------+
| crm_dict_socialNetworks_value  | Порядковый номер  |                   | Нет              |
|                                | пункта в          |                   |                  |
|                                | выпадающем списке |                   |                  |
+--------------------------------+-------------------+-------------------+------------------+

Данные справочника по умолчанию:

+--------------------------------+--------------------------------+
| **Тип**                        | **Порядковый номер пункта в**  |
|                                | **выпадающем списке**          |
+================================+================================+
| Facebook                       | 1                              |
+--------------------------------+--------------------------------+
| Facebook Messenger             | 2                              |
+--------------------------------+--------------------------------+
| Skype                          | 3                              |
+--------------------------------+--------------------------------+
| Twitter                        | 4                              |
+--------------------------------+--------------------------------+
| Instagram                      | 5                              |
+--------------------------------+--------------------------------+
| LinkedIn                       | 6                              |
+--------------------------------+--------------------------------+
| VK                             | 7                              |
+--------------------------------+--------------------------------+
| Behance                        | 8                              |
+--------------------------------+--------------------------------+
| Другой                         | 9                              |
+--------------------------------+--------------------------------+

#### Действия напоминаний {#dictionaryremindActions}

Код справочника: crm_dict_remindActions.

Поля справочника:

+--------------------------------+-------------------+-------------------+------------------+
| **Код**                        | **Имя**           | **Комментарий**   | **Переводить**   |
+================================+===================+===================+==================+
| crm_dict_remindActions_type    | Тип               |                   | Да               |
+--------------------------------+-------------------+-------------------+------------------+
| crm_dict_remindActions_value   | Порядковый номер  |                   | Нет              |
|                                | пункта в          |                   |                  |
|                                | выпадающем списке |                   |                  |
+--------------------------------+-------------------+-------------------+------------------+

Данные справочника по умолчанию:

+--------------------------------+--------------------------------+
| **Тип**                        | **Порядковый номер пункта в**  |
|                                | **выпадающем списке**          |
+================================+================================+
| Напомнить                      | 1                              |
+--------------------------------+--------------------------------+
| Позвонить                      | 2                              |
+--------------------------------+--------------------------------+
| Поздравить                     | 3                              |
+--------------------------------+--------------------------------+
| Отправить письмо               | 4                              |
+--------------------------------+--------------------------------+
| Отправить документ             | 5                              |
+--------------------------------+--------------------------------+
| Пригласить на мероприятие      | 6                              |
+--------------------------------+--------------------------------+
| Назначена встреча              | 7                              |
+--------------------------------+--------------------------------+

#### Города Казахстана {#dictionaryCities}

Код справочника: crm_dict_cities.

Поля справочника:

+--------------------------------+-------------------+-------------------+------------------+
| **Код**                        | **Имя**           | **Комментарий**   | **Переводить**   |
+================================+===================+===================+==================+
| crm_dict_cities_type           | Тип               |                   | Да               |
+--------------------------------+-------------------+-------------------+------------------+
| crm_dict_cities_value          | Порядковый номер  |                   | Нет              |
|                                | пункта в          |                   |                  |
|                                | выпадающем списке |                   |                  |
+--------------------------------+-------------------+-------------------+------------------+

Данные справочника по умолчанию:

+--------------------------------+--------------------------------+
| **Тип**                        | **Порядковый номер пункта в**  |
|                                | **выпадающем списке**          |
+================================+================================+
| г. Астана                      | 01                             |
+--------------------------------+--------------------------------+
| г. Алматы                      | 02                             |
+--------------------------------+--------------------------------+
| г. Актау                       | 03                             |
+--------------------------------+--------------------------------+
| г. Актобе                      | 04                             |
+--------------------------------+--------------------------------+
| г. Атырау                      | 05                             |
+--------------------------------+--------------------------------+
| г. Караганда                   | 06                             |
+--------------------------------+--------------------------------+
| г. Кокшетау                    | 07                             |
+--------------------------------+--------------------------------+
| г. Костанай                    | 08                             |
+--------------------------------+--------------------------------+
| г. Кызылорда                   | 09                             |
+--------------------------------+--------------------------------+
| г. Павлодар                    | 10                             |
+--------------------------------+--------------------------------+
| г. Петропавловск               | 11                             |
+--------------------------------+--------------------------------+
| г. Талдыкорган                 | 12                             |
+--------------------------------+--------------------------------+
| г. Тараз                       | 13                             |
+--------------------------------+--------------------------------+
| г. Уральск                     | 14                             |
+--------------------------------+--------------------------------+
| г. Усть-Каменогорск            | 15                             |
+--------------------------------+--------------------------------+
| г. Шымкент                     | 16                             |
+--------------------------------+--------------------------------+

#### Условия оплаты {#dictionaryPaymentMode}

Код справочника: crm_dict_paymentMode.

Поля справочника:

+--------------------------------+-------------------+-------------------+------------------+
| **Код**                        | **Имя**           | **Комментарий**   | **Переводить**   |
+================================+===================+===================+==================+
| crm_dict_paymentMode_type      | Название          |                   | Да               |
+--------------------------------+-------------------+-------------------+------------------+
| crm_dict_paymentMode_value     | Порядковый номер  |                   | Нет              |
|                                | пункта в          |                   |                  |
|                                | выпадающем списке |                   |                  |
+--------------------------------+-------------------+-------------------+------------------+

Данные справочника по умолчанию:

+--------------------------------+--------------------------------+
| **Название**                   | **Порядковый номер пункта в**  |
|                                | **выпадающем списке**          |
+================================+================================+
| Безналичный расчет             | 1                              |
+--------------------------------+--------------------------------+
| Наличный расчет                | 2                              |
+--------------------------------+--------------------------------+

#### Способы отправления {#dictionaryDeliveryMode}

Код справочника: crm_dict_deliveryMode.

Поля справочника:

+--------------------------------+-------------------+-------------------+------------------+
| **Код**                        | **Имя**           | **Комментарий**   | **Переводить**   |
+================================+===================+===================+==================+
| crm_dict_deliveryMode_type     | Название          |                   | Да               |
+--------------------------------+-------------------+-------------------+------------------+
| crm_dict_deliveryMode_value    | Порядковый номер  |                   | Нет              |
|                                | пункта в          |                   |                  |
|                                | выпадающем списке |                   |                  |
+--------------------------------+-------------------+-------------------+------------------+

Данные справочника по умолчанию:

+--------------------------------+--------------------------------+
| **Название**                   | **Порядковый номер пункта в**  |
|                                | **выпадающем списке**          |
+================================+================================+
| Доставка                       | 1                              |
+--------------------------------+--------------------------------+
| Самовывоз                      | 2                              |
+--------------------------------+--------------------------------+
| Прочее                         | 3                              |
+--------------------------------+--------------------------------+

#### Месяцы {#dictionaryMonths}

Код справочника: crm_dict_months.

Поля справочника:

+--------------------------------+-------------------+-------------------+------------------+
| **Код**                        | **Имя**           | **Комментарий**   | **Переводить**   |
+================================+===================+===================+==================+
| crm_dict_months_name           | Месяц             |                   | Да               |
+--------------------------------+-------------------+-------------------+------------------+
| crm_dict_months_value          | Порядковый номер  |                   | Нет              |
|                                | пункта в          |                   |                  |
|                                | выпадающем списке |                   |                  |
+--------------------------------+-------------------+-------------------+------------------+

Данные справочника по умолчанию:

+--------------------------------+--------------------------------+
| **Месяц**                      | **Порядковый номер пункта в**  |
|                                | **выпадающем списке**          |
+================================+================================+
| Январь                         | 1                              |
+--------------------------------+--------------------------------+
| Февраль                        | 2                              |
+--------------------------------+--------------------------------+
| Март                           | 3                              |
+--------------------------------+--------------------------------+
| Апрель                         | 4                              |
+--------------------------------+--------------------------------+
| Май                            | 5                              |
+--------------------------------+--------------------------------+
| Июнь                           | 6                              |
+--------------------------------+--------------------------------+
| Июль                           | 7                              |
+--------------------------------+--------------------------------+
| Август                         | 8                              |
+--------------------------------+--------------------------------+
| Сентябрь                       | 9                              |
+--------------------------------+--------------------------------+
| Октябрь                        | 10                             |
+--------------------------------+--------------------------------+
| Ноябрь                         | 11                             |
+--------------------------------+--------------------------------+
| Декабрь                        | 12                             |
+--------------------------------+--------------------------------+

### Создание документов {#createDoc}

Пункты создания документов представлены следующей структурой:

*   [Запись аккаунта](#accountRecord)
*   [Запись контакта](#contactRecord)
*   [Запись лида](#leadRecord)
*   [Запись мероприятия](#eventRecord)
*   [Запись сделки](#dealRecord)
*   [Шаблоны документов](#docTemplates)
    *   [Акт приема-передачи](#certificate)
    *   [Договор поставки (единовременная оплата)](#contract100)
    *   [Договор поставки (оплата частями)](#contractPart)
    *   [Коммерческое предложение](#offer)

#### Запись аккаунта {#accountRecord}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Тип                                                    | пункт                                                    |
+--------------------------------------------------------+----------------------------------------------------------+
| Код                                                    | crm_menu_addAccount                                      |
+--------------------------------------------------------+----------------------------------------------------------+
| Реестр                                                 | crm_registry_accounts                                    |
+--------------------------------------------------------+----------------------------------------------------------+
| Добавить в "Избранное" пользователя по умолчанию       | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+
| Группа                                                 | Все маркетологи, Все специалисты по продажам             |
+--------------------------------------------------------+----------------------------------------------------------+

#### Запись контакта {#contactRecord}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Тип                                                    | пункт                                                    |
+--------------------------------------------------------+----------------------------------------------------------+
| Код                                                    | crm_menu_addContact                                      |
+--------------------------------------------------------+----------------------------------------------------------+
| Реестр                                                 | crm_registry_contacts                                    |
+--------------------------------------------------------+----------------------------------------------------------+
| Добавить в "Избранное" пользователя по умолчанию       | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+
| Группа                                                 | Все маркетологи, Все специалисты по продажам             |
+--------------------------------------------------------+----------------------------------------------------------+

#### Запись лида {#leadRecord}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Тип                                                    | пункт                                                    |
+--------------------------------------------------------+----------------------------------------------------------+
| Код                                                    | crm_menu_addLead                                         |
+--------------------------------------------------------+----------------------------------------------------------+
| Реестр                                                 | crm_registry_leads                                       |
+--------------------------------------------------------+----------------------------------------------------------+
| Добавить в "Избранное" пользователя по умолчанию       | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+
| Группа                                                 | Все маркетологи                                          |
+--------------------------------------------------------+----------------------------------------------------------+

#### Запись мероприятия {#eventRecord}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Тип                                                    | пункт                                                    |
+--------------------------------------------------------+----------------------------------------------------------+
| Код                                                    | crm_menu_addEvent                                        |
+--------------------------------------------------------+----------------------------------------------------------+
| Реестр                                                 | crm_registry_events                                      |
+--------------------------------------------------------+----------------------------------------------------------+
| Добавить в "Избранное" пользователя по умолчанию       | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+
| Группа                                                 | Все маркетологи, Все специалисты по продажам             |
+--------------------------------------------------------+----------------------------------------------------------+

#### Запись сделки {#dealRecord}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Тип                                                    | пункт                                                    |
+--------------------------------------------------------+----------------------------------------------------------+
| Код                                                    | crm_menu_addDeal                                         |
+--------------------------------------------------------+----------------------------------------------------------+
| Реестр                                                 | crm_registry_deals                                       |
+--------------------------------------------------------+----------------------------------------------------------+
| Добавить в "Избранное" пользователя по умолчанию       | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+
| Группа                                                 | Все специалисты по продажам                              |
+--------------------------------------------------------+----------------------------------------------------------+

#### Шаблоны документов {#docTemplates}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Тип                                                    | группа                                                   |
+--------------------------------------------------------+----------------------------------------------------------+
| Код                                                    | crm_menu_addDocuments                                    |
+--------------------------------------------------------+----------------------------------------------------------+

#### Акт приема-передачи {#certificate}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Тип                                                    | пункт                                                    |
+--------------------------------------------------------+----------------------------------------------------------+
| Код                                                    | crm_menu_addCertificate                                  |
+--------------------------------------------------------+----------------------------------------------------------+
| Реестр                                                 | crm_registry_certificates                                |
+--------------------------------------------------------+----------------------------------------------------------+
| Добавить в "Избранное" пользователя по умолчанию       | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+
| Группа                                                 | Все маркетологи, Все специалисты по продажам             |
+--------------------------------------------------------+----------------------------------------------------------+

#### Договор поставки (единовременная оплата) {#contract100}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Тип                                                    | пункт                                                    |
+--------------------------------------------------------+----------------------------------------------------------+
| Код                                                    | crm_menu_addContract_100                                 |
+--------------------------------------------------------+----------------------------------------------------------+
| Реестр                                                 | crm_registry_contracts_delivery_100                      |
+--------------------------------------------------------+----------------------------------------------------------+
| Добавить в "Избранное" пользователя по умолчанию       | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+
| Группа                                                 | Все маркетологи, Все специалисты по продажам             |
+--------------------------------------------------------+----------------------------------------------------------+

#### Договор поставки (оплата частями) {#contractPart}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Тип                                                    | пункт                                                    |
+--------------------------------------------------------+----------------------------------------------------------+
| Код                                                    | crm_menu_addContract_part                                |
+--------------------------------------------------------+----------------------------------------------------------+
| Реестр                                                 | crm_registry_contracts_delivery_part                     |
+--------------------------------------------------------+----------------------------------------------------------+
| Добавить в "Избранное" пользователя по умолчанию       | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+
| Группа                                                 | Все маркетологи, Все специалисты по продажам             |
+--------------------------------------------------------+----------------------------------------------------------+

#### Коммерческое предложение {#offer}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Тип                                                    | пункт                                                    |
+--------------------------------------------------------+----------------------------------------------------------+
| Код                                                    | crm_menu_addOffer                                        |
+--------------------------------------------------------+----------------------------------------------------------+
| Реестр                                                 | crm_registry_offer                                       |
+--------------------------------------------------------+----------------------------------------------------------+
| Добавить в "Избранное" пользователя по умолчанию       | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+
| Группа                                                 | Все маркетологи, Все специалисты по продажам             |
+--------------------------------------------------------+----------------------------------------------------------+

### Внешние модули {#externalModules}

#### Маркетинг {#marketing}

+--------------------------------------------------------+----------------------------------------------------------------------------------------+
| Свойство                                               | Значение                                                                               |
+========================================================+========================================================================================+
| Код                                                    | crm_extModule                                                                          |
+--------------------------------------------------------+----------------------------------------------------------------------------------------+
| Адрес приложения                                       | [URL](http://tdd.lan.arta.kz/docs/cases/crm/additional/html/crm_without_data.html)/crm |
+--------------------------------------------------------+----------------------------------------------------------------------------------------+

#### Управление продажами {#sales}

+--------------------------------------------------------+---------------------------------------------------------------------------------------------+
| Свойство                                               | Значение                                                                                    |
+========================================================+=============================================================================================+
| Код                                                    | crm_extDeal                                                                                 |
+--------------------------------------------------------+---------------------------------------------------------------------------------------------+
| Адрес приложения                                       | [URL](http://tdd.lan.arta.kz/docs/cases/crm/additional/html/crm_without_data.html)/crm/deal |
+--------------------------------------------------------+---------------------------------------------------------------------------------------------+

<#include "crm_consist/user_components.md">
<#include "crm_consist/reminder.md">
