'use strict';

AS.OPTIONS.locale = "ru";
AS.OPTIONS.coreUrl = "http://intern-dev.arta.kz/Synergy/";

var portal = {
    player : null,
  
    clearPlayer : function() {
        if(portal.player) {
            portal.player.destroy();
        }
    },
 
    createPlayer : function(formCode){
        portal.clearPlayer();
        portal.player = AS.FORMS.createPlayer();
        portal.player.showFormByCode(formCode);
	    portal.player.view.appendTo($('#form_player_div'));
    },
	
	showMessage : function(message) {
        alert(message);
    }
};

AS.SERVICES.unAuthorized = function()
{
	portal.showMessage("Authorization Error!");
	location.reload();
};


var addHandlers = function(){
	jQuery(".submit").on( "click", function(event){
        AS.OPTIONS.login = $("input#login").val();
        AS.OPTIONS.password = $("input#password").val();
		var xhr = new XMLHttpRequest();
		AS.FORMS.ApiUtils.simpleAsyncGet('rest/api', xhr);
		if (xhr.status == "401") {
			AS.SERVICES.unAuthorized();
		} else {
			$(".login-form").remove();
			$(".form_player_container").show();
			portal.createPlayer("timesheet");
		}	
    });
}

$(document).ready(function(){
	addHandlers();
 });