'use strict';

AS.OPTIONS.locale = "ru";
AS.OPTIONS.coreUrl = "http://intern-dev.arta.kz/Synergy/";

function CreateAuthForm(){

	$(".saveBtn").hide();
	
	var forma = document.createElement("form");
	forma.className = "login-form";
	forma.setAttribute('id',"login-form");
	forma.setAttribute('id',"login-form");
	forma.setAttribute('align',"center");
	
	var authHeader = document.createTextNode('Введите логин и пароль');
	var authErr = document.createTextNode('Неверный логин или пароль');
	
	var Hdiv = document.createElement("div");
	Hdiv.className = "header";
	Hdiv.appendChild(authHeader);
	
	var Ediv = document.createElement("div");
	Ediv.className = "error";
	Ediv.appendChild(authErr);
	Ediv.setAttribute('id',"error");
	
	var textInp = document.createElement("input");
	textInp.className = "login";
	textInp.setAttribute('type',"text");
	textInp.setAttribute('name',"login");
	textInp.setAttribute('id',"login");
	textInp.setAttribute('placeholder',"Логин");
	textInp.setAttribute('align',"center");
	
	var pasInp = document.createElement("input");
	pasInp.className = "password";
	pasInp.setAttribute('type',"password");
	pasInp.setAttribute('name',"password");
	pasInp.setAttribute('id',"password");
	pasInp.setAttribute('placeholder',"Пароль");
	pasInp.setAttribute('align',"center");

	var submitBtn = document.createElement("input");
	submitBtn.className = "submit";
	submitBtn.setAttribute('type',"submit");
	submitBtn.setAttribute('value',"Войти");
	submitBtn.setAttribute('id',"submit");
	submitBtn.setAttribute('align',"center");

	forma.appendChild(Hdiv);
	forma.appendChild(Ediv);
	forma.appendChild(textInp);
	forma.appendChild(pasInp);
	forma.appendChild(submitBtn);

	document.getElementById("authForm").appendChild(forma);
	authFunc();
};

function ShowMessage(message){
	if(message.length > 30){
		$(".msg").css({'top': '20%'})
	} else $(".msg").css({'top': '34%'})
	$(".MsgRect").show();
	document.getElementById("msg").innerHTML = message;
	setTimeout(function(){
		$(".MsgRect").hide();
	}, 3000);
};

var portal = {
    player : null,
  
    clearPlayer : function() {
	    if(portal.player) {
            portal.player.destroy();
        }
    },
 
    createPlayer : function(){
        portal.clearPlayer();
        portal.player = AS.FORMS.createPlayer();
		AS.FORMS.bus.on(AS.FORMS.EVENT_TYPE.formShow, function (event, model, view) {
			if (model.formCode === "timesheet") {
                model.on(AS.FORMS.EVENT_TYPE.dataLoad, function() {
                    portal.main(portal.player.view.getViewWithId("main_script"), portal.player.model.getModelWithId("main_script"));
				});
			}
		});
		AS.FORMS.ApiUtils.simpleAsyncGet('rest/api/registry/create_doc?registryCode=registry_timesheets', function(result){
			if(result.errorCode != "0") {   
				AS.SERVICES.hideWaitWindow();
				ShowMessage("Ошибка во время создания документа..");					   
				return;
			} else {
				AS.SERVICES.hideWaitWindow();
				ShowMessage("Документ успешно создан!");
				portal.player.view.setEditable(true);
				portal.player.showFormData(result.documentID, 0, result.dataUUID);
				portal.player.view.appendTo($('#form_player_div'));
			}
		}, 'json');
		
	},
  
	saveData : function(){
		var errors = portal.player.model.getErrors();
        if(errors.length > 0) {
			AS.SERVICES.hideWaitWindow();
            ShowMessage("Введите все обязательные поля");
            return;
		}
		
		var data = portal.player.model.asfDataId;
		portal.player.saveFormData(function(data){
			if(_.isUndefined(data)){
				AS.SERVICES.hideWaitWindow();
				ShowMessage("Во время сохранения данных возникла ошибка");
			} else {
				AS.SERVICES.hideWaitWindow();
				ShowMessage("Данные сохранены");
			}
		});
	},
	
	main: function (view, model) {
		var serverDateTime = portal.player.model.getModelWithId("ts_date_created").value;
		var serverDate = serverDateTime.substr(0, serverDateTime.length - 9);
		var serverWeekDay = new Date(serverDate).getDay();

		switch(serverWeekDay){
			case 0: 
				portal.player.model.getModelWithId("ts_period_date_to").setValue(WeekCalculating(serverDate, 7)); //0 день воскресение прошлой недели
				portal.player.model.getModelWithId("ts_period_date_from").setValue(WeekCalculating(serverDate, 1)); // 1й день пндк нашей недели 
				break;
			case 1: 
				portal.player.model.getModelWithId("ts_period_date_to").setValue(WeekCalculating(serverDate, 6)); //0 день воскресение прошлой недели
				portal.player.model.getModelWithId("ts_period_date_from").setValue(WeekCalculating(serverDate, 0)); // 1й день пндк нашей недели 
				break;
			case 2: 
				portal.player.model.getModelWithId("ts_period_date_to").setValue(WeekCalculating(serverDate, 5)); //0 день воскресение прошлой недели
				portal.player.model.getModelWithId("ts_period_date_from").setValue(WeekCalculating(serverDate, (-1))); // 1й день пндк нашей недели 
				break;
			case 3: 
				portal.player.model.getModelWithId("ts_period_date_to").setValue(WeekCalculating(serverDate, 4)); //0 день воскресение прошлой недели
				portal.player.model.getModelWithId("ts_period_date_from").setValue(WeekCalculating(serverDate, (-2))); // 1й день пндк нашей недели 
				break;
			case 4:
				portal.player.model.getModelWithId("ts_period_date_to").setValue(WeekCalculating(serverDate, 3)); //0 день воскресение прошлой недели
				portal.player.model.getModelWithId("ts_period_date_from").setValue(WeekCalculating(serverDate, (-3))); // 1й день пндк нашей недели 
				break;
			case 5:
				portal.player.model.getModelWithId("ts_period_date_to").setValue(WeekCalculating(serverDate, 2)); //0 день воскресение прошлой недели
				portal.player.model.getModelWithId("ts_period_date_from").setValue(WeekCalculating(serverDate, (-4))); // 1й день пндк нашей недели 
				break;
			case 6:
				portal.player.model.getModelWithId("ts_period_date_to").setValue(WeekCalculating(serverDate, 1)); //0 день воскресение прошлой недели
				portal.player.model.getModelWithId("ts_period_date_from").setValue(WeekCalculating(serverDate, (-5))); // 1й день пндк нашей недели 
				break;
			case 7:
				portal.player.model.getModelWithId("ts_period_date_to").setValue(WeekCalculating(serverDate, 0)); //0 день воскресение прошлой недели
				portal.player.model.getModelWithId("ts_period_date_from").setValue(WeekCalculating(serverDate, (-6))); // 1й день пндк нашей недели 
				break;
		}
		
		function WeekCalculating(fullDate, shift){
			var year = fullDate.substr(0, (fullDate.length - 6));
			var month = fullDate.substr(5, (fullDate.length));
			month = month.substr(0, (month.length - 3));
			var day = fullDate.substr(8, fullDate.length);
			day = parseInt(day) + shift;
				switch(month){
					case "01":
					case "03":
					case "05":
					case "07":
					case "08":
					case "10":
					case "12":
						if(parseInt(day) > 31) { month = parseInt(month) + 1; day = "01";}
						break;
					case "04":
					case "06":
					case "09":
					case "11":
						if(parseInt(day) > 30) { month = parseInt(month) + 1; day = "01";}
						break;
					case "02":
						if((parseInt(year)%4 == 0) || (parseInt(year)%400 == 0))  {             
							if(parseInt(day) > 29) { month = parseInt(month) + 1; day = "01";}
						} else {
							if(parseInt(day) > 28) { month = parseInt(month) + 1; day = "01";}
						}
						break;
				}
				
				if((parseInt(month) + shift) > 12) { month = "01"; year = year + 1; }   /////если месяцев больше 12, то увелививаем год
				if(parseInt(day) < 10) day = "0" + day;
			var finalDate = year + "-" + month + "-" + day;
			return finalDate;
		}
	}
};



//переменные для WaitCircles();
var currentTime = Date.now(),
r = 40,
left = '',
Top = '',
alpha = 2 * 3.14;

function WaitCircles(num){
	var count = num;
	var t;
	let startTime = setInterval(function(count){
		switch(num){
			case '1':
				t = Date.now() - currentTime;
				left = 150 + r*Math.cos(alpha*t);
				Top = 350 + r*Math.sin(-alpha*t);
				$('.circle1').css({'left': left, 'top': Top});	
				break;
			case '2':
				t = Date.now() - currentTime + 500;
				left = 150 + r*Math.cos(alpha*t);
				Top = 350 + r*Math.sin(-alpha*t);
				$('.circle2').css({'left': left, 'top': Top});	
				break;
			case '3':
				t = Date.now() - currentTime + 1200;
				left = 150 + r*Math.cos(alpha*t);
				Top = 350 + r*Math.sin(-alpha*t);
				$('.circle3').css({'left': left, 'top': Top});
				break;
			case 'stop':
				clearInterval(startTime);
				break;
		}
	}, 1);
};

AS.SERVICES.showWaitWindow = function(){
	WaitCircles('1');
	WaitCircles('2');
	WaitCircles('3');
	$(".container").show();
};	

AS.SERVICES.hideWaitWindow = function(){
	WaitCircles('stop');
	$(".container").hide();
};	

var authFunc = function(){
	jQuery(".submit").on( "click", function(event){
		AS.SERVICES.showWaitWindow();
        AS.OPTIONS.login = $("input#login").val();
        AS.OPTIONS.password = $("input#password").val();
		portal.createPlayer();
		$(".form_player_container").show();
		$(".login-form").remove();
		$(".saveBtn").show();
    });
};

AS.SERVICES.unAuthorized = function()
{
	$(".container").hide();
	$(".login-form").remove();
	CreateAuthForm();
};

$(document).ready(function(){
	CreateAuthForm();
	$(".error").hide();
	$(".saveBtn").hide();
	$(".container").hide();
	$(".MsgRect").hide();
	
	$(".saveBtn").on("click", function(event){
		AS.SERVICES.showWaitWindow();
		portal.saveData();
	});
});

