'use strict';

AS.OPTIONS.locale = "ru";
AS.OPTIONS.coreUrl = "http://intern-dev.arta.kz/Synergy/";

var portal = {
    player : null,
  
    clearPlayer : function() {
	
        if(portal.player) {
            portal.player.destroy();
        }
    },
 
    createPlayer : function(dataId){
        portal.clearPlayer();
        portal.player = AS.FORMS.createPlayer();
		portal.player.view.setEditable(_.isUndefined(dataId));
		portal.player.showFormData("097a00e2-430c-436d-92e5-c2ea8edc5b30", 1, dataId);
		portal.player.view.appendTo($('#form_player_div'));
	}
};

function CreateAuthForm(){

	var forma = document.createElement("form");
	forma.className = "login-form";
	forma.setAttribute('id',"login-form");
	forma.setAttribute('align',"center");
	
	var authHeader = document.createTextNode('Введите логин и пароль');
	var authErr = document.createTextNode('Неверный логин или пароль');
	
	var Hdiv = document.createElement("div");
	Hdiv.className = "header";
	Hdiv.appendChild(authHeader);
	
	var Ediv = document.createElement("div");
	Ediv.className = "error";
	Ediv.appendChild(authErr);
	Ediv.setAttribute('id',"error");
	
	var textInp = document.createElement("input");
	textInp.className = "login";
	textInp.setAttribute('type',"text");
	textInp.setAttribute('name',"login");
	textInp.setAttribute('id',"login");
	textInp.setAttribute('placeholder',"Логин");
	textInp.setAttribute('align',"center");
	
	var pasInp = document.createElement("input");
	pasInp.className = "password";
	pasInp.setAttribute('type',"password");
	pasInp.setAttribute('name',"password");
	pasInp.setAttribute('id',"password");
	pasInp.setAttribute('placeholder',"Пароль");
	pasInp.setAttribute('align',"center");

	var submitBtn = document.createElement("input");
	submitBtn.className = "submit";
	submitBtn.setAttribute('type',"submit");
	submitBtn.setAttribute('value',"Войти");
	submitBtn.setAttribute('id',"submit");
	submitBtn.setAttribute('align',"center");

	forma.appendChild(Hdiv);
	forma.appendChild(Ediv);
	forma.appendChild(textInp);
	forma.appendChild(pasInp);
	forma.appendChild(submitBtn);

	document.getElementById("authForm").appendChild(forma);
	authFunc();
};

var authFunc = function(){
	jQuery(".submit").on( "click", function(event){
        AS.OPTIONS.login = $("input#login").val();
        AS.OPTIONS.password = $("input#password").val();
			portal.createPlayer();
			$(".form_player_container").show();
			$(".login-form").remove();
    });
};

AS.SERVICES.unAuthorized = function()
{
	$(".login-form").remove();
	CreateAuthForm();
};

$(document).ready(function(){
	CreateAuthForm();
	$(".error").hide();
});